/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/profile/index.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/croppr/dist/croppr.js":
/*!********************************************!*\
  !*** ./node_modules/croppr/dist/croppr.js ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/**\n * Croppr.js\n * https://github.com/jamesssooi/Croppr.js\n * \n * A JavaScript image cropper that's lightweight, awesome, and has\n * zero dependencies.\n * \n * (C) 2017 James Ooi. Released under the MIT License.\n */\n\n(function (global, factory) {\n\t true ? module.exports = factory() :\n\tundefined;\n}(this, (function () { 'use strict';\n\n(function () {\n  var lastTime = 0;\n  var vendors = ['ms', 'moz', 'webkit', 'o'];\n  for (var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {\n    window.requestAnimationFrame = window[vendors[x] + 'RequestAnimationFrame'];\n    window.cancelAnimationFrame = window[vendors[x] + 'CancelAnimationFrame'] || window[vendors[x] + 'CancelRequestAnimationFrame'];\n  }\n  if (!window.requestAnimationFrame) window.requestAnimationFrame = function (callback, element) {\n    var currTime = new Date().getTime();\n    var timeToCall = Math.max(0, 16 - (currTime - lastTime));\n    var id = window.setTimeout(function () {\n      callback(currTime + timeToCall);\n    }, timeToCall);\n    lastTime = currTime + timeToCall;\n    return id;\n  };\n  if (!window.cancelAnimationFrame) window.cancelAnimationFrame = function (id) {\n    clearTimeout(id);\n  };\n})();\n(function () {\n  if (typeof window.CustomEvent === \"function\") return false;\n  function CustomEvent(event, params) {\n    params = params || { bubbles: false, cancelable: false, detail: undefined };\n    var evt = document.createEvent('CustomEvent');\n    evt.initCustomEvent(event, params.bubbles, params.cancelable, params.detail);\n    return evt;\n  }\n  CustomEvent.prototype = window.Event.prototype;\n  window.CustomEvent = CustomEvent;\n})();\n(function (window) {\n  try {\n    new CustomEvent('test');\n    return false;\n  } catch (e) {}\n  function MouseEvent(eventType, params) {\n    params = params || { bubbles: false, cancelable: false };\n    var mouseEvent = document.createEvent('MouseEvent');\n    mouseEvent.initMouseEvent(eventType, params.bubbles, params.cancelable, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);\n    return mouseEvent;\n  }\n  MouseEvent.prototype = Event.prototype;\n  window.MouseEvent = MouseEvent;\n})(window);\n\nvar classCallCheck = function (instance, Constructor) {\n  if (!(instance instanceof Constructor)) {\n    throw new TypeError(\"Cannot call a class as a function\");\n  }\n};\n\nvar createClass = function () {\n  function defineProperties(target, props) {\n    for (var i = 0; i < props.length; i++) {\n      var descriptor = props[i];\n      descriptor.enumerable = descriptor.enumerable || false;\n      descriptor.configurable = true;\n      if (\"value\" in descriptor) descriptor.writable = true;\n      Object.defineProperty(target, descriptor.key, descriptor);\n    }\n  }\n\n  return function (Constructor, protoProps, staticProps) {\n    if (protoProps) defineProperties(Constructor.prototype, protoProps);\n    if (staticProps) defineProperties(Constructor, staticProps);\n    return Constructor;\n  };\n}();\n\n\n\n\n\n\n\nvar get = function get(object, property, receiver) {\n  if (object === null) object = Function.prototype;\n  var desc = Object.getOwnPropertyDescriptor(object, property);\n\n  if (desc === undefined) {\n    var parent = Object.getPrototypeOf(object);\n\n    if (parent === null) {\n      return undefined;\n    } else {\n      return get(parent, property, receiver);\n    }\n  } else if (\"value\" in desc) {\n    return desc.value;\n  } else {\n    var getter = desc.get;\n\n    if (getter === undefined) {\n      return undefined;\n    }\n\n    return getter.call(receiver);\n  }\n};\n\nvar inherits = function (subClass, superClass) {\n  if (typeof superClass !== \"function\" && superClass !== null) {\n    throw new TypeError(\"Super expression must either be null or a function, not \" + typeof superClass);\n  }\n\n  subClass.prototype = Object.create(superClass && superClass.prototype, {\n    constructor: {\n      value: subClass,\n      enumerable: false,\n      writable: true,\n      configurable: true\n    }\n  });\n  if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;\n};\n\n\n\n\n\n\n\n\n\n\n\nvar possibleConstructorReturn = function (self, call) {\n  if (!self) {\n    throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\");\n  }\n\n  return call && (typeof call === \"object\" || typeof call === \"function\") ? call : self;\n};\n\n\n\n\n\nvar slicedToArray = function () {\n  function sliceIterator(arr, i) {\n    var _arr = [];\n    var _n = true;\n    var _d = false;\n    var _e = undefined;\n\n    try {\n      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {\n        _arr.push(_s.value);\n\n        if (i && _arr.length === i) break;\n      }\n    } catch (err) {\n      _d = true;\n      _e = err;\n    } finally {\n      try {\n        if (!_n && _i[\"return\"]) _i[\"return\"]();\n      } finally {\n        if (_d) throw _e;\n      }\n    }\n\n    return _arr;\n  }\n\n  return function (arr, i) {\n    if (Array.isArray(arr)) {\n      return arr;\n    } else if (Symbol.iterator in Object(arr)) {\n      return sliceIterator(arr, i);\n    } else {\n      throw new TypeError(\"Invalid attempt to destructure non-iterable instance\");\n    }\n  };\n}();\n\nvar Handle =\n/**\n * Creates a new Handle instance.\n * @constructor\n * @param {Array} position The x and y ratio position of the handle\n *      within the crop region. Accepts a value between 0 to 1 in the order\n *      of [X, Y].\n * @param {Array} constraints Define the side of the crop region that\n *      is to be affected by this handle. Accepts a value of 0 or 1 in the\n *      order of [TOP, RIGHT, BOTTOM, LEFT].\n * @param {String} cursor The CSS cursor of this handle.\n * @param {Element} eventBus The element to dispatch events to.\n */\nfunction Handle(position, constraints, cursor, eventBus) {\n  classCallCheck(this, Handle);\n  var self = this;\n  this.position = position;\n  this.constraints = constraints;\n  this.cursor = cursor;\n  this.eventBus = eventBus;\n  this.el = document.createElement('div');\n  this.el.className = 'croppr-handle';\n  this.el.style.cursor = cursor;\n  this.el.addEventListener('mousedown', onMouseDown);\n  function onMouseDown(e) {\n    e.stopPropagation();\n    document.addEventListener('mouseup', onMouseUp);\n    document.addEventListener('mousemove', onMouseMove);\n    self.eventBus.dispatchEvent(new CustomEvent('handlestart', {\n      detail: { handle: self }\n    }));\n  }\n  function onMouseUp(e) {\n    e.stopPropagation();\n    document.removeEventListener('mouseup', onMouseUp);\n    document.removeEventListener('mousemove', onMouseMove);\n    self.eventBus.dispatchEvent(new CustomEvent('handleend', {\n      detail: { handle: self }\n    }));\n  }\n  function onMouseMove(e) {\n    e.stopPropagation();\n    self.eventBus.dispatchEvent(new CustomEvent('handlemove', {\n      detail: { mouseX: e.clientX, mouseY: e.clientY }\n    }));\n  }\n};\n\nvar Box = function () {\n  /**\n   * Creates a new Box instance.\n   * @constructor\n   * @param {Number} x1\n   * @param {Number} y1\n   * @param {Number} x2\n   * @param {Number} y2\n   */\n  function Box(x1, y1, x2, y2) {\n    classCallCheck(this, Box);\n    this.x1 = x1;\n    this.y1 = y1;\n    this.x2 = x2;\n    this.y2 = y2;\n  }\n  /**\n   * Sets the new dimensions of the box.\n   * @param {Number} x1\n   * @param {Number} y1\n   * @param {Number} x2\n   * @param {Number} y2\n   */\n  createClass(Box, [{\n    key: 'set',\n    value: function set$$1() {\n      var x1 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n      var y1 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n      var x2 = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n      var y2 = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;\n      this.x1 = x1 == null ? this.x1 : x1;\n      this.y1 = y1 == null ? this.y1 : y1;\n      this.x2 = x2 == null ? this.x2 : x2;\n      this.y2 = y2 == null ? this.y2 : y2;\n      return this;\n    }\n    /**\n     * Calculates the width of the box.\n     * @returns {Number}\n     */\n  }, {\n    key: 'width',\n    value: function width() {\n      return Math.abs(this.x2 - this.x1);\n    }\n    /**\n     * Calculates the height of the box.\n     * @returns {Number}\n     */\n  }, {\n    key: 'height',\n    value: function height() {\n      return Math.abs(this.y2 - this.y1);\n    }\n    /**\n     * Resizes the box to a new size.\n     * @param {Number} newWidth\n     * @param {Number} newHeight\n     * @param {Array} [origin] The origin point to resize from.\n     *      Defaults to [0, 0] (top left).\n     */\n  }, {\n    key: 'resize',\n    value: function resize(newWidth, newHeight) {\n      var origin = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [0, 0];\n      var fromX = this.x1 + this.width() * origin[0];\n      var fromY = this.y1 + this.height() * origin[1];\n      this.x1 = fromX - newWidth * origin[0];\n      this.y1 = fromY - newHeight * origin[1];\n      this.x2 = this.x1 + newWidth;\n      this.y2 = this.y1 + newHeight;\n      return this;\n    }\n    /**\n     * Scale the box by a factor.\n     * @param {Number} factor\n     * @param {Array} [origin] The origin point to resize from.\n     *      Defaults to [0, 0] (top left).\n     */\n  }, {\n    key: 'scale',\n    value: function scale(factor) {\n      var origin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0];\n      var newWidth = this.width() * factor;\n      var newHeight = this.height() * factor;\n      this.resize(newWidth, newHeight, origin);\n      return this;\n    }\n  }, {\n    key: 'move',\n    value: function move() {\n      var x = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n      var y = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n      var width = this.width();\n      var height = this.height();\n      x = x === null ? this.x1 : x;\n      y = y === null ? this.y1 : y;\n      this.x1 = x;\n      this.y1 = y;\n      this.x2 = x + width;\n      this.y2 = y + height;\n      return this;\n    }\n    /**\n     * Get relative x and y coordinates of a given point within the box.\n     * @param {Array} point The x and y ratio position within the box.\n     * @returns {Array} The x and y coordinates [x, y].\n     */\n  }, {\n    key: 'getRelativePoint',\n    value: function getRelativePoint() {\n      var point = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0];\n      var x = this.width() * point[0];\n      var y = this.height() * point[1];\n      return [x, y];\n    }\n    /**\n     * Get absolute x and y coordinates of a given point within the box.\n     * @param {Array} point The x and y ratio position within the box.\n     * @returns {Array} The x and y coordinates [x, y].\n     */\n  }, {\n    key: 'getAbsolutePoint',\n    value: function getAbsolutePoint() {\n      var point = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [0, 0];\n      var x = this.x1 + this.width() * point[0];\n      var y = this.y1 + this.height() * point[1];\n      return [x, y];\n    }\n    /**\n     * Constrain the box to a fixed ratio.\n     * @param {Number} ratio\n     * @param {Array} [origin] The origin point to resize from.\n     *     Defaults to [0, 0] (top left).\n     * @param {String} [grow] The axis to grow to maintain the ratio.\n     *     Defaults to 'height'.\n     */\n  }, {\n    key: 'constrainToRatio',\n    value: function constrainToRatio(ratio) {\n      var origin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [0, 0];\n      var grow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'height';\n      if (ratio === null) {\n        return;\n      }\n      var width = this.width();\n      var height = this.height();\n      switch (grow) {\n        case 'height':\n          this.resize(this.width(), this.width() * ratio, origin);\n          break;\n        case 'width':\n          this.resize(this.height() * 1 / ratio, this.height(), origin);\n          break;\n        default:\n          this.resize(this.width(), this.width() * ratio, origin);\n      }\n      return this;\n    }\n    /**\n     * Constrain the box within a boundary.\n     * @param {Number} boundaryWidth\n     * @param {Number} boundaryHeight\n     * @param {Array} [origin] The origin point to resize from.\n     *     Defaults to [0, 0] (top left).\n     */\n  }, {\n    key: 'constrainToBoundary',\n    value: function constrainToBoundary(boundaryWidth, boundaryHeight) {\n      var origin = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [0, 0];\n      var _getAbsolutePoint = this.getAbsolutePoint(origin),\n          _getAbsolutePoint2 = slicedToArray(_getAbsolutePoint, 2),\n          originX = _getAbsolutePoint2[0],\n          originY = _getAbsolutePoint2[1];\n      var maxIfLeft = originX;\n      var maxIfTop = originY;\n      var maxIfRight = boundaryWidth - originX;\n      var maxIfBottom = boundaryHeight - originY;\n      var directionX = -2 * origin[0] + 1;\n      var directionY = -2 * origin[1] + 1;\n      var maxWidth = null,\n          maxHeight = null;\n      switch (directionX) {\n        case -1:\n          maxWidth = maxIfLeft;break;\n        case 0:\n          maxWidth = Math.min(maxIfLeft, maxIfRight) * 2;break;\n        case +1:\n          maxWidth = maxIfRight;break;\n      }\n      switch (directionY) {\n        case -1:\n          maxHeight = maxIfTop;break;\n        case 0:\n          maxHeight = Math.min(maxIfTop, maxIfBottom) * 2;break;\n        case +1:\n          maxHeight = maxIfBottom;break;\n      }\n      if (this.width() > maxWidth) {\n        var factor = maxWidth / this.width();\n        this.scale(factor, origin);\n      }\n      if (this.height() > maxHeight) {\n        var _factor = maxHeight / this.height();\n        this.scale(_factor, origin);\n      }\n      return this;\n    }\n    /**\n     * Constrain the box to a maximum/minimum size.\n     * @param {Number} [maxWidth]\n     * @param {Number} [maxHeight]\n     * @param {Number} [minWidth]\n     * @param {Number} [minHeight]\n     * @param {Array} [origin] The origin point to resize from.\n     *     Defaults to [0, 0] (top left).\n     * @param {Number} [ratio] Ratio to maintain.\n     */\n  }, {\n    key: 'constrainToSize',\n    value: function constrainToSize() {\n      var maxWidth = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n      var maxHeight = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n      var minWidth = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;\n      var minHeight = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;\n      var origin = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [0, 0];\n      var ratio = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : null;\n      if (ratio) {\n        if (ratio > 1) {\n          maxWidth = maxHeight * 1 / ratio;\n          minHeight = minHeight * ratio;\n        } else if (ratio < 1) {\n          maxHeight = maxWidth * ratio;\n          minWidth = minHeight * 1 / ratio;\n        }\n      }\n      if (maxWidth && this.width() > maxWidth) {\n        var newWidth = maxWidth,\n            newHeight = ratio === null ? this.height() : maxHeight;\n        this.resize(newWidth, newHeight, origin);\n      }\n      if (maxHeight && this.height() > maxHeight) {\n        var _newWidth = ratio === null ? this.width() : maxWidth,\n            _newHeight = maxHeight;\n        this.resize(_newWidth, _newHeight, origin);\n      }\n      if (minWidth && this.width() < minWidth) {\n        var _newWidth2 = minWidth,\n            _newHeight2 = ratio === null ? this.height() : minHeight;\n        this.resize(_newWidth2, _newHeight2, origin);\n      }\n      if (minHeight && this.height() < minHeight) {\n        var _newWidth3 = ratio === null ? this.width() : minWidth,\n            _newHeight3 = minHeight;\n        this.resize(_newWidth3, _newHeight3, origin);\n      }\n      return this;\n    }\n  }]);\n  return Box;\n}();\n\n/**\n * Binds an element's touch events to be simulated as mouse events.\n * @param {Element} element\n */\nfunction enableTouch(element) {\n  element.addEventListener('touchstart', simulateMouseEvent);\n  element.addEventListener('touchend', simulateMouseEvent);\n  element.addEventListener('touchmove', simulateMouseEvent);\n}\n/**\n * Translates a touch event to a mouse event.\n * @param {Event} e\n */\nfunction simulateMouseEvent(e) {\n  e.preventDefault();\n  var touch = e.changedTouches[0];\n  var eventMap = {\n    'touchstart': 'mousedown',\n    'touchmove': 'mousemove',\n    'touchend': 'mouseup'\n  };\n  touch.target.dispatchEvent(new MouseEvent(eventMap[e.type], {\n    bubbles: true,\n    cancelable: true,\n    view: window,\n    clientX: touch.clientX,\n    clientY: touch.clientY,\n    screenX: touch.screenX,\n    screenY: touch.screenY\n  }));\n}\n\n/**\n * Define a list of handles to create.\n *\n * @property {Array} position - The x and y ratio position of the handle within\n *      the crop region. Accepts a value between 0 to 1 in the order of [X, Y].\n * @property {Array} constraints - Define the side of the crop region that is to\n *      be affected by this handle. Accepts a value of 0 or 1 in the order of\n *      [TOP, RIGHT, BOTTOM, LEFT].\n * @property {String} cursor - The CSS cursor of this handle.\n */\nvar HANDLES = [{ position: [0.0, 0.0], constraints: [1, 0, 0, 1], cursor: 'nw-resize' }, { position: [0.5, 0.0], constraints: [1, 0, 0, 0], cursor: 'n-resize' }, { position: [1.0, 0.0], constraints: [1, 1, 0, 0], cursor: 'ne-resize' }, { position: [1.0, 0.5], constraints: [0, 1, 0, 0], cursor: 'e-resize' }, { position: [1.0, 1.0], constraints: [0, 1, 1, 0], cursor: 'se-resize' }, { position: [0.5, 1.0], constraints: [0, 0, 1, 0], cursor: 's-resize' }, { position: [0.0, 1.0], constraints: [0, 0, 1, 1], cursor: 'sw-resize' }, { position: [0.0, 0.5], constraints: [0, 0, 0, 1], cursor: 'w-resize' }];\nvar CropprCore = function () {\n  function CropprCore(element, options) {\n    var _this = this;\n    var deferred = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n    classCallCheck(this, CropprCore);\n    this.options = CropprCore.parseOptions(options || {});\n    if (!element.nodeName) {\n      element = document.querySelector(element);\n      if (element == null) {\n        throw 'Unable to find element.';\n      }\n    }\n    if (!element.getAttribute('src')) {\n      throw 'Image src not provided.';\n    }\n    this._initialized = false;\n    this._restore = {\n      parent: element.parentNode,\n      element: element\n    };\n    if (!deferred) {\n      if (element.width === 0 || element.height === 0) {\n        element.onload = function () {\n          _this.initialize(element);\n        };\n      } else {\n        this.initialize(element);\n      }\n    }\n  }\n  createClass(CropprCore, [{\n    key: 'initialize',\n    value: function initialize(element) {\n      this.createDOM(element);\n      this.options.convertToPixels(this.cropperEl);\n      this.attachHandlerEvents();\n      this.attachRegionEvents();\n      this.attachOverlayEvents();\n      this.box = this.initializeBox(this.options);\n      this.redraw();\n      this._initialized = true;\n      if (this.options.onInitialize !== null) {\n        this.options.onInitialize(this);\n      }\n    }\n  }, {\n    key: 'createDOM',\n    value: function createDOM(targetEl) {\n      this.containerEl = document.createElement('div');\n      this.containerEl.className = 'croppr-container';\n      this.eventBus = this.containerEl;\n      enableTouch(this.containerEl);\n      this.cropperEl = document.createElement('div');\n      this.cropperEl.className = 'croppr';\n      this.imageEl = document.createElement('img');\n      this.imageEl.setAttribute('src', targetEl.getAttribute('src'));\n      this.imageEl.setAttribute('alt', targetEl.getAttribute('alt'));\n      this.imageEl.className = 'croppr-image';\n      this.imageClippedEl = this.imageEl.cloneNode();\n      this.imageClippedEl.className = 'croppr-imageClipped';\n      this.regionEl = document.createElement('div');\n      this.regionEl.className = 'croppr-region';\n      this.overlayEl = document.createElement('div');\n      this.overlayEl.className = 'croppr-overlay';\n      var handleContainerEl = document.createElement('div');\n      handleContainerEl.className = 'croppr-handleContainer';\n      this.handles = [];\n      for (var i = 0; i < HANDLES.length; i++) {\n        var handle = new Handle(HANDLES[i].position, HANDLES[i].constraints, HANDLES[i].cursor, this.eventBus);\n        this.handles.push(handle);\n        handleContainerEl.appendChild(handle.el);\n      }\n      this.cropperEl.appendChild(this.imageEl);\n      this.cropperEl.appendChild(this.imageClippedEl);\n      this.cropperEl.appendChild(this.regionEl);\n      this.cropperEl.appendChild(this.overlayEl);\n      this.cropperEl.appendChild(handleContainerEl);\n      this.containerEl.appendChild(this.cropperEl);\n      targetEl.parentElement.replaceChild(this.containerEl, targetEl);\n    }\n    /**\n     * Changes the image src.\n     * @param {String} src\n     */\n  }, {\n    key: 'setImage',\n    value: function setImage(src) {\n      var _this2 = this;\n      this.imageEl.onload = function () {\n        _this2.box = _this2.initializeBox(_this2.options);\n        _this2.redraw();\n      };\n      this.imageEl.src = src;\n      this.imageClippedEl.src = src;\n      return this;\n    }\n  }, {\n    key: 'destroy',\n    value: function destroy() {\n      this._restore.parent.replaceChild(this._restore.element, this.containerEl);\n    }\n    /**\n     * Create a new box region with a set of options.\n     * @param {Object} opts The options.\n     * @returns {Box}\n     */\n  }, {\n    key: 'initializeBox',\n    value: function initializeBox(opts) {\n      var width = opts.startSize.width;\n      var height = opts.startSize.height;\n      var box = new Box(0, 0, width, height);\n      box.constrainToRatio(opts.aspectRatio, [0.5, 0.5]);\n      var min = opts.minSize;\n      var max = opts.maxSize;\n      box.constrainToSize(max.width, max.height, min.width, min.height, [0.5, 0.5], opts.aspectRatio);\n      var parentWidth = this.cropperEl.offsetWidth;\n      var parentHeight = this.cropperEl.offsetHeight;\n      box.constrainToBoundary(parentWidth, parentHeight, [0.5, 0.5]);\n      var x = this.cropperEl.offsetWidth / 2 - box.width() / 2;\n      var y = this.cropperEl.offsetHeight / 2 - box.height() / 2;\n      box.move(x, y);\n      return box;\n    }\n  }, {\n    key: 'redraw',\n    value: function redraw() {\n      var _this3 = this;\n      var width = Math.round(this.box.width()),\n          height = Math.round(this.box.height()),\n          x1 = Math.round(this.box.x1),\n          y1 = Math.round(this.box.y1),\n          x2 = Math.round(this.box.x2),\n          y2 = Math.round(this.box.y2);\n      window.requestAnimationFrame(function () {\n        _this3.regionEl.style.transform = 'translate(' + x1 + 'px, ' + y1 + 'px)';\n        _this3.regionEl.style.width = width + 'px';\n        _this3.regionEl.style.height = height + 'px';\n        _this3.imageClippedEl.style.clip = 'rect(' + y1 + 'px, ' + x2 + 'px, ' + y2 + 'px, ' + x1 + 'px)';\n        var center = _this3.box.getAbsolutePoint([.5, .5]);\n        var xSign = center[0] - _this3.cropperEl.offsetWidth / 2 >> 31;\n        var ySign = center[1] - _this3.cropperEl.offsetHeight / 2 >> 31;\n        var quadrant = (xSign ^ ySign) + ySign + ySign + 4;\n        var foregroundHandleIndex = -2 * quadrant + 8;\n        for (var i = 0; i < _this3.handles.length; i++) {\n          var handle = _this3.handles[i];\n          var handleWidth = handle.el.offsetWidth;\n          var handleHeight = handle.el.offsetHeight;\n          var left = x1 + width * handle.position[0] - handleWidth / 2;\n          var top = y1 + height * handle.position[1] - handleHeight / 2;\n          handle.el.style.transform = 'translate(' + Math.round(left) + 'px, ' + Math.round(top) + 'px)';\n          handle.el.style.zIndex = foregroundHandleIndex == i ? 5 : 4;\n        }\n      });\n    }\n  }, {\n    key: 'attachHandlerEvents',\n    value: function attachHandlerEvents() {\n      var eventBus = this.eventBus;\n      eventBus.addEventListener('handlestart', this.onHandleMoveStart.bind(this));\n      eventBus.addEventListener('handlemove', this.onHandleMoveMoving.bind(this));\n      eventBus.addEventListener('handleend', this.onHandleMoveEnd.bind(this));\n    }\n  }, {\n    key: 'attachRegionEvents',\n    value: function attachRegionEvents() {\n      var eventBus = this.eventBus;\n      var self = this;\n      this.regionEl.addEventListener('mousedown', onMouseDown);\n      eventBus.addEventListener('regionstart', this.onRegionMoveStart.bind(this));\n      eventBus.addEventListener('regionmove', this.onRegionMoveMoving.bind(this));\n      eventBus.addEventListener('regionend', this.onRegionMoveEnd.bind(this));\n      function onMouseDown(e) {\n        e.stopPropagation();\n        document.addEventListener('mouseup', onMouseUp);\n        document.addEventListener('mousemove', onMouseMove);\n        eventBus.dispatchEvent(new CustomEvent('regionstart', {\n          detail: { mouseX: e.clientX, mouseY: e.clientY }\n        }));\n      }\n      function onMouseMove(e) {\n        e.stopPropagation();\n        eventBus.dispatchEvent(new CustomEvent('regionmove', {\n          detail: { mouseX: e.clientX, mouseY: e.clientY }\n        }));\n      }\n      function onMouseUp(e) {\n        e.stopPropagation();\n        document.removeEventListener('mouseup', onMouseUp);\n        document.removeEventListener('mousemove', onMouseMove);\n        eventBus.dispatchEvent(new CustomEvent('regionend', {\n          detail: { mouseX: e.clientX, mouseY: e.clientY }\n        }));\n      }\n    }\n  }, {\n    key: 'attachOverlayEvents',\n    value: function attachOverlayEvents() {\n      var SOUTHEAST_HANDLE_IDX = 4;\n      var self = this;\n      var tmpBox = null;\n      this.overlayEl.addEventListener('mousedown', onMouseDown);\n      function onMouseDown(e) {\n        e.stopPropagation();\n        document.addEventListener('mouseup', onMouseUp);\n        document.addEventListener('mousemove', onMouseMove);\n        var container = self.cropperEl.getBoundingClientRect();\n        var mouseX = e.clientX - container.left;\n        var mouseY = e.clientY - container.top;\n        tmpBox = self.box;\n        self.box = new Box(mouseX, mouseY, mouseX + 1, mouseY + 1);\n        self.eventBus.dispatchEvent(new CustomEvent('handlestart', {\n          detail: { handle: self.handles[SOUTHEAST_HANDLE_IDX] }\n        }));\n      }\n      function onMouseMove(e) {\n        e.stopPropagation();\n        self.eventBus.dispatchEvent(new CustomEvent('handlemove', {\n          detail: { mouseX: e.clientX, mouseY: e.clientY }\n        }));\n      }\n      function onMouseUp(e) {\n        e.stopPropagation();\n        document.removeEventListener('mouseup', onMouseUp);\n        document.removeEventListener('mousemove', onMouseMove);\n        if (self.box.width() === 1 && self.box.height() === 1) {\n          self.box = tmpBox;\n          return;\n        }\n        self.eventBus.dispatchEvent(new CustomEvent('handleend', {\n          detail: { mouseX: e.clientX, mouseY: e.clientY }\n        }));\n      }\n    }\n  }, {\n    key: 'onHandleMoveStart',\n    value: function onHandleMoveStart(e) {\n      var handle = e.detail.handle;\n      var originPoint = [1 - handle.position[0], 1 - handle.position[1]];\n      var _box$getAbsolutePoint = this.box.getAbsolutePoint(originPoint),\n          _box$getAbsolutePoint2 = slicedToArray(_box$getAbsolutePoint, 2),\n          originX = _box$getAbsolutePoint2[0],\n          originY = _box$getAbsolutePoint2[1];\n      this.activeHandle = { handle: handle, originPoint: originPoint, originX: originX, originY: originY };\n      if (this.options.onCropStart !== null) {\n        this.options.onCropStart(this.getValue());\n      }\n    }\n  }, {\n    key: 'onHandleMoveMoving',\n    value: function onHandleMoveMoving(e) {\n      var _e$detail = e.detail,\n          mouseX = _e$detail.mouseX,\n          mouseY = _e$detail.mouseY;\n      var container = this.cropperEl.getBoundingClientRect();\n      mouseX = mouseX - container.left;\n      mouseY = mouseY - container.top;\n      if (mouseX < 0) {\n        mouseX = 0;\n      } else if (mouseX > container.width) {\n        mouseX = container.width;\n      }\n      if (mouseY < 0) {\n        mouseY = 0;\n      } else if (mouseY > container.height) {\n        mouseY = container.height;\n      }\n      var origin = this.activeHandle.originPoint.slice();\n      var originX = this.activeHandle.originX;\n      var originY = this.activeHandle.originY;\n      var handle = this.activeHandle.handle;\n      var TOP_MOVABLE = handle.constraints[0] === 1;\n      var RIGHT_MOVABLE = handle.constraints[1] === 1;\n      var BOTTOM_MOVABLE = handle.constraints[2] === 1;\n      var LEFT_MOVABLE = handle.constraints[3] === 1;\n      var MULTI_AXIS = (LEFT_MOVABLE || RIGHT_MOVABLE) && (TOP_MOVABLE || BOTTOM_MOVABLE);\n      var x1 = LEFT_MOVABLE || RIGHT_MOVABLE ? originX : this.box.x1;\n      var x2 = LEFT_MOVABLE || RIGHT_MOVABLE ? originX : this.box.x2;\n      var y1 = TOP_MOVABLE || BOTTOM_MOVABLE ? originY : this.box.y1;\n      var y2 = TOP_MOVABLE || BOTTOM_MOVABLE ? originY : this.box.y2;\n      x1 = LEFT_MOVABLE ? mouseX : x1;\n      x2 = RIGHT_MOVABLE ? mouseX : x2;\n      y1 = TOP_MOVABLE ? mouseY : y1;\n      y2 = BOTTOM_MOVABLE ? mouseY : y2;\n      var isFlippedX = false,\n          isFlippedY = false;\n      if (LEFT_MOVABLE || RIGHT_MOVABLE) {\n        isFlippedX = LEFT_MOVABLE ? mouseX > originX : mouseX < originX;\n      }\n      if (TOP_MOVABLE || BOTTOM_MOVABLE) {\n        isFlippedY = TOP_MOVABLE ? mouseY > originY : mouseY < originY;\n      }\n      if (isFlippedX) {\n        var tmp = x1;x1 = x2;x2 = tmp;\n        origin[0] = 1 - origin[0];\n      }\n      if (isFlippedY) {\n        var _tmp = y1;y1 = y2;y2 = _tmp;\n        origin[1] = 1 - origin[1];\n      }\n      var box = new Box(x1, y1, x2, y2);\n      if (this.options.aspectRatio) {\n        var ratio = this.options.aspectRatio;\n        var isVerticalMovement = false;\n        if (MULTI_AXIS) {\n          isVerticalMovement = mouseY > box.y1 + ratio * box.width() || mouseY < box.y2 - ratio * box.width();\n        } else if (TOP_MOVABLE || BOTTOM_MOVABLE) {\n          isVerticalMovement = true;\n        }\n        var ratioMode = isVerticalMovement ? 'width' : 'height';\n        box.constrainToRatio(ratio, origin, ratioMode);\n      }\n      var min = this.options.minSize;\n      var max = this.options.maxSize;\n      box.constrainToSize(max.width, max.height, min.width, min.height, origin, this.options.aspectRatio);\n      var parentWidth = this.cropperEl.offsetWidth;\n      var parentHeight = this.cropperEl.offsetHeight;\n      box.constrainToBoundary(parentWidth, parentHeight, origin);\n      this.box = box;\n      this.redraw();\n      if (this.options.onCropMove !== null) {\n        this.options.onCropMove(this.getValue());\n      }\n    }\n  }, {\n    key: 'onHandleMoveEnd',\n    value: function onHandleMoveEnd(e) {\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n    }\n  }, {\n    key: 'onRegionMoveStart',\n    value: function onRegionMoveStart(e) {\n      var _e$detail2 = e.detail,\n          mouseX = _e$detail2.mouseX,\n          mouseY = _e$detail2.mouseY;\n      var container = this.cropperEl.getBoundingClientRect();\n      mouseX = mouseX - container.left;\n      mouseY = mouseY - container.top;\n      this.currentMove = {\n        offsetX: mouseX - this.box.x1,\n        offsetY: mouseY - this.box.y1\n      };\n      if (this.options.onCropStart !== null) {\n        this.options.onCropStart(this.getValue());\n      }\n    }\n  }, {\n    key: 'onRegionMoveMoving',\n    value: function onRegionMoveMoving(e) {\n      var _e$detail3 = e.detail,\n          mouseX = _e$detail3.mouseX,\n          mouseY = _e$detail3.mouseY;\n      var _currentMove = this.currentMove,\n          offsetX = _currentMove.offsetX,\n          offsetY = _currentMove.offsetY;\n      var container = this.cropperEl.getBoundingClientRect();\n      mouseX = mouseX - container.left;\n      mouseY = mouseY - container.top;\n      this.box.move(mouseX - offsetX, mouseY - offsetY);\n      if (this.box.x1 < 0) {\n        this.box.move(0, null);\n      }\n      if (this.box.x2 > container.width) {\n        this.box.move(container.width - this.box.width(), null);\n      }\n      if (this.box.y1 < 0) {\n        this.box.move(null, 0);\n      }\n      if (this.box.y2 > container.height) {\n        this.box.move(null, container.height - this.box.height());\n      }\n      this.redraw();\n      if (this.options.onCropMove !== null) {\n        this.options.onCropMove(this.getValue());\n      }\n    }\n  }, {\n    key: 'onRegionMoveEnd',\n    value: function onRegionMoveEnd(e) {\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n    }\n  }, {\n    key: 'getValue',\n    value: function getValue() {\n      var mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n      if (mode === null) {\n        mode = this.options.returnMode;\n      }\n      if (mode == 'real') {\n        var actualWidth = this.imageEl.naturalWidth;\n        var actualHeight = this.imageEl.naturalHeight;\n        var _imageEl$getBoundingC = this.imageEl.getBoundingClientRect(),\n            elementWidth = _imageEl$getBoundingC.width,\n            elementHeight = _imageEl$getBoundingC.height;\n        var factorX = actualWidth / elementWidth;\n        var factorY = actualHeight / elementHeight;\n        return {\n          x: Math.round(this.box.x1 * factorX),\n          y: Math.round(this.box.y1 * factorY),\n          width: Math.round(this.box.width() * factorX),\n          height: Math.round(this.box.height() * factorY)\n        };\n      } else if (mode == 'ratio') {\n        var _imageEl$getBoundingC2 = this.imageEl.getBoundingClientRect(),\n            _elementWidth = _imageEl$getBoundingC2.width,\n            _elementHeight = _imageEl$getBoundingC2.height;\n        return {\n          x: round(this.box.x1 / _elementWidth, 3),\n          y: round(this.box.y1 / _elementHeight, 3),\n          width: round(this.box.width() / _elementWidth, 3),\n          height: round(this.box.height() / _elementHeight, 3)\n        };\n      } else if (mode == 'raw') {\n        return {\n          x: Math.round(this.box.x1),\n          y: Math.round(this.box.y1),\n          width: Math.round(this.box.width()),\n          height: Math.round(this.box.height())\n        };\n      }\n    }\n  }], [{\n    key: 'parseOptions',\n    value: function parseOptions(opts) {\n      var defaults$$1 = {\n        aspectRatio: null,\n        maxSize: { width: null, height: null },\n        minSize: { width: null, height: null },\n        startSize: { width: 100, height: 100, unit: '%' },\n        returnMode: 'real',\n        onInitialize: null,\n        onCropStart: null,\n        onCropMove: null,\n        onCropEnd: null\n      };\n      var aspectRatio = null;\n      if (opts.aspectRatio !== undefined) {\n        if (typeof opts.aspectRatio === 'number') {\n          aspectRatio = opts.aspectRatio;\n        } else if (opts.aspectRatio instanceof Array) {\n          aspectRatio = opts.aspectRatio[1] / opts.aspectRatio[0];\n        }\n      }\n      var maxSize = null;\n      if (opts.maxSize !== undefined && opts.maxSize !== null) {\n        maxSize = {\n          width: opts.maxSize[0] || null,\n          height: opts.maxSize[1] || null,\n          unit: opts.maxSize[2] || 'px'\n        };\n      }\n      var minSize = null;\n      if (opts.minSize !== undefined && opts.minSize !== null) {\n        minSize = {\n          width: opts.minSize[0] || null,\n          height: opts.minSize[1] || null,\n          unit: opts.minSize[2] || 'px'\n        };\n      }\n      var startSize = null;\n      if (opts.startSize !== undefined && opts.startSize !== null) {\n        startSize = {\n          width: opts.startSize[0] || null,\n          height: opts.startSize[1] || null,\n          unit: opts.startSize[2] || '%'\n        };\n      }\n      var onInitialize = null;\n      if (typeof opts.onInitialize === 'function') {\n        onInitialize = opts.onInitialize;\n      }\n      var onCropStart = null;\n      if (typeof opts.onCropStart === 'function') {\n        onCropStart = opts.onCropStart;\n      }\n      var onCropEnd = null;\n      if (typeof opts.onCropEnd === 'function') {\n        onCropEnd = opts.onCropEnd;\n      }\n      var onCropMove = null;\n      if (typeof opts.onUpdate === 'function') {\n        console.warn('Croppr.js: `onUpdate` is deprecated and will be removed in the next major release. Please use `onCropMove` or `onCropEnd` instead.');\n        onCropMove = opts.onUpdate;\n      }\n      if (typeof opts.onCropMove === 'function') {\n        onCropMove = opts.onCropMove;\n      }\n      var returnMode = null;\n      if (opts.returnMode !== undefined) {\n        var s = opts.returnMode.toLowerCase();\n        if (['real', 'ratio', 'raw'].indexOf(s) === -1) {\n          throw \"Invalid return mode.\";\n        }\n        returnMode = s;\n      }\n      var convertToPixels = function convertToPixels(container) {\n        var width = container.offsetWidth;\n        var height = container.offsetHeight;\n        var sizeKeys = ['maxSize', 'minSize', 'startSize'];\n        for (var i = 0; i < sizeKeys.length; i++) {\n          var key = sizeKeys[i];\n          if (this[key] !== null) {\n            if (this[key].unit == '%') {\n              if (this[key].width !== null) {\n                this[key].width = this[key].width / 100 * width;\n              }\n              if (this[key].height !== null) {\n                this[key].height = this[key].height / 100 * height;\n              }\n            }\n            delete this[key].unit;\n          }\n        }\n      };\n      var defaultValue = function defaultValue(v, d) {\n        return v !== null ? v : d;\n      };\n      return {\n        aspectRatio: defaultValue(aspectRatio, defaults$$1.aspectRatio),\n        maxSize: defaultValue(maxSize, defaults$$1.maxSize),\n        minSize: defaultValue(minSize, defaults$$1.minSize),\n        startSize: defaultValue(startSize, defaults$$1.startSize),\n        returnMode: defaultValue(returnMode, defaults$$1.returnMode),\n        onInitialize: defaultValue(onInitialize, defaults$$1.onInitialize),\n        onCropStart: defaultValue(onCropStart, defaults$$1.onCropStart),\n        onCropMove: defaultValue(onCropMove, defaults$$1.onCropMove),\n        onCropEnd: defaultValue(onCropEnd, defaults$$1.onCropEnd),\n        convertToPixels: convertToPixels\n      };\n    }\n  }]);\n  return CropprCore;\n}();\nfunction round(value, decimals) {\n  return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals);\n}\n\nvar Croppr$1 = function (_CropprCore) {\n  inherits(Croppr, _CropprCore);\n  /**\n   * @constructor\n   * Calls the CropprCore's constructor.\n   */\n  function Croppr(element, options) {\n    var _deferred = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n    classCallCheck(this, Croppr);\n    return possibleConstructorReturn(this, (Croppr.__proto__ || Object.getPrototypeOf(Croppr)).call(this, element, options, _deferred));\n  }\n  /**\n   * Gets the value of the crop region.\n   * @param {String} [mode] Which mode of calculation to use: 'real', 'ratio' or\n   *      'raw'.\n   */\n  createClass(Croppr, [{\n    key: 'getValue',\n    value: function getValue(mode) {\n      return get(Croppr.prototype.__proto__ || Object.getPrototypeOf(Croppr.prototype), 'getValue', this).call(this, mode);\n    }\n    /**\n     * Changes the image src.\n     * @param {String} src\n     */\n  }, {\n    key: 'setImage',\n    value: function setImage(src) {\n      return get(Croppr.prototype.__proto__ || Object.getPrototypeOf(Croppr.prototype), 'setImage', this).call(this, src);\n    }\n  }, {\n    key: 'destroy',\n    value: function destroy() {\n      return get(Croppr.prototype.__proto__ || Object.getPrototypeOf(Croppr.prototype), 'destroy', this).call(this);\n    }\n    /**\n     * Moves the crop region to a specified coordinate.\n     * @param {Number} x\n     * @param {Number} y\n     */\n  }, {\n    key: 'moveTo',\n    value: function moveTo(x, y) {\n      this.box.move(x, y);\n      this.redraw();\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n      return this;\n    }\n    /**\n     * Resizes the crop region to a specified width and height.\n     * @param {Number} width\n     * @param {Number} height\n     * @param {Array} origin The origin point to resize from.\n     *      Defaults to [0.5, 0.5] (center).\n     */\n  }, {\n    key: 'resizeTo',\n    value: function resizeTo(width, height) {\n      var origin = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [.5, .5];\n      this.box.resize(width, height, origin);\n      this.redraw();\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n      return this;\n    }\n    /**\n     * Scale the crop region by a factor.\n     * @param {Number} factor\n     * @param {Array} origin The origin point to resize from.\n     *      Defaults to [0.5, 0.5] (center).\n     */\n  }, {\n    key: 'scaleBy',\n    value: function scaleBy(factor) {\n      var origin = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [.5, .5];\n      this.box.scale(factor, origin);\n      this.redraw();\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n      return this;\n    }\n  }, {\n    key: 'reset',\n    value: function reset() {\n      this.box = this.initializeBox(this.options);\n      this.redraw();\n      if (this.options.onCropEnd !== null) {\n        this.options.onCropEnd(this.getValue());\n      }\n      return this;\n    }\n  }]);\n  return Croppr;\n}(CropprCore);\n\nreturn Croppr$1;\n\n})));\n\n\n//# sourceURL=webpack:///./node_modules/croppr/dist/croppr.js?");

/***/ }),

/***/ "./node_modules/flatpickr/dist/flatpickr.js":
/*!**************************************************!*\
  !*** ./node_modules/flatpickr/dist/flatpickr.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/* flatpickr v4.6.3, @license MIT */\n(function (global, factory) {\n     true ? module.exports = factory() :\n    undefined;\n}(this, function () { 'use strict';\n\n    /*! *****************************************************************************\r\n    Copyright (c) Microsoft Corporation. All rights reserved.\r\n    Licensed under the Apache License, Version 2.0 (the \"License\"); you may not use\r\n    this file except in compliance with the License. You may obtain a copy of the\r\n    License at http://www.apache.org/licenses/LICENSE-2.0\r\n\r\n    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\r\n    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED\r\n    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,\r\n    MERCHANTABLITY OR NON-INFRINGEMENT.\r\n\r\n    See the Apache Version 2.0 License for specific language governing permissions\r\n    and limitations under the License.\r\n    ***************************************************************************** */\r\n\r\n    var __assign = function() {\r\n        __assign = Object.assign || function __assign(t) {\r\n            for (var s, i = 1, n = arguments.length; i < n; i++) {\r\n                s = arguments[i];\r\n                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];\r\n            }\r\n            return t;\r\n        };\r\n        return __assign.apply(this, arguments);\r\n    };\n\n    var HOOKS = [\n        \"onChange\",\n        \"onClose\",\n        \"onDayCreate\",\n        \"onDestroy\",\n        \"onKeyDown\",\n        \"onMonthChange\",\n        \"onOpen\",\n        \"onParseConfig\",\n        \"onReady\",\n        \"onValueUpdate\",\n        \"onYearChange\",\n        \"onPreCalendarPosition\",\n    ];\n    var defaults = {\n        _disable: [],\n        _enable: [],\n        allowInput: false,\n        altFormat: \"F j, Y\",\n        altInput: false,\n        altInputClass: \"form-control input\",\n        animate: typeof window === \"object\" &&\n            window.navigator.userAgent.indexOf(\"MSIE\") === -1,\n        ariaDateFormat: \"F j, Y\",\n        clickOpens: true,\n        closeOnSelect: true,\n        conjunction: \", \",\n        dateFormat: \"Y-m-d\",\n        defaultHour: 12,\n        defaultMinute: 0,\n        defaultSeconds: 0,\n        disable: [],\n        disableMobile: false,\n        enable: [],\n        enableSeconds: false,\n        enableTime: false,\n        errorHandler: function (err) {\n            return typeof console !== \"undefined\" && console.warn(err);\n        },\n        getWeek: function (givenDate) {\n            var date = new Date(givenDate.getTime());\n            date.setHours(0, 0, 0, 0);\n            // Thursday in current week decides the year.\n            date.setDate(date.getDate() + 3 - ((date.getDay() + 6) % 7));\n            // January 4 is always in week 1.\n            var week1 = new Date(date.getFullYear(), 0, 4);\n            // Adjust to Thursday in week 1 and count number of weeks from date to week1.\n            return (1 +\n                Math.round(((date.getTime() - week1.getTime()) / 86400000 -\n                    3 +\n                    ((week1.getDay() + 6) % 7)) /\n                    7));\n        },\n        hourIncrement: 1,\n        ignoredFocusElements: [],\n        inline: false,\n        locale: \"default\",\n        minuteIncrement: 5,\n        mode: \"single\",\n        monthSelectorType: \"dropdown\",\n        nextArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M13.207 8.472l-7.854 7.854-0.707-0.707 7.146-7.146-7.146-7.148 0.707-0.707 7.854 7.854z' /></svg>\",\n        noCalendar: false,\n        now: new Date(),\n        onChange: [],\n        onClose: [],\n        onDayCreate: [],\n        onDestroy: [],\n        onKeyDown: [],\n        onMonthChange: [],\n        onOpen: [],\n        onParseConfig: [],\n        onReady: [],\n        onValueUpdate: [],\n        onYearChange: [],\n        onPreCalendarPosition: [],\n        plugins: [],\n        position: \"auto\",\n        positionElement: undefined,\n        prevArrow: \"<svg version='1.1' xmlns='http://www.w3.org/2000/svg' xmlns:xlink='http://www.w3.org/1999/xlink' viewBox='0 0 17 17'><g></g><path d='M5.207 8.471l7.146 7.147-0.707 0.707-7.853-7.854 7.854-7.853 0.707 0.707-7.147 7.146z' /></svg>\",\n        shorthandCurrentMonth: false,\n        showMonths: 1,\n        static: false,\n        time_24hr: false,\n        weekNumbers: false,\n        wrap: false\n    };\n\n    var english = {\n        weekdays: {\n            shorthand: [\"Sun\", \"Mon\", \"Tue\", \"Wed\", \"Thu\", \"Fri\", \"Sat\"],\n            longhand: [\n                \"Sunday\",\n                \"Monday\",\n                \"Tuesday\",\n                \"Wednesday\",\n                \"Thursday\",\n                \"Friday\",\n                \"Saturday\",\n            ]\n        },\n        months: {\n            shorthand: [\n                \"Jan\",\n                \"Feb\",\n                \"Mar\",\n                \"Apr\",\n                \"May\",\n                \"Jun\",\n                \"Jul\",\n                \"Aug\",\n                \"Sep\",\n                \"Oct\",\n                \"Nov\",\n                \"Dec\",\n            ],\n            longhand: [\n                \"January\",\n                \"February\",\n                \"March\",\n                \"April\",\n                \"May\",\n                \"June\",\n                \"July\",\n                \"August\",\n                \"September\",\n                \"October\",\n                \"November\",\n                \"December\",\n            ]\n        },\n        daysInMonth: [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],\n        firstDayOfWeek: 0,\n        ordinal: function (nth) {\n            var s = nth % 100;\n            if (s > 3 && s < 21)\n                return \"th\";\n            switch (s % 10) {\n                case 1:\n                    return \"st\";\n                case 2:\n                    return \"nd\";\n                case 3:\n                    return \"rd\";\n                default:\n                    return \"th\";\n            }\n        },\n        rangeSeparator: \" to \",\n        weekAbbreviation: \"Wk\",\n        scrollTitle: \"Scroll to increment\",\n        toggleTitle: \"Click to toggle\",\n        amPM: [\"AM\", \"PM\"],\n        yearAriaLabel: \"Year\",\n        hourAriaLabel: \"Hour\",\n        minuteAriaLabel: \"Minute\",\n        time_24hr: false\n    };\n\n    var pad = function (number) { return (\"0\" + number).slice(-2); };\n    var int = function (bool) { return (bool === true ? 1 : 0); };\n    /* istanbul ignore next */\n    function debounce(func, wait, immediate) {\n        if (immediate === void 0) { immediate = false; }\n        var timeout;\n        return function () {\n            var context = this, args = arguments;\n            timeout !== null && clearTimeout(timeout);\n            timeout = window.setTimeout(function () {\n                timeout = null;\n                if (!immediate)\n                    func.apply(context, args);\n            }, wait);\n            if (immediate && !timeout)\n                func.apply(context, args);\n        };\n    }\n    var arrayify = function (obj) {\n        return obj instanceof Array ? obj : [obj];\n    };\n\n    function toggleClass(elem, className, bool) {\n        if (bool === true)\n            return elem.classList.add(className);\n        elem.classList.remove(className);\n    }\n    function createElement(tag, className, content) {\n        var e = window.document.createElement(tag);\n        className = className || \"\";\n        content = content || \"\";\n        e.className = className;\n        if (content !== undefined)\n            e.textContent = content;\n        return e;\n    }\n    function clearNode(node) {\n        while (node.firstChild)\n            node.removeChild(node.firstChild);\n    }\n    function findParent(node, condition) {\n        if (condition(node))\n            return node;\n        else if (node.parentNode)\n            return findParent(node.parentNode, condition);\n        return undefined; // nothing found\n    }\n    function createNumberInput(inputClassName, opts) {\n        var wrapper = createElement(\"div\", \"numInputWrapper\"), numInput = createElement(\"input\", \"numInput \" + inputClassName), arrowUp = createElement(\"span\", \"arrowUp\"), arrowDown = createElement(\"span\", \"arrowDown\");\n        if (navigator.userAgent.indexOf(\"MSIE 9.0\") === -1) {\n            numInput.type = \"number\";\n        }\n        else {\n            numInput.type = \"text\";\n            numInput.pattern = \"\\\\d*\";\n        }\n        if (opts !== undefined)\n            for (var key in opts)\n                numInput.setAttribute(key, opts[key]);\n        wrapper.appendChild(numInput);\n        wrapper.appendChild(arrowUp);\n        wrapper.appendChild(arrowDown);\n        return wrapper;\n    }\n    function getEventTarget(event) {\n        if (typeof event.composedPath === \"function\") {\n            var path = event.composedPath();\n            return path[0];\n        }\n        return event.target;\n    }\n\n    var doNothing = function () { return undefined; };\n    var monthToStr = function (monthNumber, shorthand, locale) { return locale.months[shorthand ? \"shorthand\" : \"longhand\"][monthNumber]; };\n    var revFormat = {\n        D: doNothing,\n        F: function (dateObj, monthName, locale) {\n            dateObj.setMonth(locale.months.longhand.indexOf(monthName));\n        },\n        G: function (dateObj, hour) {\n            dateObj.setHours(parseFloat(hour));\n        },\n        H: function (dateObj, hour) {\n            dateObj.setHours(parseFloat(hour));\n        },\n        J: function (dateObj, day) {\n            dateObj.setDate(parseFloat(day));\n        },\n        K: function (dateObj, amPM, locale) {\n            dateObj.setHours((dateObj.getHours() % 12) +\n                12 * int(new RegExp(locale.amPM[1], \"i\").test(amPM)));\n        },\n        M: function (dateObj, shortMonth, locale) {\n            dateObj.setMonth(locale.months.shorthand.indexOf(shortMonth));\n        },\n        S: function (dateObj, seconds) {\n            dateObj.setSeconds(parseFloat(seconds));\n        },\n        U: function (_, unixSeconds) { return new Date(parseFloat(unixSeconds) * 1000); },\n        W: function (dateObj, weekNum, locale) {\n            var weekNumber = parseInt(weekNum);\n            var date = new Date(dateObj.getFullYear(), 0, 2 + (weekNumber - 1) * 7, 0, 0, 0, 0);\n            date.setDate(date.getDate() - date.getDay() + locale.firstDayOfWeek);\n            return date;\n        },\n        Y: function (dateObj, year) {\n            dateObj.setFullYear(parseFloat(year));\n        },\n        Z: function (_, ISODate) { return new Date(ISODate); },\n        d: function (dateObj, day) {\n            dateObj.setDate(parseFloat(day));\n        },\n        h: function (dateObj, hour) {\n            dateObj.setHours(parseFloat(hour));\n        },\n        i: function (dateObj, minutes) {\n            dateObj.setMinutes(parseFloat(minutes));\n        },\n        j: function (dateObj, day) {\n            dateObj.setDate(parseFloat(day));\n        },\n        l: doNothing,\n        m: function (dateObj, month) {\n            dateObj.setMonth(parseFloat(month) - 1);\n        },\n        n: function (dateObj, month) {\n            dateObj.setMonth(parseFloat(month) - 1);\n        },\n        s: function (dateObj, seconds) {\n            dateObj.setSeconds(parseFloat(seconds));\n        },\n        u: function (_, unixMillSeconds) {\n            return new Date(parseFloat(unixMillSeconds));\n        },\n        w: doNothing,\n        y: function (dateObj, year) {\n            dateObj.setFullYear(2000 + parseFloat(year));\n        }\n    };\n    var tokenRegex = {\n        D: \"(\\\\w+)\",\n        F: \"(\\\\w+)\",\n        G: \"(\\\\d\\\\d|\\\\d)\",\n        H: \"(\\\\d\\\\d|\\\\d)\",\n        J: \"(\\\\d\\\\d|\\\\d)\\\\w+\",\n        K: \"\",\n        M: \"(\\\\w+)\",\n        S: \"(\\\\d\\\\d|\\\\d)\",\n        U: \"(.+)\",\n        W: \"(\\\\d\\\\d|\\\\d)\",\n        Y: \"(\\\\d{4})\",\n        Z: \"(.+)\",\n        d: \"(\\\\d\\\\d|\\\\d)\",\n        h: \"(\\\\d\\\\d|\\\\d)\",\n        i: \"(\\\\d\\\\d|\\\\d)\",\n        j: \"(\\\\d\\\\d|\\\\d)\",\n        l: \"(\\\\w+)\",\n        m: \"(\\\\d\\\\d|\\\\d)\",\n        n: \"(\\\\d\\\\d|\\\\d)\",\n        s: \"(\\\\d\\\\d|\\\\d)\",\n        u: \"(.+)\",\n        w: \"(\\\\d\\\\d|\\\\d)\",\n        y: \"(\\\\d{2})\"\n    };\n    var formats = {\n        // get the date in UTC\n        Z: function (date) { return date.toISOString(); },\n        // weekday name, short, e.g. Thu\n        D: function (date, locale, options) {\n            return locale.weekdays.shorthand[formats.w(date, locale, options)];\n        },\n        // full month name e.g. January\n        F: function (date, locale, options) {\n            return monthToStr(formats.n(date, locale, options) - 1, false, locale);\n        },\n        // padded hour 1-12\n        G: function (date, locale, options) {\n            return pad(formats.h(date, locale, options));\n        },\n        // hours with leading zero e.g. 03\n        H: function (date) { return pad(date.getHours()); },\n        // day (1-30) with ordinal suffix e.g. 1st, 2nd\n        J: function (date, locale) {\n            return locale.ordinal !== undefined\n                ? date.getDate() + locale.ordinal(date.getDate())\n                : date.getDate();\n        },\n        // AM/PM\n        K: function (date, locale) { return locale.amPM[int(date.getHours() > 11)]; },\n        // shorthand month e.g. Jan, Sep, Oct, etc\n        M: function (date, locale) {\n            return monthToStr(date.getMonth(), true, locale);\n        },\n        // seconds 00-59\n        S: function (date) { return pad(date.getSeconds()); },\n        // unix timestamp\n        U: function (date) { return date.getTime() / 1000; },\n        W: function (date, _, options) {\n            return options.getWeek(date);\n        },\n        // full year e.g. 2016\n        Y: function (date) { return date.getFullYear(); },\n        // day in month, padded (01-30)\n        d: function (date) { return pad(date.getDate()); },\n        // hour from 1-12 (am/pm)\n        h: function (date) { return (date.getHours() % 12 ? date.getHours() % 12 : 12); },\n        // minutes, padded with leading zero e.g. 09\n        i: function (date) { return pad(date.getMinutes()); },\n        // day in month (1-30)\n        j: function (date) { return date.getDate(); },\n        // weekday name, full, e.g. Thursday\n        l: function (date, locale) {\n            return locale.weekdays.longhand[date.getDay()];\n        },\n        // padded month number (01-12)\n        m: function (date) { return pad(date.getMonth() + 1); },\n        // the month number (1-12)\n        n: function (date) { return date.getMonth() + 1; },\n        // seconds 0-59\n        s: function (date) { return date.getSeconds(); },\n        // Unix Milliseconds\n        u: function (date) { return date.getTime(); },\n        // number of the day of the week\n        w: function (date) { return date.getDay(); },\n        // last two digits of year e.g. 16 for 2016\n        y: function (date) { return String(date.getFullYear()).substring(2); }\n    };\n\n    var createDateFormatter = function (_a) {\n        var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;\n        return function (dateObj, frmt, overrideLocale) {\n            var locale = overrideLocale || l10n;\n            if (config.formatDate !== undefined) {\n                return config.formatDate(dateObj, frmt, locale);\n            }\n            return frmt\n                .split(\"\")\n                .map(function (c, i, arr) {\n                return formats[c] && arr[i - 1] !== \"\\\\\"\n                    ? formats[c](dateObj, locale, config)\n                    : c !== \"\\\\\"\n                        ? c\n                        : \"\";\n            })\n                .join(\"\");\n        };\n    };\n    var createDateParser = function (_a) {\n        var _b = _a.config, config = _b === void 0 ? defaults : _b, _c = _a.l10n, l10n = _c === void 0 ? english : _c;\n        return function (date, givenFormat, timeless, customLocale) {\n            if (date !== 0 && !date)\n                return undefined;\n            var locale = customLocale || l10n;\n            var parsedDate;\n            var dateOrig = date;\n            if (date instanceof Date)\n                parsedDate = new Date(date.getTime());\n            else if (typeof date !== \"string\" &&\n                date.toFixed !== undefined // timestamp\n            )\n                // create a copy\n                parsedDate = new Date(date);\n            else if (typeof date === \"string\") {\n                // date string\n                var format = givenFormat || (config || defaults).dateFormat;\n                var datestr = String(date).trim();\n                if (datestr === \"today\") {\n                    parsedDate = new Date();\n                    timeless = true;\n                }\n                else if (/Z$/.test(datestr) ||\n                    /GMT$/.test(datestr) // datestrings w/ timezone\n                )\n                    parsedDate = new Date(date);\n                else if (config && config.parseDate)\n                    parsedDate = config.parseDate(date, format);\n                else {\n                    parsedDate =\n                        !config || !config.noCalendar\n                            ? new Date(new Date().getFullYear(), 0, 1, 0, 0, 0, 0)\n                            : new Date(new Date().setHours(0, 0, 0, 0));\n                    var matched = void 0, ops = [];\n                    for (var i = 0, matchIndex = 0, regexStr = \"\"; i < format.length; i++) {\n                        var token_1 = format[i];\n                        var isBackSlash = token_1 === \"\\\\\";\n                        var escaped = format[i - 1] === \"\\\\\" || isBackSlash;\n                        if (tokenRegex[token_1] && !escaped) {\n                            regexStr += tokenRegex[token_1];\n                            var match = new RegExp(regexStr).exec(date);\n                            if (match && (matched = true)) {\n                                ops[token_1 !== \"Y\" ? \"push\" : \"unshift\"]({\n                                    fn: revFormat[token_1],\n                                    val: match[++matchIndex]\n                                });\n                            }\n                        }\n                        else if (!isBackSlash)\n                            regexStr += \".\"; // don't really care\n                        ops.forEach(function (_a) {\n                            var fn = _a.fn, val = _a.val;\n                            return (parsedDate = fn(parsedDate, val, locale) || parsedDate);\n                        });\n                    }\n                    parsedDate = matched ? parsedDate : undefined;\n                }\n            }\n            /* istanbul ignore next */\n            if (!(parsedDate instanceof Date && !isNaN(parsedDate.getTime()))) {\n                config.errorHandler(new Error(\"Invalid date provided: \" + dateOrig));\n                return undefined;\n            }\n            if (timeless === true)\n                parsedDate.setHours(0, 0, 0, 0);\n            return parsedDate;\n        };\n    };\n    /**\n     * Compute the difference in dates, measured in ms\n     */\n    function compareDates(date1, date2, timeless) {\n        if (timeless === void 0) { timeless = true; }\n        if (timeless !== false) {\n            return (new Date(date1.getTime()).setHours(0, 0, 0, 0) -\n                new Date(date2.getTime()).setHours(0, 0, 0, 0));\n        }\n        return date1.getTime() - date2.getTime();\n    }\n    var isBetween = function (ts, ts1, ts2) {\n        return ts > Math.min(ts1, ts2) && ts < Math.max(ts1, ts2);\n    };\n    var duration = {\n        DAY: 86400000\n    };\n\n    if (typeof Object.assign !== \"function\") {\n        Object.assign = function (target) {\n            var args = [];\n            for (var _i = 1; _i < arguments.length; _i++) {\n                args[_i - 1] = arguments[_i];\n            }\n            if (!target) {\n                throw TypeError(\"Cannot convert undefined or null to object\");\n            }\n            var _loop_1 = function (source) {\n                if (source) {\n                    Object.keys(source).forEach(function (key) { return (target[key] = source[key]); });\n                }\n            };\n            for (var _a = 0, args_1 = args; _a < args_1.length; _a++) {\n                var source = args_1[_a];\n                _loop_1(source);\n            }\n            return target;\n        };\n    }\n\n    var DEBOUNCED_CHANGE_MS = 300;\n    function FlatpickrInstance(element, instanceConfig) {\n        var self = {\n            config: __assign({}, defaults, flatpickr.defaultConfig),\n            l10n: english\n        };\n        self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n        self._handlers = [];\n        self.pluginElements = [];\n        self.loadedPlugins = [];\n        self._bind = bind;\n        self._setHoursFromDate = setHoursFromDate;\n        self._positionCalendar = positionCalendar;\n        self.changeMonth = changeMonth;\n        self.changeYear = changeYear;\n        self.clear = clear;\n        self.close = close;\n        self._createElement = createElement;\n        self.destroy = destroy;\n        self.isEnabled = isEnabled;\n        self.jumpToDate = jumpToDate;\n        self.open = open;\n        self.redraw = redraw;\n        self.set = set;\n        self.setDate = setDate;\n        self.toggle = toggle;\n        function setupHelperFunctions() {\n            self.utils = {\n                getDaysInMonth: function (month, yr) {\n                    if (month === void 0) { month = self.currentMonth; }\n                    if (yr === void 0) { yr = self.currentYear; }\n                    if (month === 1 && ((yr % 4 === 0 && yr % 100 !== 0) || yr % 400 === 0))\n                        return 29;\n                    return self.l10n.daysInMonth[month];\n                }\n            };\n        }\n        function init() {\n            self.element = self.input = element;\n            self.isOpen = false;\n            parseConfig();\n            setupLocale();\n            setupInputs();\n            setupDates();\n            setupHelperFunctions();\n            if (!self.isMobile)\n                build();\n            bindEvents();\n            if (self.selectedDates.length || self.config.noCalendar) {\n                if (self.config.enableTime) {\n                    setHoursFromDate(self.config.noCalendar\n                        ? self.latestSelectedDateObj || self.config.minDate\n                        : undefined);\n                }\n                updateValue(false);\n            }\n            setCalendarWidth();\n            self.showTimeInput =\n                self.selectedDates.length > 0 || self.config.noCalendar;\n            var isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);\n            /* TODO: investigate this further\n        \n              Currently, there is weird positioning behavior in safari causing pages\n              to scroll up. https://github.com/chmln/flatpickr/issues/563\n        \n              However, most browsers are not Safari and positioning is expensive when used\n              in scale. https://github.com/chmln/flatpickr/issues/1096\n            */\n            if (!self.isMobile && isSafari) {\n                positionCalendar();\n            }\n            triggerEvent(\"onReady\");\n        }\n        function bindToInstance(fn) {\n            return fn.bind(self);\n        }\n        function setCalendarWidth() {\n            var config = self.config;\n            if (config.weekNumbers === false && config.showMonths === 1)\n                return;\n            else if (config.noCalendar !== true) {\n                window.requestAnimationFrame(function () {\n                    if (self.calendarContainer !== undefined) {\n                        self.calendarContainer.style.visibility = \"hidden\";\n                        self.calendarContainer.style.display = \"block\";\n                    }\n                    if (self.daysContainer !== undefined) {\n                        var daysWidth = (self.days.offsetWidth + 1) * config.showMonths;\n                        self.daysContainer.style.width = daysWidth + \"px\";\n                        self.calendarContainer.style.width =\n                            daysWidth +\n                                (self.weekWrapper !== undefined\n                                    ? self.weekWrapper.offsetWidth\n                                    : 0) +\n                                \"px\";\n                        self.calendarContainer.style.removeProperty(\"visibility\");\n                        self.calendarContainer.style.removeProperty(\"display\");\n                    }\n                });\n            }\n        }\n        /**\n         * The handler for all events targeting the time inputs\n         */\n        function updateTime(e) {\n            if (self.selectedDates.length === 0) {\n                setDefaultTime();\n            }\n            if (e !== undefined && e.type !== \"blur\") {\n                timeWrapper(e);\n            }\n            var prevValue = self._input.value;\n            setHoursFromInputs();\n            updateValue();\n            if (self._input.value !== prevValue) {\n                self._debouncedChange();\n            }\n        }\n        function ampm2military(hour, amPM) {\n            return (hour % 12) + 12 * int(amPM === self.l10n.amPM[1]);\n        }\n        function military2ampm(hour) {\n            switch (hour % 24) {\n                case 0:\n                case 12:\n                    return 12;\n                default:\n                    return hour % 12;\n            }\n        }\n        /**\n         * Syncs the selected date object time with user's time input\n         */\n        function setHoursFromInputs() {\n            if (self.hourElement === undefined || self.minuteElement === undefined)\n                return;\n            var hours = (parseInt(self.hourElement.value.slice(-2), 10) || 0) % 24, minutes = (parseInt(self.minuteElement.value, 10) || 0) % 60, seconds = self.secondElement !== undefined\n                ? (parseInt(self.secondElement.value, 10) || 0) % 60\n                : 0;\n            if (self.amPM !== undefined) {\n                hours = ampm2military(hours, self.amPM.textContent);\n            }\n            var limitMinHours = self.config.minTime !== undefined ||\n                (self.config.minDate &&\n                    self.minDateHasTime &&\n                    self.latestSelectedDateObj &&\n                    compareDates(self.latestSelectedDateObj, self.config.minDate, true) ===\n                        0);\n            var limitMaxHours = self.config.maxTime !== undefined ||\n                (self.config.maxDate &&\n                    self.maxDateHasTime &&\n                    self.latestSelectedDateObj &&\n                    compareDates(self.latestSelectedDateObj, self.config.maxDate, true) ===\n                        0);\n            if (limitMaxHours) {\n                var maxTime = self.config.maxTime !== undefined\n                    ? self.config.maxTime\n                    : self.config.maxDate;\n                hours = Math.min(hours, maxTime.getHours());\n                if (hours === maxTime.getHours())\n                    minutes = Math.min(minutes, maxTime.getMinutes());\n                if (minutes === maxTime.getMinutes())\n                    seconds = Math.min(seconds, maxTime.getSeconds());\n            }\n            if (limitMinHours) {\n                var minTime = self.config.minTime !== undefined\n                    ? self.config.minTime\n                    : self.config.minDate;\n                hours = Math.max(hours, minTime.getHours());\n                if (hours === minTime.getHours())\n                    minutes = Math.max(minutes, minTime.getMinutes());\n                if (minutes === minTime.getMinutes())\n                    seconds = Math.max(seconds, minTime.getSeconds());\n            }\n            setHours(hours, minutes, seconds);\n        }\n        /**\n         * Syncs time input values with a date\n         */\n        function setHoursFromDate(dateObj) {\n            var date = dateObj || self.latestSelectedDateObj;\n            if (date)\n                setHours(date.getHours(), date.getMinutes(), date.getSeconds());\n        }\n        function setDefaultHours() {\n            var hours = self.config.defaultHour;\n            var minutes = self.config.defaultMinute;\n            var seconds = self.config.defaultSeconds;\n            if (self.config.minDate !== undefined) {\n                var minHr = self.config.minDate.getHours();\n                var minMinutes = self.config.minDate.getMinutes();\n                hours = Math.max(hours, minHr);\n                if (hours === minHr)\n                    minutes = Math.max(minMinutes, minutes);\n                if (hours === minHr && minutes === minMinutes)\n                    seconds = self.config.minDate.getSeconds();\n            }\n            if (self.config.maxDate !== undefined) {\n                var maxHr = self.config.maxDate.getHours();\n                var maxMinutes = self.config.maxDate.getMinutes();\n                hours = Math.min(hours, maxHr);\n                if (hours === maxHr)\n                    minutes = Math.min(maxMinutes, minutes);\n                if (hours === maxHr && minutes === maxMinutes)\n                    seconds = self.config.maxDate.getSeconds();\n            }\n            setHours(hours, minutes, seconds);\n        }\n        /**\n         * Sets the hours, minutes, and optionally seconds\n         * of the latest selected date object and the\n         * corresponding time inputs\n         * @param {Number} hours the hour. whether its military\n         *                 or am-pm gets inferred from config\n         * @param {Number} minutes the minutes\n         * @param {Number} seconds the seconds (optional)\n         */\n        function setHours(hours, minutes, seconds) {\n            if (self.latestSelectedDateObj !== undefined) {\n                self.latestSelectedDateObj.setHours(hours % 24, minutes, seconds || 0, 0);\n            }\n            if (!self.hourElement || !self.minuteElement || self.isMobile)\n                return;\n            self.hourElement.value = pad(!self.config.time_24hr\n                ? ((12 + hours) % 12) + 12 * int(hours % 12 === 0)\n                : hours);\n            self.minuteElement.value = pad(minutes);\n            if (self.amPM !== undefined)\n                self.amPM.textContent = self.l10n.amPM[int(hours >= 12)];\n            if (self.secondElement !== undefined)\n                self.secondElement.value = pad(seconds);\n        }\n        /**\n         * Handles the year input and incrementing events\n         * @param {Event} event the keyup or increment event\n         */\n        function onYearInput(event) {\n            var year = parseInt(event.target.value) + (event.delta || 0);\n            if (year / 1000 > 1 ||\n                (event.key === \"Enter\" && !/[^\\d]/.test(year.toString()))) {\n                changeYear(year);\n            }\n        }\n        /**\n         * Essentially addEventListener + tracking\n         * @param {Element} element the element to addEventListener to\n         * @param {String} event the event name\n         * @param {Function} handler the event handler\n         */\n        function bind(element, event, handler, options) {\n            if (event instanceof Array)\n                return event.forEach(function (ev) { return bind(element, ev, handler, options); });\n            if (element instanceof Array)\n                return element.forEach(function (el) { return bind(el, event, handler, options); });\n            element.addEventListener(event, handler, options);\n            self._handlers.push({\n                element: element,\n                event: event,\n                handler: handler,\n                options: options\n            });\n        }\n        /**\n         * A mousedown handler which mimics click.\n         * Minimizes latency, since we don't need to wait for mouseup in most cases.\n         * Also, avoids handling right clicks.\n         *\n         * @param {Function} handler the event handler\n         */\n        function onClick(handler) {\n            return function (evt) {\n                evt.which === 1 && handler(evt);\n            };\n        }\n        function triggerChange() {\n            triggerEvent(\"onChange\");\n        }\n        /**\n         * Adds all the necessary event listeners\n         */\n        function bindEvents() {\n            if (self.config.wrap) {\n                [\"open\", \"close\", \"toggle\", \"clear\"].forEach(function (evt) {\n                    Array.prototype.forEach.call(self.element.querySelectorAll(\"[data-\" + evt + \"]\"), function (el) {\n                        return bind(el, \"click\", self[evt]);\n                    });\n                });\n            }\n            if (self.isMobile) {\n                setupMobile();\n                return;\n            }\n            var debouncedResize = debounce(onResize, 50);\n            self._debouncedChange = debounce(triggerChange, DEBOUNCED_CHANGE_MS);\n            if (self.daysContainer && !/iPhone|iPad|iPod/i.test(navigator.userAgent))\n                bind(self.daysContainer, \"mouseover\", function (e) {\n                    if (self.config.mode === \"range\")\n                        onMouseOver(e.target);\n                });\n            bind(window.document.body, \"keydown\", onKeyDown);\n            if (!self.config.inline && !self.config.static)\n                bind(window, \"resize\", debouncedResize);\n            if (window.ontouchstart !== undefined)\n                bind(window.document, \"touchstart\", documentClick);\n            else\n                bind(window.document, \"mousedown\", onClick(documentClick));\n            bind(window.document, \"focus\", documentClick, { capture: true });\n            if (self.config.clickOpens === true) {\n                bind(self._input, \"focus\", self.open);\n                bind(self._input, \"mousedown\", onClick(self.open));\n            }\n            if (self.daysContainer !== undefined) {\n                bind(self.monthNav, \"mousedown\", onClick(onMonthNavClick));\n                bind(self.monthNav, [\"keyup\", \"increment\"], onYearInput);\n                bind(self.daysContainer, \"mousedown\", onClick(selectDate));\n            }\n            if (self.timeContainer !== undefined &&\n                self.minuteElement !== undefined &&\n                self.hourElement !== undefined) {\n                var selText = function (e) {\n                    return e.target.select();\n                };\n                bind(self.timeContainer, [\"increment\"], updateTime);\n                bind(self.timeContainer, \"blur\", updateTime, { capture: true });\n                bind(self.timeContainer, \"mousedown\", onClick(timeIncrement));\n                bind([self.hourElement, self.minuteElement], [\"focus\", \"click\"], selText);\n                if (self.secondElement !== undefined)\n                    bind(self.secondElement, \"focus\", function () { return self.secondElement && self.secondElement.select(); });\n                if (self.amPM !== undefined) {\n                    bind(self.amPM, \"mousedown\", onClick(function (e) {\n                        updateTime(e);\n                        triggerChange();\n                    }));\n                }\n            }\n        }\n        /**\n         * Set the calendar view to a particular date.\n         * @param {Date} jumpDate the date to set the view to\n         * @param {boolean} triggerChange if change events should be triggered\n         */\n        function jumpToDate(jumpDate, triggerChange) {\n            var jumpTo = jumpDate !== undefined\n                ? self.parseDate(jumpDate)\n                : self.latestSelectedDateObj ||\n                    (self.config.minDate && self.config.minDate > self.now\n                        ? self.config.minDate\n                        : self.config.maxDate && self.config.maxDate < self.now\n                            ? self.config.maxDate\n                            : self.now);\n            var oldYear = self.currentYear;\n            var oldMonth = self.currentMonth;\n            try {\n                if (jumpTo !== undefined) {\n                    self.currentYear = jumpTo.getFullYear();\n                    self.currentMonth = jumpTo.getMonth();\n                }\n            }\n            catch (e) {\n                /* istanbul ignore next */\n                e.message = \"Invalid date supplied: \" + jumpTo;\n                self.config.errorHandler(e);\n            }\n            if (triggerChange && self.currentYear !== oldYear) {\n                triggerEvent(\"onYearChange\");\n                buildMonthSwitch();\n            }\n            if (triggerChange &&\n                (self.currentYear !== oldYear || self.currentMonth !== oldMonth)) {\n                triggerEvent(\"onMonthChange\");\n            }\n            self.redraw();\n        }\n        /**\n         * The up/down arrow handler for time inputs\n         * @param {Event} e the click event\n         */\n        function timeIncrement(e) {\n            if (~e.target.className.indexOf(\"arrow\"))\n                incrementNumInput(e, e.target.classList.contains(\"arrowUp\") ? 1 : -1);\n        }\n        /**\n         * Increments/decrements the value of input associ-\n         * ated with the up/down arrow by dispatching an\n         * \"increment\" event on the input.\n         *\n         * @param {Event} e the click event\n         * @param {Number} delta the diff (usually 1 or -1)\n         * @param {Element} inputElem the input element\n         */\n        function incrementNumInput(e, delta, inputElem) {\n            var target = e && e.target;\n            var input = inputElem ||\n                (target && target.parentNode && target.parentNode.firstChild);\n            var event = createEvent(\"increment\");\n            event.delta = delta;\n            input && input.dispatchEvent(event);\n        }\n        function build() {\n            var fragment = window.document.createDocumentFragment();\n            self.calendarContainer = createElement(\"div\", \"flatpickr-calendar\");\n            self.calendarContainer.tabIndex = -1;\n            if (!self.config.noCalendar) {\n                fragment.appendChild(buildMonthNav());\n                self.innerContainer = createElement(\"div\", \"flatpickr-innerContainer\");\n                if (self.config.weekNumbers) {\n                    var _a = buildWeeks(), weekWrapper = _a.weekWrapper, weekNumbers = _a.weekNumbers;\n                    self.innerContainer.appendChild(weekWrapper);\n                    self.weekNumbers = weekNumbers;\n                    self.weekWrapper = weekWrapper;\n                }\n                self.rContainer = createElement(\"div\", \"flatpickr-rContainer\");\n                self.rContainer.appendChild(buildWeekdays());\n                if (!self.daysContainer) {\n                    self.daysContainer = createElement(\"div\", \"flatpickr-days\");\n                    self.daysContainer.tabIndex = -1;\n                }\n                buildDays();\n                self.rContainer.appendChild(self.daysContainer);\n                self.innerContainer.appendChild(self.rContainer);\n                fragment.appendChild(self.innerContainer);\n            }\n            if (self.config.enableTime) {\n                fragment.appendChild(buildTime());\n            }\n            toggleClass(self.calendarContainer, \"rangeMode\", self.config.mode === \"range\");\n            toggleClass(self.calendarContainer, \"animate\", self.config.animate === true);\n            toggleClass(self.calendarContainer, \"multiMonth\", self.config.showMonths > 1);\n            self.calendarContainer.appendChild(fragment);\n            var customAppend = self.config.appendTo !== undefined &&\n                self.config.appendTo.nodeType !== undefined;\n            if (self.config.inline || self.config.static) {\n                self.calendarContainer.classList.add(self.config.inline ? \"inline\" : \"static\");\n                if (self.config.inline) {\n                    if (!customAppend && self.element.parentNode)\n                        self.element.parentNode.insertBefore(self.calendarContainer, self._input.nextSibling);\n                    else if (self.config.appendTo !== undefined)\n                        self.config.appendTo.appendChild(self.calendarContainer);\n                }\n                if (self.config.static) {\n                    var wrapper = createElement(\"div\", \"flatpickr-wrapper\");\n                    if (self.element.parentNode)\n                        self.element.parentNode.insertBefore(wrapper, self.element);\n                    wrapper.appendChild(self.element);\n                    if (self.altInput)\n                        wrapper.appendChild(self.altInput);\n                    wrapper.appendChild(self.calendarContainer);\n                }\n            }\n            if (!self.config.static && !self.config.inline)\n                (self.config.appendTo !== undefined\n                    ? self.config.appendTo\n                    : window.document.body).appendChild(self.calendarContainer);\n        }\n        function createDay(className, date, dayNumber, i) {\n            var dateIsEnabled = isEnabled(date, true), dayElement = createElement(\"span\", \"flatpickr-day \" + className, date.getDate().toString());\n            dayElement.dateObj = date;\n            dayElement.$i = i;\n            dayElement.setAttribute(\"aria-label\", self.formatDate(date, self.config.ariaDateFormat));\n            if (className.indexOf(\"hidden\") === -1 &&\n                compareDates(date, self.now) === 0) {\n                self.todayDateElem = dayElement;\n                dayElement.classList.add(\"today\");\n                dayElement.setAttribute(\"aria-current\", \"date\");\n            }\n            if (dateIsEnabled) {\n                dayElement.tabIndex = -1;\n                if (isDateSelected(date)) {\n                    dayElement.classList.add(\"selected\");\n                    self.selectedDateElem = dayElement;\n                    if (self.config.mode === \"range\") {\n                        toggleClass(dayElement, \"startRange\", self.selectedDates[0] &&\n                            compareDates(date, self.selectedDates[0], true) === 0);\n                        toggleClass(dayElement, \"endRange\", self.selectedDates[1] &&\n                            compareDates(date, self.selectedDates[1], true) === 0);\n                        if (className === \"nextMonthDay\")\n                            dayElement.classList.add(\"inRange\");\n                    }\n                }\n            }\n            else {\n                dayElement.classList.add(\"flatpickr-disabled\");\n            }\n            if (self.config.mode === \"range\") {\n                if (isDateInRange(date) && !isDateSelected(date))\n                    dayElement.classList.add(\"inRange\");\n            }\n            if (self.weekNumbers &&\n                self.config.showMonths === 1 &&\n                className !== \"prevMonthDay\" &&\n                dayNumber % 7 === 1) {\n                self.weekNumbers.insertAdjacentHTML(\"beforeend\", \"<span class='flatpickr-day'>\" + self.config.getWeek(date) + \"</span>\");\n            }\n            triggerEvent(\"onDayCreate\", dayElement);\n            return dayElement;\n        }\n        function focusOnDayElem(targetNode) {\n            targetNode.focus();\n            if (self.config.mode === \"range\")\n                onMouseOver(targetNode);\n        }\n        function getFirstAvailableDay(delta) {\n            var startMonth = delta > 0 ? 0 : self.config.showMonths - 1;\n            var endMonth = delta > 0 ? self.config.showMonths : -1;\n            for (var m = startMonth; m != endMonth; m += delta) {\n                var month = self.daysContainer.children[m];\n                var startIndex = delta > 0 ? 0 : month.children.length - 1;\n                var endIndex = delta > 0 ? month.children.length : -1;\n                for (var i = startIndex; i != endIndex; i += delta) {\n                    var c = month.children[i];\n                    if (c.className.indexOf(\"hidden\") === -1 && isEnabled(c.dateObj))\n                        return c;\n                }\n            }\n            return undefined;\n        }\n        function getNextAvailableDay(current, delta) {\n            var givenMonth = current.className.indexOf(\"Month\") === -1\n                ? current.dateObj.getMonth()\n                : self.currentMonth;\n            var endMonth = delta > 0 ? self.config.showMonths : -1;\n            var loopDelta = delta > 0 ? 1 : -1;\n            for (var m = givenMonth - self.currentMonth; m != endMonth; m += loopDelta) {\n                var month = self.daysContainer.children[m];\n                var startIndex = givenMonth - self.currentMonth === m\n                    ? current.$i + delta\n                    : delta < 0\n                        ? month.children.length - 1\n                        : 0;\n                var numMonthDays = month.children.length;\n                for (var i = startIndex; i >= 0 && i < numMonthDays && i != (delta > 0 ? numMonthDays : -1); i += loopDelta) {\n                    var c = month.children[i];\n                    if (c.className.indexOf(\"hidden\") === -1 &&\n                        isEnabled(c.dateObj) &&\n                        Math.abs(current.$i - i) >= Math.abs(delta))\n                        return focusOnDayElem(c);\n                }\n            }\n            self.changeMonth(loopDelta);\n            focusOnDay(getFirstAvailableDay(loopDelta), 0);\n            return undefined;\n        }\n        function focusOnDay(current, offset) {\n            var dayFocused = isInView(document.activeElement || document.body);\n            var startElem = current !== undefined\n                ? current\n                : dayFocused\n                    ? document.activeElement\n                    : self.selectedDateElem !== undefined && isInView(self.selectedDateElem)\n                        ? self.selectedDateElem\n                        : self.todayDateElem !== undefined && isInView(self.todayDateElem)\n                            ? self.todayDateElem\n                            : getFirstAvailableDay(offset > 0 ? 1 : -1);\n            if (startElem === undefined)\n                return self._input.focus();\n            if (!dayFocused)\n                return focusOnDayElem(startElem);\n            getNextAvailableDay(startElem, offset);\n        }\n        function buildMonthDays(year, month) {\n            var firstOfMonth = (new Date(year, month, 1).getDay() - self.l10n.firstDayOfWeek + 7) % 7;\n            var prevMonthDays = self.utils.getDaysInMonth((month - 1 + 12) % 12);\n            var daysInMonth = self.utils.getDaysInMonth(month), days = window.document.createDocumentFragment(), isMultiMonth = self.config.showMonths > 1, prevMonthDayClass = isMultiMonth ? \"prevMonthDay hidden\" : \"prevMonthDay\", nextMonthDayClass = isMultiMonth ? \"nextMonthDay hidden\" : \"nextMonthDay\";\n            var dayNumber = prevMonthDays + 1 - firstOfMonth, dayIndex = 0;\n            // prepend days from the ending of previous month\n            for (; dayNumber <= prevMonthDays; dayNumber++, dayIndex++) {\n                days.appendChild(createDay(prevMonthDayClass, new Date(year, month - 1, dayNumber), dayNumber, dayIndex));\n            }\n            // Start at 1 since there is no 0th day\n            for (dayNumber = 1; dayNumber <= daysInMonth; dayNumber++, dayIndex++) {\n                days.appendChild(createDay(\"\", new Date(year, month, dayNumber), dayNumber, dayIndex));\n            }\n            // append days from the next month\n            for (var dayNum = daysInMonth + 1; dayNum <= 42 - firstOfMonth &&\n                (self.config.showMonths === 1 || dayIndex % 7 !== 0); dayNum++, dayIndex++) {\n                days.appendChild(createDay(nextMonthDayClass, new Date(year, month + 1, dayNum % daysInMonth), dayNum, dayIndex));\n            }\n            //updateNavigationCurrentMonth();\n            var dayContainer = createElement(\"div\", \"dayContainer\");\n            dayContainer.appendChild(days);\n            return dayContainer;\n        }\n        function buildDays() {\n            if (self.daysContainer === undefined) {\n                return;\n            }\n            clearNode(self.daysContainer);\n            // TODO: week numbers for each month\n            if (self.weekNumbers)\n                clearNode(self.weekNumbers);\n            var frag = document.createDocumentFragment();\n            for (var i = 0; i < self.config.showMonths; i++) {\n                var d = new Date(self.currentYear, self.currentMonth, 1);\n                d.setMonth(self.currentMonth + i);\n                frag.appendChild(buildMonthDays(d.getFullYear(), d.getMonth()));\n            }\n            self.daysContainer.appendChild(frag);\n            self.days = self.daysContainer.firstChild;\n            if (self.config.mode === \"range\" && self.selectedDates.length === 1) {\n                onMouseOver();\n            }\n        }\n        function buildMonthSwitch() {\n            if (self.config.showMonths > 1 ||\n                self.config.monthSelectorType !== \"dropdown\")\n                return;\n            var shouldBuildMonth = function (month) {\n                if (self.config.minDate !== undefined &&\n                    self.currentYear === self.config.minDate.getFullYear() &&\n                    month < self.config.minDate.getMonth()) {\n                    return false;\n                }\n                return !(self.config.maxDate !== undefined &&\n                    self.currentYear === self.config.maxDate.getFullYear() &&\n                    month > self.config.maxDate.getMonth());\n            };\n            self.monthsDropdownContainer.tabIndex = -1;\n            self.monthsDropdownContainer.innerHTML = \"\";\n            for (var i = 0; i < 12; i++) {\n                if (!shouldBuildMonth(i))\n                    continue;\n                var month = createElement(\"option\", \"flatpickr-monthDropdown-month\");\n                month.value = new Date(self.currentYear, i).getMonth().toString();\n                month.textContent = monthToStr(i, self.config.shorthandCurrentMonth, self.l10n);\n                month.tabIndex = -1;\n                if (self.currentMonth === i) {\n                    month.selected = true;\n                }\n                self.monthsDropdownContainer.appendChild(month);\n            }\n        }\n        function buildMonth() {\n            var container = createElement(\"div\", \"flatpickr-month\");\n            var monthNavFragment = window.document.createDocumentFragment();\n            var monthElement;\n            if (self.config.showMonths > 1 ||\n                self.config.monthSelectorType === \"static\") {\n                monthElement = createElement(\"span\", \"cur-month\");\n            }\n            else {\n                self.monthsDropdownContainer = createElement(\"select\", \"flatpickr-monthDropdown-months\");\n                bind(self.monthsDropdownContainer, \"change\", function (e) {\n                    var target = e.target;\n                    var selectedMonth = parseInt(target.value, 10);\n                    self.changeMonth(selectedMonth - self.currentMonth);\n                    triggerEvent(\"onMonthChange\");\n                });\n                buildMonthSwitch();\n                monthElement = self.monthsDropdownContainer;\n            }\n            var yearInput = createNumberInput(\"cur-year\", { tabindex: \"-1\" });\n            var yearElement = yearInput.getElementsByTagName(\"input\")[0];\n            yearElement.setAttribute(\"aria-label\", self.l10n.yearAriaLabel);\n            if (self.config.minDate) {\n                yearElement.setAttribute(\"min\", self.config.minDate.getFullYear().toString());\n            }\n            if (self.config.maxDate) {\n                yearElement.setAttribute(\"max\", self.config.maxDate.getFullYear().toString());\n                yearElement.disabled =\n                    !!self.config.minDate &&\n                        self.config.minDate.getFullYear() === self.config.maxDate.getFullYear();\n            }\n            var currentMonth = createElement(\"div\", \"flatpickr-current-month\");\n            currentMonth.appendChild(monthElement);\n            currentMonth.appendChild(yearInput);\n            monthNavFragment.appendChild(currentMonth);\n            container.appendChild(monthNavFragment);\n            return {\n                container: container,\n                yearElement: yearElement,\n                monthElement: monthElement\n            };\n        }\n        function buildMonths() {\n            clearNode(self.monthNav);\n            self.monthNav.appendChild(self.prevMonthNav);\n            if (self.config.showMonths) {\n                self.yearElements = [];\n                self.monthElements = [];\n            }\n            for (var m = self.config.showMonths; m--;) {\n                var month = buildMonth();\n                self.yearElements.push(month.yearElement);\n                self.monthElements.push(month.monthElement);\n                self.monthNav.appendChild(month.container);\n            }\n            self.monthNav.appendChild(self.nextMonthNav);\n        }\n        function buildMonthNav() {\n            self.monthNav = createElement(\"div\", \"flatpickr-months\");\n            self.yearElements = [];\n            self.monthElements = [];\n            self.prevMonthNav = createElement(\"span\", \"flatpickr-prev-month\");\n            self.prevMonthNav.innerHTML = self.config.prevArrow;\n            self.nextMonthNav = createElement(\"span\", \"flatpickr-next-month\");\n            self.nextMonthNav.innerHTML = self.config.nextArrow;\n            buildMonths();\n            Object.defineProperty(self, \"_hidePrevMonthArrow\", {\n                get: function () { return self.__hidePrevMonthArrow; },\n                set: function (bool) {\n                    if (self.__hidePrevMonthArrow !== bool) {\n                        toggleClass(self.prevMonthNav, \"flatpickr-disabled\", bool);\n                        self.__hidePrevMonthArrow = bool;\n                    }\n                }\n            });\n            Object.defineProperty(self, \"_hideNextMonthArrow\", {\n                get: function () { return self.__hideNextMonthArrow; },\n                set: function (bool) {\n                    if (self.__hideNextMonthArrow !== bool) {\n                        toggleClass(self.nextMonthNav, \"flatpickr-disabled\", bool);\n                        self.__hideNextMonthArrow = bool;\n                    }\n                }\n            });\n            self.currentYearElement = self.yearElements[0];\n            updateNavigationCurrentMonth();\n            return self.monthNav;\n        }\n        function buildTime() {\n            self.calendarContainer.classList.add(\"hasTime\");\n            if (self.config.noCalendar)\n                self.calendarContainer.classList.add(\"noCalendar\");\n            self.timeContainer = createElement(\"div\", \"flatpickr-time\");\n            self.timeContainer.tabIndex = -1;\n            var separator = createElement(\"span\", \"flatpickr-time-separator\", \":\");\n            var hourInput = createNumberInput(\"flatpickr-hour\", {\n                \"aria-label\": self.l10n.hourAriaLabel\n            });\n            self.hourElement = hourInput.getElementsByTagName(\"input\")[0];\n            var minuteInput = createNumberInput(\"flatpickr-minute\", {\n                \"aria-label\": self.l10n.minuteAriaLabel\n            });\n            self.minuteElement = minuteInput.getElementsByTagName(\"input\")[0];\n            self.hourElement.tabIndex = self.minuteElement.tabIndex = -1;\n            self.hourElement.value = pad(self.latestSelectedDateObj\n                ? self.latestSelectedDateObj.getHours()\n                : self.config.time_24hr\n                    ? self.config.defaultHour\n                    : military2ampm(self.config.defaultHour));\n            self.minuteElement.value = pad(self.latestSelectedDateObj\n                ? self.latestSelectedDateObj.getMinutes()\n                : self.config.defaultMinute);\n            self.hourElement.setAttribute(\"step\", self.config.hourIncrement.toString());\n            self.minuteElement.setAttribute(\"step\", self.config.minuteIncrement.toString());\n            self.hourElement.setAttribute(\"min\", self.config.time_24hr ? \"0\" : \"1\");\n            self.hourElement.setAttribute(\"max\", self.config.time_24hr ? \"23\" : \"12\");\n            self.minuteElement.setAttribute(\"min\", \"0\");\n            self.minuteElement.setAttribute(\"max\", \"59\");\n            self.timeContainer.appendChild(hourInput);\n            self.timeContainer.appendChild(separator);\n            self.timeContainer.appendChild(minuteInput);\n            if (self.config.time_24hr)\n                self.timeContainer.classList.add(\"time24hr\");\n            if (self.config.enableSeconds) {\n                self.timeContainer.classList.add(\"hasSeconds\");\n                var secondInput = createNumberInput(\"flatpickr-second\");\n                self.secondElement = secondInput.getElementsByTagName(\"input\")[0];\n                self.secondElement.value = pad(self.latestSelectedDateObj\n                    ? self.latestSelectedDateObj.getSeconds()\n                    : self.config.defaultSeconds);\n                self.secondElement.setAttribute(\"step\", self.minuteElement.getAttribute(\"step\"));\n                self.secondElement.setAttribute(\"min\", \"0\");\n                self.secondElement.setAttribute(\"max\", \"59\");\n                self.timeContainer.appendChild(createElement(\"span\", \"flatpickr-time-separator\", \":\"));\n                self.timeContainer.appendChild(secondInput);\n            }\n            if (!self.config.time_24hr) {\n                // add self.amPM if appropriate\n                self.amPM = createElement(\"span\", \"flatpickr-am-pm\", self.l10n.amPM[int((self.latestSelectedDateObj\n                    ? self.hourElement.value\n                    : self.config.defaultHour) > 11)]);\n                self.amPM.title = self.l10n.toggleTitle;\n                self.amPM.tabIndex = -1;\n                self.timeContainer.appendChild(self.amPM);\n            }\n            return self.timeContainer;\n        }\n        function buildWeekdays() {\n            if (!self.weekdayContainer)\n                self.weekdayContainer = createElement(\"div\", \"flatpickr-weekdays\");\n            else\n                clearNode(self.weekdayContainer);\n            for (var i = self.config.showMonths; i--;) {\n                var container = createElement(\"div\", \"flatpickr-weekdaycontainer\");\n                self.weekdayContainer.appendChild(container);\n            }\n            updateWeekdays();\n            return self.weekdayContainer;\n        }\n        function updateWeekdays() {\n            if (!self.weekdayContainer) {\n                return;\n            }\n            var firstDayOfWeek = self.l10n.firstDayOfWeek;\n            var weekdays = self.l10n.weekdays.shorthand.slice();\n            if (firstDayOfWeek > 0 && firstDayOfWeek < weekdays.length) {\n                weekdays = weekdays.splice(firstDayOfWeek, weekdays.length).concat(weekdays.splice(0, firstDayOfWeek));\n            }\n            for (var i = self.config.showMonths; i--;) {\n                self.weekdayContainer.children[i].innerHTML = \"\\n      <span class='flatpickr-weekday'>\\n        \" + weekdays.join(\"</span><span class='flatpickr-weekday'>\") + \"\\n      </span>\\n      \";\n            }\n        }\n        /* istanbul ignore next */\n        function buildWeeks() {\n            self.calendarContainer.classList.add(\"hasWeeks\");\n            var weekWrapper = createElement(\"div\", \"flatpickr-weekwrapper\");\n            weekWrapper.appendChild(createElement(\"span\", \"flatpickr-weekday\", self.l10n.weekAbbreviation));\n            var weekNumbers = createElement(\"div\", \"flatpickr-weeks\");\n            weekWrapper.appendChild(weekNumbers);\n            return {\n                weekWrapper: weekWrapper,\n                weekNumbers: weekNumbers\n            };\n        }\n        function changeMonth(value, isOffset) {\n            if (isOffset === void 0) { isOffset = true; }\n            var delta = isOffset ? value : value - self.currentMonth;\n            if ((delta < 0 && self._hidePrevMonthArrow === true) ||\n                (delta > 0 && self._hideNextMonthArrow === true))\n                return;\n            self.currentMonth += delta;\n            if (self.currentMonth < 0 || self.currentMonth > 11) {\n                self.currentYear += self.currentMonth > 11 ? 1 : -1;\n                self.currentMonth = (self.currentMonth + 12) % 12;\n                triggerEvent(\"onYearChange\");\n                buildMonthSwitch();\n            }\n            buildDays();\n            triggerEvent(\"onMonthChange\");\n            updateNavigationCurrentMonth();\n        }\n        function clear(triggerChangeEvent, toInitial) {\n            if (triggerChangeEvent === void 0) { triggerChangeEvent = true; }\n            if (toInitial === void 0) { toInitial = true; }\n            self.input.value = \"\";\n            if (self.altInput !== undefined)\n                self.altInput.value = \"\";\n            if (self.mobileInput !== undefined)\n                self.mobileInput.value = \"\";\n            self.selectedDates = [];\n            self.latestSelectedDateObj = undefined;\n            if (toInitial === true) {\n                self.currentYear = self._initialDate.getFullYear();\n                self.currentMonth = self._initialDate.getMonth();\n            }\n            self.showTimeInput = false;\n            if (self.config.enableTime === true) {\n                setDefaultHours();\n            }\n            self.redraw();\n            if (triggerChangeEvent)\n                // triggerChangeEvent is true (default) or an Event\n                triggerEvent(\"onChange\");\n        }\n        function close() {\n            self.isOpen = false;\n            if (!self.isMobile) {\n                if (self.calendarContainer !== undefined) {\n                    self.calendarContainer.classList.remove(\"open\");\n                }\n                if (self._input !== undefined) {\n                    self._input.classList.remove(\"active\");\n                }\n            }\n            triggerEvent(\"onClose\");\n        }\n        function destroy() {\n            if (self.config !== undefined)\n                triggerEvent(\"onDestroy\");\n            for (var i = self._handlers.length; i--;) {\n                var h = self._handlers[i];\n                h.element.removeEventListener(h.event, h.handler, h.options);\n            }\n            self._handlers = [];\n            if (self.mobileInput) {\n                if (self.mobileInput.parentNode)\n                    self.mobileInput.parentNode.removeChild(self.mobileInput);\n                self.mobileInput = undefined;\n            }\n            else if (self.calendarContainer && self.calendarContainer.parentNode) {\n                if (self.config.static && self.calendarContainer.parentNode) {\n                    var wrapper = self.calendarContainer.parentNode;\n                    wrapper.lastChild && wrapper.removeChild(wrapper.lastChild);\n                    if (wrapper.parentNode) {\n                        while (wrapper.firstChild)\n                            wrapper.parentNode.insertBefore(wrapper.firstChild, wrapper);\n                        wrapper.parentNode.removeChild(wrapper);\n                    }\n                }\n                else\n                    self.calendarContainer.parentNode.removeChild(self.calendarContainer);\n            }\n            if (self.altInput) {\n                self.input.type = \"text\";\n                if (self.altInput.parentNode)\n                    self.altInput.parentNode.removeChild(self.altInput);\n                delete self.altInput;\n            }\n            if (self.input) {\n                self.input.type = self.input._type;\n                self.input.classList.remove(\"flatpickr-input\");\n                self.input.removeAttribute(\"readonly\");\n                self.input.value = \"\";\n            }\n            [\n                \"_showTimeInput\",\n                \"latestSelectedDateObj\",\n                \"_hideNextMonthArrow\",\n                \"_hidePrevMonthArrow\",\n                \"__hideNextMonthArrow\",\n                \"__hidePrevMonthArrow\",\n                \"isMobile\",\n                \"isOpen\",\n                \"selectedDateElem\",\n                \"minDateHasTime\",\n                \"maxDateHasTime\",\n                \"days\",\n                \"daysContainer\",\n                \"_input\",\n                \"_positionElement\",\n                \"innerContainer\",\n                \"rContainer\",\n                \"monthNav\",\n                \"todayDateElem\",\n                \"calendarContainer\",\n                \"weekdayContainer\",\n                \"prevMonthNav\",\n                \"nextMonthNav\",\n                \"monthsDropdownContainer\",\n                \"currentMonthElement\",\n                \"currentYearElement\",\n                \"navigationCurrentMonth\",\n                \"selectedDateElem\",\n                \"config\",\n            ].forEach(function (k) {\n                try {\n                    delete self[k];\n                }\n                catch (_) { }\n            });\n        }\n        function isCalendarElem(elem) {\n            if (self.config.appendTo && self.config.appendTo.contains(elem))\n                return true;\n            return self.calendarContainer.contains(elem);\n        }\n        function documentClick(e) {\n            if (self.isOpen && !self.config.inline) {\n                var eventTarget_1 = getEventTarget(e);\n                var isCalendarElement = isCalendarElem(eventTarget_1);\n                var isInput = eventTarget_1 === self.input ||\n                    eventTarget_1 === self.altInput ||\n                    self.element.contains(eventTarget_1) ||\n                    // web components\n                    // e.path is not present in all browsers. circumventing typechecks\n                    (e.path &&\n                        e.path.indexOf &&\n                        (~e.path.indexOf(self.input) ||\n                            ~e.path.indexOf(self.altInput)));\n                var lostFocus = e.type === \"blur\"\n                    ? isInput &&\n                        e.relatedTarget &&\n                        !isCalendarElem(e.relatedTarget)\n                    : !isInput &&\n                        !isCalendarElement &&\n                        !isCalendarElem(e.relatedTarget);\n                var isIgnored = !self.config.ignoredFocusElements.some(function (elem) {\n                    return elem.contains(eventTarget_1);\n                });\n                if (lostFocus && isIgnored) {\n                    if (self.timeContainer !== undefined &&\n                        self.minuteElement !== undefined &&\n                        self.hourElement !== undefined) {\n                        updateTime();\n                    }\n                    self.close();\n                    if (self.config.mode === \"range\" && self.selectedDates.length === 1) {\n                        self.clear(false);\n                        self.redraw();\n                    }\n                }\n            }\n        }\n        function changeYear(newYear) {\n            if (!newYear ||\n                (self.config.minDate && newYear < self.config.minDate.getFullYear()) ||\n                (self.config.maxDate && newYear > self.config.maxDate.getFullYear()))\n                return;\n            var newYearNum = newYear, isNewYear = self.currentYear !== newYearNum;\n            self.currentYear = newYearNum || self.currentYear;\n            if (self.config.maxDate &&\n                self.currentYear === self.config.maxDate.getFullYear()) {\n                self.currentMonth = Math.min(self.config.maxDate.getMonth(), self.currentMonth);\n            }\n            else if (self.config.minDate &&\n                self.currentYear === self.config.minDate.getFullYear()) {\n                self.currentMonth = Math.max(self.config.minDate.getMonth(), self.currentMonth);\n            }\n            if (isNewYear) {\n                self.redraw();\n                triggerEvent(\"onYearChange\");\n                buildMonthSwitch();\n            }\n        }\n        function isEnabled(date, timeless) {\n            if (timeless === void 0) { timeless = true; }\n            var dateToCheck = self.parseDate(date, undefined, timeless); // timeless\n            if ((self.config.minDate &&\n                dateToCheck &&\n                compareDates(dateToCheck, self.config.minDate, timeless !== undefined ? timeless : !self.minDateHasTime) < 0) ||\n                (self.config.maxDate &&\n                    dateToCheck &&\n                    compareDates(dateToCheck, self.config.maxDate, timeless !== undefined ? timeless : !self.maxDateHasTime) > 0))\n                return false;\n            if (self.config.enable.length === 0 && self.config.disable.length === 0)\n                return true;\n            if (dateToCheck === undefined)\n                return false;\n            var bool = self.config.enable.length > 0, array = bool ? self.config.enable : self.config.disable;\n            for (var i = 0, d = void 0; i < array.length; i++) {\n                d = array[i];\n                if (typeof d === \"function\" &&\n                    d(dateToCheck) // disabled by function\n                )\n                    return bool;\n                else if (d instanceof Date &&\n                    dateToCheck !== undefined &&\n                    d.getTime() === dateToCheck.getTime())\n                    // disabled by date\n                    return bool;\n                else if (typeof d === \"string\" && dateToCheck !== undefined) {\n                    // disabled by date string\n                    var parsed = self.parseDate(d, undefined, true);\n                    return parsed && parsed.getTime() === dateToCheck.getTime()\n                        ? bool\n                        : !bool;\n                }\n                else if (\n                // disabled by range\n                typeof d === \"object\" &&\n                    dateToCheck !== undefined &&\n                    d.from &&\n                    d.to &&\n                    dateToCheck.getTime() >= d.from.getTime() &&\n                    dateToCheck.getTime() <= d.to.getTime())\n                    return bool;\n            }\n            return !bool;\n        }\n        function isInView(elem) {\n            if (self.daysContainer !== undefined)\n                return (elem.className.indexOf(\"hidden\") === -1 &&\n                    self.daysContainer.contains(elem));\n            return false;\n        }\n        function onKeyDown(e) {\n            // e.key                      e.keyCode\n            // \"Backspace\"                        8\n            // \"Tab\"                              9\n            // \"Enter\"                           13\n            // \"Escape\"     (IE \"Esc\")           27\n            // \"ArrowLeft\"  (IE \"Left\")          37\n            // \"ArrowUp\"    (IE \"Up\")            38\n            // \"ArrowRight\" (IE \"Right\")         39\n            // \"ArrowDown\"  (IE \"Down\")          40\n            // \"Delete\"     (IE \"Del\")           46\n            var isInput = e.target === self._input;\n            var allowInput = self.config.allowInput;\n            var allowKeydown = self.isOpen && (!allowInput || !isInput);\n            var allowInlineKeydown = self.config.inline && isInput && !allowInput;\n            if (e.keyCode === 13 && isInput) {\n                if (allowInput) {\n                    self.setDate(self._input.value, true, e.target === self.altInput\n                        ? self.config.altFormat\n                        : self.config.dateFormat);\n                    return e.target.blur();\n                }\n                else {\n                    self.open();\n                }\n            }\n            else if (isCalendarElem(e.target) ||\n                allowKeydown ||\n                allowInlineKeydown) {\n                var isTimeObj = !!self.timeContainer &&\n                    self.timeContainer.contains(e.target);\n                switch (e.keyCode) {\n                    case 13:\n                        if (isTimeObj) {\n                            e.preventDefault();\n                            updateTime();\n                            focusAndClose();\n                        }\n                        else\n                            selectDate(e);\n                        break;\n                    case 27: // escape\n                        e.preventDefault();\n                        focusAndClose();\n                        break;\n                    case 8:\n                    case 46:\n                        if (isInput && !self.config.allowInput) {\n                            e.preventDefault();\n                            self.clear();\n                        }\n                        break;\n                    case 37:\n                    case 39:\n                        if (!isTimeObj && !isInput) {\n                            e.preventDefault();\n                            if (self.daysContainer !== undefined &&\n                                (allowInput === false ||\n                                    (document.activeElement && isInView(document.activeElement)))) {\n                                var delta_1 = e.keyCode === 39 ? 1 : -1;\n                                if (!e.ctrlKey)\n                                    focusOnDay(undefined, delta_1);\n                                else {\n                                    e.stopPropagation();\n                                    changeMonth(delta_1);\n                                    focusOnDay(getFirstAvailableDay(1), 0);\n                                }\n                            }\n                        }\n                        else if (self.hourElement)\n                            self.hourElement.focus();\n                        break;\n                    case 38:\n                    case 40:\n                        e.preventDefault();\n                        var delta = e.keyCode === 40 ? 1 : -1;\n                        if ((self.daysContainer && e.target.$i !== undefined) ||\n                            e.target === self.input ||\n                            e.target === self.altInput) {\n                            if (e.ctrlKey) {\n                                e.stopPropagation();\n                                changeYear(self.currentYear - delta);\n                                focusOnDay(getFirstAvailableDay(1), 0);\n                            }\n                            else if (!isTimeObj)\n                                focusOnDay(undefined, delta * 7);\n                        }\n                        else if (e.target === self.currentYearElement) {\n                            changeYear(self.currentYear - delta);\n                        }\n                        else if (self.config.enableTime) {\n                            if (!isTimeObj && self.hourElement)\n                                self.hourElement.focus();\n                            updateTime(e);\n                            self._debouncedChange();\n                        }\n                        break;\n                    case 9:\n                        if (isTimeObj) {\n                            var elems = [\n                                self.hourElement,\n                                self.minuteElement,\n                                self.secondElement,\n                                self.amPM,\n                            ]\n                                .concat(self.pluginElements)\n                                .filter(function (x) { return x; });\n                            var i = elems.indexOf(e.target);\n                            if (i !== -1) {\n                                var target = elems[i + (e.shiftKey ? -1 : 1)];\n                                e.preventDefault();\n                                (target || self._input).focus();\n                            }\n                        }\n                        else if (!self.config.noCalendar &&\n                            self.daysContainer &&\n                            self.daysContainer.contains(e.target) &&\n                            e.shiftKey) {\n                            e.preventDefault();\n                            self._input.focus();\n                        }\n                        break;\n                    default:\n                        break;\n                }\n            }\n            if (self.amPM !== undefined && e.target === self.amPM) {\n                switch (e.key) {\n                    case self.l10n.amPM[0].charAt(0):\n                    case self.l10n.amPM[0].charAt(0).toLowerCase():\n                        self.amPM.textContent = self.l10n.amPM[0];\n                        setHoursFromInputs();\n                        updateValue();\n                        break;\n                    case self.l10n.amPM[1].charAt(0):\n                    case self.l10n.amPM[1].charAt(0).toLowerCase():\n                        self.amPM.textContent = self.l10n.amPM[1];\n                        setHoursFromInputs();\n                        updateValue();\n                        break;\n                }\n            }\n            if (isInput || isCalendarElem(e.target)) {\n                triggerEvent(\"onKeyDown\", e);\n            }\n        }\n        function onMouseOver(elem) {\n            if (self.selectedDates.length !== 1 ||\n                (elem &&\n                    (!elem.classList.contains(\"flatpickr-day\") ||\n                        elem.classList.contains(\"flatpickr-disabled\"))))\n                return;\n            var hoverDate = elem\n                ? elem.dateObj.getTime()\n                : self.days.firstElementChild.dateObj.getTime(), initialDate = self.parseDate(self.selectedDates[0], undefined, true).getTime(), rangeStartDate = Math.min(hoverDate, self.selectedDates[0].getTime()), rangeEndDate = Math.max(hoverDate, self.selectedDates[0].getTime());\n            var containsDisabled = false;\n            var minRange = 0, maxRange = 0;\n            for (var t = rangeStartDate; t < rangeEndDate; t += duration.DAY) {\n                if (!isEnabled(new Date(t), true)) {\n                    containsDisabled =\n                        containsDisabled || (t > rangeStartDate && t < rangeEndDate);\n                    if (t < initialDate && (!minRange || t > minRange))\n                        minRange = t;\n                    else if (t > initialDate && (!maxRange || t < maxRange))\n                        maxRange = t;\n                }\n            }\n            for (var m = 0; m < self.config.showMonths; m++) {\n                var month = self.daysContainer.children[m];\n                var _loop_1 = function (i, l) {\n                    var dayElem = month.children[i], date = dayElem.dateObj;\n                    var timestamp = date.getTime();\n                    var outOfRange = (minRange > 0 && timestamp < minRange) ||\n                        (maxRange > 0 && timestamp > maxRange);\n                    if (outOfRange) {\n                        dayElem.classList.add(\"notAllowed\");\n                        [\"inRange\", \"startRange\", \"endRange\"].forEach(function (c) {\n                            dayElem.classList.remove(c);\n                        });\n                        return \"continue\";\n                    }\n                    else if (containsDisabled && !outOfRange)\n                        return \"continue\";\n                    [\"startRange\", \"inRange\", \"endRange\", \"notAllowed\"].forEach(function (c) {\n                        dayElem.classList.remove(c);\n                    });\n                    if (elem !== undefined) {\n                        elem.classList.add(hoverDate <= self.selectedDates[0].getTime()\n                            ? \"startRange\"\n                            : \"endRange\");\n                        if (initialDate < hoverDate && timestamp === initialDate)\n                            dayElem.classList.add(\"startRange\");\n                        else if (initialDate > hoverDate && timestamp === initialDate)\n                            dayElem.classList.add(\"endRange\");\n                        if (timestamp >= minRange &&\n                            (maxRange === 0 || timestamp <= maxRange) &&\n                            isBetween(timestamp, initialDate, hoverDate))\n                            dayElem.classList.add(\"inRange\");\n                    }\n                };\n                for (var i = 0, l = month.children.length; i < l; i++) {\n                    _loop_1(i, l);\n                }\n            }\n        }\n        function onResize() {\n            if (self.isOpen && !self.config.static && !self.config.inline)\n                positionCalendar();\n        }\n        function setDefaultTime() {\n            self.setDate(self.config.minDate !== undefined\n                ? new Date(self.config.minDate.getTime())\n                : new Date(), true);\n            setDefaultHours();\n            updateValue();\n        }\n        function open(e, positionElement) {\n            if (positionElement === void 0) { positionElement = self._positionElement; }\n            if (self.isMobile === true) {\n                if (e) {\n                    e.preventDefault();\n                    e.target && e.target.blur();\n                }\n                if (self.mobileInput !== undefined) {\n                    self.mobileInput.focus();\n                    self.mobileInput.click();\n                }\n                triggerEvent(\"onOpen\");\n                return;\n            }\n            if (self._input.disabled || self.config.inline)\n                return;\n            var wasOpen = self.isOpen;\n            self.isOpen = true;\n            if (!wasOpen) {\n                self.calendarContainer.classList.add(\"open\");\n                self._input.classList.add(\"active\");\n                triggerEvent(\"onOpen\");\n                positionCalendar(positionElement);\n            }\n            if (self.config.enableTime === true && self.config.noCalendar === true) {\n                if (self.selectedDates.length === 0) {\n                    setDefaultTime();\n                }\n                if (self.config.allowInput === false &&\n                    (e === undefined ||\n                        !self.timeContainer.contains(e.relatedTarget))) {\n                    setTimeout(function () { return self.hourElement.select(); }, 50);\n                }\n            }\n        }\n        function minMaxDateSetter(type) {\n            return function (date) {\n                var dateObj = (self.config[\"_\" + type + \"Date\"] = self.parseDate(date, self.config.dateFormat));\n                var inverseDateObj = self.config[\"_\" + (type === \"min\" ? \"max\" : \"min\") + \"Date\"];\n                if (dateObj !== undefined) {\n                    self[type === \"min\" ? \"minDateHasTime\" : \"maxDateHasTime\"] =\n                        dateObj.getHours() > 0 ||\n                            dateObj.getMinutes() > 0 ||\n                            dateObj.getSeconds() > 0;\n                }\n                if (self.selectedDates) {\n                    self.selectedDates = self.selectedDates.filter(function (d) { return isEnabled(d); });\n                    if (!self.selectedDates.length && type === \"min\")\n                        setHoursFromDate(dateObj);\n                    updateValue();\n                }\n                if (self.daysContainer) {\n                    redraw();\n                    if (dateObj !== undefined)\n                        self.currentYearElement[type] = dateObj.getFullYear().toString();\n                    else\n                        self.currentYearElement.removeAttribute(type);\n                    self.currentYearElement.disabled =\n                        !!inverseDateObj &&\n                            dateObj !== undefined &&\n                            inverseDateObj.getFullYear() === dateObj.getFullYear();\n                }\n            };\n        }\n        function parseConfig() {\n            var boolOpts = [\n                \"wrap\",\n                \"weekNumbers\",\n                \"allowInput\",\n                \"clickOpens\",\n                \"time_24hr\",\n                \"enableTime\",\n                \"noCalendar\",\n                \"altInput\",\n                \"shorthandCurrentMonth\",\n                \"inline\",\n                \"static\",\n                \"enableSeconds\",\n                \"disableMobile\",\n            ];\n            var userConfig = __assign({}, instanceConfig, JSON.parse(JSON.stringify(element.dataset || {})));\n            var formats = {};\n            self.config.parseDate = userConfig.parseDate;\n            self.config.formatDate = userConfig.formatDate;\n            Object.defineProperty(self.config, \"enable\", {\n                get: function () { return self.config._enable; },\n                set: function (dates) {\n                    self.config._enable = parseDateRules(dates);\n                }\n            });\n            Object.defineProperty(self.config, \"disable\", {\n                get: function () { return self.config._disable; },\n                set: function (dates) {\n                    self.config._disable = parseDateRules(dates);\n                }\n            });\n            var timeMode = userConfig.mode === \"time\";\n            if (!userConfig.dateFormat && (userConfig.enableTime || timeMode)) {\n                var defaultDateFormat = flatpickr.defaultConfig.dateFormat || defaults.dateFormat;\n                formats.dateFormat =\n                    userConfig.noCalendar || timeMode\n                        ? \"H:i\" + (userConfig.enableSeconds ? \":S\" : \"\")\n                        : defaultDateFormat + \" H:i\" + (userConfig.enableSeconds ? \":S\" : \"\");\n            }\n            if (userConfig.altInput &&\n                (userConfig.enableTime || timeMode) &&\n                !userConfig.altFormat) {\n                var defaultAltFormat = flatpickr.defaultConfig.altFormat || defaults.altFormat;\n                formats.altFormat =\n                    userConfig.noCalendar || timeMode\n                        ? \"h:i\" + (userConfig.enableSeconds ? \":S K\" : \" K\")\n                        : defaultAltFormat + (\" h:i\" + (userConfig.enableSeconds ? \":S\" : \"\") + \" K\");\n            }\n            if (!userConfig.altInputClass) {\n                self.config.altInputClass =\n                    self.input.className + \" \" + self.config.altInputClass;\n            }\n            Object.defineProperty(self.config, \"minDate\", {\n                get: function () { return self.config._minDate; },\n                set: minMaxDateSetter(\"min\")\n            });\n            Object.defineProperty(self.config, \"maxDate\", {\n                get: function () { return self.config._maxDate; },\n                set: minMaxDateSetter(\"max\")\n            });\n            var minMaxTimeSetter = function (type) { return function (val) {\n                self.config[type === \"min\" ? \"_minTime\" : \"_maxTime\"] = self.parseDate(val, \"H:i:S\");\n            }; };\n            Object.defineProperty(self.config, \"minTime\", {\n                get: function () { return self.config._minTime; },\n                set: minMaxTimeSetter(\"min\")\n            });\n            Object.defineProperty(self.config, \"maxTime\", {\n                get: function () { return self.config._maxTime; },\n                set: minMaxTimeSetter(\"max\")\n            });\n            if (userConfig.mode === \"time\") {\n                self.config.noCalendar = true;\n                self.config.enableTime = true;\n            }\n            Object.assign(self.config, formats, userConfig);\n            for (var i = 0; i < boolOpts.length; i++)\n                self.config[boolOpts[i]] =\n                    self.config[boolOpts[i]] === true ||\n                        self.config[boolOpts[i]] === \"true\";\n            HOOKS.filter(function (hook) { return self.config[hook] !== undefined; }).forEach(function (hook) {\n                self.config[hook] = arrayify(self.config[hook] || []).map(bindToInstance);\n            });\n            self.isMobile =\n                !self.config.disableMobile &&\n                    !self.config.inline &&\n                    self.config.mode === \"single\" &&\n                    !self.config.disable.length &&\n                    !self.config.enable.length &&\n                    !self.config.weekNumbers &&\n                    /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent);\n            for (var i = 0; i < self.config.plugins.length; i++) {\n                var pluginConf = self.config.plugins[i](self) || {};\n                for (var key in pluginConf) {\n                    if (HOOKS.indexOf(key) > -1) {\n                        self.config[key] = arrayify(pluginConf[key])\n                            .map(bindToInstance)\n                            .concat(self.config[key]);\n                    }\n                    else if (typeof userConfig[key] === \"undefined\")\n                        self.config[key] = pluginConf[key];\n                }\n            }\n            triggerEvent(\"onParseConfig\");\n        }\n        function setupLocale() {\n            if (typeof self.config.locale !== \"object\" &&\n                typeof flatpickr.l10ns[self.config.locale] === \"undefined\")\n                self.config.errorHandler(new Error(\"flatpickr: invalid locale \" + self.config.locale));\n            self.l10n = __assign({}, flatpickr.l10ns[\"default\"], (typeof self.config.locale === \"object\"\n                ? self.config.locale\n                : self.config.locale !== \"default\"\n                    ? flatpickr.l10ns[self.config.locale]\n                    : undefined));\n            tokenRegex.K = \"(\" + self.l10n.amPM[0] + \"|\" + self.l10n.amPM[1] + \"|\" + self.l10n.amPM[0].toLowerCase() + \"|\" + self.l10n.amPM[1].toLowerCase() + \")\";\n            var userConfig = __assign({}, instanceConfig, JSON.parse(JSON.stringify(element.dataset || {})));\n            if (userConfig.time_24hr === undefined &&\n                flatpickr.defaultConfig.time_24hr === undefined) {\n                self.config.time_24hr = self.l10n.time_24hr;\n            }\n            self.formatDate = createDateFormatter(self);\n            self.parseDate = createDateParser({ config: self.config, l10n: self.l10n });\n        }\n        function positionCalendar(customPositionElement) {\n            if (self.calendarContainer === undefined)\n                return;\n            triggerEvent(\"onPreCalendarPosition\");\n            var positionElement = customPositionElement || self._positionElement;\n            var calendarHeight = Array.prototype.reduce.call(self.calendarContainer.children, (function (acc, child) { return acc + child.offsetHeight; }), 0), calendarWidth = self.calendarContainer.offsetWidth, configPos = self.config.position.split(\" \"), configPosVertical = configPos[0], configPosHorizontal = configPos.length > 1 ? configPos[1] : null, inputBounds = positionElement.getBoundingClientRect(), distanceFromBottom = window.innerHeight - inputBounds.bottom, showOnTop = configPosVertical === \"above\" ||\n                (configPosVertical !== \"below\" &&\n                    distanceFromBottom < calendarHeight &&\n                    inputBounds.top > calendarHeight);\n            var top = window.pageYOffset +\n                inputBounds.top +\n                (!showOnTop ? positionElement.offsetHeight + 2 : -calendarHeight - 2);\n            toggleClass(self.calendarContainer, \"arrowTop\", !showOnTop);\n            toggleClass(self.calendarContainer, \"arrowBottom\", showOnTop);\n            if (self.config.inline)\n                return;\n            var left = window.pageXOffset +\n                inputBounds.left -\n                (configPosHorizontal != null && configPosHorizontal === \"center\"\n                    ? (calendarWidth - inputBounds.width) / 2\n                    : 0);\n            var right = window.document.body.offsetWidth - (window.pageXOffset + inputBounds.right);\n            var rightMost = left + calendarWidth > window.document.body.offsetWidth;\n            var centerMost = right + calendarWidth > window.document.body.offsetWidth;\n            toggleClass(self.calendarContainer, \"rightMost\", rightMost);\n            if (self.config.static)\n                return;\n            self.calendarContainer.style.top = top + \"px\";\n            if (!rightMost) {\n                self.calendarContainer.style.left = left + \"px\";\n                self.calendarContainer.style.right = \"auto\";\n            }\n            else if (!centerMost) {\n                self.calendarContainer.style.left = \"auto\";\n                self.calendarContainer.style.right = right + \"px\";\n            }\n            else {\n                var doc = document.styleSheets[0];\n                // some testing environments don't have css support\n                if (doc === undefined)\n                    return;\n                var bodyWidth = window.document.body.offsetWidth;\n                var centerLeft = Math.max(0, bodyWidth / 2 - calendarWidth / 2);\n                var centerBefore = \".flatpickr-calendar.centerMost:before\";\n                var centerAfter = \".flatpickr-calendar.centerMost:after\";\n                var centerIndex = doc.cssRules.length;\n                var centerStyle = \"{left:\" + inputBounds.left + \"px;right:auto;}\";\n                toggleClass(self.calendarContainer, \"rightMost\", false);\n                toggleClass(self.calendarContainer, \"centerMost\", true);\n                doc.insertRule(centerBefore + \",\" + centerAfter + centerStyle, centerIndex);\n                self.calendarContainer.style.left = centerLeft + \"px\";\n                self.calendarContainer.style.right = \"auto\";\n            }\n        }\n        function redraw() {\n            if (self.config.noCalendar || self.isMobile)\n                return;\n            updateNavigationCurrentMonth();\n            buildDays();\n        }\n        function focusAndClose() {\n            self._input.focus();\n            if (window.navigator.userAgent.indexOf(\"MSIE\") !== -1 ||\n                navigator.msMaxTouchPoints !== undefined) {\n                // hack - bugs in the way IE handles focus keeps the calendar open\n                setTimeout(self.close, 0);\n            }\n            else {\n                self.close();\n            }\n        }\n        function selectDate(e) {\n            e.preventDefault();\n            e.stopPropagation();\n            var isSelectable = function (day) {\n                return day.classList &&\n                    day.classList.contains(\"flatpickr-day\") &&\n                    !day.classList.contains(\"flatpickr-disabled\") &&\n                    !day.classList.contains(\"notAllowed\");\n            };\n            var t = findParent(e.target, isSelectable);\n            if (t === undefined)\n                return;\n            var target = t;\n            var selectedDate = (self.latestSelectedDateObj = new Date(target.dateObj.getTime()));\n            var shouldChangeMonth = (selectedDate.getMonth() < self.currentMonth ||\n                selectedDate.getMonth() >\n                    self.currentMonth + self.config.showMonths - 1) &&\n                self.config.mode !== \"range\";\n            self.selectedDateElem = target;\n            if (self.config.mode === \"single\")\n                self.selectedDates = [selectedDate];\n            else if (self.config.mode === \"multiple\") {\n                var selectedIndex = isDateSelected(selectedDate);\n                if (selectedIndex)\n                    self.selectedDates.splice(parseInt(selectedIndex), 1);\n                else\n                    self.selectedDates.push(selectedDate);\n            }\n            else if (self.config.mode === \"range\") {\n                if (self.selectedDates.length === 2) {\n                    self.clear(false, false);\n                }\n                self.latestSelectedDateObj = selectedDate;\n                self.selectedDates.push(selectedDate);\n                // unless selecting same date twice, sort ascendingly\n                if (compareDates(selectedDate, self.selectedDates[0], true) !== 0)\n                    self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n            }\n            setHoursFromInputs();\n            if (shouldChangeMonth) {\n                var isNewYear = self.currentYear !== selectedDate.getFullYear();\n                self.currentYear = selectedDate.getFullYear();\n                self.currentMonth = selectedDate.getMonth();\n                if (isNewYear) {\n                    triggerEvent(\"onYearChange\");\n                    buildMonthSwitch();\n                }\n                triggerEvent(\"onMonthChange\");\n            }\n            updateNavigationCurrentMonth();\n            buildDays();\n            updateValue();\n            if (self.config.enableTime)\n                setTimeout(function () { return (self.showTimeInput = true); }, 50);\n            // maintain focus\n            if (!shouldChangeMonth &&\n                self.config.mode !== \"range\" &&\n                self.config.showMonths === 1)\n                focusOnDayElem(target);\n            else if (self.selectedDateElem !== undefined &&\n                self.hourElement === undefined) {\n                self.selectedDateElem && self.selectedDateElem.focus();\n            }\n            if (self.hourElement !== undefined)\n                self.hourElement !== undefined && self.hourElement.focus();\n            if (self.config.closeOnSelect) {\n                var single = self.config.mode === \"single\" && !self.config.enableTime;\n                var range = self.config.mode === \"range\" &&\n                    self.selectedDates.length === 2 &&\n                    !self.config.enableTime;\n                if (single || range) {\n                    focusAndClose();\n                }\n            }\n            triggerChange();\n        }\n        var CALLBACKS = {\n            locale: [setupLocale, updateWeekdays],\n            showMonths: [buildMonths, setCalendarWidth, buildWeekdays],\n            minDate: [jumpToDate],\n            maxDate: [jumpToDate]\n        };\n        function set(option, value) {\n            if (option !== null && typeof option === \"object\") {\n                Object.assign(self.config, option);\n                for (var key in option) {\n                    if (CALLBACKS[key] !== undefined)\n                        CALLBACKS[key].forEach(function (x) { return x(); });\n                }\n            }\n            else {\n                self.config[option] = value;\n                if (CALLBACKS[option] !== undefined)\n                    CALLBACKS[option].forEach(function (x) { return x(); });\n                else if (HOOKS.indexOf(option) > -1)\n                    self.config[option] = arrayify(value);\n            }\n            self.redraw();\n            updateValue(false);\n        }\n        function setSelectedDate(inputDate, format) {\n            var dates = [];\n            if (inputDate instanceof Array)\n                dates = inputDate.map(function (d) { return self.parseDate(d, format); });\n            else if (inputDate instanceof Date || typeof inputDate === \"number\")\n                dates = [self.parseDate(inputDate, format)];\n            else if (typeof inputDate === \"string\") {\n                switch (self.config.mode) {\n                    case \"single\":\n                    case \"time\":\n                        dates = [self.parseDate(inputDate, format)];\n                        break;\n                    case \"multiple\":\n                        dates = inputDate\n                            .split(self.config.conjunction)\n                            .map(function (date) { return self.parseDate(date, format); });\n                        break;\n                    case \"range\":\n                        dates = inputDate\n                            .split(self.l10n.rangeSeparator)\n                            .map(function (date) { return self.parseDate(date, format); });\n                        break;\n                    default:\n                        break;\n                }\n            }\n            else\n                self.config.errorHandler(new Error(\"Invalid date supplied: \" + JSON.stringify(inputDate)));\n            self.selectedDates = dates.filter(function (d) { return d instanceof Date && isEnabled(d, false); });\n            if (self.config.mode === \"range\")\n                self.selectedDates.sort(function (a, b) { return a.getTime() - b.getTime(); });\n        }\n        function setDate(date, triggerChange, format) {\n            if (triggerChange === void 0) { triggerChange = false; }\n            if (format === void 0) { format = self.config.dateFormat; }\n            if ((date !== 0 && !date) || (date instanceof Array && date.length === 0))\n                return self.clear(triggerChange);\n            setSelectedDate(date, format);\n            self.showTimeInput = self.selectedDates.length > 0;\n            self.latestSelectedDateObj =\n                self.selectedDates[self.selectedDates.length - 1];\n            self.redraw();\n            jumpToDate();\n            setHoursFromDate();\n            if (self.selectedDates.length === 0) {\n                self.clear(false);\n            }\n            updateValue(triggerChange);\n            if (triggerChange)\n                triggerEvent(\"onChange\");\n        }\n        function parseDateRules(arr) {\n            return arr\n                .slice()\n                .map(function (rule) {\n                if (typeof rule === \"string\" ||\n                    typeof rule === \"number\" ||\n                    rule instanceof Date) {\n                    return self.parseDate(rule, undefined, true);\n                }\n                else if (rule &&\n                    typeof rule === \"object\" &&\n                    rule.from &&\n                    rule.to)\n                    return {\n                        from: self.parseDate(rule.from, undefined),\n                        to: self.parseDate(rule.to, undefined)\n                    };\n                return rule;\n            })\n                .filter(function (x) { return x; }); // remove falsy values\n        }\n        function setupDates() {\n            self.selectedDates = [];\n            self.now = self.parseDate(self.config.now) || new Date();\n            // Workaround IE11 setting placeholder as the input's value\n            var preloadedDate = self.config.defaultDate ||\n                ((self.input.nodeName === \"INPUT\" ||\n                    self.input.nodeName === \"TEXTAREA\") &&\n                    self.input.placeholder &&\n                    self.input.value === self.input.placeholder\n                    ? null\n                    : self.input.value);\n            if (preloadedDate)\n                setSelectedDate(preloadedDate, self.config.dateFormat);\n            self._initialDate =\n                self.selectedDates.length > 0\n                    ? self.selectedDates[0]\n                    : self.config.minDate &&\n                        self.config.minDate.getTime() > self.now.getTime()\n                        ? self.config.minDate\n                        : self.config.maxDate &&\n                            self.config.maxDate.getTime() < self.now.getTime()\n                            ? self.config.maxDate\n                            : self.now;\n            self.currentYear = self._initialDate.getFullYear();\n            self.currentMonth = self._initialDate.getMonth();\n            if (self.selectedDates.length > 0)\n                self.latestSelectedDateObj = self.selectedDates[0];\n            if (self.config.minTime !== undefined)\n                self.config.minTime = self.parseDate(self.config.minTime, \"H:i\");\n            if (self.config.maxTime !== undefined)\n                self.config.maxTime = self.parseDate(self.config.maxTime, \"H:i\");\n            self.minDateHasTime =\n                !!self.config.minDate &&\n                    (self.config.minDate.getHours() > 0 ||\n                        self.config.minDate.getMinutes() > 0 ||\n                        self.config.minDate.getSeconds() > 0);\n            self.maxDateHasTime =\n                !!self.config.maxDate &&\n                    (self.config.maxDate.getHours() > 0 ||\n                        self.config.maxDate.getMinutes() > 0 ||\n                        self.config.maxDate.getSeconds() > 0);\n            Object.defineProperty(self, \"showTimeInput\", {\n                get: function () { return self._showTimeInput; },\n                set: function (bool) {\n                    self._showTimeInput = bool;\n                    if (self.calendarContainer)\n                        toggleClass(self.calendarContainer, \"showTimeInput\", bool);\n                    self.isOpen && positionCalendar();\n                }\n            });\n        }\n        function setupInputs() {\n            self.input = self.config.wrap\n                ? element.querySelector(\"[data-input]\")\n                : element;\n            /* istanbul ignore next */\n            if (!self.input) {\n                self.config.errorHandler(new Error(\"Invalid input element specified\"));\n                return;\n            }\n            // hack: store previous type to restore it after destroy()\n            self.input._type = self.input.type;\n            self.input.type = \"text\";\n            self.input.classList.add(\"flatpickr-input\");\n            self._input = self.input;\n            if (self.config.altInput) {\n                // replicate self.element\n                self.altInput = createElement(self.input.nodeName, self.config.altInputClass);\n                self._input = self.altInput;\n                self.altInput.placeholder = self.input.placeholder;\n                self.altInput.disabled = self.input.disabled;\n                self.altInput.required = self.input.required;\n                self.altInput.tabIndex = self.input.tabIndex;\n                self.altInput.type = \"text\";\n                self.input.setAttribute(\"type\", \"hidden\");\n                if (!self.config.static && self.input.parentNode)\n                    self.input.parentNode.insertBefore(self.altInput, self.input.nextSibling);\n            }\n            if (!self.config.allowInput)\n                self._input.setAttribute(\"readonly\", \"readonly\");\n            self._positionElement = self.config.positionElement || self._input;\n        }\n        function setupMobile() {\n            var inputType = self.config.enableTime\n                ? self.config.noCalendar\n                    ? \"time\"\n                    : \"datetime-local\"\n                : \"date\";\n            self.mobileInput = createElement(\"input\", self.input.className + \" flatpickr-mobile\");\n            self.mobileInput.step = self.input.getAttribute(\"step\") || \"any\";\n            self.mobileInput.tabIndex = 1;\n            self.mobileInput.type = inputType;\n            self.mobileInput.disabled = self.input.disabled;\n            self.mobileInput.required = self.input.required;\n            self.mobileInput.placeholder = self.input.placeholder;\n            self.mobileFormatStr =\n                inputType === \"datetime-local\"\n                    ? \"Y-m-d\\\\TH:i:S\"\n                    : inputType === \"date\"\n                        ? \"Y-m-d\"\n                        : \"H:i:S\";\n            if (self.selectedDates.length > 0) {\n                self.mobileInput.defaultValue = self.mobileInput.value = self.formatDate(self.selectedDates[0], self.mobileFormatStr);\n            }\n            if (self.config.minDate)\n                self.mobileInput.min = self.formatDate(self.config.minDate, \"Y-m-d\");\n            if (self.config.maxDate)\n                self.mobileInput.max = self.formatDate(self.config.maxDate, \"Y-m-d\");\n            self.input.type = \"hidden\";\n            if (self.altInput !== undefined)\n                self.altInput.type = \"hidden\";\n            try {\n                if (self.input.parentNode)\n                    self.input.parentNode.insertBefore(self.mobileInput, self.input.nextSibling);\n            }\n            catch (_a) { }\n            bind(self.mobileInput, \"change\", function (e) {\n                self.setDate(e.target.value, false, self.mobileFormatStr);\n                triggerEvent(\"onChange\");\n                triggerEvent(\"onClose\");\n            });\n        }\n        function toggle(e) {\n            if (self.isOpen === true)\n                return self.close();\n            self.open(e);\n        }\n        function triggerEvent(event, data) {\n            // If the instance has been destroyed already, all hooks have been removed\n            if (self.config === undefined)\n                return;\n            var hooks = self.config[event];\n            if (hooks !== undefined && hooks.length > 0) {\n                for (var i = 0; hooks[i] && i < hooks.length; i++)\n                    hooks[i](self.selectedDates, self.input.value, self, data);\n            }\n            if (event === \"onChange\") {\n                self.input.dispatchEvent(createEvent(\"change\"));\n                // many front-end frameworks bind to the input event\n                self.input.dispatchEvent(createEvent(\"input\"));\n            }\n        }\n        function createEvent(name) {\n            var e = document.createEvent(\"Event\");\n            e.initEvent(name, true, true);\n            return e;\n        }\n        function isDateSelected(date) {\n            for (var i = 0; i < self.selectedDates.length; i++) {\n                if (compareDates(self.selectedDates[i], date) === 0)\n                    return \"\" + i;\n            }\n            return false;\n        }\n        function isDateInRange(date) {\n            if (self.config.mode !== \"range\" || self.selectedDates.length < 2)\n                return false;\n            return (compareDates(date, self.selectedDates[0]) >= 0 &&\n                compareDates(date, self.selectedDates[1]) <= 0);\n        }\n        function updateNavigationCurrentMonth() {\n            if (self.config.noCalendar || self.isMobile || !self.monthNav)\n                return;\n            self.yearElements.forEach(function (yearElement, i) {\n                var d = new Date(self.currentYear, self.currentMonth, 1);\n                d.setMonth(self.currentMonth + i);\n                if (self.config.showMonths > 1 ||\n                    self.config.monthSelectorType === \"static\") {\n                    self.monthElements[i].textContent =\n                        monthToStr(d.getMonth(), self.config.shorthandCurrentMonth, self.l10n) + \" \";\n                }\n                else {\n                    self.monthsDropdownContainer.value = d.getMonth().toString();\n                }\n                yearElement.value = d.getFullYear().toString();\n            });\n            self._hidePrevMonthArrow =\n                self.config.minDate !== undefined &&\n                    (self.currentYear === self.config.minDate.getFullYear()\n                        ? self.currentMonth <= self.config.minDate.getMonth()\n                        : self.currentYear < self.config.minDate.getFullYear());\n            self._hideNextMonthArrow =\n                self.config.maxDate !== undefined &&\n                    (self.currentYear === self.config.maxDate.getFullYear()\n                        ? self.currentMonth + 1 > self.config.maxDate.getMonth()\n                        : self.currentYear > self.config.maxDate.getFullYear());\n        }\n        function getDateStr(format) {\n            return self.selectedDates\n                .map(function (dObj) { return self.formatDate(dObj, format); })\n                .filter(function (d, i, arr) {\n                return self.config.mode !== \"range\" ||\n                    self.config.enableTime ||\n                    arr.indexOf(d) === i;\n            })\n                .join(self.config.mode !== \"range\"\n                ? self.config.conjunction\n                : self.l10n.rangeSeparator);\n        }\n        /**\n         * Updates the values of inputs associated with the calendar\n         */\n        function updateValue(triggerChange) {\n            if (triggerChange === void 0) { triggerChange = true; }\n            if (self.mobileInput !== undefined && self.mobileFormatStr) {\n                self.mobileInput.value =\n                    self.latestSelectedDateObj !== undefined\n                        ? self.formatDate(self.latestSelectedDateObj, self.mobileFormatStr)\n                        : \"\";\n            }\n            self.input.value = getDateStr(self.config.dateFormat);\n            if (self.altInput !== undefined) {\n                self.altInput.value = getDateStr(self.config.altFormat);\n            }\n            if (triggerChange !== false)\n                triggerEvent(\"onValueUpdate\");\n        }\n        function onMonthNavClick(e) {\n            var isPrevMonth = self.prevMonthNav.contains(e.target);\n            var isNextMonth = self.nextMonthNav.contains(e.target);\n            if (isPrevMonth || isNextMonth) {\n                changeMonth(isPrevMonth ? -1 : 1);\n            }\n            else if (self.yearElements.indexOf(e.target) >= 0) {\n                e.target.select();\n            }\n            else if (e.target.classList.contains(\"arrowUp\")) {\n                self.changeYear(self.currentYear + 1);\n            }\n            else if (e.target.classList.contains(\"arrowDown\")) {\n                self.changeYear(self.currentYear - 1);\n            }\n        }\n        function timeWrapper(e) {\n            e.preventDefault();\n            var isKeyDown = e.type === \"keydown\", input = e.target;\n            if (self.amPM !== undefined && e.target === self.amPM) {\n                self.amPM.textContent =\n                    self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n            }\n            var min = parseFloat(input.getAttribute(\"min\")), max = parseFloat(input.getAttribute(\"max\")), step = parseFloat(input.getAttribute(\"step\")), curValue = parseInt(input.value, 10), delta = e.delta ||\n                (isKeyDown ? (e.which === 38 ? 1 : -1) : 0);\n            var newValue = curValue + step * delta;\n            if (typeof input.value !== \"undefined\" && input.value.length === 2) {\n                var isHourElem = input === self.hourElement, isMinuteElem = input === self.minuteElement;\n                if (newValue < min) {\n                    newValue =\n                        max +\n                            newValue +\n                            int(!isHourElem) +\n                            (int(isHourElem) && int(!self.amPM));\n                    if (isMinuteElem)\n                        incrementNumInput(undefined, -1, self.hourElement);\n                }\n                else if (newValue > max) {\n                    newValue =\n                        input === self.hourElement ? newValue - max - int(!self.amPM) : min;\n                    if (isMinuteElem)\n                        incrementNumInput(undefined, 1, self.hourElement);\n                }\n                if (self.amPM &&\n                    isHourElem &&\n                    (step === 1\n                        ? newValue + curValue === 23\n                        : Math.abs(newValue - curValue) > step)) {\n                    self.amPM.textContent =\n                        self.l10n.amPM[int(self.amPM.textContent === self.l10n.amPM[0])];\n                }\n                input.value = pad(newValue);\n            }\n        }\n        init();\n        return self;\n    }\n    /* istanbul ignore next */\n    function _flatpickr(nodeList, config) {\n        // static list\n        var nodes = Array.prototype.slice\n            .call(nodeList)\n            .filter(function (x) { return x instanceof HTMLElement; });\n        var instances = [];\n        for (var i = 0; i < nodes.length; i++) {\n            var node = nodes[i];\n            try {\n                if (node.getAttribute(\"data-fp-omit\") !== null)\n                    continue;\n                if (node._flatpickr !== undefined) {\n                    node._flatpickr.destroy();\n                    node._flatpickr = undefined;\n                }\n                node._flatpickr = FlatpickrInstance(node, config || {});\n                instances.push(node._flatpickr);\n            }\n            catch (e) {\n                console.error(e);\n            }\n        }\n        return instances.length === 1 ? instances[0] : instances;\n    }\n    /* istanbul ignore next */\n    if (typeof HTMLElement !== \"undefined\" &&\n        typeof HTMLCollection !== \"undefined\" &&\n        typeof NodeList !== \"undefined\") {\n        // browser env\n        HTMLCollection.prototype.flatpickr = NodeList.prototype.flatpickr = function (config) {\n            return _flatpickr(this, config);\n        };\n        HTMLElement.prototype.flatpickr = function (config) {\n            return _flatpickr([this], config);\n        };\n    }\n    /* istanbul ignore next */\n    var flatpickr = function (selector, config) {\n        if (typeof selector === \"string\") {\n            return _flatpickr(window.document.querySelectorAll(selector), config);\n        }\n        else if (selector instanceof Node) {\n            return _flatpickr([selector], config);\n        }\n        else {\n            return _flatpickr(selector, config);\n        }\n    };\n    /* istanbul ignore next */\n    flatpickr.defaultConfig = {};\n    flatpickr.l10ns = {\n        en: __assign({}, english),\n        \"default\": __assign({}, english)\n    };\n    flatpickr.localize = function (l10n) {\n        flatpickr.l10ns[\"default\"] = __assign({}, flatpickr.l10ns[\"default\"], l10n);\n    };\n    flatpickr.setDefaults = function (config) {\n        flatpickr.defaultConfig = __assign({}, flatpickr.defaultConfig, config);\n    };\n    flatpickr.parseDate = createDateParser({});\n    flatpickr.formatDate = createDateFormatter({});\n    flatpickr.compareDates = compareDates;\n    /* istanbul ignore next */\n    if (typeof jQuery !== \"undefined\" && typeof jQuery.fn !== \"undefined\") {\n        jQuery.fn.flatpickr = function (config) {\n            return _flatpickr(this, config);\n        };\n    }\n    // eslint-disable-next-line @typescript-eslint/camelcase\n    Date.prototype.fp_incr = function (days) {\n        return new Date(this.getFullYear(), this.getMonth(), this.getDate() + (typeof days === \"string\" ? parseInt(days, 10) : days));\n    };\n    if (typeof window !== \"undefined\") {\n        window.flatpickr = flatpickr;\n    }\n\n    return flatpickr;\n\n}));\n\n\n//# sourceURL=webpack:///./node_modules/flatpickr/dist/flatpickr.js?");

/***/ }),

/***/ "./node_modules/object-assign/index.js":
/*!*********************************************!*\
  !*** ./node_modules/object-assign/index.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/*\nobject-assign\n(c) Sindre Sorhus\n@license MIT\n*/\n\n\n/* eslint-disable no-unused-vars */\nvar getOwnPropertySymbols = Object.getOwnPropertySymbols;\nvar hasOwnProperty = Object.prototype.hasOwnProperty;\nvar propIsEnumerable = Object.prototype.propertyIsEnumerable;\n\nfunction toObject(val) {\n\tif (val === null || val === undefined) {\n\t\tthrow new TypeError('Object.assign cannot be called with null or undefined');\n\t}\n\n\treturn Object(val);\n}\n\nfunction shouldUseNative() {\n\ttry {\n\t\tif (!Object.assign) {\n\t\t\treturn false;\n\t\t}\n\n\t\t// Detect buggy property enumeration order in older V8 versions.\n\n\t\t// https://bugs.chromium.org/p/v8/issues/detail?id=4118\n\t\tvar test1 = new String('abc');  // eslint-disable-line no-new-wrappers\n\t\ttest1[5] = 'de';\n\t\tif (Object.getOwnPropertyNames(test1)[0] === '5') {\n\t\t\treturn false;\n\t\t}\n\n\t\t// https://bugs.chromium.org/p/v8/issues/detail?id=3056\n\t\tvar test2 = {};\n\t\tfor (var i = 0; i < 10; i++) {\n\t\t\ttest2['_' + String.fromCharCode(i)] = i;\n\t\t}\n\t\tvar order2 = Object.getOwnPropertyNames(test2).map(function (n) {\n\t\t\treturn test2[n];\n\t\t});\n\t\tif (order2.join('') !== '0123456789') {\n\t\t\treturn false;\n\t\t}\n\n\t\t// https://bugs.chromium.org/p/v8/issues/detail?id=3056\n\t\tvar test3 = {};\n\t\t'abcdefghijklmnopqrst'.split('').forEach(function (letter) {\n\t\t\ttest3[letter] = letter;\n\t\t});\n\t\tif (Object.keys(Object.assign({}, test3)).join('') !==\n\t\t\t\t'abcdefghijklmnopqrst') {\n\t\t\treturn false;\n\t\t}\n\n\t\treturn true;\n\t} catch (err) {\n\t\t// We don't expect any of the above to throw, but better to be safe.\n\t\treturn false;\n\t}\n}\n\nmodule.exports = shouldUseNative() ? Object.assign : function (target, source) {\n\tvar from;\n\tvar to = toObject(target);\n\tvar symbols;\n\n\tfor (var s = 1; s < arguments.length; s++) {\n\t\tfrom = Object(arguments[s]);\n\n\t\tfor (var key in from) {\n\t\t\tif (hasOwnProperty.call(from, key)) {\n\t\t\t\tto[key] = from[key];\n\t\t\t}\n\t\t}\n\n\t\tif (getOwnPropertySymbols) {\n\t\t\tsymbols = getOwnPropertySymbols(from);\n\t\t\tfor (var i = 0; i < symbols.length; i++) {\n\t\t\t\tif (propIsEnumerable.call(from, symbols[i])) {\n\t\t\t\t\tto[symbols[i]] = from[symbols[i]];\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n\n\treturn to;\n};\n\n\n//# sourceURL=webpack:///./node_modules/object-assign/index.js?");

/***/ }),

/***/ "./node_modules/prop-types/checkPropTypes.js":
/*!***************************************************!*\
  !*** ./node_modules/prop-types/checkPropTypes.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * Copyright (c) 2013-present, Facebook, Inc.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n\n\nvar printWarning = function() {};\n\nif (true) {\n  var ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ \"./node_modules/prop-types/lib/ReactPropTypesSecret.js\");\n  var loggedTypeFailures = {};\n  var has = Function.call.bind(Object.prototype.hasOwnProperty);\n\n  printWarning = function(text) {\n    var message = 'Warning: ' + text;\n    if (typeof console !== 'undefined') {\n      console.error(message);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      throw new Error(message);\n    } catch (x) {}\n  };\n}\n\n/**\n * Assert that the values match with the type specs.\n * Error messages are memorized and will only be shown once.\n *\n * @param {object} typeSpecs Map of name to a ReactPropType\n * @param {object} values Runtime values that need to be type-checked\n * @param {string} location e.g. \"prop\", \"context\", \"child context\"\n * @param {string} componentName Name of the component for error messages.\n * @param {?Function} getStack Returns the component stack.\n * @private\n */\nfunction checkPropTypes(typeSpecs, values, location, componentName, getStack) {\n  if (true) {\n    for (var typeSpecName in typeSpecs) {\n      if (has(typeSpecs, typeSpecName)) {\n        var error;\n        // Prop type validation may throw. In case they do, we don't want to\n        // fail the render phase where it didn't fail before. So we log it.\n        // After these have been cleaned up, we'll let them throw.\n        try {\n          // This is intentionally an invariant that gets caught. It's the same\n          // behavior as without this statement except with a better message.\n          if (typeof typeSpecs[typeSpecName] !== 'function') {\n            var err = Error(\n              (componentName || 'React class') + ': ' + location + ' type `' + typeSpecName + '` is invalid; ' +\n              'it must be a function, usually from the `prop-types` package, but received `' + typeof typeSpecs[typeSpecName] + '`.'\n            );\n            err.name = 'Invariant Violation';\n            throw err;\n          }\n          error = typeSpecs[typeSpecName](values, typeSpecName, componentName, location, null, ReactPropTypesSecret);\n        } catch (ex) {\n          error = ex;\n        }\n        if (error && !(error instanceof Error)) {\n          printWarning(\n            (componentName || 'React class') + ': type specification of ' +\n            location + ' `' + typeSpecName + '` is invalid; the type checker ' +\n            'function must return `null` or an `Error` but returned a ' + typeof error + '. ' +\n            'You may have forgotten to pass an argument to the type checker ' +\n            'creator (arrayOf, instanceOf, objectOf, oneOf, oneOfType, and ' +\n            'shape all require an argument).'\n          );\n        }\n        if (error instanceof Error && !(error.message in loggedTypeFailures)) {\n          // Only monitor this failure once because there tends to be a lot of the\n          // same error.\n          loggedTypeFailures[error.message] = true;\n\n          var stack = getStack ? getStack() : '';\n\n          printWarning(\n            'Failed ' + location + ' type: ' + error.message + (stack != null ? stack : '')\n          );\n        }\n      }\n    }\n  }\n}\n\n/**\n * Resets warning cache when testing.\n *\n * @private\n */\ncheckPropTypes.resetWarningCache = function() {\n  if (true) {\n    loggedTypeFailures = {};\n  }\n}\n\nmodule.exports = checkPropTypes;\n\n\n//# sourceURL=webpack:///./node_modules/prop-types/checkPropTypes.js?");

/***/ }),

/***/ "./node_modules/prop-types/factoryWithTypeCheckers.js":
/*!************************************************************!*\
  !*** ./node_modules/prop-types/factoryWithTypeCheckers.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * Copyright (c) 2013-present, Facebook, Inc.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n\n\nvar ReactIs = __webpack_require__(/*! react-is */ \"./node_modules/react-is/index.js\");\nvar assign = __webpack_require__(/*! object-assign */ \"./node_modules/object-assign/index.js\");\n\nvar ReactPropTypesSecret = __webpack_require__(/*! ./lib/ReactPropTypesSecret */ \"./node_modules/prop-types/lib/ReactPropTypesSecret.js\");\nvar checkPropTypes = __webpack_require__(/*! ./checkPropTypes */ \"./node_modules/prop-types/checkPropTypes.js\");\n\nvar has = Function.call.bind(Object.prototype.hasOwnProperty);\nvar printWarning = function() {};\n\nif (true) {\n  printWarning = function(text) {\n    var message = 'Warning: ' + text;\n    if (typeof console !== 'undefined') {\n      console.error(message);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      throw new Error(message);\n    } catch (x) {}\n  };\n}\n\nfunction emptyFunctionThatReturnsNull() {\n  return null;\n}\n\nmodule.exports = function(isValidElement, throwOnDirectAccess) {\n  /* global Symbol */\n  var ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;\n  var FAUX_ITERATOR_SYMBOL = '@@iterator'; // Before Symbol spec.\n\n  /**\n   * Returns the iterator method function contained on the iterable object.\n   *\n   * Be sure to invoke the function with the iterable as context:\n   *\n   *     var iteratorFn = getIteratorFn(myIterable);\n   *     if (iteratorFn) {\n   *       var iterator = iteratorFn.call(myIterable);\n   *       ...\n   *     }\n   *\n   * @param {?object} maybeIterable\n   * @return {?function}\n   */\n  function getIteratorFn(maybeIterable) {\n    var iteratorFn = maybeIterable && (ITERATOR_SYMBOL && maybeIterable[ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL]);\n    if (typeof iteratorFn === 'function') {\n      return iteratorFn;\n    }\n  }\n\n  /**\n   * Collection of methods that allow declaration and validation of props that are\n   * supplied to React components. Example usage:\n   *\n   *   var Props = require('ReactPropTypes');\n   *   var MyArticle = React.createClass({\n   *     propTypes: {\n   *       // An optional string prop named \"description\".\n   *       description: Props.string,\n   *\n   *       // A required enum prop named \"category\".\n   *       category: Props.oneOf(['News','Photos']).isRequired,\n   *\n   *       // A prop named \"dialog\" that requires an instance of Dialog.\n   *       dialog: Props.instanceOf(Dialog).isRequired\n   *     },\n   *     render: function() { ... }\n   *   });\n   *\n   * A more formal specification of how these methods are used:\n   *\n   *   type := array|bool|func|object|number|string|oneOf([...])|instanceOf(...)\n   *   decl := ReactPropTypes.{type}(.isRequired)?\n   *\n   * Each and every declaration produces a function with the same signature. This\n   * allows the creation of custom validation functions. For example:\n   *\n   *  var MyLink = React.createClass({\n   *    propTypes: {\n   *      // An optional string or URI prop named \"href\".\n   *      href: function(props, propName, componentName) {\n   *        var propValue = props[propName];\n   *        if (propValue != null && typeof propValue !== 'string' &&\n   *            !(propValue instanceof URI)) {\n   *          return new Error(\n   *            'Expected a string or an URI for ' + propName + ' in ' +\n   *            componentName\n   *          );\n   *        }\n   *      }\n   *    },\n   *    render: function() {...}\n   *  });\n   *\n   * @internal\n   */\n\n  var ANONYMOUS = '<<anonymous>>';\n\n  // Important!\n  // Keep this list in sync with production version in `./factoryWithThrowingShims.js`.\n  var ReactPropTypes = {\n    array: createPrimitiveTypeChecker('array'),\n    bool: createPrimitiveTypeChecker('boolean'),\n    func: createPrimitiveTypeChecker('function'),\n    number: createPrimitiveTypeChecker('number'),\n    object: createPrimitiveTypeChecker('object'),\n    string: createPrimitiveTypeChecker('string'),\n    symbol: createPrimitiveTypeChecker('symbol'),\n\n    any: createAnyTypeChecker(),\n    arrayOf: createArrayOfTypeChecker,\n    element: createElementTypeChecker(),\n    elementType: createElementTypeTypeChecker(),\n    instanceOf: createInstanceTypeChecker,\n    node: createNodeChecker(),\n    objectOf: createObjectOfTypeChecker,\n    oneOf: createEnumTypeChecker,\n    oneOfType: createUnionTypeChecker,\n    shape: createShapeTypeChecker,\n    exact: createStrictShapeTypeChecker,\n  };\n\n  /**\n   * inlined Object.is polyfill to avoid requiring consumers ship their own\n   * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/is\n   */\n  /*eslint-disable no-self-compare*/\n  function is(x, y) {\n    // SameValue algorithm\n    if (x === y) {\n      // Steps 1-5, 7-10\n      // Steps 6.b-6.e: +0 != -0\n      return x !== 0 || 1 / x === 1 / y;\n    } else {\n      // Step 6.a: NaN == NaN\n      return x !== x && y !== y;\n    }\n  }\n  /*eslint-enable no-self-compare*/\n\n  /**\n   * We use an Error-like object for backward compatibility as people may call\n   * PropTypes directly and inspect their output. However, we don't use real\n   * Errors anymore. We don't inspect their stack anyway, and creating them\n   * is prohibitively expensive if they are created too often, such as what\n   * happens in oneOfType() for any type before the one that matched.\n   */\n  function PropTypeError(message) {\n    this.message = message;\n    this.stack = '';\n  }\n  // Make `instanceof Error` still work for returned errors.\n  PropTypeError.prototype = Error.prototype;\n\n  function createChainableTypeChecker(validate) {\n    if (true) {\n      var manualPropTypeCallCache = {};\n      var manualPropTypeWarningCount = 0;\n    }\n    function checkType(isRequired, props, propName, componentName, location, propFullName, secret) {\n      componentName = componentName || ANONYMOUS;\n      propFullName = propFullName || propName;\n\n      if (secret !== ReactPropTypesSecret) {\n        if (throwOnDirectAccess) {\n          // New behavior only for users of `prop-types` package\n          var err = new Error(\n            'Calling PropTypes validators directly is not supported by the `prop-types` package. ' +\n            'Use `PropTypes.checkPropTypes()` to call them. ' +\n            'Read more at http://fb.me/use-check-prop-types'\n          );\n          err.name = 'Invariant Violation';\n          throw err;\n        } else if ( true && typeof console !== 'undefined') {\n          // Old behavior for people using React.PropTypes\n          var cacheKey = componentName + ':' + propName;\n          if (\n            !manualPropTypeCallCache[cacheKey] &&\n            // Avoid spamming the console because they are often not actionable except for lib authors\n            manualPropTypeWarningCount < 3\n          ) {\n            printWarning(\n              'You are manually calling a React.PropTypes validation ' +\n              'function for the `' + propFullName + '` prop on `' + componentName  + '`. This is deprecated ' +\n              'and will throw in the standalone `prop-types` package. ' +\n              'You may be seeing this warning due to a third-party PropTypes ' +\n              'library. See https://fb.me/react-warning-dont-call-proptypes ' + 'for details.'\n            );\n            manualPropTypeCallCache[cacheKey] = true;\n            manualPropTypeWarningCount++;\n          }\n        }\n      }\n      if (props[propName] == null) {\n        if (isRequired) {\n          if (props[propName] === null) {\n            return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required ' + ('in `' + componentName + '`, but its value is `null`.'));\n          }\n          return new PropTypeError('The ' + location + ' `' + propFullName + '` is marked as required in ' + ('`' + componentName + '`, but its value is `undefined`.'));\n        }\n        return null;\n      } else {\n        return validate(props, propName, componentName, location, propFullName);\n      }\n    }\n\n    var chainedCheckType = checkType.bind(null, false);\n    chainedCheckType.isRequired = checkType.bind(null, true);\n\n    return chainedCheckType;\n  }\n\n  function createPrimitiveTypeChecker(expectedType) {\n    function validate(props, propName, componentName, location, propFullName, secret) {\n      var propValue = props[propName];\n      var propType = getPropType(propValue);\n      if (propType !== expectedType) {\n        // `propValue` being instance of, say, date/regexp, pass the 'object'\n        // check, but we can offer a more precise error message here rather than\n        // 'of type `object`'.\n        var preciseType = getPreciseType(propValue);\n\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + preciseType + '` supplied to `' + componentName + '`, expected ') + ('`' + expectedType + '`.'));\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createAnyTypeChecker() {\n    return createChainableTypeChecker(emptyFunctionThatReturnsNull);\n  }\n\n  function createArrayOfTypeChecker(typeChecker) {\n    function validate(props, propName, componentName, location, propFullName) {\n      if (typeof typeChecker !== 'function') {\n        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside arrayOf.');\n      }\n      var propValue = props[propName];\n      if (!Array.isArray(propValue)) {\n        var propType = getPropType(propValue);\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an array.'));\n      }\n      for (var i = 0; i < propValue.length; i++) {\n        var error = typeChecker(propValue, i, componentName, location, propFullName + '[' + i + ']', ReactPropTypesSecret);\n        if (error instanceof Error) {\n          return error;\n        }\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createElementTypeChecker() {\n    function validate(props, propName, componentName, location, propFullName) {\n      var propValue = props[propName];\n      if (!isValidElement(propValue)) {\n        var propType = getPropType(propValue);\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement.'));\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createElementTypeTypeChecker() {\n    function validate(props, propName, componentName, location, propFullName) {\n      var propValue = props[propName];\n      if (!ReactIs.isValidElementType(propValue)) {\n        var propType = getPropType(propValue);\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected a single ReactElement type.'));\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createInstanceTypeChecker(expectedClass) {\n    function validate(props, propName, componentName, location, propFullName) {\n      if (!(props[propName] instanceof expectedClass)) {\n        var expectedClassName = expectedClass.name || ANONYMOUS;\n        var actualClassName = getClassName(props[propName]);\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + actualClassName + '` supplied to `' + componentName + '`, expected ') + ('instance of `' + expectedClassName + '`.'));\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createEnumTypeChecker(expectedValues) {\n    if (!Array.isArray(expectedValues)) {\n      if (true) {\n        if (arguments.length > 1) {\n          printWarning(\n            'Invalid arguments supplied to oneOf, expected an array, got ' + arguments.length + ' arguments. ' +\n            'A common mistake is to write oneOf(x, y, z) instead of oneOf([x, y, z]).'\n          );\n        } else {\n          printWarning('Invalid argument supplied to oneOf, expected an array.');\n        }\n      }\n      return emptyFunctionThatReturnsNull;\n    }\n\n    function validate(props, propName, componentName, location, propFullName) {\n      var propValue = props[propName];\n      for (var i = 0; i < expectedValues.length; i++) {\n        if (is(propValue, expectedValues[i])) {\n          return null;\n        }\n      }\n\n      var valuesString = JSON.stringify(expectedValues, function replacer(key, value) {\n        var type = getPreciseType(value);\n        if (type === 'symbol') {\n          return String(value);\n        }\n        return value;\n      });\n      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of value `' + String(propValue) + '` ' + ('supplied to `' + componentName + '`, expected one of ' + valuesString + '.'));\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createObjectOfTypeChecker(typeChecker) {\n    function validate(props, propName, componentName, location, propFullName) {\n      if (typeof typeChecker !== 'function') {\n        return new PropTypeError('Property `' + propFullName + '` of component `' + componentName + '` has invalid PropType notation inside objectOf.');\n      }\n      var propValue = props[propName];\n      var propType = getPropType(propValue);\n      if (propType !== 'object') {\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type ' + ('`' + propType + '` supplied to `' + componentName + '`, expected an object.'));\n      }\n      for (var key in propValue) {\n        if (has(propValue, key)) {\n          var error = typeChecker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);\n          if (error instanceof Error) {\n            return error;\n          }\n        }\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createUnionTypeChecker(arrayOfTypeCheckers) {\n    if (!Array.isArray(arrayOfTypeCheckers)) {\n       true ? printWarning('Invalid argument supplied to oneOfType, expected an instance of array.') : undefined;\n      return emptyFunctionThatReturnsNull;\n    }\n\n    for (var i = 0; i < arrayOfTypeCheckers.length; i++) {\n      var checker = arrayOfTypeCheckers[i];\n      if (typeof checker !== 'function') {\n        printWarning(\n          'Invalid argument supplied to oneOfType. Expected an array of check functions, but ' +\n          'received ' + getPostfixForTypeWarning(checker) + ' at index ' + i + '.'\n        );\n        return emptyFunctionThatReturnsNull;\n      }\n    }\n\n    function validate(props, propName, componentName, location, propFullName) {\n      for (var i = 0; i < arrayOfTypeCheckers.length; i++) {\n        var checker = arrayOfTypeCheckers[i];\n        if (checker(props, propName, componentName, location, propFullName, ReactPropTypesSecret) == null) {\n          return null;\n        }\n      }\n\n      return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`.'));\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createNodeChecker() {\n    function validate(props, propName, componentName, location, propFullName) {\n      if (!isNode(props[propName])) {\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` supplied to ' + ('`' + componentName + '`, expected a ReactNode.'));\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createShapeTypeChecker(shapeTypes) {\n    function validate(props, propName, componentName, location, propFullName) {\n      var propValue = props[propName];\n      var propType = getPropType(propValue);\n      if (propType !== 'object') {\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));\n      }\n      for (var key in shapeTypes) {\n        var checker = shapeTypes[key];\n        if (!checker) {\n          continue;\n        }\n        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);\n        if (error) {\n          return error;\n        }\n      }\n      return null;\n    }\n    return createChainableTypeChecker(validate);\n  }\n\n  function createStrictShapeTypeChecker(shapeTypes) {\n    function validate(props, propName, componentName, location, propFullName) {\n      var propValue = props[propName];\n      var propType = getPropType(propValue);\n      if (propType !== 'object') {\n        return new PropTypeError('Invalid ' + location + ' `' + propFullName + '` of type `' + propType + '` ' + ('supplied to `' + componentName + '`, expected `object`.'));\n      }\n      // We need to check all keys in case some are required but missing from\n      // props.\n      var allKeys = assign({}, props[propName], shapeTypes);\n      for (var key in allKeys) {\n        var checker = shapeTypes[key];\n        if (!checker) {\n          return new PropTypeError(\n            'Invalid ' + location + ' `' + propFullName + '` key `' + key + '` supplied to `' + componentName + '`.' +\n            '\\nBad object: ' + JSON.stringify(props[propName], null, '  ') +\n            '\\nValid keys: ' +  JSON.stringify(Object.keys(shapeTypes), null, '  ')\n          );\n        }\n        var error = checker(propValue, key, componentName, location, propFullName + '.' + key, ReactPropTypesSecret);\n        if (error) {\n          return error;\n        }\n      }\n      return null;\n    }\n\n    return createChainableTypeChecker(validate);\n  }\n\n  function isNode(propValue) {\n    switch (typeof propValue) {\n      case 'number':\n      case 'string':\n      case 'undefined':\n        return true;\n      case 'boolean':\n        return !propValue;\n      case 'object':\n        if (Array.isArray(propValue)) {\n          return propValue.every(isNode);\n        }\n        if (propValue === null || isValidElement(propValue)) {\n          return true;\n        }\n\n        var iteratorFn = getIteratorFn(propValue);\n        if (iteratorFn) {\n          var iterator = iteratorFn.call(propValue);\n          var step;\n          if (iteratorFn !== propValue.entries) {\n            while (!(step = iterator.next()).done) {\n              if (!isNode(step.value)) {\n                return false;\n              }\n            }\n          } else {\n            // Iterator will provide entry [k,v] tuples rather than values.\n            while (!(step = iterator.next()).done) {\n              var entry = step.value;\n              if (entry) {\n                if (!isNode(entry[1])) {\n                  return false;\n                }\n              }\n            }\n          }\n        } else {\n          return false;\n        }\n\n        return true;\n      default:\n        return false;\n    }\n  }\n\n  function isSymbol(propType, propValue) {\n    // Native Symbol.\n    if (propType === 'symbol') {\n      return true;\n    }\n\n    // falsy value can't be a Symbol\n    if (!propValue) {\n      return false;\n    }\n\n    // 19.4.3.5 Symbol.prototype[@@toStringTag] === 'Symbol'\n    if (propValue['@@toStringTag'] === 'Symbol') {\n      return true;\n    }\n\n    // Fallback for non-spec compliant Symbols which are polyfilled.\n    if (typeof Symbol === 'function' && propValue instanceof Symbol) {\n      return true;\n    }\n\n    return false;\n  }\n\n  // Equivalent of `typeof` but with special handling for array and regexp.\n  function getPropType(propValue) {\n    var propType = typeof propValue;\n    if (Array.isArray(propValue)) {\n      return 'array';\n    }\n    if (propValue instanceof RegExp) {\n      // Old webkits (at least until Android 4.0) return 'function' rather than\n      // 'object' for typeof a RegExp. We'll normalize this here so that /bla/\n      // passes PropTypes.object.\n      return 'object';\n    }\n    if (isSymbol(propType, propValue)) {\n      return 'symbol';\n    }\n    return propType;\n  }\n\n  // This handles more types than `getPropType`. Only used for error messages.\n  // See `createPrimitiveTypeChecker`.\n  function getPreciseType(propValue) {\n    if (typeof propValue === 'undefined' || propValue === null) {\n      return '' + propValue;\n    }\n    var propType = getPropType(propValue);\n    if (propType === 'object') {\n      if (propValue instanceof Date) {\n        return 'date';\n      } else if (propValue instanceof RegExp) {\n        return 'regexp';\n      }\n    }\n    return propType;\n  }\n\n  // Returns a string that is postfixed to a warning about an invalid type.\n  // For example, \"undefined\" or \"of type array\"\n  function getPostfixForTypeWarning(value) {\n    var type = getPreciseType(value);\n    switch (type) {\n      case 'array':\n      case 'object':\n        return 'an ' + type;\n      case 'boolean':\n      case 'date':\n      case 'regexp':\n        return 'a ' + type;\n      default:\n        return type;\n    }\n  }\n\n  // Returns class name of the object, if any.\n  function getClassName(propValue) {\n    if (!propValue.constructor || !propValue.constructor.name) {\n      return ANONYMOUS;\n    }\n    return propValue.constructor.name;\n  }\n\n  ReactPropTypes.checkPropTypes = checkPropTypes;\n  ReactPropTypes.resetWarningCache = checkPropTypes.resetWarningCache;\n  ReactPropTypes.PropTypes = ReactPropTypes;\n\n  return ReactPropTypes;\n};\n\n\n//# sourceURL=webpack:///./node_modules/prop-types/factoryWithTypeCheckers.js?");

/***/ }),

/***/ "./node_modules/prop-types/index.js":
/*!******************************************!*\
  !*** ./node_modules/prop-types/index.js ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/**\n * Copyright (c) 2013-present, Facebook, Inc.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\nif (true) {\n  var ReactIs = __webpack_require__(/*! react-is */ \"./node_modules/react-is/index.js\");\n\n  // By explicitly using `prop-types` you are opting into new development behavior.\n  // http://fb.me/prop-types-in-prod\n  var throwOnDirectAccess = true;\n  module.exports = __webpack_require__(/*! ./factoryWithTypeCheckers */ \"./node_modules/prop-types/factoryWithTypeCheckers.js\")(ReactIs.isElement, throwOnDirectAccess);\n} else {}\n\n\n//# sourceURL=webpack:///./node_modules/prop-types/index.js?");

/***/ }),

/***/ "./node_modules/prop-types/lib/ReactPropTypesSecret.js":
/*!*************************************************************!*\
  !*** ./node_modules/prop-types/lib/ReactPropTypesSecret.js ***!
  \*************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/**\n * Copyright (c) 2013-present, Facebook, Inc.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n\n\nvar ReactPropTypesSecret = 'SECRET_DO_NOT_PASS_THIS_OR_YOU_WILL_BE_FIRED';\n\nmodule.exports = ReactPropTypesSecret;\n\n\n//# sourceURL=webpack:///./node_modules/prop-types/lib/ReactPropTypesSecret.js?");

/***/ }),

/***/ "./node_modules/react-flatpickr/build/index.js":
/*!*****************************************************!*\
  !*** ./node_modules/react-flatpickr/build/index.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nObject.defineProperty(exports, \"__esModule\", {\n  value: true\n});\nexports[\"default\"] = void 0;\n\nvar _react = _interopRequireWildcard(__webpack_require__(/*! react */ \"./node_modules/react/index.js\"));\n\nvar _propTypes = _interopRequireDefault(__webpack_require__(/*! prop-types */ \"./node_modules/prop-types/index.js\"));\n\nvar _flatpickr = _interopRequireDefault(__webpack_require__(/*! flatpickr */ \"./node_modules/flatpickr/dist/flatpickr.js\"));\n\nfunction _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { \"default\": obj }; }\n\nfunction _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj[\"default\"] = obj; return newObj; } }\n\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }\n\nfunction _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }\n\nfunction _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }\n\nfunction _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError(\"Cannot call a class as a function\"); } }\n\nfunction _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if (\"value\" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }\n\nfunction _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }\n\nfunction _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === \"object\" || typeof call === \"function\")) { return call; } return _assertThisInitialized(self); }\n\nfunction _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError(\"this hasn't been initialised - super() hasn't been called\"); } return self; }\n\nfunction _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }\n\nfunction _inherits(subClass, superClass) { if (typeof superClass !== \"function\" && superClass !== null) { throw new TypeError(\"Super expression must either be null or a function\"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }\n\nfunction _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nvar hooks = ['onChange', 'onOpen', 'onClose', 'onMonthChange', 'onYearChange', 'onReady', 'onValueUpdate', 'onDayCreate'];\n\nvar hookPropType = _propTypes[\"default\"].oneOfType([_propTypes[\"default\"].func, _propTypes[\"default\"].arrayOf(_propTypes[\"default\"].func)]);\n\nvar callbacks = ['onCreate', 'onDestroy'];\nvar callbackPropTypes = _propTypes[\"default\"].func;\n\nvar DateTimePicker =\n/*#__PURE__*/\nfunction (_Component) {\n  _inherits(DateTimePicker, _Component);\n\n  function DateTimePicker() {\n    _classCallCheck(this, DateTimePicker);\n\n    return _possibleConstructorReturn(this, _getPrototypeOf(DateTimePicker).apply(this, arguments));\n  }\n\n  _createClass(DateTimePicker, [{\n    key: \"componentDidUpdate\",\n    value: function componentDidUpdate(prevProps) {\n      var _this = this;\n\n      if (this.props.hasOwnProperty('value') && this.props.value !== prevProps.value) {\n        this.flatpickr.setDate(this.props.value, false);\n      }\n\n      var options = this.props.options;\n      var prevOptions = prevProps.options;\n      hooks.forEach(function (hook) {\n        if (_this.props.hasOwnProperty(hook)) {\n          options[hook] = _this.props[hook];\n        } // Add prev ones too so we can compare against them later\n\n\n        if (prevProps.hasOwnProperty(hook)) {\n          prevOptions[hook] = prevProps[hook];\n        }\n      });\n      var optionsKeys = Object.getOwnPropertyNames(options);\n\n      for (var index = optionsKeys.length - 1; index >= 0; index--) {\n        var key = optionsKeys[index];\n        var value = options[key];\n\n        if (value !== prevOptions[key]) {\n          // Hook handlers must be set as an array\n          if (hooks.indexOf(key) !== -1 && !Array.isArray(value)) {\n            value = [value];\n          }\n\n          this.flatpickr.set(key, value);\n        }\n      }\n    }\n  }, {\n    key: \"componentDidMount\",\n    value: function componentDidMount() {\n      var _this2 = this;\n\n      var options = _objectSpread({\n        onClose: function onClose() {\n          _this2.node.blur && _this2.node.blur();\n        }\n      }, this.props.options); // Add prop hooks to options\n\n\n      hooks.forEach(function (hook) {\n        if (_this2.props[hook]) {\n          options[hook] = _this2.props[hook];\n        }\n      });\n      this.flatpickr = new _flatpickr[\"default\"](this.node, options);\n\n      if (this.props.hasOwnProperty('value')) {\n        this.flatpickr.setDate(this.props.value, false);\n      }\n\n      var onCreate = this.props.onCreate;\n      if (onCreate) onCreate(this.flatpickr);\n    }\n  }, {\n    key: \"componentWillUnmount\",\n    value: function componentWillUnmount() {\n      var onDestroy = this.props.onDestroy;\n      if (onDestroy) onDestroy(this.flatpickr);\n      this.flatpickr.destroy();\n    }\n  }, {\n    key: \"render\",\n    value: function render() {\n      var _this3 = this;\n\n      // eslint-disable-next-line no-unused-vars\n      var _this$props = this.props,\n          options = _this$props.options,\n          defaultValue = _this$props.defaultValue,\n          value = _this$props.value,\n          children = _this$props.children,\n          render = _this$props.render,\n          props = _objectWithoutProperties(_this$props, [\"options\", \"defaultValue\", \"value\", \"children\", \"render\"]);\n\n      var ref = function ref(node) {\n        _this3.node = node;\n      }; // Don't pass hooks and callbacks to dom node\n\n\n      hooks.forEach(function (hook) {\n        delete props[hook];\n      });\n      callbacks.forEach(function (callback) {\n        delete props[callback];\n      });\n      if (render) return render(_objectSpread({}, props, {\n        defaultValue: defaultValue,\n        value: value\n      }), ref);\n      return options.wrap ? _react[\"default\"].createElement(\"div\", _extends({}, props, {\n        ref: ref\n      }), children) : _react[\"default\"].createElement(\"input\", _extends({}, props, {\n        defaultValue: defaultValue,\n        ref: ref\n      }));\n    }\n  }]);\n\n  return DateTimePicker;\n}(_react.Component);\n\n_defineProperty(DateTimePicker, \"propTypes\", {\n  defaultValue: _propTypes[\"default\"].string,\n  options: _propTypes[\"default\"].object,\n  onChange: hookPropType,\n  onOpen: hookPropType,\n  onClose: hookPropType,\n  onMonthChange: hookPropType,\n  onYearChange: hookPropType,\n  onReady: hookPropType,\n  onValueUpdate: hookPropType,\n  onDayCreate: hookPropType,\n  onCreate: callbackPropTypes,\n  onDestroy: callbackPropTypes,\n  value: _propTypes[\"default\"].oneOfType([_propTypes[\"default\"].string, _propTypes[\"default\"].array, _propTypes[\"default\"].object, _propTypes[\"default\"].number]),\n  children: _propTypes[\"default\"].node,\n  className: _propTypes[\"default\"].string,\n  render: _propTypes[\"default\"].func\n});\n\n_defineProperty(DateTimePicker, \"defaultProps\", {\n  options: {}\n});\n\nvar _default = DateTimePicker;\nexports[\"default\"] = _default;\n\n//# sourceURL=webpack:///./node_modules/react-flatpickr/build/index.js?");

/***/ }),

/***/ "./node_modules/react-is/cjs/react-is.development.js":
/*!***********************************************************!*\
  !*** ./node_modules/react-is/cjs/react-is.development.js ***!
  \***********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/** @license React v16.9.0\n * react-is.development.js\n *\n * Copyright (c) Facebook, Inc. and its affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n\n\n\n\nif (true) {\n  (function() {\n'use strict';\n\nObject.defineProperty(exports, '__esModule', { value: true });\n\n// The Symbol used to tag the ReactElement-like types. If there is no native Symbol\n// nor polyfill, then a plain number is used for performance.\nvar hasSymbol = typeof Symbol === 'function' && Symbol.for;\n\nvar REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;\nvar REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;\nvar REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;\nvar REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;\nvar REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;\nvar REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;\nvar REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;\n// TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary\n// (unstable) APIs that have been removed. Can we remove the symbols?\nvar REACT_ASYNC_MODE_TYPE = hasSymbol ? Symbol.for('react.async_mode') : 0xeacf;\nvar REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;\nvar REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;\nvar REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;\nvar REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;\nvar REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;\nvar REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;\nvar REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;\nvar REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;\n\nfunction isValidElementType(type) {\n  return typeof type === 'string' || typeof type === 'function' ||\n  // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.\n  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE);\n}\n\n/**\n * Forked from fbjs/warning:\n * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js\n *\n * Only change is we use console.warn instead of console.error,\n * and do nothing when 'console' is not supported.\n * This really simplifies the code.\n * ---\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar lowPriorityWarning = function () {};\n\n{\n  var printWarning = function (format) {\n    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n      args[_key - 1] = arguments[_key];\n    }\n\n    var argIndex = 0;\n    var message = 'Warning: ' + format.replace(/%s/g, function () {\n      return args[argIndex++];\n    });\n    if (typeof console !== 'undefined') {\n      console.warn(message);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      throw new Error(message);\n    } catch (x) {}\n  };\n\n  lowPriorityWarning = function (condition, format) {\n    if (format === undefined) {\n      throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');\n    }\n    if (!condition) {\n      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {\n        args[_key2 - 2] = arguments[_key2];\n      }\n\n      printWarning.apply(undefined, [format].concat(args));\n    }\n  };\n}\n\nvar lowPriorityWarning$1 = lowPriorityWarning;\n\nfunction typeOf(object) {\n  if (typeof object === 'object' && object !== null) {\n    var $$typeof = object.$$typeof;\n    switch ($$typeof) {\n      case REACT_ELEMENT_TYPE:\n        var type = object.type;\n\n        switch (type) {\n          case REACT_ASYNC_MODE_TYPE:\n          case REACT_CONCURRENT_MODE_TYPE:\n          case REACT_FRAGMENT_TYPE:\n          case REACT_PROFILER_TYPE:\n          case REACT_STRICT_MODE_TYPE:\n          case REACT_SUSPENSE_TYPE:\n            return type;\n          default:\n            var $$typeofType = type && type.$$typeof;\n\n            switch ($$typeofType) {\n              case REACT_CONTEXT_TYPE:\n              case REACT_FORWARD_REF_TYPE:\n              case REACT_PROVIDER_TYPE:\n                return $$typeofType;\n              default:\n                return $$typeof;\n            }\n        }\n      case REACT_LAZY_TYPE:\n      case REACT_MEMO_TYPE:\n      case REACT_PORTAL_TYPE:\n        return $$typeof;\n    }\n  }\n\n  return undefined;\n}\n\n// AsyncMode is deprecated along with isAsyncMode\nvar AsyncMode = REACT_ASYNC_MODE_TYPE;\nvar ConcurrentMode = REACT_CONCURRENT_MODE_TYPE;\nvar ContextConsumer = REACT_CONTEXT_TYPE;\nvar ContextProvider = REACT_PROVIDER_TYPE;\nvar Element = REACT_ELEMENT_TYPE;\nvar ForwardRef = REACT_FORWARD_REF_TYPE;\nvar Fragment = REACT_FRAGMENT_TYPE;\nvar Lazy = REACT_LAZY_TYPE;\nvar Memo = REACT_MEMO_TYPE;\nvar Portal = REACT_PORTAL_TYPE;\nvar Profiler = REACT_PROFILER_TYPE;\nvar StrictMode = REACT_STRICT_MODE_TYPE;\nvar Suspense = REACT_SUSPENSE_TYPE;\n\nvar hasWarnedAboutDeprecatedIsAsyncMode = false;\n\n// AsyncMode should be deprecated\nfunction isAsyncMode(object) {\n  {\n    if (!hasWarnedAboutDeprecatedIsAsyncMode) {\n      hasWarnedAboutDeprecatedIsAsyncMode = true;\n      lowPriorityWarning$1(false, 'The ReactIs.isAsyncMode() alias has been deprecated, ' + 'and will be removed in React 17+. Update your code to use ' + 'ReactIs.isConcurrentMode() instead. It has the exact same API.');\n    }\n  }\n  return isConcurrentMode(object) || typeOf(object) === REACT_ASYNC_MODE_TYPE;\n}\nfunction isConcurrentMode(object) {\n  return typeOf(object) === REACT_CONCURRENT_MODE_TYPE;\n}\nfunction isContextConsumer(object) {\n  return typeOf(object) === REACT_CONTEXT_TYPE;\n}\nfunction isContextProvider(object) {\n  return typeOf(object) === REACT_PROVIDER_TYPE;\n}\nfunction isElement(object) {\n  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;\n}\nfunction isForwardRef(object) {\n  return typeOf(object) === REACT_FORWARD_REF_TYPE;\n}\nfunction isFragment(object) {\n  return typeOf(object) === REACT_FRAGMENT_TYPE;\n}\nfunction isLazy(object) {\n  return typeOf(object) === REACT_LAZY_TYPE;\n}\nfunction isMemo(object) {\n  return typeOf(object) === REACT_MEMO_TYPE;\n}\nfunction isPortal(object) {\n  return typeOf(object) === REACT_PORTAL_TYPE;\n}\nfunction isProfiler(object) {\n  return typeOf(object) === REACT_PROFILER_TYPE;\n}\nfunction isStrictMode(object) {\n  return typeOf(object) === REACT_STRICT_MODE_TYPE;\n}\nfunction isSuspense(object) {\n  return typeOf(object) === REACT_SUSPENSE_TYPE;\n}\n\nexports.typeOf = typeOf;\nexports.AsyncMode = AsyncMode;\nexports.ConcurrentMode = ConcurrentMode;\nexports.ContextConsumer = ContextConsumer;\nexports.ContextProvider = ContextProvider;\nexports.Element = Element;\nexports.ForwardRef = ForwardRef;\nexports.Fragment = Fragment;\nexports.Lazy = Lazy;\nexports.Memo = Memo;\nexports.Portal = Portal;\nexports.Profiler = Profiler;\nexports.StrictMode = StrictMode;\nexports.Suspense = Suspense;\nexports.isValidElementType = isValidElementType;\nexports.isAsyncMode = isAsyncMode;\nexports.isConcurrentMode = isConcurrentMode;\nexports.isContextConsumer = isContextConsumer;\nexports.isContextProvider = isContextProvider;\nexports.isElement = isElement;\nexports.isForwardRef = isForwardRef;\nexports.isFragment = isFragment;\nexports.isLazy = isLazy;\nexports.isMemo = isMemo;\nexports.isPortal = isPortal;\nexports.isProfiler = isProfiler;\nexports.isStrictMode = isStrictMode;\nexports.isSuspense = isSuspense;\n  })();\n}\n\n\n//# sourceURL=webpack:///./node_modules/react-is/cjs/react-is.development.js?");

/***/ }),

/***/ "./node_modules/react-is/index.js":
/*!****************************************!*\
  !*** ./node_modules/react-is/index.js ***!
  \****************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nif (false) {} else {\n  module.exports = __webpack_require__(/*! ./cjs/react-is.development.js */ \"./node_modules/react-is/cjs/react-is.development.js\");\n}\n\n\n//# sourceURL=webpack:///./node_modules/react-is/index.js?");

/***/ }),

/***/ "./node_modules/react/cjs/react.development.js":
/*!*****************************************************!*\
  !*** ./node_modules/react/cjs/react.development.js ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("/** @license React v16.9.0\n * react.development.js\n *\n * Copyright (c) Facebook, Inc. and its affiliates.\n *\n * This source code is licensed under the MIT license found in the\n * LICENSE file in the root directory of this source tree.\n */\n\n\n\n\n\nif (true) {\n  (function() {\n'use strict';\n\nvar _assign = __webpack_require__(/*! object-assign */ \"./node_modules/object-assign/index.js\");\nvar checkPropTypes = __webpack_require__(/*! prop-types/checkPropTypes */ \"./node_modules/prop-types/checkPropTypes.js\");\n\n// TODO: this is special because it gets imported during build.\n\nvar ReactVersion = '16.9.0';\n\n// The Symbol used to tag the ReactElement-like types. If there is no native Symbol\n// nor polyfill, then a plain number is used for performance.\nvar hasSymbol = typeof Symbol === 'function' && Symbol.for;\n\nvar REACT_ELEMENT_TYPE = hasSymbol ? Symbol.for('react.element') : 0xeac7;\nvar REACT_PORTAL_TYPE = hasSymbol ? Symbol.for('react.portal') : 0xeaca;\nvar REACT_FRAGMENT_TYPE = hasSymbol ? Symbol.for('react.fragment') : 0xeacb;\nvar REACT_STRICT_MODE_TYPE = hasSymbol ? Symbol.for('react.strict_mode') : 0xeacc;\nvar REACT_PROFILER_TYPE = hasSymbol ? Symbol.for('react.profiler') : 0xead2;\nvar REACT_PROVIDER_TYPE = hasSymbol ? Symbol.for('react.provider') : 0xeacd;\nvar REACT_CONTEXT_TYPE = hasSymbol ? Symbol.for('react.context') : 0xeace;\n// TODO: We don't use AsyncMode or ConcurrentMode anymore. They were temporary\n// (unstable) APIs that have been removed. Can we remove the symbols?\n\nvar REACT_CONCURRENT_MODE_TYPE = hasSymbol ? Symbol.for('react.concurrent_mode') : 0xeacf;\nvar REACT_FORWARD_REF_TYPE = hasSymbol ? Symbol.for('react.forward_ref') : 0xead0;\nvar REACT_SUSPENSE_TYPE = hasSymbol ? Symbol.for('react.suspense') : 0xead1;\nvar REACT_SUSPENSE_LIST_TYPE = hasSymbol ? Symbol.for('react.suspense_list') : 0xead8;\nvar REACT_MEMO_TYPE = hasSymbol ? Symbol.for('react.memo') : 0xead3;\nvar REACT_LAZY_TYPE = hasSymbol ? Symbol.for('react.lazy') : 0xead4;\nvar REACT_FUNDAMENTAL_TYPE = hasSymbol ? Symbol.for('react.fundamental') : 0xead5;\nvar REACT_RESPONDER_TYPE = hasSymbol ? Symbol.for('react.responder') : 0xead6;\n\nvar MAYBE_ITERATOR_SYMBOL = typeof Symbol === 'function' && Symbol.iterator;\nvar FAUX_ITERATOR_SYMBOL = '@@iterator';\n\nfunction getIteratorFn(maybeIterable) {\n  if (maybeIterable === null || typeof maybeIterable !== 'object') {\n    return null;\n  }\n  var maybeIterator = MAYBE_ITERATOR_SYMBOL && maybeIterable[MAYBE_ITERATOR_SYMBOL] || maybeIterable[FAUX_ITERATOR_SYMBOL];\n  if (typeof maybeIterator === 'function') {\n    return maybeIterator;\n  }\n  return null;\n}\n\n// Do not require this module directly! Use normal `invariant` calls with\n// template literal strings. The messages will be converted to ReactError during\n// build, and in production they will be minified.\n\n// Do not require this module directly! Use normal `invariant` calls with\n// template literal strings. The messages will be converted to ReactError during\n// build, and in production they will be minified.\n\nfunction ReactError(error) {\n  error.name = 'Invariant Violation';\n  return error;\n}\n\n/**\n * Use invariant() to assert state which your program assumes to be true.\n *\n * Provide sprintf-style format (only %s is supported) and arguments\n * to provide information about what broke and what you were\n * expecting.\n *\n * The invariant message will be stripped in production, but the invariant\n * will remain to ensure logic does not differ in production.\n */\n\n/**\n * Forked from fbjs/warning:\n * https://github.com/facebook/fbjs/blob/e66ba20ad5be433eb54423f2b097d829324d9de6/packages/fbjs/src/__forks__/warning.js\n *\n * Only change is we use console.warn instead of console.error,\n * and do nothing when 'console' is not supported.\n * This really simplifies the code.\n * ---\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar lowPriorityWarning = function () {};\n\n{\n  var printWarning = function (format) {\n    for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n      args[_key - 1] = arguments[_key];\n    }\n\n    var argIndex = 0;\n    var message = 'Warning: ' + format.replace(/%s/g, function () {\n      return args[argIndex++];\n    });\n    if (typeof console !== 'undefined') {\n      console.warn(message);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      throw new Error(message);\n    } catch (x) {}\n  };\n\n  lowPriorityWarning = function (condition, format) {\n    if (format === undefined) {\n      throw new Error('`lowPriorityWarning(condition, format, ...args)` requires a warning ' + 'message argument');\n    }\n    if (!condition) {\n      for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {\n        args[_key2 - 2] = arguments[_key2];\n      }\n\n      printWarning.apply(undefined, [format].concat(args));\n    }\n  };\n}\n\nvar lowPriorityWarning$1 = lowPriorityWarning;\n\n/**\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar warningWithoutStack = function () {};\n\n{\n  warningWithoutStack = function (condition, format) {\n    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {\n      args[_key - 2] = arguments[_key];\n    }\n\n    if (format === undefined) {\n      throw new Error('`warningWithoutStack(condition, format, ...args)` requires a warning ' + 'message argument');\n    }\n    if (args.length > 8) {\n      // Check before the condition to catch violations early.\n      throw new Error('warningWithoutStack() currently supports at most 8 arguments.');\n    }\n    if (condition) {\n      return;\n    }\n    if (typeof console !== 'undefined') {\n      var argsWithFormat = args.map(function (item) {\n        return '' + item;\n      });\n      argsWithFormat.unshift('Warning: ' + format);\n\n      // We intentionally don't use spread (or .apply) directly because it\n      // breaks IE9: https://github.com/facebook/react/issues/13610\n      Function.prototype.apply.call(console.error, console, argsWithFormat);\n    }\n    try {\n      // --- Welcome to debugging React ---\n      // This error was thrown as a convenience so that you can use this stack\n      // to find the callsite that caused this warning to fire.\n      var argIndex = 0;\n      var message = 'Warning: ' + format.replace(/%s/g, function () {\n        return args[argIndex++];\n      });\n      throw new Error(message);\n    } catch (x) {}\n  };\n}\n\nvar warningWithoutStack$1 = warningWithoutStack;\n\nvar didWarnStateUpdateForUnmountedComponent = {};\n\nfunction warnNoop(publicInstance, callerName) {\n  {\n    var _constructor = publicInstance.constructor;\n    var componentName = _constructor && (_constructor.displayName || _constructor.name) || 'ReactClass';\n    var warningKey = componentName + '.' + callerName;\n    if (didWarnStateUpdateForUnmountedComponent[warningKey]) {\n      return;\n    }\n    warningWithoutStack$1(false, \"Can't call %s on a component that is not yet mounted. \" + 'This is a no-op, but it might indicate a bug in your application. ' + 'Instead, assign to `this.state` directly or define a `state = {};` ' + 'class property with the desired state in the %s component.', callerName, componentName);\n    didWarnStateUpdateForUnmountedComponent[warningKey] = true;\n  }\n}\n\n/**\n * This is the abstract API for an update queue.\n */\nvar ReactNoopUpdateQueue = {\n  /**\n   * Checks whether or not this composite component is mounted.\n   * @param {ReactClass} publicInstance The instance we want to test.\n   * @return {boolean} True if mounted, false otherwise.\n   * @protected\n   * @final\n   */\n  isMounted: function (publicInstance) {\n    return false;\n  },\n\n  /**\n   * Forces an update. This should only be invoked when it is known with\n   * certainty that we are **not** in a DOM transaction.\n   *\n   * You may want to call this when you know that some deeper aspect of the\n   * component's state has changed but `setState` was not called.\n   *\n   * This will not invoke `shouldComponentUpdate`, but it will invoke\n   * `componentWillUpdate` and `componentDidUpdate`.\n   *\n   * @param {ReactClass} publicInstance The instance that should rerender.\n   * @param {?function} callback Called after component is updated.\n   * @param {?string} callerName name of the calling function in the public API.\n   * @internal\n   */\n  enqueueForceUpdate: function (publicInstance, callback, callerName) {\n    warnNoop(publicInstance, 'forceUpdate');\n  },\n\n  /**\n   * Replaces all of the state. Always use this or `setState` to mutate state.\n   * You should treat `this.state` as immutable.\n   *\n   * There is no guarantee that `this.state` will be immediately updated, so\n   * accessing `this.state` after calling this method may return the old value.\n   *\n   * @param {ReactClass} publicInstance The instance that should rerender.\n   * @param {object} completeState Next state.\n   * @param {?function} callback Called after component is updated.\n   * @param {?string} callerName name of the calling function in the public API.\n   * @internal\n   */\n  enqueueReplaceState: function (publicInstance, completeState, callback, callerName) {\n    warnNoop(publicInstance, 'replaceState');\n  },\n\n  /**\n   * Sets a subset of the state. This only exists because _pendingState is\n   * internal. This provides a merging strategy that is not available to deep\n   * properties which is confusing. TODO: Expose pendingState or don't use it\n   * during the merge.\n   *\n   * @param {ReactClass} publicInstance The instance that should rerender.\n   * @param {object} partialState Next partial state to be merged with state.\n   * @param {?function} callback Called after component is updated.\n   * @param {?string} Name of the calling function in the public API.\n   * @internal\n   */\n  enqueueSetState: function (publicInstance, partialState, callback, callerName) {\n    warnNoop(publicInstance, 'setState');\n  }\n};\n\nvar emptyObject = {};\n{\n  Object.freeze(emptyObject);\n}\n\n/**\n * Base class helpers for the updating state of a component.\n */\nfunction Component(props, context, updater) {\n  this.props = props;\n  this.context = context;\n  // If a component has string refs, we will assign a different object later.\n  this.refs = emptyObject;\n  // We initialize the default updater but the real one gets injected by the\n  // renderer.\n  this.updater = updater || ReactNoopUpdateQueue;\n}\n\nComponent.prototype.isReactComponent = {};\n\n/**\n * Sets a subset of the state. Always use this to mutate\n * state. You should treat `this.state` as immutable.\n *\n * There is no guarantee that `this.state` will be immediately updated, so\n * accessing `this.state` after calling this method may return the old value.\n *\n * There is no guarantee that calls to `setState` will run synchronously,\n * as they may eventually be batched together.  You can provide an optional\n * callback that will be executed when the call to setState is actually\n * completed.\n *\n * When a function is provided to setState, it will be called at some point in\n * the future (not synchronously). It will be called with the up to date\n * component arguments (state, props, context). These values can be different\n * from this.* because your function may be called after receiveProps but before\n * shouldComponentUpdate, and this new state, props, and context will not yet be\n * assigned to this.\n *\n * @param {object|function} partialState Next partial state or function to\n *        produce next partial state to be merged with current state.\n * @param {?function} callback Called after state is updated.\n * @final\n * @protected\n */\nComponent.prototype.setState = function (partialState, callback) {\n  (function () {\n    if (!(typeof partialState === 'object' || typeof partialState === 'function' || partialState == null)) {\n      {\n        throw ReactError(Error('setState(...): takes an object of state variables to update or a function which returns an object of state variables.'));\n      }\n    }\n  })();\n  this.updater.enqueueSetState(this, partialState, callback, 'setState');\n};\n\n/**\n * Forces an update. This should only be invoked when it is known with\n * certainty that we are **not** in a DOM transaction.\n *\n * You may want to call this when you know that some deeper aspect of the\n * component's state has changed but `setState` was not called.\n *\n * This will not invoke `shouldComponentUpdate`, but it will invoke\n * `componentWillUpdate` and `componentDidUpdate`.\n *\n * @param {?function} callback Called after update is complete.\n * @final\n * @protected\n */\nComponent.prototype.forceUpdate = function (callback) {\n  this.updater.enqueueForceUpdate(this, callback, 'forceUpdate');\n};\n\n/**\n * Deprecated APIs. These APIs used to exist on classic React classes but since\n * we would like to deprecate them, we're not going to move them over to this\n * modern base class. Instead, we define a getter that warns if it's accessed.\n */\n{\n  var deprecatedAPIs = {\n    isMounted: ['isMounted', 'Instead, make sure to clean up subscriptions and pending requests in ' + 'componentWillUnmount to prevent memory leaks.'],\n    replaceState: ['replaceState', 'Refactor your code to use setState instead (see ' + 'https://github.com/facebook/react/issues/3236).']\n  };\n  var defineDeprecationWarning = function (methodName, info) {\n    Object.defineProperty(Component.prototype, methodName, {\n      get: function () {\n        lowPriorityWarning$1(false, '%s(...) is deprecated in plain JavaScript React classes. %s', info[0], info[1]);\n        return undefined;\n      }\n    });\n  };\n  for (var fnName in deprecatedAPIs) {\n    if (deprecatedAPIs.hasOwnProperty(fnName)) {\n      defineDeprecationWarning(fnName, deprecatedAPIs[fnName]);\n    }\n  }\n}\n\nfunction ComponentDummy() {}\nComponentDummy.prototype = Component.prototype;\n\n/**\n * Convenience component with default shallow equality check for sCU.\n */\nfunction PureComponent(props, context, updater) {\n  this.props = props;\n  this.context = context;\n  // If a component has string refs, we will assign a different object later.\n  this.refs = emptyObject;\n  this.updater = updater || ReactNoopUpdateQueue;\n}\n\nvar pureComponentPrototype = PureComponent.prototype = new ComponentDummy();\npureComponentPrototype.constructor = PureComponent;\n// Avoid an extra prototype jump for these methods.\n_assign(pureComponentPrototype, Component.prototype);\npureComponentPrototype.isPureReactComponent = true;\n\n// an immutable object with a single mutable value\nfunction createRef() {\n  var refObject = {\n    current: null\n  };\n  {\n    Object.seal(refObject);\n  }\n  return refObject;\n}\n\n/**\n * Keeps track of the current dispatcher.\n */\nvar ReactCurrentDispatcher = {\n  /**\n   * @internal\n   * @type {ReactComponent}\n   */\n  current: null\n};\n\n/**\n * Keeps track of the current batch's configuration such as how long an update\n * should suspend for if it needs to.\n */\nvar ReactCurrentBatchConfig = {\n  suspense: null\n};\n\n/**\n * Keeps track of the current owner.\n *\n * The current owner is the component who should own any components that are\n * currently being constructed.\n */\nvar ReactCurrentOwner = {\n  /**\n   * @internal\n   * @type {ReactComponent}\n   */\n  current: null\n};\n\nvar BEFORE_SLASH_RE = /^(.*)[\\\\\\/]/;\n\nvar describeComponentFrame = function (name, source, ownerName) {\n  var sourceInfo = '';\n  if (source) {\n    var path = source.fileName;\n    var fileName = path.replace(BEFORE_SLASH_RE, '');\n    {\n      // In DEV, include code for a common special case:\n      // prefer \"folder/index.js\" instead of just \"index.js\".\n      if (/^index\\./.test(fileName)) {\n        var match = path.match(BEFORE_SLASH_RE);\n        if (match) {\n          var pathBeforeSlash = match[1];\n          if (pathBeforeSlash) {\n            var folderName = pathBeforeSlash.replace(BEFORE_SLASH_RE, '');\n            fileName = folderName + '/' + fileName;\n          }\n        }\n      }\n    }\n    sourceInfo = ' (at ' + fileName + ':' + source.lineNumber + ')';\n  } else if (ownerName) {\n    sourceInfo = ' (created by ' + ownerName + ')';\n  }\n  return '\\n    in ' + (name || 'Unknown') + sourceInfo;\n};\n\nvar Resolved = 1;\n\n\nfunction refineResolvedLazyComponent(lazyComponent) {\n  return lazyComponent._status === Resolved ? lazyComponent._result : null;\n}\n\nfunction getWrappedName(outerType, innerType, wrapperName) {\n  var functionName = innerType.displayName || innerType.name || '';\n  return outerType.displayName || (functionName !== '' ? wrapperName + '(' + functionName + ')' : wrapperName);\n}\n\nfunction getComponentName(type) {\n  if (type == null) {\n    // Host root, text node or just invalid type.\n    return null;\n  }\n  {\n    if (typeof type.tag === 'number') {\n      warningWithoutStack$1(false, 'Received an unexpected object in getComponentName(). ' + 'This is likely a bug in React. Please file an issue.');\n    }\n  }\n  if (typeof type === 'function') {\n    return type.displayName || type.name || null;\n  }\n  if (typeof type === 'string') {\n    return type;\n  }\n  switch (type) {\n    case REACT_FRAGMENT_TYPE:\n      return 'Fragment';\n    case REACT_PORTAL_TYPE:\n      return 'Portal';\n    case REACT_PROFILER_TYPE:\n      return 'Profiler';\n    case REACT_STRICT_MODE_TYPE:\n      return 'StrictMode';\n    case REACT_SUSPENSE_TYPE:\n      return 'Suspense';\n    case REACT_SUSPENSE_LIST_TYPE:\n      return 'SuspenseList';\n  }\n  if (typeof type === 'object') {\n    switch (type.$$typeof) {\n      case REACT_CONTEXT_TYPE:\n        return 'Context.Consumer';\n      case REACT_PROVIDER_TYPE:\n        return 'Context.Provider';\n      case REACT_FORWARD_REF_TYPE:\n        return getWrappedName(type, type.render, 'ForwardRef');\n      case REACT_MEMO_TYPE:\n        return getComponentName(type.type);\n      case REACT_LAZY_TYPE:\n        {\n          var thenable = type;\n          var resolvedThenable = refineResolvedLazyComponent(thenable);\n          if (resolvedThenable) {\n            return getComponentName(resolvedThenable);\n          }\n          break;\n        }\n    }\n  }\n  return null;\n}\n\nvar ReactDebugCurrentFrame = {};\n\nvar currentlyValidatingElement = null;\n\nfunction setCurrentlyValidatingElement(element) {\n  {\n    currentlyValidatingElement = element;\n  }\n}\n\n{\n  // Stack implementation injected by the current renderer.\n  ReactDebugCurrentFrame.getCurrentStack = null;\n\n  ReactDebugCurrentFrame.getStackAddendum = function () {\n    var stack = '';\n\n    // Add an extra top frame while an element is being validated\n    if (currentlyValidatingElement) {\n      var name = getComponentName(currentlyValidatingElement.type);\n      var owner = currentlyValidatingElement._owner;\n      stack += describeComponentFrame(name, currentlyValidatingElement._source, owner && getComponentName(owner.type));\n    }\n\n    // Delegate to the injected renderer-specific implementation\n    var impl = ReactDebugCurrentFrame.getCurrentStack;\n    if (impl) {\n      stack += impl() || '';\n    }\n\n    return stack;\n  };\n}\n\n/**\n * Used by act() to track whether you're inside an act() scope.\n */\n\nvar IsSomeRendererActing = {\n  current: false\n};\n\nvar ReactSharedInternals = {\n  ReactCurrentDispatcher: ReactCurrentDispatcher,\n  ReactCurrentBatchConfig: ReactCurrentBatchConfig,\n  ReactCurrentOwner: ReactCurrentOwner,\n  IsSomeRendererActing: IsSomeRendererActing,\n  // Used by renderers to avoid bundling object-assign twice in UMD bundles:\n  assign: _assign\n};\n\n{\n  _assign(ReactSharedInternals, {\n    // These should not be included in production.\n    ReactDebugCurrentFrame: ReactDebugCurrentFrame,\n    // Shim for React DOM 16.0.0 which still destructured (but not used) this.\n    // TODO: remove in React 17.0.\n    ReactComponentTreeHook: {}\n  });\n}\n\n/**\n * Similar to invariant but only logs a warning if the condition is not met.\n * This can be used to log issues in development environments in critical\n * paths. Removing the logging code for production environments will keep the\n * same logic and follow the same code paths.\n */\n\nvar warning = warningWithoutStack$1;\n\n{\n  warning = function (condition, format) {\n    if (condition) {\n      return;\n    }\n    var ReactDebugCurrentFrame = ReactSharedInternals.ReactDebugCurrentFrame;\n    var stack = ReactDebugCurrentFrame.getStackAddendum();\n    // eslint-disable-next-line react-internal/warning-and-invariant-args\n\n    for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {\n      args[_key - 2] = arguments[_key];\n    }\n\n    warningWithoutStack$1.apply(undefined, [false, format + '%s'].concat(args, [stack]));\n  };\n}\n\nvar warning$1 = warning;\n\nvar hasOwnProperty = Object.prototype.hasOwnProperty;\n\nvar RESERVED_PROPS = {\n  key: true,\n  ref: true,\n  __self: true,\n  __source: true\n};\n\nvar specialPropKeyWarningShown = void 0;\nvar specialPropRefWarningShown = void 0;\n\nfunction hasValidRef(config) {\n  {\n    if (hasOwnProperty.call(config, 'ref')) {\n      var getter = Object.getOwnPropertyDescriptor(config, 'ref').get;\n      if (getter && getter.isReactWarning) {\n        return false;\n      }\n    }\n  }\n  return config.ref !== undefined;\n}\n\nfunction hasValidKey(config) {\n  {\n    if (hasOwnProperty.call(config, 'key')) {\n      var getter = Object.getOwnPropertyDescriptor(config, 'key').get;\n      if (getter && getter.isReactWarning) {\n        return false;\n      }\n    }\n  }\n  return config.key !== undefined;\n}\n\nfunction defineKeyPropWarningGetter(props, displayName) {\n  var warnAboutAccessingKey = function () {\n    if (!specialPropKeyWarningShown) {\n      specialPropKeyWarningShown = true;\n      warningWithoutStack$1(false, '%s: `key` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://fb.me/react-special-props)', displayName);\n    }\n  };\n  warnAboutAccessingKey.isReactWarning = true;\n  Object.defineProperty(props, 'key', {\n    get: warnAboutAccessingKey,\n    configurable: true\n  });\n}\n\nfunction defineRefPropWarningGetter(props, displayName) {\n  var warnAboutAccessingRef = function () {\n    if (!specialPropRefWarningShown) {\n      specialPropRefWarningShown = true;\n      warningWithoutStack$1(false, '%s: `ref` is not a prop. Trying to access it will result ' + 'in `undefined` being returned. If you need to access the same ' + 'value within the child component, you should pass it as a different ' + 'prop. (https://fb.me/react-special-props)', displayName);\n    }\n  };\n  warnAboutAccessingRef.isReactWarning = true;\n  Object.defineProperty(props, 'ref', {\n    get: warnAboutAccessingRef,\n    configurable: true\n  });\n}\n\n/**\n * Factory method to create a new React element. This no longer adheres to\n * the class pattern, so do not use new to call it. Also, no instanceof check\n * will work. Instead test $$typeof field against Symbol.for('react.element') to check\n * if something is a React Element.\n *\n * @param {*} type\n * @param {*} props\n * @param {*} key\n * @param {string|object} ref\n * @param {*} owner\n * @param {*} self A *temporary* helper to detect places where `this` is\n * different from the `owner` when React.createElement is called, so that we\n * can warn. We want to get rid of owner and replace string `ref`s with arrow\n * functions, and as long as `this` and owner are the same, there will be no\n * change in behavior.\n * @param {*} source An annotation object (added by a transpiler or otherwise)\n * indicating filename, line number, and/or other information.\n * @internal\n */\nvar ReactElement = function (type, key, ref, self, source, owner, props) {\n  var element = {\n    // This tag allows us to uniquely identify this as a React Element\n    $$typeof: REACT_ELEMENT_TYPE,\n\n    // Built-in properties that belong on the element\n    type: type,\n    key: key,\n    ref: ref,\n    props: props,\n\n    // Record the component responsible for creating this element.\n    _owner: owner\n  };\n\n  {\n    // The validation flag is currently mutative. We put it on\n    // an external backing store so that we can freeze the whole object.\n    // This can be replaced with a WeakMap once they are implemented in\n    // commonly used development environments.\n    element._store = {};\n\n    // To make comparing ReactElements easier for testing purposes, we make\n    // the validation flag non-enumerable (where possible, which should\n    // include every environment we run tests in), so the test framework\n    // ignores it.\n    Object.defineProperty(element._store, 'validated', {\n      configurable: false,\n      enumerable: false,\n      writable: true,\n      value: false\n    });\n    // self and source are DEV only properties.\n    Object.defineProperty(element, '_self', {\n      configurable: false,\n      enumerable: false,\n      writable: false,\n      value: self\n    });\n    // Two elements created in two different places should be considered\n    // equal for testing purposes and therefore we hide it from enumeration.\n    Object.defineProperty(element, '_source', {\n      configurable: false,\n      enumerable: false,\n      writable: false,\n      value: source\n    });\n    if (Object.freeze) {\n      Object.freeze(element.props);\n      Object.freeze(element);\n    }\n  }\n\n  return element;\n};\n\n/**\n * https://github.com/reactjs/rfcs/pull/107\n * @param {*} type\n * @param {object} props\n * @param {string} key\n */\n\n\n/**\n * https://github.com/reactjs/rfcs/pull/107\n * @param {*} type\n * @param {object} props\n * @param {string} key\n */\nfunction jsxDEV(type, config, maybeKey, source, self) {\n  var propName = void 0;\n\n  // Reserved names are extracted\n  var props = {};\n\n  var key = null;\n  var ref = null;\n\n  if (hasValidRef(config)) {\n    ref = config.ref;\n  }\n\n  if (hasValidKey(config)) {\n    key = '' + config.key;\n  }\n\n  // Remaining properties are added to a new props object\n  for (propName in config) {\n    if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {\n      props[propName] = config[propName];\n    }\n  }\n\n  // intentionally not checking if key was set above\n  // this key is higher priority as it's static\n  if (maybeKey !== undefined) {\n    key = '' + maybeKey;\n  }\n\n  // Resolve default props\n  if (type && type.defaultProps) {\n    var defaultProps = type.defaultProps;\n    for (propName in defaultProps) {\n      if (props[propName] === undefined) {\n        props[propName] = defaultProps[propName];\n      }\n    }\n  }\n\n  if (key || ref) {\n    var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;\n    if (key) {\n      defineKeyPropWarningGetter(props, displayName);\n    }\n    if (ref) {\n      defineRefPropWarningGetter(props, displayName);\n    }\n  }\n\n  return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);\n}\n\n/**\n * Create and return a new ReactElement of the given type.\n * See https://reactjs.org/docs/react-api.html#createelement\n */\nfunction createElement(type, config, children) {\n  var propName = void 0;\n\n  // Reserved names are extracted\n  var props = {};\n\n  var key = null;\n  var ref = null;\n  var self = null;\n  var source = null;\n\n  if (config != null) {\n    if (hasValidRef(config)) {\n      ref = config.ref;\n    }\n    if (hasValidKey(config)) {\n      key = '' + config.key;\n    }\n\n    self = config.__self === undefined ? null : config.__self;\n    source = config.__source === undefined ? null : config.__source;\n    // Remaining properties are added to a new props object\n    for (propName in config) {\n      if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {\n        props[propName] = config[propName];\n      }\n    }\n  }\n\n  // Children can be more than one argument, and those are transferred onto\n  // the newly allocated props object.\n  var childrenLength = arguments.length - 2;\n  if (childrenLength === 1) {\n    props.children = children;\n  } else if (childrenLength > 1) {\n    var childArray = Array(childrenLength);\n    for (var i = 0; i < childrenLength; i++) {\n      childArray[i] = arguments[i + 2];\n    }\n    {\n      if (Object.freeze) {\n        Object.freeze(childArray);\n      }\n    }\n    props.children = childArray;\n  }\n\n  // Resolve default props\n  if (type && type.defaultProps) {\n    var defaultProps = type.defaultProps;\n    for (propName in defaultProps) {\n      if (props[propName] === undefined) {\n        props[propName] = defaultProps[propName];\n      }\n    }\n  }\n  {\n    if (key || ref) {\n      var displayName = typeof type === 'function' ? type.displayName || type.name || 'Unknown' : type;\n      if (key) {\n        defineKeyPropWarningGetter(props, displayName);\n      }\n      if (ref) {\n        defineRefPropWarningGetter(props, displayName);\n      }\n    }\n  }\n  return ReactElement(type, key, ref, self, source, ReactCurrentOwner.current, props);\n}\n\n/**\n * Return a function that produces ReactElements of a given type.\n * See https://reactjs.org/docs/react-api.html#createfactory\n */\n\n\nfunction cloneAndReplaceKey(oldElement, newKey) {\n  var newElement = ReactElement(oldElement.type, newKey, oldElement.ref, oldElement._self, oldElement._source, oldElement._owner, oldElement.props);\n\n  return newElement;\n}\n\n/**\n * Clone and return a new ReactElement using element as the starting point.\n * See https://reactjs.org/docs/react-api.html#cloneelement\n */\nfunction cloneElement(element, config, children) {\n  (function () {\n    if (!!(element === null || element === undefined)) {\n      {\n        throw ReactError(Error('React.cloneElement(...): The argument must be a React element, but you passed ' + element + '.'));\n      }\n    }\n  })();\n\n  var propName = void 0;\n\n  // Original props are copied\n  var props = _assign({}, element.props);\n\n  // Reserved names are extracted\n  var key = element.key;\n  var ref = element.ref;\n  // Self is preserved since the owner is preserved.\n  var self = element._self;\n  // Source is preserved since cloneElement is unlikely to be targeted by a\n  // transpiler, and the original source is probably a better indicator of the\n  // true owner.\n  var source = element._source;\n\n  // Owner will be preserved, unless ref is overridden\n  var owner = element._owner;\n\n  if (config != null) {\n    if (hasValidRef(config)) {\n      // Silently steal the ref from the parent.\n      ref = config.ref;\n      owner = ReactCurrentOwner.current;\n    }\n    if (hasValidKey(config)) {\n      key = '' + config.key;\n    }\n\n    // Remaining properties override existing props\n    var defaultProps = void 0;\n    if (element.type && element.type.defaultProps) {\n      defaultProps = element.type.defaultProps;\n    }\n    for (propName in config) {\n      if (hasOwnProperty.call(config, propName) && !RESERVED_PROPS.hasOwnProperty(propName)) {\n        if (config[propName] === undefined && defaultProps !== undefined) {\n          // Resolve default props\n          props[propName] = defaultProps[propName];\n        } else {\n          props[propName] = config[propName];\n        }\n      }\n    }\n  }\n\n  // Children can be more than one argument, and those are transferred onto\n  // the newly allocated props object.\n  var childrenLength = arguments.length - 2;\n  if (childrenLength === 1) {\n    props.children = children;\n  } else if (childrenLength > 1) {\n    var childArray = Array(childrenLength);\n    for (var i = 0; i < childrenLength; i++) {\n      childArray[i] = arguments[i + 2];\n    }\n    props.children = childArray;\n  }\n\n  return ReactElement(element.type, key, ref, self, source, owner, props);\n}\n\n/**\n * Verifies the object is a ReactElement.\n * See https://reactjs.org/docs/react-api.html#isvalidelement\n * @param {?object} object\n * @return {boolean} True if `object` is a ReactElement.\n * @final\n */\nfunction isValidElement(object) {\n  return typeof object === 'object' && object !== null && object.$$typeof === REACT_ELEMENT_TYPE;\n}\n\nvar SEPARATOR = '.';\nvar SUBSEPARATOR = ':';\n\n/**\n * Escape and wrap key so it is safe to use as a reactid\n *\n * @param {string} key to be escaped.\n * @return {string} the escaped key.\n */\nfunction escape(key) {\n  var escapeRegex = /[=:]/g;\n  var escaperLookup = {\n    '=': '=0',\n    ':': '=2'\n  };\n  var escapedString = ('' + key).replace(escapeRegex, function (match) {\n    return escaperLookup[match];\n  });\n\n  return '$' + escapedString;\n}\n\n/**\n * TODO: Test that a single child and an array with one item have the same key\n * pattern.\n */\n\nvar didWarnAboutMaps = false;\n\nvar userProvidedKeyEscapeRegex = /\\/+/g;\nfunction escapeUserProvidedKey(text) {\n  return ('' + text).replace(userProvidedKeyEscapeRegex, '$&/');\n}\n\nvar POOL_SIZE = 10;\nvar traverseContextPool = [];\nfunction getPooledTraverseContext(mapResult, keyPrefix, mapFunction, mapContext) {\n  if (traverseContextPool.length) {\n    var traverseContext = traverseContextPool.pop();\n    traverseContext.result = mapResult;\n    traverseContext.keyPrefix = keyPrefix;\n    traverseContext.func = mapFunction;\n    traverseContext.context = mapContext;\n    traverseContext.count = 0;\n    return traverseContext;\n  } else {\n    return {\n      result: mapResult,\n      keyPrefix: keyPrefix,\n      func: mapFunction,\n      context: mapContext,\n      count: 0\n    };\n  }\n}\n\nfunction releaseTraverseContext(traverseContext) {\n  traverseContext.result = null;\n  traverseContext.keyPrefix = null;\n  traverseContext.func = null;\n  traverseContext.context = null;\n  traverseContext.count = 0;\n  if (traverseContextPool.length < POOL_SIZE) {\n    traverseContextPool.push(traverseContext);\n  }\n}\n\n/**\n * @param {?*} children Children tree container.\n * @param {!string} nameSoFar Name of the key path so far.\n * @param {!function} callback Callback to invoke with each child found.\n * @param {?*} traverseContext Used to pass information throughout the traversal\n * process.\n * @return {!number} The number of children in this subtree.\n */\nfunction traverseAllChildrenImpl(children, nameSoFar, callback, traverseContext) {\n  var type = typeof children;\n\n  if (type === 'undefined' || type === 'boolean') {\n    // All of the above are perceived as null.\n    children = null;\n  }\n\n  var invokeCallback = false;\n\n  if (children === null) {\n    invokeCallback = true;\n  } else {\n    switch (type) {\n      case 'string':\n      case 'number':\n        invokeCallback = true;\n        break;\n      case 'object':\n        switch (children.$$typeof) {\n          case REACT_ELEMENT_TYPE:\n          case REACT_PORTAL_TYPE:\n            invokeCallback = true;\n        }\n    }\n  }\n\n  if (invokeCallback) {\n    callback(traverseContext, children,\n    // If it's the only child, treat the name as if it was wrapped in an array\n    // so that it's consistent if the number of children grows.\n    nameSoFar === '' ? SEPARATOR + getComponentKey(children, 0) : nameSoFar);\n    return 1;\n  }\n\n  var child = void 0;\n  var nextName = void 0;\n  var subtreeCount = 0; // Count of children found in the current subtree.\n  var nextNamePrefix = nameSoFar === '' ? SEPARATOR : nameSoFar + SUBSEPARATOR;\n\n  if (Array.isArray(children)) {\n    for (var i = 0; i < children.length; i++) {\n      child = children[i];\n      nextName = nextNamePrefix + getComponentKey(child, i);\n      subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext);\n    }\n  } else {\n    var iteratorFn = getIteratorFn(children);\n    if (typeof iteratorFn === 'function') {\n      {\n        // Warn about using Maps as children\n        if (iteratorFn === children.entries) {\n          !didWarnAboutMaps ? warning$1(false, 'Using Maps as children is unsupported and will likely yield ' + 'unexpected results. Convert it to a sequence/iterable of keyed ' + 'ReactElements instead.') : void 0;\n          didWarnAboutMaps = true;\n        }\n      }\n\n      var iterator = iteratorFn.call(children);\n      var step = void 0;\n      var ii = 0;\n      while (!(step = iterator.next()).done) {\n        child = step.value;\n        nextName = nextNamePrefix + getComponentKey(child, ii++);\n        subtreeCount += traverseAllChildrenImpl(child, nextName, callback, traverseContext);\n      }\n    } else if (type === 'object') {\n      var addendum = '';\n      {\n        addendum = ' If you meant to render a collection of children, use an array ' + 'instead.' + ReactDebugCurrentFrame.getStackAddendum();\n      }\n      var childrenString = '' + children;\n      (function () {\n        {\n          {\n            throw ReactError(Error('Objects are not valid as a React child (found: ' + (childrenString === '[object Object]' ? 'object with keys {' + Object.keys(children).join(', ') + '}' : childrenString) + ').' + addendum));\n          }\n        }\n      })();\n    }\n  }\n\n  return subtreeCount;\n}\n\n/**\n * Traverses children that are typically specified as `props.children`, but\n * might also be specified through attributes:\n *\n * - `traverseAllChildren(this.props.children, ...)`\n * - `traverseAllChildren(this.props.leftPanelChildren, ...)`\n *\n * The `traverseContext` is an optional argument that is passed through the\n * entire traversal. It can be used to store accumulations or anything else that\n * the callback might find relevant.\n *\n * @param {?*} children Children tree object.\n * @param {!function} callback To invoke upon traversing each child.\n * @param {?*} traverseContext Context for traversal.\n * @return {!number} The number of children in this subtree.\n */\nfunction traverseAllChildren(children, callback, traverseContext) {\n  if (children == null) {\n    return 0;\n  }\n\n  return traverseAllChildrenImpl(children, '', callback, traverseContext);\n}\n\n/**\n * Generate a key string that identifies a component within a set.\n *\n * @param {*} component A component that could contain a manual key.\n * @param {number} index Index that is used if a manual key is not provided.\n * @return {string}\n */\nfunction getComponentKey(component, index) {\n  // Do some typechecking here since we call this blindly. We want to ensure\n  // that we don't block potential future ES APIs.\n  if (typeof component === 'object' && component !== null && component.key != null) {\n    // Explicit key\n    return escape(component.key);\n  }\n  // Implicit key determined by the index in the set\n  return index.toString(36);\n}\n\nfunction forEachSingleChild(bookKeeping, child, name) {\n  var func = bookKeeping.func,\n      context = bookKeeping.context;\n\n  func.call(context, child, bookKeeping.count++);\n}\n\n/**\n * Iterates through children that are typically specified as `props.children`.\n *\n * See https://reactjs.org/docs/react-api.html#reactchildrenforeach\n *\n * The provided forEachFunc(child, index) will be called for each\n * leaf child.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} forEachFunc\n * @param {*} forEachContext Context for forEachContext.\n */\nfunction forEachChildren(children, forEachFunc, forEachContext) {\n  if (children == null) {\n    return children;\n  }\n  var traverseContext = getPooledTraverseContext(null, null, forEachFunc, forEachContext);\n  traverseAllChildren(children, forEachSingleChild, traverseContext);\n  releaseTraverseContext(traverseContext);\n}\n\nfunction mapSingleChildIntoContext(bookKeeping, child, childKey) {\n  var result = bookKeeping.result,\n      keyPrefix = bookKeeping.keyPrefix,\n      func = bookKeeping.func,\n      context = bookKeeping.context;\n\n\n  var mappedChild = func.call(context, child, bookKeeping.count++);\n  if (Array.isArray(mappedChild)) {\n    mapIntoWithKeyPrefixInternal(mappedChild, result, childKey, function (c) {\n      return c;\n    });\n  } else if (mappedChild != null) {\n    if (isValidElement(mappedChild)) {\n      mappedChild = cloneAndReplaceKey(mappedChild,\n      // Keep both the (mapped) and old keys if they differ, just as\n      // traverseAllChildren used to do for objects as children\n      keyPrefix + (mappedChild.key && (!child || child.key !== mappedChild.key) ? escapeUserProvidedKey(mappedChild.key) + '/' : '') + childKey);\n    }\n    result.push(mappedChild);\n  }\n}\n\nfunction mapIntoWithKeyPrefixInternal(children, array, prefix, func, context) {\n  var escapedPrefix = '';\n  if (prefix != null) {\n    escapedPrefix = escapeUserProvidedKey(prefix) + '/';\n  }\n  var traverseContext = getPooledTraverseContext(array, escapedPrefix, func, context);\n  traverseAllChildren(children, mapSingleChildIntoContext, traverseContext);\n  releaseTraverseContext(traverseContext);\n}\n\n/**\n * Maps children that are typically specified as `props.children`.\n *\n * See https://reactjs.org/docs/react-api.html#reactchildrenmap\n *\n * The provided mapFunction(child, key, index) will be called for each\n * leaf child.\n *\n * @param {?*} children Children tree container.\n * @param {function(*, int)} func The map function.\n * @param {*} context Context for mapFunction.\n * @return {object} Object containing the ordered map of results.\n */\nfunction mapChildren(children, func, context) {\n  if (children == null) {\n    return children;\n  }\n  var result = [];\n  mapIntoWithKeyPrefixInternal(children, result, null, func, context);\n  return result;\n}\n\n/**\n * Count the number of children that are typically specified as\n * `props.children`.\n *\n * See https://reactjs.org/docs/react-api.html#reactchildrencount\n *\n * @param {?*} children Children tree container.\n * @return {number} The number of children.\n */\nfunction countChildren(children) {\n  return traverseAllChildren(children, function () {\n    return null;\n  }, null);\n}\n\n/**\n * Flatten a children object (typically specified as `props.children`) and\n * return an array with appropriately re-keyed children.\n *\n * See https://reactjs.org/docs/react-api.html#reactchildrentoarray\n */\nfunction toArray(children) {\n  var result = [];\n  mapIntoWithKeyPrefixInternal(children, result, null, function (child) {\n    return child;\n  });\n  return result;\n}\n\n/**\n * Returns the first child in a collection of children and verifies that there\n * is only one child in the collection.\n *\n * See https://reactjs.org/docs/react-api.html#reactchildrenonly\n *\n * The current implementation of this function assumes that a single child gets\n * passed without a wrapper, but the purpose of this helper function is to\n * abstract away the particular structure of children.\n *\n * @param {?object} children Child collection structure.\n * @return {ReactElement} The first and only `ReactElement` contained in the\n * structure.\n */\nfunction onlyChild(children) {\n  (function () {\n    if (!isValidElement(children)) {\n      {\n        throw ReactError(Error('React.Children.only expected to receive a single React element child.'));\n      }\n    }\n  })();\n  return children;\n}\n\nfunction createContext(defaultValue, calculateChangedBits) {\n  if (calculateChangedBits === undefined) {\n    calculateChangedBits = null;\n  } else {\n    {\n      !(calculateChangedBits === null || typeof calculateChangedBits === 'function') ? warningWithoutStack$1(false, 'createContext: Expected the optional second argument to be a ' + 'function. Instead received: %s', calculateChangedBits) : void 0;\n    }\n  }\n\n  var context = {\n    $$typeof: REACT_CONTEXT_TYPE,\n    _calculateChangedBits: calculateChangedBits,\n    // As a workaround to support multiple concurrent renderers, we categorize\n    // some renderers as primary and others as secondary. We only expect\n    // there to be two concurrent renderers at most: React Native (primary) and\n    // Fabric (secondary); React DOM (primary) and React ART (secondary).\n    // Secondary renderers store their context values on separate fields.\n    _currentValue: defaultValue,\n    _currentValue2: defaultValue,\n    // Used to track how many concurrent renderers this context currently\n    // supports within in a single renderer. Such as parallel server rendering.\n    _threadCount: 0,\n    // These are circular\n    Provider: null,\n    Consumer: null\n  };\n\n  context.Provider = {\n    $$typeof: REACT_PROVIDER_TYPE,\n    _context: context\n  };\n\n  var hasWarnedAboutUsingNestedContextConsumers = false;\n  var hasWarnedAboutUsingConsumerProvider = false;\n\n  {\n    // A separate object, but proxies back to the original context object for\n    // backwards compatibility. It has a different $$typeof, so we can properly\n    // warn for the incorrect usage of Context as a Consumer.\n    var Consumer = {\n      $$typeof: REACT_CONTEXT_TYPE,\n      _context: context,\n      _calculateChangedBits: context._calculateChangedBits\n    };\n    // $FlowFixMe: Flow complains about not setting a value, which is intentional here\n    Object.defineProperties(Consumer, {\n      Provider: {\n        get: function () {\n          if (!hasWarnedAboutUsingConsumerProvider) {\n            hasWarnedAboutUsingConsumerProvider = true;\n            warning$1(false, 'Rendering <Context.Consumer.Provider> is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Provider> instead?');\n          }\n          return context.Provider;\n        },\n        set: function (_Provider) {\n          context.Provider = _Provider;\n        }\n      },\n      _currentValue: {\n        get: function () {\n          return context._currentValue;\n        },\n        set: function (_currentValue) {\n          context._currentValue = _currentValue;\n        }\n      },\n      _currentValue2: {\n        get: function () {\n          return context._currentValue2;\n        },\n        set: function (_currentValue2) {\n          context._currentValue2 = _currentValue2;\n        }\n      },\n      _threadCount: {\n        get: function () {\n          return context._threadCount;\n        },\n        set: function (_threadCount) {\n          context._threadCount = _threadCount;\n        }\n      },\n      Consumer: {\n        get: function () {\n          if (!hasWarnedAboutUsingNestedContextConsumers) {\n            hasWarnedAboutUsingNestedContextConsumers = true;\n            warning$1(false, 'Rendering <Context.Consumer.Consumer> is not supported and will be removed in ' + 'a future major release. Did you mean to render <Context.Consumer> instead?');\n          }\n          return context.Consumer;\n        }\n      }\n    });\n    // $FlowFixMe: Flow complains about missing properties because it doesn't understand defineProperty\n    context.Consumer = Consumer;\n  }\n\n  {\n    context._currentRenderer = null;\n    context._currentRenderer2 = null;\n  }\n\n  return context;\n}\n\nfunction lazy(ctor) {\n  var lazyType = {\n    $$typeof: REACT_LAZY_TYPE,\n    _ctor: ctor,\n    // React uses these fields to store the result.\n    _status: -1,\n    _result: null\n  };\n\n  {\n    // In production, this would just set it on the object.\n    var defaultProps = void 0;\n    var propTypes = void 0;\n    Object.defineProperties(lazyType, {\n      defaultProps: {\n        configurable: true,\n        get: function () {\n          return defaultProps;\n        },\n        set: function (newDefaultProps) {\n          warning$1(false, 'React.lazy(...): It is not supported to assign `defaultProps` to ' + 'a lazy component import. Either specify them where the component ' + 'is defined, or create a wrapping component around it.');\n          defaultProps = newDefaultProps;\n          // Match production behavior more closely:\n          Object.defineProperty(lazyType, 'defaultProps', {\n            enumerable: true\n          });\n        }\n      },\n      propTypes: {\n        configurable: true,\n        get: function () {\n          return propTypes;\n        },\n        set: function (newPropTypes) {\n          warning$1(false, 'React.lazy(...): It is not supported to assign `propTypes` to ' + 'a lazy component import. Either specify them where the component ' + 'is defined, or create a wrapping component around it.');\n          propTypes = newPropTypes;\n          // Match production behavior more closely:\n          Object.defineProperty(lazyType, 'propTypes', {\n            enumerable: true\n          });\n        }\n      }\n    });\n  }\n\n  return lazyType;\n}\n\nfunction forwardRef(render) {\n  {\n    if (render != null && render.$$typeof === REACT_MEMO_TYPE) {\n      warningWithoutStack$1(false, 'forwardRef requires a render function but received a `memo` ' + 'component. Instead of forwardRef(memo(...)), use ' + 'memo(forwardRef(...)).');\n    } else if (typeof render !== 'function') {\n      warningWithoutStack$1(false, 'forwardRef requires a render function but was given %s.', render === null ? 'null' : typeof render);\n    } else {\n      !(\n      // Do not warn for 0 arguments because it could be due to usage of the 'arguments' object\n      render.length === 0 || render.length === 2) ? warningWithoutStack$1(false, 'forwardRef render functions accept exactly two parameters: props and ref. %s', render.length === 1 ? 'Did you forget to use the ref parameter?' : 'Any additional parameter will be undefined.') : void 0;\n    }\n\n    if (render != null) {\n      !(render.defaultProps == null && render.propTypes == null) ? warningWithoutStack$1(false, 'forwardRef render functions do not support propTypes or defaultProps. ' + 'Did you accidentally pass a React component?') : void 0;\n    }\n  }\n\n  return {\n    $$typeof: REACT_FORWARD_REF_TYPE,\n    render: render\n  };\n}\n\nfunction isValidElementType(type) {\n  return typeof type === 'string' || typeof type === 'function' ||\n  // Note: its typeof might be other than 'symbol' or 'number' if it's a polyfill.\n  type === REACT_FRAGMENT_TYPE || type === REACT_CONCURRENT_MODE_TYPE || type === REACT_PROFILER_TYPE || type === REACT_STRICT_MODE_TYPE || type === REACT_SUSPENSE_TYPE || type === REACT_SUSPENSE_LIST_TYPE || typeof type === 'object' && type !== null && (type.$$typeof === REACT_LAZY_TYPE || type.$$typeof === REACT_MEMO_TYPE || type.$$typeof === REACT_PROVIDER_TYPE || type.$$typeof === REACT_CONTEXT_TYPE || type.$$typeof === REACT_FORWARD_REF_TYPE || type.$$typeof === REACT_FUNDAMENTAL_TYPE || type.$$typeof === REACT_RESPONDER_TYPE);\n}\n\nfunction memo(type, compare) {\n  {\n    if (!isValidElementType(type)) {\n      warningWithoutStack$1(false, 'memo: The first argument must be a component. Instead ' + 'received: %s', type === null ? 'null' : typeof type);\n    }\n  }\n  return {\n    $$typeof: REACT_MEMO_TYPE,\n    type: type,\n    compare: compare === undefined ? null : compare\n  };\n}\n\nfunction resolveDispatcher() {\n  var dispatcher = ReactCurrentDispatcher.current;\n  (function () {\n    if (!(dispatcher !== null)) {\n      {\n        throw ReactError(Error('Invalid hook call. Hooks can only be called inside of the body of a function component. This could happen for one of the following reasons:\\n1. You might have mismatching versions of React and the renderer (such as React DOM)\\n2. You might be breaking the Rules of Hooks\\n3. You might have more than one copy of React in the same app\\nSee https://fb.me/react-invalid-hook-call for tips about how to debug and fix this problem.'));\n      }\n    }\n  })();\n  return dispatcher;\n}\n\nfunction useContext(Context, unstable_observedBits) {\n  var dispatcher = resolveDispatcher();\n  {\n    !(unstable_observedBits === undefined) ? warning$1(false, 'useContext() second argument is reserved for future ' + 'use in React. Passing it is not supported. ' + 'You passed: %s.%s', unstable_observedBits, typeof unstable_observedBits === 'number' && Array.isArray(arguments[2]) ? '\\n\\nDid you call array.map(useContext)? ' + 'Calling Hooks inside a loop is not supported. ' + 'Learn more at https://fb.me/rules-of-hooks' : '') : void 0;\n\n    // TODO: add a more generic warning for invalid values.\n    if (Context._context !== undefined) {\n      var realContext = Context._context;\n      // Don't deduplicate because this legitimately causes bugs\n      // and nobody should be using this in existing code.\n      if (realContext.Consumer === Context) {\n        warning$1(false, 'Calling useContext(Context.Consumer) is not supported, may cause bugs, and will be ' + 'removed in a future major release. Did you mean to call useContext(Context) instead?');\n      } else if (realContext.Provider === Context) {\n        warning$1(false, 'Calling useContext(Context.Provider) is not supported. ' + 'Did you mean to call useContext(Context) instead?');\n      }\n    }\n  }\n  return dispatcher.useContext(Context, unstable_observedBits);\n}\n\nfunction useState(initialState) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useState(initialState);\n}\n\nfunction useReducer(reducer, initialArg, init) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useReducer(reducer, initialArg, init);\n}\n\nfunction useRef(initialValue) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useRef(initialValue);\n}\n\nfunction useEffect(create, inputs) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useEffect(create, inputs);\n}\n\nfunction useLayoutEffect(create, inputs) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useLayoutEffect(create, inputs);\n}\n\nfunction useCallback(callback, inputs) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useCallback(callback, inputs);\n}\n\nfunction useMemo(create, inputs) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useMemo(create, inputs);\n}\n\nfunction useImperativeHandle(ref, create, inputs) {\n  var dispatcher = resolveDispatcher();\n  return dispatcher.useImperativeHandle(ref, create, inputs);\n}\n\nfunction useDebugValue(value, formatterFn) {\n  {\n    var dispatcher = resolveDispatcher();\n    return dispatcher.useDebugValue(value, formatterFn);\n  }\n}\n\nvar emptyObject$1 = {};\n\nfunction useResponder(responder, listenerProps) {\n  var dispatcher = resolveDispatcher();\n  {\n    if (responder == null || responder.$$typeof !== REACT_RESPONDER_TYPE) {\n      warning$1(false, 'useResponder: invalid first argument. Expected an event responder, but instead got %s', responder);\n      return;\n    }\n  }\n  return dispatcher.useResponder(responder, listenerProps || emptyObject$1);\n}\n\n// Within the scope of the callback, mark all updates as being allowed to suspend.\nfunction withSuspenseConfig(scope, config) {\n  var previousConfig = ReactCurrentBatchConfig.suspense;\n  ReactCurrentBatchConfig.suspense = config === undefined ? null : config;\n  try {\n    scope();\n  } finally {\n    ReactCurrentBatchConfig.suspense = previousConfig;\n  }\n}\n\n/**\n * ReactElementValidator provides a wrapper around a element factory\n * which validates the props passed to the element. This is intended to be\n * used only in DEV and could be replaced by a static type checker for languages\n * that support it.\n */\n\nvar propTypesMisspellWarningShown = void 0;\n\n{\n  propTypesMisspellWarningShown = false;\n}\n\nfunction getDeclarationErrorAddendum() {\n  if (ReactCurrentOwner.current) {\n    var name = getComponentName(ReactCurrentOwner.current.type);\n    if (name) {\n      return '\\n\\nCheck the render method of `' + name + '`.';\n    }\n  }\n  return '';\n}\n\nfunction getSourceInfoErrorAddendum(source) {\n  if (source !== undefined) {\n    var fileName = source.fileName.replace(/^.*[\\\\\\/]/, '');\n    var lineNumber = source.lineNumber;\n    return '\\n\\nCheck your code at ' + fileName + ':' + lineNumber + '.';\n  }\n  return '';\n}\n\nfunction getSourceInfoErrorAddendumForProps(elementProps) {\n  if (elementProps !== null && elementProps !== undefined) {\n    return getSourceInfoErrorAddendum(elementProps.__source);\n  }\n  return '';\n}\n\n/**\n * Warn if there's no key explicitly set on dynamic arrays of children or\n * object keys are not valid. This allows us to keep track of children between\n * updates.\n */\nvar ownerHasKeyUseWarning = {};\n\nfunction getCurrentComponentErrorInfo(parentType) {\n  var info = getDeclarationErrorAddendum();\n\n  if (!info) {\n    var parentName = typeof parentType === 'string' ? parentType : parentType.displayName || parentType.name;\n    if (parentName) {\n      info = '\\n\\nCheck the top-level render call using <' + parentName + '>.';\n    }\n  }\n  return info;\n}\n\n/**\n * Warn if the element doesn't have an explicit key assigned to it.\n * This element is in an array. The array could grow and shrink or be\n * reordered. All children that haven't already been validated are required to\n * have a \"key\" property assigned to it. Error statuses are cached so a warning\n * will only be shown once.\n *\n * @internal\n * @param {ReactElement} element Element that requires a key.\n * @param {*} parentType element's parent's type.\n */\nfunction validateExplicitKey(element, parentType) {\n  if (!element._store || element._store.validated || element.key != null) {\n    return;\n  }\n  element._store.validated = true;\n\n  var currentComponentErrorInfo = getCurrentComponentErrorInfo(parentType);\n  if (ownerHasKeyUseWarning[currentComponentErrorInfo]) {\n    return;\n  }\n  ownerHasKeyUseWarning[currentComponentErrorInfo] = true;\n\n  // Usually the current owner is the offender, but if it accepts children as a\n  // property, it may be the creator of the child that's responsible for\n  // assigning it a key.\n  var childOwner = '';\n  if (element && element._owner && element._owner !== ReactCurrentOwner.current) {\n    // Give the component that originally created this child.\n    childOwner = ' It was passed a child from ' + getComponentName(element._owner.type) + '.';\n  }\n\n  setCurrentlyValidatingElement(element);\n  {\n    warning$1(false, 'Each child in a list should have a unique \"key\" prop.' + '%s%s See https://fb.me/react-warning-keys for more information.', currentComponentErrorInfo, childOwner);\n  }\n  setCurrentlyValidatingElement(null);\n}\n\n/**\n * Ensure that every element either is passed in a static location, in an\n * array with an explicit keys property defined, or in an object literal\n * with valid key property.\n *\n * @internal\n * @param {ReactNode} node Statically passed child of any type.\n * @param {*} parentType node's parent's type.\n */\nfunction validateChildKeys(node, parentType) {\n  if (typeof node !== 'object') {\n    return;\n  }\n  if (Array.isArray(node)) {\n    for (var i = 0; i < node.length; i++) {\n      var child = node[i];\n      if (isValidElement(child)) {\n        validateExplicitKey(child, parentType);\n      }\n    }\n  } else if (isValidElement(node)) {\n    // This element was passed in a valid location.\n    if (node._store) {\n      node._store.validated = true;\n    }\n  } else if (node) {\n    var iteratorFn = getIteratorFn(node);\n    if (typeof iteratorFn === 'function') {\n      // Entry iterators used to provide implicit keys,\n      // but now we print a separate warning for them later.\n      if (iteratorFn !== node.entries) {\n        var iterator = iteratorFn.call(node);\n        var step = void 0;\n        while (!(step = iterator.next()).done) {\n          if (isValidElement(step.value)) {\n            validateExplicitKey(step.value, parentType);\n          }\n        }\n      }\n    }\n  }\n}\n\n/**\n * Given an element, validate that its props follow the propTypes definition,\n * provided by the type.\n *\n * @param {ReactElement} element\n */\nfunction validatePropTypes(element) {\n  var type = element.type;\n  if (type === null || type === undefined || typeof type === 'string') {\n    return;\n  }\n  var name = getComponentName(type);\n  var propTypes = void 0;\n  if (typeof type === 'function') {\n    propTypes = type.propTypes;\n  } else if (typeof type === 'object' && (type.$$typeof === REACT_FORWARD_REF_TYPE ||\n  // Note: Memo only checks outer props here.\n  // Inner props are checked in the reconciler.\n  type.$$typeof === REACT_MEMO_TYPE)) {\n    propTypes = type.propTypes;\n  } else {\n    return;\n  }\n  if (propTypes) {\n    setCurrentlyValidatingElement(element);\n    checkPropTypes(propTypes, element.props, 'prop', name, ReactDebugCurrentFrame.getStackAddendum);\n    setCurrentlyValidatingElement(null);\n  } else if (type.PropTypes !== undefined && !propTypesMisspellWarningShown) {\n    propTypesMisspellWarningShown = true;\n    warningWithoutStack$1(false, 'Component %s declared `PropTypes` instead of `propTypes`. Did you misspell the property assignment?', name || 'Unknown');\n  }\n  if (typeof type.getDefaultProps === 'function') {\n    !type.getDefaultProps.isReactClassApproved ? warningWithoutStack$1(false, 'getDefaultProps is only used on classic React.createClass ' + 'definitions. Use a static property named `defaultProps` instead.') : void 0;\n  }\n}\n\n/**\n * Given a fragment, validate that it can only be provided with fragment props\n * @param {ReactElement} fragment\n */\nfunction validateFragmentProps(fragment) {\n  setCurrentlyValidatingElement(fragment);\n\n  var keys = Object.keys(fragment.props);\n  for (var i = 0; i < keys.length; i++) {\n    var key = keys[i];\n    if (key !== 'children' && key !== 'key') {\n      warning$1(false, 'Invalid prop `%s` supplied to `React.Fragment`. ' + 'React.Fragment can only have `key` and `children` props.', key);\n      break;\n    }\n  }\n\n  if (fragment.ref !== null) {\n    warning$1(false, 'Invalid attribute `ref` supplied to `React.Fragment`.');\n  }\n\n  setCurrentlyValidatingElement(null);\n}\n\nfunction jsxWithValidation(type, props, key, isStaticChildren, source, self) {\n  var validType = isValidElementType(type);\n\n  // We warn in this case but don't throw. We expect the element creation to\n  // succeed and there will likely be errors in render.\n  if (!validType) {\n    var info = '';\n    if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {\n      info += ' You likely forgot to export your component from the file ' + \"it's defined in, or you might have mixed up default and named imports.\";\n    }\n\n    var sourceInfo = getSourceInfoErrorAddendum(source);\n    if (sourceInfo) {\n      info += sourceInfo;\n    } else {\n      info += getDeclarationErrorAddendum();\n    }\n\n    var typeString = void 0;\n    if (type === null) {\n      typeString = 'null';\n    } else if (Array.isArray(type)) {\n      typeString = 'array';\n    } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {\n      typeString = '<' + (getComponentName(type.type) || 'Unknown') + ' />';\n      info = ' Did you accidentally export a JSX literal instead of a component?';\n    } else {\n      typeString = typeof type;\n    }\n\n    warning$1(false, 'React.jsx: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);\n  }\n\n  var element = jsxDEV(type, props, key, source, self);\n\n  // The result can be nullish if a mock or a custom function is used.\n  // TODO: Drop this when these are no longer allowed as the type argument.\n  if (element == null) {\n    return element;\n  }\n\n  // Skip key warning if the type isn't valid since our key validation logic\n  // doesn't expect a non-string/function type and can throw confusing errors.\n  // We don't want exception behavior to differ between dev and prod.\n  // (Rendering will throw with a helpful message and as soon as the type is\n  // fixed, the key warnings will appear.)\n  if (validType) {\n    var children = props.children;\n    if (children !== undefined) {\n      if (isStaticChildren) {\n        for (var i = 0; i < children.length; i++) {\n          validateChildKeys(children[i], type);\n        }\n      } else {\n        validateChildKeys(children, type);\n      }\n    }\n  }\n\n  if (props.key !== undefined) {\n    warning$1(false, 'React.jsx: Spreading a key to JSX is a deprecated pattern. ' + 'Explicitly pass a key after spreading props in your JSX call. ' + 'E.g. <ComponentName {...props} key={key} />');\n  }\n\n  if (type === REACT_FRAGMENT_TYPE) {\n    validateFragmentProps(element);\n  } else {\n    validatePropTypes(element);\n  }\n\n  return element;\n}\n\n// These two functions exist to still get child warnings in dev\n// even with the prod transform. This means that jsxDEV is purely\n// opt-in behavior for better messages but that we won't stop\n// giving you warnings if you use production apis.\nfunction jsxWithValidationStatic(type, props, key) {\n  return jsxWithValidation(type, props, key, true);\n}\n\nfunction jsxWithValidationDynamic(type, props, key) {\n  return jsxWithValidation(type, props, key, false);\n}\n\nfunction createElementWithValidation(type, props, children) {\n  var validType = isValidElementType(type);\n\n  // We warn in this case but don't throw. We expect the element creation to\n  // succeed and there will likely be errors in render.\n  if (!validType) {\n    var info = '';\n    if (type === undefined || typeof type === 'object' && type !== null && Object.keys(type).length === 0) {\n      info += ' You likely forgot to export your component from the file ' + \"it's defined in, or you might have mixed up default and named imports.\";\n    }\n\n    var sourceInfo = getSourceInfoErrorAddendumForProps(props);\n    if (sourceInfo) {\n      info += sourceInfo;\n    } else {\n      info += getDeclarationErrorAddendum();\n    }\n\n    var typeString = void 0;\n    if (type === null) {\n      typeString = 'null';\n    } else if (Array.isArray(type)) {\n      typeString = 'array';\n    } else if (type !== undefined && type.$$typeof === REACT_ELEMENT_TYPE) {\n      typeString = '<' + (getComponentName(type.type) || 'Unknown') + ' />';\n      info = ' Did you accidentally export a JSX literal instead of a component?';\n    } else {\n      typeString = typeof type;\n    }\n\n    warning$1(false, 'React.createElement: type is invalid -- expected a string (for ' + 'built-in components) or a class/function (for composite ' + 'components) but got: %s.%s', typeString, info);\n  }\n\n  var element = createElement.apply(this, arguments);\n\n  // The result can be nullish if a mock or a custom function is used.\n  // TODO: Drop this when these are no longer allowed as the type argument.\n  if (element == null) {\n    return element;\n  }\n\n  // Skip key warning if the type isn't valid since our key validation logic\n  // doesn't expect a non-string/function type and can throw confusing errors.\n  // We don't want exception behavior to differ between dev and prod.\n  // (Rendering will throw with a helpful message and as soon as the type is\n  // fixed, the key warnings will appear.)\n  if (validType) {\n    for (var i = 2; i < arguments.length; i++) {\n      validateChildKeys(arguments[i], type);\n    }\n  }\n\n  if (type === REACT_FRAGMENT_TYPE) {\n    validateFragmentProps(element);\n  } else {\n    validatePropTypes(element);\n  }\n\n  return element;\n}\n\nfunction createFactoryWithValidation(type) {\n  var validatedFactory = createElementWithValidation.bind(null, type);\n  validatedFactory.type = type;\n  // Legacy hook: remove it\n  {\n    Object.defineProperty(validatedFactory, 'type', {\n      enumerable: false,\n      get: function () {\n        lowPriorityWarning$1(false, 'Factory.type is deprecated. Access the class directly ' + 'before passing it to createFactory.');\n        Object.defineProperty(this, 'type', {\n          value: type\n        });\n        return type;\n      }\n    });\n  }\n\n  return validatedFactory;\n}\n\nfunction cloneElementWithValidation(element, props, children) {\n  var newElement = cloneElement.apply(this, arguments);\n  for (var i = 2; i < arguments.length; i++) {\n    validateChildKeys(arguments[i], newElement.type);\n  }\n  validatePropTypes(newElement);\n  return newElement;\n}\n\nvar hasBadMapPolyfill = void 0;\n\n{\n  hasBadMapPolyfill = false;\n  try {\n    var frozenObject = Object.freeze({});\n    var testMap = new Map([[frozenObject, null]]);\n    var testSet = new Set([frozenObject]);\n    // This is necessary for Rollup to not consider these unused.\n    // https://github.com/rollup/rollup/issues/1771\n    // TODO: we can remove these if Rollup fixes the bug.\n    testMap.set(0, 0);\n    testSet.add(0);\n  } catch (e) {\n    // TODO: Consider warning about bad polyfills\n    hasBadMapPolyfill = true;\n  }\n}\n\nfunction createFundamentalComponent(impl) {\n  // We use responder as a Map key later on. When we have a bad\n  // polyfill, then we can't use it as a key as the polyfill tries\n  // to add a property to the object.\n  if ( true && !hasBadMapPolyfill) {\n    Object.freeze(impl);\n  }\n  var fundamantalComponent = {\n    $$typeof: REACT_FUNDAMENTAL_TYPE,\n    impl: impl\n  };\n  {\n    Object.freeze(fundamantalComponent);\n  }\n  return fundamantalComponent;\n}\n\nfunction createEventResponder(displayName, responderConfig) {\n  var getInitialState = responderConfig.getInitialState,\n      onEvent = responderConfig.onEvent,\n      onMount = responderConfig.onMount,\n      onUnmount = responderConfig.onUnmount,\n      onOwnershipChange = responderConfig.onOwnershipChange,\n      onRootEvent = responderConfig.onRootEvent,\n      rootEventTypes = responderConfig.rootEventTypes,\n      targetEventTypes = responderConfig.targetEventTypes;\n\n  var eventResponder = {\n    $$typeof: REACT_RESPONDER_TYPE,\n    displayName: displayName,\n    getInitialState: getInitialState || null,\n    onEvent: onEvent || null,\n    onMount: onMount || null,\n    onOwnershipChange: onOwnershipChange || null,\n    onRootEvent: onRootEvent || null,\n    onUnmount: onUnmount || null,\n    rootEventTypes: rootEventTypes || null,\n    targetEventTypes: targetEventTypes || null\n  };\n  // We use responder as a Map key later on. When we have a bad\n  // polyfill, then we can't use it as a key as the polyfill tries\n  // to add a property to the object.\n  if ( true && !hasBadMapPolyfill) {\n    Object.freeze(eventResponder);\n  }\n  return eventResponder;\n}\n\n// Helps identify side effects in begin-phase lifecycle hooks and setState reducers:\n\n\n// In some cases, StrictMode should also double-render lifecycles.\n// This can be confusing for tests though,\n// And it can be bad for performance in production.\n// This feature flag can be used to control the behavior:\n\n\n// To preserve the \"Pause on caught exceptions\" behavior of the debugger, we\n// replay the begin phase of a failed component inside invokeGuardedCallback.\n\n\n// Warn about deprecated, async-unsafe lifecycles; relates to RFC #6:\n\n\n// Gather advanced timing metrics for Profiler subtrees.\n\n\n// Trace which interactions trigger each commit.\n\n\n// Only used in www builds.\n // TODO: true? Here it might just be false.\n\n// Only used in www builds.\n\n\n// Only used in www builds.\n\n\n// Disable javascript: URL strings in href for XSS protection.\n\n\n// React Fire: prevent the value and checked attributes from syncing\n// with their related DOM properties\n\n\n// These APIs will no longer be \"unstable\" in the upcoming 16.7 release,\n// Control this behavior with a flag to support 16.6 minor releases in the meanwhile.\n\n\n\n\n// See https://github.com/react-native-community/discussions-and-proposals/issues/72 for more information\n// This is a flag so we can fix warnings in RN core before turning it on\n\n\n// Experimental React Flare event system and event components support.\nvar enableFlareAPI = false;\n\n// Experimental Host Component support.\nvar enableFundamentalAPI = false;\n\n// New API for JSX transforms to target - https://github.com/reactjs/rfcs/pull/107\nvar enableJSXTransformAPI = false;\n\n// We will enforce mocking scheduler with scheduler/unstable_mock at some point. (v17?)\n// Till then, we warn about the missing mock, but still fallback to a sync mode compatible version\n\n// Temporary flag to revert the fix in #15650\n\n\n// For tests, we flush suspense fallbacks in an act scope;\n// *except* in some of our own tests, where we test incremental loading states.\n\n\n// Changes priority of some events like mousemove to user-blocking priority,\n// but without making them discrete. The flag exists in case it causes\n// starvation problems.\n\n\n// Add a callback property to suspense to notify which promises are currently\n// in the update queue. This allows reporting and tracing of what is causing\n// the user to see a loading state.\n\n\n// Part of the simplification of React.createElement so we can eventually move\n// from React.createElement to React.jsx\n// https://github.com/reactjs/rfcs/blob/createlement-rfc/text/0000-create-element-changes.md\n\nvar React = {\n  Children: {\n    map: mapChildren,\n    forEach: forEachChildren,\n    count: countChildren,\n    toArray: toArray,\n    only: onlyChild\n  },\n\n  createRef: createRef,\n  Component: Component,\n  PureComponent: PureComponent,\n\n  createContext: createContext,\n  forwardRef: forwardRef,\n  lazy: lazy,\n  memo: memo,\n\n  useCallback: useCallback,\n  useContext: useContext,\n  useEffect: useEffect,\n  useImperativeHandle: useImperativeHandle,\n  useDebugValue: useDebugValue,\n  useLayoutEffect: useLayoutEffect,\n  useMemo: useMemo,\n  useReducer: useReducer,\n  useRef: useRef,\n  useState: useState,\n\n  Fragment: REACT_FRAGMENT_TYPE,\n  Profiler: REACT_PROFILER_TYPE,\n  StrictMode: REACT_STRICT_MODE_TYPE,\n  Suspense: REACT_SUSPENSE_TYPE,\n  unstable_SuspenseList: REACT_SUSPENSE_LIST_TYPE,\n\n  createElement: createElementWithValidation,\n  cloneElement: cloneElementWithValidation,\n  createFactory: createFactoryWithValidation,\n  isValidElement: isValidElement,\n\n  version: ReactVersion,\n\n  unstable_withSuspenseConfig: withSuspenseConfig,\n\n  __SECRET_INTERNALS_DO_NOT_USE_OR_YOU_WILL_BE_FIRED: ReactSharedInternals\n};\n\nif (enableFlareAPI) {\n  React.unstable_useResponder = useResponder;\n  React.unstable_createResponder = createEventResponder;\n}\n\nif (enableFundamentalAPI) {\n  React.unstable_createFundamental = createFundamentalComponent;\n}\n\n// Note: some APIs are added with feature flags.\n// Make sure that stable builds for open source\n// don't modify the React object to avoid deopts.\n// Also let's not expose their names in stable builds.\n\nif (enableJSXTransformAPI) {\n  {\n    React.jsxDEV = jsxWithValidation;\n    React.jsx = jsxWithValidationDynamic;\n    React.jsxs = jsxWithValidationStatic;\n  }\n}\n\n\n\nvar React$2 = Object.freeze({\n\tdefault: React\n});\n\nvar React$3 = ( React$2 && React ) || React$2;\n\n// TODO: decide on the top-level export form.\n// This is hacky but makes it work with both Rollup and Jest.\nvar react = React$3.default || React$3;\n\nmodule.exports = react;\n  })();\n}\n\n\n//# sourceURL=webpack:///./node_modules/react/cjs/react.development.js?");

/***/ }),

/***/ "./node_modules/react/index.js":
/*!*************************************!*\
  !*** ./node_modules/react/index.js ***!
  \*************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nif (false) {} else {\n  module.exports = __webpack_require__(/*! ./cjs/react.development.js */ \"./node_modules/react/cjs/react.development.js\");\n}\n\n\n//# sourceURL=webpack:///./node_modules/react/index.js?");

/***/ }),

/***/ "./node_modules/vanilla-picker/dist/vanilla-picker.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/vanilla-picker/dist/vanilla-picker.mjs ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar classCallCheck = function (instance, Constructor) {\n  if (!(instance instanceof Constructor)) {\n    throw new TypeError(\"Cannot call a class as a function\");\n  }\n};\n\nvar createClass = function () {\n  function defineProperties(target, props) {\n    for (var i = 0; i < props.length; i++) {\n      var descriptor = props[i];\n      descriptor.enumerable = descriptor.enumerable || false;\n      descriptor.configurable = true;\n      if (\"value\" in descriptor) descriptor.writable = true;\n      Object.defineProperty(target, descriptor.key, descriptor);\n    }\n  }\n\n  return function (Constructor, protoProps, staticProps) {\n    if (protoProps) defineProperties(Constructor.prototype, protoProps);\n    if (staticProps) defineProperties(Constructor, staticProps);\n    return Constructor;\n  };\n}();\n\nvar slicedToArray = function () {\n  function sliceIterator(arr, i) {\n    var _arr = [];\n    var _n = true;\n    var _d = false;\n    var _e = undefined;\n\n    try {\n      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {\n        _arr.push(_s.value);\n\n        if (i && _arr.length === i) break;\n      }\n    } catch (err) {\n      _d = true;\n      _e = err;\n    } finally {\n      try {\n        if (!_n && _i[\"return\"]) _i[\"return\"]();\n      } finally {\n        if (_d) throw _e;\n      }\n    }\n\n    return _arr;\n  }\n\n  return function (arr, i) {\n    if (Array.isArray(arr)) {\n      return arr;\n    } else if (Symbol.iterator in Object(arr)) {\n      return sliceIterator(arr, i);\n    } else {\n      throw new TypeError(\"Invalid attempt to destructure non-iterable instance\");\n    }\n  };\n}();\n\nString.prototype.startsWith = String.prototype.startsWith || function (needle) {\n    return this.indexOf(needle) === 0;\n};\nString.prototype.padStart = String.prototype.padStart || function (len, pad) {\n    var str = this;while (str.length < len) {\n        str = pad + str;\n    }return str;\n};\n\nvar colorNames = { cb: '0f8ff', tqw: 'aebd7', q: '-ffff', qmrn: '7fffd4', zr: '0ffff', bg: '5f5dc', bsq: 'e4c4', bck: '---', nch: 'ebcd', b: '--ff', bvt: '8a2be2', brwn: 'a52a2a', brw: 'deb887', ctb: '5f9ea0', hrt: '7fff-', chcT: 'd2691e', cr: '7f50', rnw: '6495ed', crns: '8dc', crms: 'dc143c', cn: '-ffff', Db: '--8b', Dcn: '-8b8b', Dgnr: 'b8860b', Dgr: 'a9a9a9', Dgrn: '-64-', Dkhk: 'bdb76b', Dmgn: '8b-8b', Dvgr: '556b2f', Drng: '8c-', Drch: '9932cc', Dr: '8b--', Dsmn: 'e9967a', Dsgr: '8fbc8f', DsTb: '483d8b', DsTg: '2f4f4f', Dtrq: '-ced1', Dvt: '94-d3', ppnk: '1493', pskb: '-bfff', mgr: '696969', grb: '1e90ff', rbrc: 'b22222', rwht: 'af0', stg: '228b22', chs: '-ff', gnsb: 'dcdcdc', st: '8f8ff', g: 'd7-', gnr: 'daa520', gr: '808080', grn: '-8-0', grnw: 'adff2f', hnw: '0fff0', htpn: '69b4', nnr: 'cd5c5c', ng: '4b-82', vr: '0', khk: '0e68c', vnr: 'e6e6fa', nrb: '0f5', wngr: '7cfc-', mnch: 'acd', Lb: 'add8e6', Lcr: '08080', Lcn: 'e0ffff', Lgnr: 'afad2', Lgr: 'd3d3d3', Lgrn: '90ee90', Lpnk: 'b6c1', Lsmn: 'a07a', Lsgr: '20b2aa', Lskb: '87cefa', LsTg: '778899', Lstb: 'b0c4de', Lw: 'e0', m: '-ff-', mgrn: '32cd32', nn: 'af0e6', mgnt: '-ff', mrn: '8--0', mqm: '66cdaa', mmb: '--cd', mmrc: 'ba55d3', mmpr: '9370db', msg: '3cb371', mmsT: '7b68ee', '': '-fa9a', mtr: '48d1cc', mmvt: 'c71585', mnLb: '191970', ntc: '5fffa', mstr: 'e4e1', mccs: 'e4b5', vjw: 'dead', nv: '--80', c: 'df5e6', v: '808-0', vrb: '6b8e23', rng: 'a5-', rngr: '45-', rch: 'da70d6', pgnr: 'eee8aa', pgrn: '98fb98', ptrq: 'afeeee', pvtr: 'db7093', ppwh: 'efd5', pchp: 'dab9', pr: 'cd853f', pnk: 'c0cb', pm: 'dda0dd', pwrb: 'b0e0e6', prp: '8-080', cc: '663399', r: '--', sbr: 'bc8f8f', rb: '4169e1', sbrw: '8b4513', smn: 'a8072', nbr: '4a460', sgrn: '2e8b57', ssh: '5ee', snn: 'a0522d', svr: 'c0c0c0', skb: '87ceeb', sTb: '6a5acd', sTgr: '708090', snw: 'afa', n: '-ff7f', stb: '4682b4', tn: 'd2b48c', t: '-8080', thst: 'd8bfd8', tmT: '6347', trqs: '40e0d0', vt: 'ee82ee', whT: '5deb3', wht: '', hts: '5f5f5', w: '-', wgrn: '9acd32' };\n\nfunction printNum(num) {\n    var decs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;\n\n    var str = decs > 0 ? num.toFixed(decs).replace(/0+$/, '').replace(/\\.$/, '') : num.toString();\n    return str || '0';\n}\n\nvar Color = function () {\n    function Color(r, g, b, a) {\n        classCallCheck(this, Color);\n\n\n        var that = this;\n        function parseString(input) {\n\n            if (input.startsWith('hsl')) {\n                var _input$match$map = input.match(/([\\-\\d\\.e]+)/g).map(Number),\n                    _input$match$map2 = slicedToArray(_input$match$map, 4),\n                    h = _input$match$map2[0],\n                    s = _input$match$map2[1],\n                    l = _input$match$map2[2],\n                    _a = _input$match$map2[3];\n\n                if (_a === undefined) {\n                    _a = 1;\n                }\n\n                h /= 360;\n                s /= 100;\n                l /= 100;\n                that.hsla = [h, s, l, _a];\n            } else if (input.startsWith('rgb')) {\n                var _input$match$map3 = input.match(/([\\-\\d\\.e]+)/g).map(Number),\n                    _input$match$map4 = slicedToArray(_input$match$map3, 4),\n                    _r = _input$match$map4[0],\n                    _g = _input$match$map4[1],\n                    _b = _input$match$map4[2],\n                    _a2 = _input$match$map4[3];\n\n                if (_a2 === undefined) {\n                    _a2 = 1;\n                }\n\n                that.rgba = [_r, _g, _b, _a2];\n            } else {\n                if (input.startsWith('#')) {\n                    that.rgba = Color.hexToRgb(input);\n                } else {\n                    that.rgba = Color.nameToRgb(input) || Color.hexToRgb(input);\n                }\n            }\n        }\n\n        if (r === undefined) ; else if (Array.isArray(r)) {\n            this.rgba = r;\n        } else if (b === undefined) {\n            var color = r && '' + r;\n            if (color) {\n                parseString(color.toLowerCase());\n            }\n        } else {\n            this.rgba = [r, g, b, a === undefined ? 1 : a];\n        }\n    }\n\n    createClass(Color, [{\n        key: 'printRGB',\n        value: function printRGB(alpha) {\n            var rgb = alpha ? this.rgba : this.rgba.slice(0, 3),\n                vals = rgb.map(function (x, i) {\n                return printNum(x, i === 3 ? 3 : 0);\n            });\n\n            return alpha ? 'rgba(' + vals + ')' : 'rgb(' + vals + ')';\n        }\n    }, {\n        key: 'printHSL',\n        value: function printHSL(alpha) {\n            var mults = [360, 100, 100, 1],\n                suff = ['', '%', '%', ''];\n\n            var hsl = alpha ? this.hsla : this.hsla.slice(0, 3),\n                vals = hsl.map(function (x, i) {\n                return printNum(x * mults[i], i === 3 ? 3 : 1) + suff[i];\n            });\n\n            return alpha ? 'hsla(' + vals + ')' : 'hsl(' + vals + ')';\n        }\n    }, {\n        key: 'printHex',\n        value: function printHex(alpha) {\n            var hex = this.hex;\n            return alpha ? hex : hex.substring(0, 7);\n        }\n    }, {\n        key: 'rgba',\n        get: function get$$1() {\n            if (this._rgba) {\n                return this._rgba;\n            }\n            if (!this._hsla) {\n                throw new Error('No color is set');\n            }\n\n            return this._rgba = Color.hslToRgb(this._hsla);\n        },\n        set: function set$$1(rgb) {\n            if (rgb.length === 3) {\n                rgb[3] = 1;\n            }\n\n            this._rgba = rgb;\n            this._hsla = null;\n        }\n    }, {\n        key: 'rgbString',\n        get: function get$$1() {\n            return this.printRGB();\n        }\n    }, {\n        key: 'rgbaString',\n        get: function get$$1() {\n            return this.printRGB(true);\n        }\n    }, {\n        key: 'hsla',\n        get: function get$$1() {\n            if (this._hsla) {\n                return this._hsla;\n            }\n            if (!this._rgba) {\n                throw new Error('No color is set');\n            }\n\n            return this._hsla = Color.rgbToHsl(this._rgba);\n        },\n        set: function set$$1(hsl) {\n            if (hsl.length === 3) {\n                hsl[3] = 1;\n            }\n\n            this._hsla = hsl;\n            this._rgba = null;\n        }\n    }, {\n        key: 'hslString',\n        get: function get$$1() {\n            return this.printHSL();\n        }\n    }, {\n        key: 'hslaString',\n        get: function get$$1() {\n            return this.printHSL(true);\n        }\n    }, {\n        key: 'hex',\n        get: function get$$1() {\n            var rgb = this.rgba,\n                hex = rgb.map(function (x, i) {\n                return i < 3 ? x.toString(16) : Math.round(x * 255).toString(16);\n            });\n\n            return '#' + hex.map(function (x) {\n                return x.padStart(2, '0');\n            }).join('');\n        },\n        set: function set$$1(hex) {\n            this.rgba = Color.hexToRgb(hex);\n        }\n    }], [{\n        key: 'hexToRgb',\n        value: function hexToRgb(input) {\n\n            var hex = (input.startsWith('#') ? input.slice(1) : input).replace(/^(\\w{3})$/, '$1F').replace(/^(\\w)(\\w)(\\w)(\\w)$/, '$1$1$2$2$3$3$4$4').replace(/^(\\w{6})$/, '$1FF');\n\n            if (!hex.match(/^([0-9a-fA-F]{8})$/)) {\n                throw new Error('Unknown hex color; ' + input);\n            }\n\n            var rgba = hex.match(/^(\\w\\w)(\\w\\w)(\\w\\w)(\\w\\w)$/).slice(1).map(function (x) {\n                return parseInt(x, 16);\n            });\n\n            rgba[3] = rgba[3] / 255;\n            return rgba;\n        }\n    }, {\n        key: 'nameToRgb',\n        value: function nameToRgb(input) {\n\n            var hash = input.toLowerCase().replace('at', 'T').replace(/[aeiouyldf]/g, '').replace('ght', 'L').replace('rk', 'D').slice(-5, 4),\n                hex = colorNames[hash];\n            return hex === undefined ? hex : Color.hexToRgb(hex.replace(/\\-/g, '00').padStart(6, 'f'));\n        }\n    }, {\n        key: 'rgbToHsl',\n        value: function rgbToHsl(_ref) {\n            var _ref2 = slicedToArray(_ref, 4),\n                r = _ref2[0],\n                g = _ref2[1],\n                b = _ref2[2],\n                a = _ref2[3];\n\n            r /= 255;\n            g /= 255;\n            b /= 255;\n\n            var max = Math.max(r, g, b),\n                min = Math.min(r, g, b);\n            var h = void 0,\n                s = void 0,\n                l = (max + min) / 2;\n\n            if (max === min) {\n                h = s = 0;\n            } else {\n                var d = max - min;\n                s = l > 0.5 ? d / (2 - max - min) : d / (max + min);\n                switch (max) {\n                    case r:\n                        h = (g - b) / d + (g < b ? 6 : 0);break;\n                    case g:\n                        h = (b - r) / d + 2;break;\n                    case b:\n                        h = (r - g) / d + 4;break;\n                }\n\n                h /= 6;\n            }\n\n            return [h, s, l, a];\n        }\n    }, {\n        key: 'hslToRgb',\n        value: function hslToRgb(_ref3) {\n            var _ref4 = slicedToArray(_ref3, 4),\n                h = _ref4[0],\n                s = _ref4[1],\n                l = _ref4[2],\n                a = _ref4[3];\n\n            var r = void 0,\n                g = void 0,\n                b = void 0;\n\n            if (s === 0) {\n                r = g = b = l;\n            } else {\n                var hue2rgb = function hue2rgb(p, q, t) {\n                    if (t < 0) t += 1;\n                    if (t > 1) t -= 1;\n                    if (t < 1 / 6) return p + (q - p) * 6 * t;\n                    if (t < 1 / 2) return q;\n                    if (t < 2 / 3) return p + (q - p) * (2 / 3 - t) * 6;\n                    return p;\n                };\n\n                var q = l < 0.5 ? l * (1 + s) : l + s - l * s,\n                    p = 2 * l - q;\n\n                r = hue2rgb(p, q, h + 1 / 3);\n                g = hue2rgb(p, q, h);\n                b = hue2rgb(p, q, h - 1 / 3);\n            }\n\n            var rgba = [r * 255, g * 255, b * 255].map(Math.round);\n            rgba[3] = a;\n\n            return rgba;\n        }\n    }]);\n    return Color;\n}();\n\nvar EventBucket = function () {\n    function EventBucket() {\n        classCallCheck(this, EventBucket);\n\n        this._events = [];\n    }\n\n    createClass(EventBucket, [{\n        key: 'add',\n        value: function add(target, type, handler) {\n            target.addEventListener(type, handler, false);\n            this._events.push({\n                target: target,\n                type: type,\n                handler: handler\n            });\n        }\n    }, {\n        key: 'remove',\n        value: function remove(target, type, handler) {\n            this._events = this._events.filter(function (e) {\n                var isMatch = true;\n                if (target && target !== e.target) {\n                    isMatch = false;\n                }\n                if (type && type !== e.type) {\n                    isMatch = false;\n                }\n                if (handler && handler !== e.handler) {\n                    isMatch = false;\n                }\n\n                if (isMatch) {\n                    EventBucket._doRemove(e.target, e.type, e.handler);\n                }\n                return !isMatch;\n            });\n        }\n    }, {\n        key: 'destroy',\n        value: function destroy() {\n            this._events.forEach(function (e) {\n                return EventBucket._doRemove(e.target, e.type, e.handler);\n            });\n            this._events = [];\n        }\n    }], [{\n        key: '_doRemove',\n        value: function _doRemove(target, type, handler) {\n            target.removeEventListener(type, handler, false);\n        }\n    }]);\n    return EventBucket;\n}();\n\nfunction parseHTML(htmlString) {\n\n    var div = document.createElement('div');\n    div.innerHTML = htmlString;\n    return div.firstElementChild;\n}\n\nfunction dragTrack(eventBucket, area, callback) {\n    var dragging = false;\n\n    function clamp(val, min, max) {\n        return Math.max(min, Math.min(val, max));\n    }\n\n    function onMove(e, info, starting) {\n        if (starting) {\n            dragging = true;\n        }\n        if (!dragging) {\n            return;\n        }\n\n        e.preventDefault();\n\n        var bounds = area.getBoundingClientRect(),\n            w = bounds.width,\n            h = bounds.height,\n            x = info.clientX,\n            y = info.clientY;\n\n        var relX = clamp(x - bounds.left, 0, w),\n            relY = clamp(y - bounds.top, 0, h);\n\n        callback(relX / w, relY / h);\n    }\n\n    function onMouse(e, starting) {\n        var button = e.buttons === undefined ? e.which : e.buttons;\n        if (button === 1) {\n            onMove(e, e, starting);\n        } else {\n            dragging = false;\n        }\n    }\n\n    function onTouch(e, starting) {\n        if (e.touches.length === 1) {\n            onMove(e, e.touches[0], starting);\n        } else {\n            dragging = false;\n        }\n    }\n\n    eventBucket.add(area, 'mousedown', function (e) {\n        onMouse(e, true);\n    });\n    eventBucket.add(area, 'touchstart', function (e) {\n        onTouch(e, true);\n    });\n    eventBucket.add(window, 'mousemove', onMouse);\n    eventBucket.add(area, 'touchmove', onTouch);\n    eventBucket.add(window, 'mouseup', function (e) {\n        dragging = false;\n    });\n    eventBucket.add(area, 'touchend', function (e) {\n        dragging = false;\n    });\n    eventBucket.add(area, 'touchcancel', function (e) {\n        dragging = false;\n    });\n}\n\nvar BG_TRANSP = 'url(\"data:image/svg+xml,%3Csvg xmlns=\\'http://www.w3.org/2000/svg\\' width=\\'2\\' height=\\'2\\'%3E%3Cpath d=\\'M1,0H0V1H2V2H1\\' fill=\\'lightgrey\\'/%3E%3C/svg%3E\")';\nvar HUES = 360;\n\nvar EVENT_KEY = 'keydown',\n    EVENT_CLICK_OUTSIDE = 'mousedown',\n    EVENT_TAB_MOVE = 'focusin';\n\nfunction $(selector, context) {\n    return (context || document).querySelector(selector);\n}\n\nfunction stopEvent(e) {\n\n    e.preventDefault();\n    e.stopPropagation();\n}\nfunction onKey(bucket, target, keys, handler, stop) {\n    bucket.add(target, EVENT_KEY, function (e) {\n        if (keys.indexOf(e.key) >= 0) {\n            if (stop) {\n                stopEvent(e);\n            }\n            handler(e);\n        }\n    });\n}\n\nvar _style = document.createElement('style');\n_style.textContent = '.picker_wrapper.no_alpha .picker_alpha{display:none}.picker_wrapper.no_editor .picker_editor{position:absolute;z-index:-1;opacity:0}.picker_wrapper.no_cancel .picker_cancel{display:none}.layout_default.picker_wrapper{display:-webkit-box;display:flex;-webkit-box-orient:horizontal;-webkit-box-direction:normal;flex-flow:row wrap;-webkit-box-pack:justify;justify-content:space-between;-webkit-box-align:stretch;align-items:stretch;font-size:10px;width:25em;padding:.5em}.layout_default.picker_wrapper input,.layout_default.picker_wrapper button{font-size:1rem}.layout_default.picker_wrapper>*{margin:.5em}.layout_default.picker_wrapper::before{content:\\'\\';display:block;width:100%;height:0;-webkit-box-ordinal-group:2;order:1}.layout_default .picker_slider,.layout_default .picker_selector{padding:1em}.layout_default .picker_hue{width:100%}.layout_default .picker_sl{-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_sl::before{content:\\'\\';display:block;padding-bottom:100%}.layout_default .picker_editor{-webkit-box-ordinal-group:2;order:1;width:6.5rem}.layout_default .picker_editor input{width:100%;height:100%}.layout_default .picker_sample{-webkit-box-ordinal-group:2;order:1;-webkit-box-flex:1;flex:1 1 auto}.layout_default .picker_done,.layout_default .picker_cancel{-webkit-box-ordinal-group:2;order:1}.picker_wrapper{box-sizing:border-box;background:#f2f2f2;box-shadow:0 0 0 1px silver;cursor:default;font-family:sans-serif;color:#444;pointer-events:auto}.picker_wrapper:focus{outline:none}.picker_wrapper button,.picker_wrapper input{box-sizing:border-box;border:none;box-shadow:0 0 0 1px silver;outline:none}.picker_wrapper button:focus,.picker_wrapper button:active,.picker_wrapper input:focus,.picker_wrapper input:active{box-shadow:0 0 2px 1px dodgerblue}.picker_wrapper button{padding:.4em .6em;cursor:pointer;background-color:whitesmoke;background-image:-webkit-gradient(linear, left bottom, left top, from(gainsboro), to(transparent));background-image:-webkit-linear-gradient(bottom, gainsboro, transparent);background-image:linear-gradient(0deg, gainsboro, transparent)}.picker_wrapper button:active{background-image:-webkit-gradient(linear, left bottom, left top, from(transparent), to(gainsboro));background-image:-webkit-linear-gradient(bottom, transparent, gainsboro);background-image:linear-gradient(0deg, transparent, gainsboro)}.picker_wrapper button:hover{background-color:white}.picker_selector{position:absolute;z-index:1;display:block;-webkit-transform:translate(-50%, -50%);transform:translate(-50%, -50%);border:2px solid white;border-radius:100%;box-shadow:0 0 3px 1px #67b9ff;background:currentColor;cursor:pointer}.picker_slider .picker_selector{border-radius:2px}.picker_hue{position:relative;background-image:-webkit-gradient(linear, left top, right top, from(red), color-stop(yellow), color-stop(lime), color-stop(cyan), color-stop(blue), color-stop(magenta), to(red));background-image:-webkit-linear-gradient(left, red, yellow, lime, cyan, blue, magenta, red);background-image:linear-gradient(90deg, red, yellow, lime, cyan, blue, magenta, red);box-shadow:0 0 0 1px silver}.picker_sl{position:relative;box-shadow:0 0 0 1px silver;background-image:-webkit-gradient(linear, left top, left bottom, from(white), color-stop(50%, rgba(255,255,255,0))),-webkit-gradient(linear, left bottom, left top, from(black), color-stop(50%, rgba(0,0,0,0))),-webkit-gradient(linear, left top, right top, from(gray), to(rgba(128,128,128,0)));background-image:-webkit-linear-gradient(top, white, rgba(255,255,255,0) 50%),-webkit-linear-gradient(bottom, black, rgba(0,0,0,0) 50%),-webkit-linear-gradient(left, gray, rgba(128,128,128,0));background-image:linear-gradient(180deg, white, rgba(255,255,255,0) 50%),linear-gradient(0deg, black, rgba(0,0,0,0) 50%),linear-gradient(90deg, gray, rgba(128,128,128,0))}.picker_alpha,.picker_sample{position:relative;background:url(\"data:image/svg+xml,%3Csvg xmlns=\\'http://www.w3.org/2000/svg\\' width=\\'2\\' height=\\'2\\'%3E%3Cpath d=\\'M1,0H0V1H2V2H1\\' fill=\\'lightgrey\\'/%3E%3C/svg%3E\") left top/contain white;box-shadow:0 0 0 1px silver}.picker_alpha .picker_selector,.picker_sample .picker_selector{background:none}.picker_editor input{font-family:monospace;padding:.2em .4em}.picker_sample::before{content:\\'\\';position:absolute;display:block;width:100%;height:100%;background:currentColor}.picker_arrow{position:absolute;z-index:-1}.picker_wrapper.popup{position:absolute;z-index:2;margin:1.5em}.picker_wrapper.popup,.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{background:#f2f2f2;box-shadow:0 0 10px 1px rgba(0,0,0,0.4)}.picker_wrapper.popup .picker_arrow{width:3em;height:3em;margin:0}.picker_wrapper.popup .picker_arrow::before,.picker_wrapper.popup .picker_arrow::after{content:\"\";display:block;position:absolute;top:0;left:0;z-index:-99}.picker_wrapper.popup .picker_arrow::before{width:100%;height:100%;-webkit-transform:skew(45deg);transform:skew(45deg);-webkit-transform-origin:0 100%;transform-origin:0 100%}.picker_wrapper.popup .picker_arrow::after{width:150%;height:150%;box-shadow:none}.popup.popup_top{bottom:100%;left:0}.popup.popup_top .picker_arrow{bottom:0;left:0;-webkit-transform:rotate(-90deg);transform:rotate(-90deg)}.popup.popup_bottom{top:100%;left:0}.popup.popup_bottom .picker_arrow{top:0;left:0;-webkit-transform:rotate(90deg) scale(1, -1);transform:rotate(90deg) scale(1, -1)}.popup.popup_left{top:0;right:100%}.popup.popup_left .picker_arrow{top:0;right:0;-webkit-transform:scale(-1, 1);transform:scale(-1, 1)}.popup.popup_right{top:0;left:100%}.popup.popup_right .picker_arrow{top:0;left:0}';\ndocument.documentElement.firstElementChild.appendChild(_style);\n\nvar Picker = function () {\n    function Picker(options) {\n        classCallCheck(this, Picker);\n\n\n        this.settings = {\n\n            popup: 'right',\n            layout: 'default',\n            alpha: true,\n            editor: true,\n            editorFormat: 'hex',\n            cancelButton: false\n        };\n\n        this._events = new EventBucket();\n\n        this.onChange = null;\n\n        this.onDone = null;\n\n        this.onOpen = null;\n\n        this.onClose = null;\n\n        this.setOptions(options);\n    }\n\n    createClass(Picker, [{\n        key: 'setOptions',\n        value: function setOptions(options) {\n            var _this = this;\n\n            if (!options) {\n                return;\n            }\n            var settings = this.settings;\n\n            function transfer(source, target, skipKeys) {\n                for (var key in source) {\n                    if (skipKeys && skipKeys.indexOf(key) >= 0) {\n                        continue;\n                    }\n\n                    target[key] = source[key];\n                }\n            }\n\n            if (options instanceof HTMLElement) {\n                settings.parent = options;\n            } else {\n\n                if (settings.parent && options.parent && settings.parent !== options.parent) {\n                    this._events.remove(settings.parent);\n                    this._popupInited = false;\n                }\n\n                transfer(options, settings);\n\n                if (options.onChange) {\n                    this.onChange = options.onChange;\n                }\n                if (options.onDone) {\n                    this.onDone = options.onDone;\n                }\n                if (options.onOpen) {\n                    this.onOpen = options.onOpen;\n                }\n                if (options.onClose) {\n                    this.onClose = options.onClose;\n                }\n\n                var col = options.color || options.colour;\n                if (col) {\n                    this._setColor(col);\n                }\n            }\n\n            var parent = settings.parent;\n            if (parent && settings.popup && !this._popupInited) {\n\n                var openProxy = function openProxy(e) {\n                    return _this.openHandler(e);\n                };\n\n                this._events.add(parent, 'click', openProxy);\n\n                onKey(this._events, parent, [' ', 'Spacebar', 'Enter'], openProxy);\n\n                this._popupInited = true;\n            } else if (options.parent && !settings.popup) {\n                this.show();\n            }\n        }\n    }, {\n        key: 'openHandler',\n        value: function openHandler(e) {\n            if (this.show()) {\n\n                e && e.preventDefault();\n\n                this.settings.parent.style.pointerEvents = 'none';\n\n                var toFocus = e && e.type === EVENT_KEY ? this._domEdit : this.domElement;\n                setTimeout(function () {\n                    return toFocus.focus();\n                }, 100);\n\n                if (this.onOpen) {\n                    this.onOpen(this.colour);\n                }\n            }\n        }\n    }, {\n        key: 'closeHandler',\n        value: function closeHandler(e) {\n            var event = e && e.type;\n            var doHide = false;\n\n            if (!e) {\n                doHide = true;\n            } else if (event === EVENT_CLICK_OUTSIDE || event === EVENT_TAB_MOVE) {\n\n                var knownTime = (this.__containedEvent || 0) + 100;\n                if (e.timeStamp > knownTime) {\n                    doHide = true;\n                }\n            } else {\n\n                stopEvent(e);\n\n                doHide = true;\n            }\n\n            if (doHide && this.hide()) {\n                this.settings.parent.style.pointerEvents = '';\n\n                if (event !== EVENT_CLICK_OUTSIDE) {\n                    this.settings.parent.focus();\n                }\n\n                if (this.onClose) {\n                    this.onClose(this.colour);\n                }\n            }\n        }\n    }, {\n        key: 'movePopup',\n        value: function movePopup(options, open) {\n\n            this.closeHandler();\n\n            this.setOptions(options);\n            if (open) {\n                this.openHandler();\n            }\n        }\n    }, {\n        key: 'setColor',\n        value: function setColor(color, silent) {\n            this._setColor(color, { silent: silent });\n        }\n    }, {\n        key: '_setColor',\n        value: function _setColor(color, flags) {\n            if (typeof color === 'string') {\n                color = color.trim();\n            }\n            if (!color) {\n                return;\n            }\n\n            flags = flags || {};\n            var c = void 0;\n            try {\n\n                c = new Color(color);\n            } catch (ex) {\n                if (flags.failSilently) {\n                    return;\n                }\n                throw ex;\n            }\n\n            if (!this.settings.alpha) {\n                var hsla = c.hsla;\n                hsla[3] = 1;\n                c.hsla = hsla;\n            }\n            this.colour = this.color = c;\n            this._setHSLA(null, null, null, null, flags);\n        }\n    }, {\n        key: 'setColour',\n        value: function setColour(colour, silent) {\n            this.setColor(colour, silent);\n        }\n    }, {\n        key: 'show',\n        value: function show() {\n            var parent = this.settings.parent;\n            if (!parent) {\n                return false;\n            }\n\n            if (this.domElement) {\n                var toggled = this._toggleDOM(true);\n\n                this._setPosition();\n\n                return toggled;\n            }\n\n            var html = this.settings.template || '<div class=\"picker_wrapper\" tabindex=\"-1\"><div class=\"picker_arrow\"></div><div class=\"picker_hue picker_slider\"><div class=\"picker_selector\"></div></div><div class=\"picker_sl\"><div class=\"picker_selector\"></div></div><div class=\"picker_alpha picker_slider\"><div class=\"picker_selector\"></div></div><div class=\"picker_editor\"><input aria-label=\"Type a color name or hex value\"/></div><div class=\"picker_sample\"></div><div class=\"picker_done\"><button>Ok</button></div><div class=\"picker_cancel\"><button>Cancel</button></div></div>';\n            var wrapper = parseHTML(html);\n\n            this.domElement = wrapper;\n            this._domH = $('.picker_hue', wrapper);\n            this._domSL = $('.picker_sl', wrapper);\n            this._domA = $('.picker_alpha', wrapper);\n            this._domEdit = $('.picker_editor input', wrapper);\n            this._domSample = $('.picker_sample', wrapper);\n            this._domOkay = $('.picker_done button', wrapper);\n            this._domCancel = $('.picker_cancel button', wrapper);\n\n            wrapper.classList.add('layout_' + this.settings.layout);\n            if (!this.settings.alpha) {\n                wrapper.classList.add('no_alpha');\n            }\n            if (!this.settings.editor) {\n                wrapper.classList.add('no_editor');\n            }\n            if (!this.settings.cancelButton) {\n                wrapper.classList.add('no_cancel');\n            }\n            this._ifPopup(function () {\n                return wrapper.classList.add('popup');\n            });\n\n            this._setPosition();\n\n            if (this.colour) {\n                this._updateUI();\n            } else {\n                this._setColor('#0cf');\n            }\n            this._bindEvents();\n\n            return true;\n        }\n    }, {\n        key: 'hide',\n        value: function hide() {\n            return this._toggleDOM(false);\n        }\n    }, {\n        key: 'destroy',\n        value: function destroy() {\n            this._events.destroy();\n            if (this.domElement) {\n                this.settings.parent.removeChild(this.domElement);\n            }\n        }\n    }, {\n        key: '_bindEvents',\n        value: function _bindEvents() {\n            var _this2 = this;\n\n            var that = this,\n                dom = this.domElement,\n                events = this._events;\n\n            function addEvent(target, type, handler) {\n                events.add(target, type, handler);\n            }\n\n            addEvent(dom, 'click', function (e) {\n                return e.preventDefault();\n            });\n\n            dragTrack(events, this._domH, function (x, y) {\n                return that._setHSLA(x);\n            });\n\n            dragTrack(events, this._domSL, function (x, y) {\n                return that._setHSLA(null, x, 1 - y);\n            });\n\n            if (this.settings.alpha) {\n                dragTrack(events, this._domA, function (x, y) {\n                    return that._setHSLA(null, null, null, 1 - y);\n                });\n            }\n\n            var editInput = this._domEdit;\n            {\n                addEvent(editInput, 'input', function (e) {\n                    that._setColor(this.value, { fromEditor: true, failSilently: true });\n                });\n\n                addEvent(editInput, 'focus', function (e) {\n                    var input = this;\n\n                    if (input.selectionStart === input.selectionEnd) {\n                        input.select();\n                    }\n                });\n            }\n\n            this._ifPopup(function () {\n\n                var popupCloseProxy = function popupCloseProxy(e) {\n                    return _this2.closeHandler(e);\n                };\n\n                addEvent(window, EVENT_CLICK_OUTSIDE, popupCloseProxy);\n                addEvent(window, EVENT_TAB_MOVE, popupCloseProxy);\n                onKey(events, dom, ['Esc', 'Escape'], popupCloseProxy);\n\n                var timeKeeper = function timeKeeper(e) {\n                    _this2.__containedEvent = e.timeStamp;\n                };\n                addEvent(dom, EVENT_CLICK_OUTSIDE, timeKeeper);\n\n                addEvent(dom, EVENT_TAB_MOVE, timeKeeper);\n\n                addEvent(_this2._domCancel, 'click', popupCloseProxy);\n            });\n\n            var onDoneProxy = function onDoneProxy(e) {\n                _this2._ifPopup(function () {\n                    return _this2.closeHandler(e);\n                });\n                if (_this2.onDone) {\n                    _this2.onDone(_this2.colour);\n                }\n            };\n            addEvent(this._domOkay, 'click', onDoneProxy);\n            onKey(events, dom, ['Enter'], onDoneProxy);\n        }\n    }, {\n        key: '_setPosition',\n        value: function _setPosition() {\n            var parent = this.settings.parent,\n                elm = this.domElement;\n\n            if (parent !== elm.parentNode) {\n                parent.appendChild(elm);\n            }\n\n            this._ifPopup(function (popup) {\n\n                if (getComputedStyle(parent).position === 'static') {\n                    parent.style.position = 'relative';\n                }\n\n                var cssClass = popup === true ? 'popup_right' : 'popup_' + popup;\n\n                ['popup_top', 'popup_bottom', 'popup_left', 'popup_right'].forEach(function (c) {\n\n                    if (c === cssClass) {\n                        elm.classList.add(c);\n                    } else {\n                        elm.classList.remove(c);\n                    }\n                });\n\n                elm.classList.add(cssClass);\n            });\n        }\n    }, {\n        key: '_setHSLA',\n        value: function _setHSLA(h, s, l, a, flags) {\n            flags = flags || {};\n\n            var col = this.colour,\n                hsla = col.hsla;\n\n            [h, s, l, a].forEach(function (x, i) {\n                if (x || x === 0) {\n                    hsla[i] = x;\n                }\n            });\n            col.hsla = hsla;\n\n            this._updateUI(flags);\n\n            if (this.onChange && !flags.silent) {\n                this.onChange(col);\n            }\n        }\n    }, {\n        key: '_updateUI',\n        value: function _updateUI(flags) {\n            if (!this.domElement) {\n                return;\n            }\n            flags = flags || {};\n\n            var col = this.colour,\n                hsl = col.hsla,\n                cssHue = 'hsl(' + hsl[0] * HUES + ', 100%, 50%)',\n                cssHSL = col.hslString,\n                cssHSLA = col.hslaString;\n\n            var uiH = this._domH,\n                uiSL = this._domSL,\n                uiA = this._domA,\n                thumbH = $('.picker_selector', uiH),\n                thumbSL = $('.picker_selector', uiSL),\n                thumbA = $('.picker_selector', uiA);\n\n            function posX(parent, child, relX) {\n                child.style.left = relX * 100 + '%';\n            }\n            function posY(parent, child, relY) {\n                child.style.top = relY * 100 + '%';\n            }\n\n            posX(uiH, thumbH, hsl[0]);\n\n            this._domSL.style.backgroundColor = this._domH.style.color = cssHue;\n\n            posX(uiSL, thumbSL, hsl[1]);\n            posY(uiSL, thumbSL, 1 - hsl[2]);\n\n            uiSL.style.color = cssHSL;\n\n            posY(uiA, thumbA, 1 - hsl[3]);\n\n            var opaque = cssHSL,\n                transp = opaque.replace('hsl', 'hsla').replace(')', ', 0)'),\n                bg = 'linear-gradient(' + [opaque, transp] + ')';\n\n            this._domA.style.backgroundImage = bg + ', ' + BG_TRANSP;\n\n            if (!flags.fromEditor) {\n                var format = this.settings.editorFormat,\n                    alpha = this.settings.alpha;\n\n                var value = void 0;\n                switch (format) {\n                    case 'rgb':\n                        value = col.printRGB(alpha);break;\n                    case 'hsl':\n                        value = col.printHSL(alpha);break;\n                    default:\n                        value = col.printHex(alpha);\n                }\n                this._domEdit.value = value;\n            }\n\n            this._domSample.style.color = cssHSLA;\n        }\n    }, {\n        key: '_ifPopup',\n        value: function _ifPopup(actionIf, actionElse) {\n            if (this.settings.parent && this.settings.popup) {\n                actionIf && actionIf(this.settings.popup);\n            } else {\n                actionElse && actionElse();\n            }\n        }\n    }, {\n        key: '_toggleDOM',\n        value: function _toggleDOM(toVisible) {\n            var dom = this.domElement;\n            if (!dom) {\n                return false;\n            }\n\n            var displayStyle = toVisible ? '' : 'none',\n                toggle = dom.style.display !== displayStyle;\n\n            if (toggle) {\n                dom.style.display = displayStyle;\n            }\n            return toggle;\n        }\n    }], [{\n        key: 'StyleElement',\n        get: function get$$1() {\n            return _style;\n        }\n    }]);\n    return Picker;\n}();\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Picker);\n\n\n//# sourceURL=webpack:///./node_modules/vanilla-picker/dist/vanilla-picker.mjs?");

/***/ }),

/***/ "./src/profile/components/activity/activities.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/activity/activities.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _post_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./post.js */ \"./src/profile/components/activity/post.js\");\n/* harmony import */ var _activity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./activity.js */ \"./src/profile/components/activity/activity.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Activities = function Activities(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      activities = _useState2[0],\n      setActivities = _useState2[1];\n\n  var _useState3 = useState({}),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      more = _useState6[0],\n      setMore = _useState6[1];\n\n  var _useState7 = useState(true),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isLoading = _useState8[0],\n      setisLoading = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      isPagination = _useState10[0],\n      setIsPagination = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      activityFilters = _useState12[0],\n      setActivityFilters = _useState12[1];\n\n  useEffect(function () {\n    if (props.type === 'personal') {\n      setArgs({\n        filter: 'just-me',\n        search: '',\n        sorter: '',\n        page: 1\n      });\n    }\n\n    if (props.type === 'group') {\n      setArgs({\n        filter: 'groups',\n        item_id: props.id,\n        search: '',\n        sorter: '',\n        page: 1\n      });\n    }\n\n    var activity_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent_slug === 'activity';\n    });\n\n    if (window.vibebp.settings.followers) {\n      activity_filters.push({\n        \"class\": [\"menu-child\"],\n        css_id: \"activity-following\",\n        name: window.vibebp.translations.following,\n        parent: \"activity\"\n      });\n    }\n\n    if (window.vibebp.settings.likes) {\n      activity_filters.push({\n        \"class\": [\"menu-child\"],\n        css_id: \"activity-likes\",\n        name: window.vibebp.translations.liked,\n        parent: \"activity\"\n      });\n    }\n\n    activity_filters.map(function (filter, index) {\n      if (activity_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        activity_filters[index][\"class\"].push('current-menu-item'); //Current Action\n\n        var event = new CustomEvent('action_loaded', {\n          detail: {\n            component: window.vibebp.api.endpoints.activity,\n            action: activity_filters[index][\"class\"]\n          }\n        });\n        document.dispatchEvent(event);\n      }\n    });\n    setActivityFilters(activity_filters);\n  }, []);\n  useEffect(function () {\n    if (Object.keys(args).length) {\n      var nargs = _objectSpread({}, args);\n\n      nargs['token'] = select('vibebp').getToken();\n\n      if (navigator.onLine) {}\n\n      setisLoading(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.activity), {\n        method: 'post',\n        body: JSON.stringify(nargs)\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setisLoading(false);\n\n        if (data.status) {\n          var acties = [];\n\n          if (isPagination) {\n            acties = _toConsumableArray(activities);\n            data.data.activities.map(function (act) {\n              acties.push(act);\n            });\n            setIsPagination(false);\n          } else {\n            if (args.filter === 'activity-favs') {\n              var ids = [];\n              localforage.getItem('favorite_activities_' + select('vibebp').getUser().id).then(function (favoriteIds) {\n                if (favoriteIds) {\n                  favoriteIds = JSON.parse(favoriteIds);\n\n                  if (favoriteIds && favoriteIds.length) {\n                    ids = _toConsumableArray(favoriteIds);\n                  }\n\n                  data.data.activities.map(function (act) {\n                    if (ids.indexOf(act.id) === -1) {\n                      ids.push(act.id);\n                    }\n                  });\n                  localforage.setItem('favorite_activities_' + select('vibebp').getUser().id, JSON.stringify(ids));\n                }\n              });\n            }\n\n            if (args.filter === 'activity-likes') {\n              var _ids = [];\n              localforage.getItem('liked_activities_' + select('vibebp').getUser().id).then(function (favoriteIds) {\n                if (favoriteIds) {\n                  favoriteIds = JSON.parse(favoriteIds);\n\n                  if (favoriteIds && favoriteIds.length) {\n                    _ids = _toConsumableArray(favoriteIds);\n                  }\n\n                  data.data.activities.map(function (act) {\n                    if (_ids.indexOf(act.id) === -1) {\n                      _ids.push(act.id);\n                    }\n                  });\n                  localforage.setItem('liked_activities_' + select('vibebp').getUser().id, JSON.stringify(_ids));\n                }\n              });\n            }\n\n            acties = data.data.activities;\n          }\n\n          setActivities(acties);\n          setMore(data.data.has_more_items);\n        } else {\n          if (data.hasOwnProperty('message')) {\n            dispatch('vibebp').addNotification({\n              text: data.message\n            });\n          }\n        }\n      });\n    }\n  }, [args]);\n\n  var selectActivityType = function selectActivityType(sorter) {\n    setArgs(_objectSpread({}, args, {\n      sorter: sorter\n    }));\n  };\n\n  var updateActivity = function updateActivity(activity, action) {\n    var acts = _toConsumableArray(activities);\n\n    if (action === 'remove' || action == 'remove-favorite' && args.filter == \"activity-favs\") {\n      var _acts = _toConsumableArray(activities);\n\n      var index = _acts.findIndex(function (item) {\n        return item.id === activity.id;\n      });\n\n      if (index !== -1) {\n        _acts.splice(index, 1);\n\n        setActivities(_acts);\n      }\n    }\n\n    if (action === 'add') {\n      acts.unshift(activity);\n      setActivities(acts);\n    }\n\n    if (action === 'add_comment') {// acts.map((act,key)=>{\n      // \tif(act.children){\n      // \t\tact.children.map((ch,k)=>{\n      // \t\t})\n      // \t}\n      // });\n      // setActivities(acts);\n    }\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, props.type === 'personal' ? wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.activity.label), activityFilters.map(function (filter, i) {\n    return wp.element.createElement(\"a\", {\n      className: filter[\"class\"].join(' '),\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n        nargs.page = 1;\n        setArgs(nargs);\n\n        var ffilters = _toConsumableArray(activityFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setActivityFilters(ffilters);\n      }\n    }, filter.name);\n  }), wp.element.createElement(\"div\", {\n    className: \"labels\"\n  }, wp.element.createElement(\"div\", {\n    \"class\": \"labels_title\"\n  }, wp.element.createElement(\"span\", null, window.vibebp.translations.labels), wp.element.createElement(\"a\", {\n    className: \"link\"\n  }, window.vibebp.translations.add_new)), wp.element.createElement(\"ul\", null))) : '', wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, wp.element.createElement(_post_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    component: props.type,\n    id: props.id,\n    update: updateActivity\n  }), wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"div\", {\n    className: \"header_links\"\n  }, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    placeholder: window.vibebp.translations.search_text,\n    value: args.search,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.search = e.target.value;\n      nargs.page = 1;\n      setArgs(nargs);\n    }\n  }))), wp.element.createElement(\"div\", {\n    className: \"header_extras\"\n  }, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      return selectActivityType(e.target.value);\n    }\n  }, Object.keys(window.vibebp.components.activity.sorters).map(function (item) {\n    return wp.element.createElement(\"option\", {\n      value: item\n    }, window.vibebp.components.activity.sorters[item]);\n  })))), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : activities.length ? wp.element.createElement(\"div\", {\n    className: \"activity_list\"\n  }, activities.map(function (activity) {\n    return wp.element.createElement(_activity_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      activity: activity,\n      rootActivityId: activity.id,\n      update: updateActivity\n    });\n  }), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '') : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_activity_found)))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Activities);\n\n//# sourceURL=webpack:///./src/profile/components/activity/activities.js?");

/***/ }),

/***/ "./src/profile/components/activity/activity.js":
/*!*****************************************************!*\
  !*** ./src/profile/components/activity/activity.js ***!
  \*****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _timer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../timer.js */ \"./src/profile/components/timer.js\");\n/* harmony import */ var _post_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./post.js */ \"./src/profile/components/activity/post.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Activity = function Activity(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      activity = _useState2[0],\n      setActivity = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isRemoved = _useState4[0],\n      setisRemoved = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      showComments = _useState6[0],\n      setshowComments = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      favoriteIds = _useState8[0],\n      setFavoriteIds = _useState8[1];\n\n  var _useState9 = useState([]),\n      _useState10 = _slicedToArray(_useState9, 2),\n      likes = _useState10[0],\n      setLikes = _useState10[1];\n\n  useEffect(function () {\n    setActivity(props.activity);\n    localforage.getItem('favorite_activities_' + select('vibebp').getUser().id).then(function (fav_ids) {\n      if (fav_ids) {\n        fav_ids = JSON.parse(fav_ids);\n        setFavoriteIds(fav_ids);\n      }\n    });\n    localforage.getItem('liked_activities_' + select('vibebp').getUser().id).then(function (like_ids) {\n      if (like_ids) {\n        like_ids = JSON.parse(like_ids);\n        setLikes(like_ids);\n      }\n    });\n  }, [props.activity]);\n\n  var removeActivity = function removeActivity() {\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.activity, \"/remove\"), {\n      method: 'post',\n      body: JSON.stringify({\n        activity_id: activity.id,\n        parent_id: props.rootActivityId,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.hasOwnProperty('message')) {\n        select('vibebp').addNotification({\n          text: data.message\n        });\n      }\n    });\n    setisRemoved(true);\n    props.update(activity, 'remove');\n  };\n\n  var setFavorite = function setFavorite() {\n    var ids = [];\n    var index = -1;\n\n    if (favoriteIds) {\n      ids = _toConsumableArray(favoriteIds);\n      index = favoriteIds.indexOf(activity.id);\n    }\n\n    var endpoint = 'add-favorite';\n\n    if (index === -1) {\n      ids.push(activity.id);\n    } else {\n      endpoint = 'remove-favorite';\n      props.update(activity, 'remove-favorite');\n      ids.splice(index, 1);\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.activity, \"/\").concat(endpoint), {\n      method: 'post',\n      body: JSON.stringify({\n        activity_id: activity.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.hasOwnProperty('message')) {\n        select('vibebp').addNotification({\n          text: data.message\n        });\n      }\n\n      localforage.setItem('liked_activities_' + select('vibebp').getUser().id, JSON.stringify(ids));\n    });\n  };\n\n  var likeIt = function likeIt() {\n    var ids = [];\n    var index = -1;\n\n    if (likes) {\n      ids = _toConsumableArray(likes);\n      index = likes.indexOf(activity.id);\n    }\n\n    var endpoint = 'add-like';\n\n    if (index === -1) {\n      ids.push(activity.id);\n    } else {\n      endpoint = 'remove-like';\n      props.update(activity, 'remove-like');\n      ids.splice(index, 1);\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.activity, \"/\").concat(endpoint), {\n      method: 'post',\n      body: JSON.stringify({\n        activity_id: activity.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.hasOwnProperty('message')) {\n        select('vibebp').addNotification({\n          text: data.message\n        });\n      }\n\n      localforage.setItem('liked_activities_' + select('vibebp').getUser().id, JSON.stringify(ids));\n    });\n    setLikes(ids);\n  };\n\n  var addComment = function addComment() {\n    if (showComments) {\n      setshowComments(false);\n    } else {\n      setshowComments(true);\n    }\n  };\n\n  var updateActivityChildren = function updateActivityChildren(childActivity, type) {\n    var myactivity = _objectSpread({}, activity);\n\n    if (type === 'add') {\n      if (myactivity.children) {\n        myactivity.children[Object.keys(myactivity.children).length] = childActivity;\n      } else {\n        if (_typeof(myactivity.children) !== 'object' || myactivity.children === null) {\n          myactivity.children = {};\n        }\n\n        myactivity.children[0] = childActivity;\n      }\n\n      setshowComments(false);\n      setActivity(myactivity);\n    }\n\n    if (type === 'remove') {\n      var index = Object.keys(myactivity.children).findIndex(function (i) {\n        return myactivity.children[i].id === childActivity.id;\n      });\n\n      if (index !== -1) {\n        delete myactivity.children[i];\n        setActivity(myactivity);\n      }\n    }\n\n    if (type === 'cancel') {\n      setshowComments(false);\n    }\n  };\n\n  if (!activity.hasOwnProperty('date_recorded')) {\n    activity['date_recorded'] = new Date().getTime();\n  }\n\n  var classs = 'activity_item ' + activity.type + ' ' + activity.component;\n\n  if (activity.hasOwnProperty('content') && activity.content.length) {\n    classs += ' with_activity_content';\n  }\n\n  if (isRemoved) {\n    classs += ' removed';\n  }\n\n  return wp.element.createElement(\"div\", {\n    className: classs,\n    \"data-activity-id\": activity.id\n  }, wp.element.createElement(\"div\", {\n    className: \"activity_avatar\"\n  }, wp.element.createElement(\"img\", {\n    src: activity.avatar\n  })), wp.element.createElement(\"div\", {\n    className: \"activity_body\"\n  }, wp.element.createElement(\"div\", {\n    className: \"activity_header\"\n  }, wp.element.createElement(\"span\", {\n    dangerouslySetInnerHTML: {\n      __html: activity.action\n    }\n  })), activity.hasOwnProperty('content') && activity.content.length ? wp.element.createElement(\"div\", {\n    className: \"activity_content\"\n  }, wp.element.createElement(\"span\", {\n    dangerouslySetInnerHTML: {\n      __html: activity.content\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"activity_attachments\"\n  }, activity.hasOwnProperty('meta') && Object.keys(activity.meta).length ? Object.keys(activity.meta).map(function (meta_key) {\n    return wp.element.createElement(Fragment, null, activity.meta[meta_key].map(function (value) {\n      if (value.length > 3) {\n        if (meta_key == 'image') {\n          return wp.element.createElement(\"img\", {\n            src: value,\n            className: \"activity_meta image\"\n          });\n        }\n\n        if (meta_key == 'video') {\n          return wp.element.createElement(\"video\", {\n            src: value,\n            className: \"activity_meta video\"\n          });\n        }\n\n        if (meta_key == 'attachment') {\n          return wp.element.createElement(\"a\", {\n            href: value,\n            target: \"_blank\",\n            className: \"vicon vicon-clip activity_meta\"\n          });\n        }\n      }\n    }));\n  }) : '')) : '', wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    time: activity.date_recorded\n  }), wp.element.createElement(\"div\", {\n    className: \"activity_actions\"\n  }, window.vibebp.settings.likes ? wp.element.createElement(\"a\", {\n    className: likes.indexOf(activity.id) === -1 ? 'vicon vicon-thumb-up' : 'vicon vicon-thumb-up filled',\n    onClick: likeIt\n  }) : '', wp.element.createElement(\"a\", {\n    className: activity.hasOwnProperty('children') && activity.children ? 'vicon vicon-comment-alt' : 'vicon vicon-comment',\n    onClick: addComment\n  }), wp.element.createElement(\"a\", {\n    className: favoriteIds && favoriteIds.indexOf(activity.id) !== -1 ? 'vicon vicon-star filled' : 'vicon vicon-star',\n    onClick: setFavorite\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-trash\",\n    onClick: removeActivity\n  })), showComments ? wp.element.createElement(_post_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    activity_id: props.rootActivityId,\n    update: updateActivityChildren,\n    comment_id: activity.id\n  }) : '', activity.hasOwnProperty('children') && activity.children ? wp.element.createElement(\"div\", {\n    \"class\": \"activity_list\"\n  }, Object.keys(activity.children).map(function (key) {\n    return wp.element.createElement(Activity, {\n      activity: activity.children[key],\n      rootActivityId: props.rootActivityId\n    });\n  })) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Activity);\n\n//# sourceURL=webpack:///./src/profile/components/activity/activity.js?");

/***/ }),

/***/ "./src/profile/components/activity/post.js":
/*!*************************************************!*\
  !*** ./src/profile/components/activity/post.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _uploader_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../uploader.js */ \"./src/profile/components/uploader.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ActivityPost = function ActivityPost(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      componentItems = _useState2[0],\n      setComponentItems = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      enableAttachment = _useState4[0],\n      setEnableAttachment = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      attachments = _useState6[0],\n      setAttachments = _useState6[1];\n\n  var _useState7 = useState({\n    content: '',\n    component: 'activity',\n    component_id: '',\n    parent_id: '',\n    meta: []\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      args = _useState8[0],\n      setArgs = _useState8[1];\n\n  useEffect(function () {\n    console.log(props);\n\n    if (props.hasOwnProperty('activity_id')) {\n      setArgs({\n        content: '',\n        component: 'activity_comment',\n        component_id: props.comment_id,\n        parent_id: props.activity_id,\n        meta: []\n      });\n    }\n\n    if (props.hasOwnProperty('component') && props.component != 'personal') {\n      setArgs(_objectSpread({}, args, {\n        component: props.component,\n        component_id: props.id\n      }));\n    }\n  }, []);\n  useEffect(function () {\n    if (args.component.length && args.component !== 'activity' && args.component !== 'activity_comment') {\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(args.component, \"/user/\").concat(select('vibebp').getUser().id, \"/get_items\"), {\n        method: 'post',\n        body: JSON.stringify({\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          if (Array.isArray(data.groups)) {\n            setComponentItems(data.groups);\n          }\n        }\n      });\n    }\n  }, [args.component]);\n\n  var insertActivity = function insertActivity() {\n    if (!args.content.length) {\n      return;\n    }\n\n    var formData = new FormData();\n    formData.append(\"body\", JSON.stringify({\n      args: args,\n      token: select('vibebp').getToken()\n    }));\n\n    if (attachments.length) {\n      attachments.map(function (attachment, i) {\n        formData.append(\"files_\" + i, attachment);\n      });\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.activity, \"/add\"), {\n      method: 'post',\n      body: formData\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        props.update(data.activity, 'add');\n        setArgs(_objectSpread({}, args, {\n          content: '',\n          meta: []\n        }));\n        setAttachments([]);\n        dispatch('vibebp').addNotification({\n          text: data.activity.action\n        });\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"portal activity_post\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, wp.element.createElement(\"textarea\", {\n    placeholder: window.vibebp.translations.whats_new,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.content = e.target.value;\n      setArgs(nargs);\n    }\n  }, args.content)), wp.element.createElement(\"div\", {\n    className: \"portal_footer\"\n  }, props.hasOwnProperty('activity_id') ? '' : args.component !== 'activity' ? '' : wp.element.createElement(\"div\", {\n    className: \"footer_main\"\n  }, wp.element.createElement(\"select\", {\n    value: args.component,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.component = e.target.value;\n      setArgs(nargs);\n    }\n  }, Object.keys(window.vibebp.components.activity.post.components).map(function (comp) {\n    return wp.element.createElement(\"option\", {\n      value: comp\n    }, window.vibebp.components.activity.post.components[comp]);\n  })), componentItems.length ? wp.element.createElement(\"select\", {\n    value: args.component_id,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.component_id = e.target.value;\n      setArgs(nargs);\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.select_component), componentItems.map(function (item) {\n    return wp.element.createElement(\"option\", {\n      value: item.id\n    }, item.label);\n  })) : ''), wp.element.createElement(\"div\", {\n    className: \"footer_links\"\n  }, enableAttachment.length ? enableAttachment.map(function (item, i) {\n    return wp.element.createElement(Fragment, null, item == 'image' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-image upload_type\"\n    }) : item == 'video' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-video-camera upload_type\"\n    }) : wp.element.createElement(\"a\", {\n      className: \"vicon vicon-clip upload_type\"\n    }), wp.element.createElement(_uploader_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      type: item,\n      update: function update(files, data) {\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments[i] = new File([files[0]], files[0].name);\n        setAttachments(nattachments);\n        setArgs(_objectSpread({}, args, {\n          meta: [].concat(_toConsumableArray(args.meta), [{\n            key: item,\n            value: i\n          }])\n        }));\n      }\n    }), wp.element.createElement(\"a\", {\n      className: \"vicon vicon-close\",\n      onClick: function onClick() {\n        var nenableAttachment = _toConsumableArray(enableAttachment);\n\n        nenableAttachment.splice(i, 1);\n\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments.splice(i, 1);\n        setAttachments(nattachments);\n        setEnableAttachment(nenableAttachment);\n      }\n    }));\n  }) : '', wp.element.createElement(Fragment, null, wp.element.createElement(\"a\", {\n    className: \"vicon vicon-clip\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('attachment');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-video-camera\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('video');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-image\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('image');\n      setEnableAttachment(nenableAttachment);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: insertActivity\n  }, window.vibebp.translations.post_update), props.hasOwnProperty('activity_id') ? wp.element.createElement(\"a\", {\n    className: \"button is-text\",\n    onClick: function onClick() {\n      props.update('', 'cancel');\n    }\n  }, window.vibebp.translations.cancel) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ActivityPost);\n\n//# sourceURL=webpack:///./src/profile/components/activity/post.js?");

/***/ }),

/***/ "./src/profile/components/avatar.js":
/*!******************************************!*\
  !*** ./src/profile/components/avatar.js ***!
  \******************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Avatar = function Avatar(props) {\n  var _useState = useState(''),\n      _useState2 = _slicedToArray(_useState, 2),\n      avatar = _useState2[0],\n      setAvatar = _useState2[1];\n\n  useEffect(function () {\n    var key = '';\n    var type = '';\n\n    switch (props.type) {\n      case 'friends':\n        type = 'user';\n        key = props.id.item_id;\n        break;\n\n      case 'group':\n        type = 'group';\n        key = props.id.item_id;\n        break;\n\n      case 'activity':\n        type = 'user';\n        key = props.id.secondary_item_id;\n        break;\n\n      case 'user':\n        type = 'user';\n        key = props.id.user_id;\n        break;\n\n      default:\n        type = props.type;\n        key = props.id.item_id;\n        break;\n    }\n\n    localforage.getItem(type + '_' + key).then(function (stored) {\n      if (stored !== null) {\n        setAvatar(JSON.parse(stored));\n      } else {\n        fetch(\"\".concat(window.vibebp.api.url, \"/avatar\"), {\n          method: 'post',\n          body: JSON.stringify({\n            type: props.type,\n            ids: props.id,\n            token: select('vibebp').getToken()\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {\n          if (data.status) {\n            localforage.setItem(data.key, JSON.stringify(data.value));\n            setAvatar(data.value);\n          }\n        });\n      }\n    });\n  }, []);\n  return wp.element.createElement(\"img\", {\n    src: avatar.avatar,\n    className: \"vibebp_avatar\",\n    onClick: props.click,\n    alt: avatar.name,\n    title: avatar.name\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Avatar);\n\n//# sourceURL=webpack:///./src/profile/components/avatar.js?");

/***/ }),

/***/ "./src/profile/components/dashboard/dashboard.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/dashboard/dashboard.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./widget */ \"./src/profile/components/dashboard/widget.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Dashboard = function Dashboard(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      widgets = _useState4[0],\n      setWidgets = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/sidebar/\").concat(window.vibebp.components.dashboard), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      console.log(data);\n\n      if (data.status) {\n        setWidgets(data.widgets);\n      }\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    \"class\": \"dashboard\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : widgets.length ? widgets.map(function (widget) {\n    return wp.element.createElement(_widget__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      widget: widget\n    });\n  }) : wp.element.createElement(\"div\", {\n    className: \"vibebp_message\"\n  }, window.vibebp.translations.empty_dashboard));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Dashboard);\n\n//# sourceURL=webpack:///./src/profile/components/dashboard/dashboard.js?");

/***/ }),

/***/ "./src/profile/components/dashboard/widget.js":
/*!****************************************************!*\
  !*** ./src/profile/components/dashboard/widget.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Widget = function Widget(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      widget = _useState4[0],\n      setWidget = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(props.widget), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setWidget(data.widget);\n      }\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    \"class\": \"dashboard_widget\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : widget.hasOwnProperty('html') ? wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: widget.html\n    }\n  }) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Widget);\n\n//# sourceURL=webpack:///./src/profile/components/dashboard/widget.js?");

/***/ }),

/***/ "./src/profile/components/followers/followers.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/followers/followers.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _followers_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./followers_block */ \"./src/profile/components/followers/followers_block.js\");\n/* harmony import */ var _following_block__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./following_block */ \"./src/profile/components/followers/following_block.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Followers = function Followers(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      followersFilters = _useState4[0],\n      setFollowersFilters = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      activeTab = _useState6[0],\n      setActiveTab = _useState6[1];\n\n  useEffect(function () {\n    var follower_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'followers';\n    });\n    follower_filters.map(function (filter, index) {\n      if (follower_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        follower_filters[index][\"class\"].push('current-menu-item'); // setActiveTab(group_filters[index].css_id);\n      }\n    });\n    setFollowersFilters(follower_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.followers.label), followersFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n    return wp.element.createElement(\"a\", {\n      className: classs,\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n        nargs.page = 1;\n\n        if (args.css_id !== nargs.filter) {\n          setArgs(nargs);\n        }\n\n        setActiveTab(filter.css_id);\n\n        var ffilters = _toConsumableArray(followersFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setFollowersFilters(ffilters);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, activeTab === 'following' ? wp.element.createElement(_following_block__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null) : wp.element.createElement(_followers_block__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Followers);\n\n//# sourceURL=webpack:///./src/profile/components/followers/followers.js?");

/***/ }),

/***/ "./src/profile/components/followers/followers_block.js":
/*!*************************************************************!*\
  !*** ./src/profile/components/followers/followers_block.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _members_member__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../members/member */ \"./src/profile/components/members/member.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FollowersBlock = function FollowersBlock(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    search: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      followers = _useState6[0],\n      setFollowers = _useState6[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/followers\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setFollowers(data.followers);\n      }\n    });\n  }, [args]);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_followers\"\n  }, followers.length ? followers.map(function (follower) {\n    return wp.element.createElement(_members_member__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      member: follower\n    });\n  }) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_followers));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FollowersBlock);\n\n//# sourceURL=webpack:///./src/profile/components/followers/followers_block.js?");

/***/ }),

/***/ "./src/profile/components/followers/following_block.js":
/*!*************************************************************!*\
  !*** ./src/profile/components/followers/following_block.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _members_member__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../members/member */ \"./src/profile/components/members/member.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FollowingBlock = function FollowingBlock(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    search: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      following = _useState6[0],\n      setFollowing = _useState6[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/following\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setFollowing(data.following);\n      }\n    });\n  }, [args]);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_followers\"\n  }, following.length ? following.map(function (follower) {\n    return wp.element.createElement(_members_member__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      member: follower\n    });\n  }) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_following));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FollowingBlock);\n\n//# sourceURL=webpack:///./src/profile/components/followers/following_block.js?");

/***/ }),

/***/ "./src/profile/components/forums/allforums.js":
/*!****************************************************!*\
  !*** ./src/profile/components/forums/allforums.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\n/* harmony import */ var _forum__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./forum */ \"./src/profile/components/forums/forum.js\");\n/* harmony import */ var _topics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./topics */ \"./src/profile/components/forums/topics.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\n\n\nvar AllForums = function AllForums(props) {\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      forums = _useState4[0],\n      setForums = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      openForum = _useState6[0],\n      setOpenForum = _useState6[1];\n\n  var _useState7 = useState({\n    page: 1,\n    s: ''\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      args = _useState8[0],\n      setArgs = _useState8[1];\n\n  var _useState9 = useState(''),\n      _useState10 = _slicedToArray(_useState9, 2),\n      message = _useState10[0],\n      setMessage = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      more = _useState12[0],\n      setMore = _useState12[1];\n\n  var _useState13 = useState(false),\n      _useState14 = _slicedToArray(_useState13, 2),\n      isPagination = _useState14[0],\n      setIsPagination = _useState14[1];\n\n  var _useState15 = useState(false),\n      _useState16 = _slicedToArray(_useState15, 2),\n      isSearching = _useState16[0],\n      setIsSearching = _useState16[1];\n\n  var _useState17 = useState([]),\n      _useState18 = _slicedToArray(_useState17, 2),\n      searchResults = _useState18[0],\n      setSearchResults = _useState18[1];\n\n  Object(_functions__WEBPACK_IMPORTED_MODULE_0__[\"useThrottledEffect\"])(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/forums\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          var nforums = _toConsumableArray(forums);\n\n          data.data.map(function (forum) {\n            nforums.push(forum);\n          });\n          setForums(nforums);\n          setIsPagination(false);\n\n          if (ntopics.length < data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setForums(data.data);\n          setMessage(data.message);\n        }\n      }\n    });\n  }, 500, [args]);\n\n  var subscribe = function subscribe(i) {\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/forums/subscribe\"), {\n      method: 'post',\n      body: JSON.stringify({\n        subscribe: !forums[i].id.subscribed,\n        forum_id: forums[i].id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        var nforums = _toConsumableArray(forums);\n\n        nforums[i].subscribed = !forums[i].subscribed;\n        setForums(nforums);\n      } else {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_forums\"\n  }, openForum ? wp.element.createElement(_topics__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    type: \"forum\",\n    forum: openForum,\n    back: function back() {\n      setOpenForum(false);\n    }\n  }) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"div\", {\n    className: isSearching ? 'search_me control is-loading' : 'search_me'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.s,\n    onChange: function onChange(e) {\n      setArgs({\n        page: 1,\n        s: e.target.value\n      });\n    },\n    placeholder: window.vibebp.translations.search_text\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }))), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : wp.element.createElement(Fragment, null, forums.length ? forums.map(function (forum, i) {\n    console.log(forum.forums);\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_forum\",\n      onClick: function onClick() {\n        if (forum.access) {\n          setOpenForum(forum);\n        }\n      }\n    }, wp.element.createElement(\"div\", {\n      className: \"vibebp_forum_details\"\n    }, wp.element.createElement(\"strong\", null, forum.title), wp.element.createElement(\"div\", {\n      className: \"vibebp_forum_description\"\n    }, forum.description), wp.element.createElement(\"div\", {\n      className: \"vibebp_forum_meta\"\n    }, forum[\"private\"] ? wp.element.createElement(\"span\", {\n      className: \"vicon vicon-key\"\n    }) : '', forum.subscribed ? wp.element.createElement(\"span\", {\n      onClick: function onClick() {\n        subscribe(i);\n      },\n      className: \"active subscribe\"\n    }, window.vibebp.translations.subscribed) : wp.element.createElement(\"span\", {\n      onClick: function onClick() {\n        subscribe(i);\n      },\n      className: \"subscribe\"\n    }, window.vibebp.translations.subscribe), forum.access ? wp.element.createElement(\"span\", {\n      className: \"vicon vicon-eye\"\n    }) : wp.element.createElement(\"span\", {\n      className: \"vicon vicon-na\"\n    }), forum.forums_count ? wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vicon vicon-comment-alt\"\n    }), \" \", forum.forums_count) : '', forum.hasOwnProperty('forums') && forum.forums.length ? wp.element.createElement(\"div\", {\n      \"class\": \"sub_forums\"\n    }, forum.forums.map(function (f) {\n      return wp.element.createElement(_forum__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n        forum: f\n      });\n    })) : '')), wp.element.createElement(\"div\", {\n      className: \"vibebp_topic_count\"\n    }, wp.element.createElement(\"span\", {\n      className: \"vicon vicon-comments\"\n    }), forum.topic_count));\n  }) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, message), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (AllForums);\n\n//# sourceURL=webpack:///./src/profile/components/forums/allforums.js?");

/***/ }),

/***/ "./src/profile/components/forums/forum.js":
/*!************************************************!*\
  !*** ./src/profile/components/forums/forum.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Forum = function Forum(props) {\n  console.log(props);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sub_forum\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_sub_forum_details\"\n  }, wp.element.createElement(\"strong\", null, props.forum.post_title), wp.element.createElement(\"div\", {\n    dangerouselySetInnerHTML: {\n      __html: props.forum.post_content\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_topic_count\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-comments\"\n  }), props.forum.topic_count), props.forum.hasOwnProperty('forums') && props.forums.forums.length ? props.forums.forums.map(function (forum) {\n    return wp.element.createElement(Forum, {\n      forum: forum\n    });\n  }) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Forum);\n\n//# sourceURL=webpack:///./src/profile/components/forums/forum.js?");

/***/ }),

/***/ "./src/profile/components/forums/forums.js":
/*!*************************************************!*\
  !*** ./src/profile/components/forums/forums.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _allforums__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./allforums */ \"./src/profile/components/forums/allforums.js\");\n/* harmony import */ var _topics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./topics */ \"./src/profile/components/forums/topics.js\");\n/* harmony import */ var _replies__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./replies */ \"./src/profile/components/forums/replies.js\");\n/* harmony import */ var _newtopic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./newtopic */ \"./src/profile/components/forums/newtopic.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Forums = function Forums(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      forumsFilters = _useState4[0],\n      setForumsFilters = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      newTopic = _useState6[0],\n      setNewTopic = _useState6[1];\n\n  var _useState7 = useState(''),\n      _useState8 = _slicedToArray(_useState7, 2),\n      activeTab = _useState8[0],\n      setActiveTab = _useState8[1];\n\n  useEffect(function () {\n    var forum_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'forums';\n    });\n    forum_filters.map(function (filter, index) {\n      if (forum_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        forum_filters[index][\"class\"].push('current-menu-item'); // setActiveTab(group_filters[index].css_id);\n      }\n    });\n    setForumsFilters(forum_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.forums.label), wp.element.createElement(\"a\", {\n    className: \"button is-primary new_mail\",\n    onClick: function onClick() {\n      setNewTopic(true);\n    }\n  }, window.vibebp.translations.new_topic), wp.element.createElement(\"a\", {\n    className: \"button is-link new_mail\",\n    onClick: function onClick() {\n      setActiveTab('forums');\n    }\n  }, window.vibebp.translations.all_forums), forumsFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n    return wp.element.createElement(\"a\", {\n      className: classs,\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n        nargs.page = 1;\n\n        if (args.css_id !== nargs.filter) {\n          setArgs(nargs);\n        }\n\n        setActiveTab(filter.css_id);\n\n        var ffilters = _toConsumableArray(forumsFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setForumsFilters(ffilters);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, newTopic ? wp.element.createElement(_newtopic__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    back: function back() {\n      setNewTopic(false);\n    }\n  }) : activeTab === 'forums' ? wp.element.createElement(_allforums__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null) : activeTab === 'replies' ? wp.element.createElement(_replies__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    type: \"mine\"\n  }) : activeTab === 'engagements' ? wp.element.createElement(_topics__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"engagements\"\n  }) : activeTab === 'favorites' ? wp.element.createElement(_topics__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"favorites\"\n  }) : activeTab === 'subscriptions' ? wp.element.createElement(_topics__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"subscriptions\"\n  }) : wp.element.createElement(_topics__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"mine\"\n  })));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Forums);\n\n//# sourceURL=webpack:///./src/profile/components/forums/forums.js?");

/***/ }),

/***/ "./src/profile/components/forums/newtopic.js":
/*!***************************************************!*\
  !*** ./src/profile/components/forums/newtopic.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar NewTopic = function NewTopic(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      forums = _useState4[0],\n      setForums = _useState4[1];\n\n  var _useState5 = useState({\n    post_title: '',\n    post_content: '',\n    forum_id: 0\n  }),\n      _useState6 = _slicedToArray(_useState5, 2),\n      args = _useState6[0],\n      setArgs = _useState6[1];\n\n  useEffect(function () {\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/forums\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        setForums(data.data);\n      }\n    });\n  }, []);\n  useEffect(function () {\n    if (props.hasOwnProperty('topic')) {\n      setArgs({\n        post_title: topic.post_title,\n        post_content: topic.content,\n        forum_id: topic.forum_id,\n        topic_id: topic.id\n      });\n    }\n  }, []);\n\n  var postTopic = function postTopic() {\n    setIsLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/create\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setIsLoading(false);\n\n      if (data.status) {\n        props.update(_objectSpread({}, props.topic, {\n          post_title: topic.post_title,\n          post_content: topic.content,\n          forum_id: topic.forum_id\n        }));\n        props.back();\n      } else {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_new_topic\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_new_topic_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  }), wp.element.createElement(\"div\", {\n    className: \"vibebp_topic_actions\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-trash\",\n    onClick: function onClick() {\n      setArgs(_objectSpread({}, args, {\n        post_title: '',\n        post_content: ''\n      }));\n    }\n  }))), wp.element.createElement(\"div\", {\n    className: \"vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.post_title,\n    placeholder: window.vibebp.translations.topic_title,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        post_title: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, forums.length ? wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        forum_id: e.target.value\n      }));\n    },\n    value: args.forum_id,\n    placeholder: window.vibebp.translations.select_forum\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.select_forum), forums.map(function (forum) {\n    if (forum.access) {\n      return wp.element.createElement(\"option\", {\n        value: forum.id\n      }, forum.title);\n    }\n  })) : ''), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"textarea\", {\n    value: args.post_content,\n    placeholder: window.vibebp.translations.topic_content,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        post_content: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"a\", {\n    className: isLoading ? 'button is-primary is-loading' : 'button is-primary',\n    onClick: postTopic\n  }, window.vibebp.translations.submit)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (NewTopic);\n\n//# sourceURL=webpack:///./src/profile/components/forums/newtopic.js?");

/***/ }),

/***/ "./src/profile/components/forums/replies.js":
/*!**************************************************!*\
  !*** ./src/profile/components/forums/replies.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _reply_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./reply.js */ \"./src/profile/components/forums/reply.js\");\n/* harmony import */ var _topic_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./topic.js */ \"./src/profile/components/forums/topic.js\");\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\nvar Replies = function Replies(props) {\n  var _useState = useState({\n    type: props.type,\n    sorter: '',\n    page: 1,\n    s: ''\n  }),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isLoading = _useState4[0],\n      setisLoading = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      replies = _useState6[0],\n      setReplies = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isPagination = _useState8[0],\n      setIsPagination = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      more = _useState10[0],\n      setMore = _useState10[1];\n\n  var _useState11 = useState(0),\n      _useState12 = _slicedToArray(_useState11, 2),\n      fullTopic = _useState12[0],\n      setFullTopic = _useState12[1];\n\n  var _useState13 = useState(false),\n      _useState14 = _slicedToArray(_useState13, 2),\n      isSearching = _useState14[0],\n      setIsSearching = _useState14[1];\n\n  Object(_functions__WEBPACK_IMPORTED_MODULE_3__[\"useThrottledEffect\"])(function () {\n    setisLoading(true);\n\n    var nargs = _objectSpread({}, args);\n\n    nargs['token'] = select('vibebp').getToken();\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/replies\"), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          var nreplies = _toConsumableArray(replies);\n\n          data.replies.map(function (reply) {\n            nreplies.push(reply);\n          });\n          setReplies(nreplies);\n          setIsPagination(false);\n\n          if (nreplies.length < data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setReplies(data.replies);\n        }\n      }\n    });\n  }, 500, [args]);\n  useEffect(function () {}, [args]);\n\n  var updateReply = function updateReply() {};\n\n  var loadTopic = function loadTopic(topic_id) {};\n\n  return wp.element.createElement(Fragment, null, fullTopic ? wp.element.createElement(_topic_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    topic: fullTopic,\n    back: function back() {\n      setFullTopic(false);\n    }\n  }) : wp.element.createElement(\"div\", {\n    className: \"vibebp_replies\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"div\", {\n    className: isSearching ? 'search_me control is-loading' : 'search_me'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.s,\n    onChange: function onChange(e) {\n      setArgs({\n        page: 1,\n        s: e.target.value\n      });\n    },\n    placeholder: window.vibebp.translations.search_text\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }))), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : replies.length ? replies.map(function (reply, i) {\n    return wp.element.createElement(_reply_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      reply: reply,\n      update: updateReply,\n      open: function open() {\n        setFullTopic(reply.topic_id);\n      }\n    });\n  }) : '', more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Replies);\n\n//# sourceURL=webpack:///./src/profile/components/forums/replies.js?");

/***/ }),

/***/ "./src/profile/components/forums/reply.js":
/*!************************************************!*\
  !*** ./src/profile/components/forums/reply.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\nvar user = select('vibebp').getUser();\n\nvar Reply = function Reply(props) {\n  var _useState = useState(props.reply),\n      _useState2 = _slicedToArray(_useState, 2),\n      reply = _useState2[0],\n      setReply = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      replies = _useState4[0],\n      setReplies = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      isLoading = _useState6[0],\n      setisLoading = _useState6[1];\n\n  useEffect(function () {}, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_reply\"\n  }, wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"user\",\n    id: {\n      user_id: parseInt(reply.author)\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_content\"\n  }, wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: reply.post_content\n    },\n    onClick: function onClick() {\n      if (props.hasOwnProperty('open')) {\n        props.open(reply.topic_id);\n      }\n    }\n  }), reply.attachments.length ? wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_attachments\"\n  }, reply.attachments.map(function (attachment) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_reply_attachment\"\n    }, attachment.key == 'image' ? wp.element.createElement(\"a\", {\n      href: attachment.value,\n      target: \"_blank\"\n    }, wp.element.createElement(\"img\", {\n      src: attachment.value\n    })) : wp.element.createElement(\"a\", {\n      href: attachment.value,\n      target: \"_blank\",\n      className: \"vicon vicon-link\"\n    }));\n  })) : '', wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_content_meta\"\n  }, wp.element.createElement(\"a\", {\n    href: reply.permalink,\n    className: \"vicon vicon-link\"\n  }), wp.element.createElement(\"span\", null, reply.last_update), user.id === parseInt(reply.author) ? wp.element.createElement(Fragment, null, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-pencil\"\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-trash\"\n  })) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Reply);\n\n//# sourceURL=webpack:///./src/profile/components/forums/reply.js?");

/***/ }),

/***/ "./src/profile/components/forums/topic.js":
/*!************************************************!*\
  !*** ./src/profile/components/forums/topic.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _uploader_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../uploader.js */ \"./src/profile/components/uploader.js\");\n/* harmony import */ var _reply_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./reply.js */ \"./src/profile/components/forums/reply.js\");\n/* harmony import */ var _newtopic_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./newtopic.js */ \"./src/profile/components/forums/newtopic.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\nvar user = select('vibebp').getUser();\n\nvar Topic = function Topic(props) {\n  var _useState = useState(props.topic),\n      _useState2 = _slicedToArray(_useState, 2),\n      topic = _useState2[0],\n      setTopic = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      editTopic = _useState4[0],\n      setEditTopic = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      replies = _useState6[0],\n      setReplies = _useState6[1];\n\n  var _useState7 = useState(true),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isLoading = _useState8[0],\n      setisLoading = _useState8[1];\n\n  var _useState9 = useState({\n    post_content: '',\n    topic_id: 0,\n    forum_id: 0,\n    meta: []\n  }),\n      _useState10 = _slicedToArray(_useState9, 2),\n      newReply = _useState10[0],\n      setNewReply = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      isPagination = _useState12[0],\n      setIsPagination = _useState12[1];\n\n  var _useState13 = useState(false),\n      _useState14 = _slicedToArray(_useState13, 2),\n      more = _useState14[0],\n      setMore = _useState14[1];\n\n  var _useState15 = useState({\n    page: 1,\n    post_parent: 0\n  }),\n      _useState16 = _slicedToArray(_useState15, 2),\n      args = _useState16[0],\n      setArgs = _useState16[1];\n\n  var _useState17 = useState([]),\n      _useState18 = _slicedToArray(_useState17, 2),\n      enableAttachment = _useState18[0],\n      setEnableAttachment = _useState18[1];\n\n  var _useState19 = useState(''),\n      _useState20 = _slicedToArray(_useState19, 2),\n      attachments = _useState20[0],\n      setAttachments = _useState20[1];\n\n  console.log(props);\n  useEffect(function () {\n    if (_typeof(props.topic) === 'object') {\n      console.log('object');\n      setTopic(props.topic);\n      setArgs(_objectSpread({}, args, {\n        post_parent: props.topic.id\n      }));\n      setNewReply(_objectSpread({}, newReply, {\n        topic_id: props.topic.id,\n        forum_id: props.topic.forum_id\n      }));\n      setisLoading(false);\n    } else {\n      setArgs(_objectSpread({}, args, {\n        post_parent: props.topic\n      }));\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topic\"), {\n        method: 'post',\n        body: JSON.stringify({\n          topic_id: props.topic,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          setisLoading(false);\n          setTopic(data.topic);\n          setArgs(_objectSpread({}, args, {\n            post_parent: props.topic.id\n          }));\n        }\n      });\n    }\n  }, []);\n  useEffect(function () {\n    if (args.post_parent) {\n      setisLoading(true);\n\n      var nargs = _objectSpread({}, args);\n\n      nargs['token'] = select('vibebp').getToken();\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/replies\"), {\n        method: 'post',\n        body: JSON.stringify(nargs)\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setisLoading(false);\n\n        if (data.status) {\n          if (isPagination) {\n            var nreplies = _toConsumableArray(replies);\n\n            data.replies.map(function (reply) {\n              nreplies.push(reply);\n            });\n            setReplies(nreplies);\n            setIsPagination(false);\n\n            if (nreplies.length < data.total) {\n              setMore(true);\n            } else {\n              setMore(false);\n            }\n          } else {\n            setReplies(data.replies);\n          }\n        } else {\n          if (data.hasOwnProperty('message')) {\n            dispatch('vibebp').addNotification({\n              text: data.message\n            });\n          }\n        }\n      });\n    }\n  }, [args]);\n\n  var updateReply = function updateReply(reply) {};\n\n  var postNewReply = function postNewReply() {\n    var formData = new FormData();\n    formData.append(\"body\", JSON.stringify({\n      args: _objectSpread({}, newReply),\n      token: select('vibebp').getToken()\n    }));\n\n    if (attachments.length) {\n      attachments.map(function (attachment, i) {\n        formData.append(\"files_\" + i, attachment);\n      });\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/replies/create\"), {\n      method: 'post',\n      body: formData\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        var nreplies = _toConsumableArray(replies);\n\n        nreplies.push(data.reply);\n        setReplies(nreplies);\n        setNewReply(_objectSpread({}, newReply, {\n          post_content: '',\n          meta: []\n        }));\n        setEnableAttachment([]);\n        setAttachments('');\n      } else {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  var setTopicFavorite = function setTopicFavorite() {\n    if (isFavorite) {\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/unfavorite\"), {\n        method: 'post',\n        body: JSON.stringify({\n          topic_id: topic.id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          setTopic(_objectSpread({}, topic, {\n            favorite: false\n          }));\n        }\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    } else {\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/favorite\"), {\n        method: 'post',\n        body: JSON.stringify({\n          topic_id: topic.id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          setTopic(_objectSpread({}, topic, {\n            favorite: true\n          }));\n        }\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    }\n  };\n\n  var trashTopic = function trashTopic() {\n    props.back();\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_full_topic\"\n  }, editTopic ? wp.element.createElement(_newtopic_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    back: function back() {\n      setEditTopic(false);\n    },\n    topic: topic,\n    update: function update(topic) {\n      setTopic(topic);\n    }\n  }) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_full_topic_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  }), wp.element.createElement(\"div\", {\n    className: \"vibebp_topic_actions\"\n  }, wp.element.createElement(\"span\", {\n    className: topic.hasOwnProperty('favorite') && topic.favorite ? 'vicon vicon-star active' : 'vicon vicon-star',\n    onClick: setTopicFavorite\n  }), topic.hasOwnProperty('author') && topic.author == user.id ? wp.element.createElement(Fragment, null, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-pencil\",\n    onClick: function onClick() {\n      setEditTopic(topic);\n    }\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-trash\",\n    onClick: trashTopic\n  })) : '')), wp.element.createElement(\"div\", {\n    className: \"vibebp_main_topic\"\n  }, wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"user\",\n    id: {\n      user_id: topic.author\n    }\n  }), wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: topic.post_content\n    }\n  })), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : replies.length ? replies.map(function (reply, i) {\n    if (i) {\n      return wp.element.createElement(_reply_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n        reply: reply,\n        update: updateReply\n      });\n    }\n  }) : '', more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '', wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibe_editor\"\n  }, wp.element.createElement(\"textarea\", {\n    value: newReply.content,\n    onChange: function onChange(e) {\n      setNewReply(_objectSpread({}, newReply, {\n        post_content: e.target.value\n      }));\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_form_actions\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_reply_form_attachments\"\n  }, wp.element.createElement(Fragment, null, wp.element.createElement(\"a\", {\n    className: \"vicon vicon-clip\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('attachment');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-video-camera\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('video');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-image\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('image');\n      setEnableAttachment(nenableAttachment);\n    }\n  })), enableAttachment.length ? enableAttachment.map(function (item, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_reply_form_attachment\"\n    }, item == 'image' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-image upload_type\"\n    }) : item == 'video' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-video-camera upload_type\"\n    }) : wp.element.createElement(\"a\", {\n      className: \"vicon vicon-clip upload_type\"\n    }), wp.element.createElement(_uploader_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      type: item,\n      update: function update(files, data) {\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments[i] = new File([files[0]], files[0].name);\n        setAttachments(nattachments);\n\n        var nmeta = _toConsumableArray(newReply.meta);\n\n        nmeta.push({\n          key: item,\n          value: i\n        });\n        setNewReply(_objectSpread({}, newReply, {\n          meta: nmeta\n        }));\n      }\n    }), wp.element.createElement(\"a\", {\n      className: \"vicon vicon-close\",\n      onClick: function onClick() {\n        var nenableAttachment = _toConsumableArray(enableAttachment);\n\n        nenableAttachment.splice(i, 1);\n\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments.splice(i, 1);\n        setAttachments(nattachments);\n        setEnableAttachment(nenableAttachment);\n      }\n    }));\n  }) : ''), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: postNewReply\n  }, window.vibebp.translations.submit))))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Topic);\n\n//# sourceURL=webpack:///./src/profile/components/forums/topic.js?");

/***/ }),

/***/ "./src/profile/components/forums/topics.js":
/*!*************************************************!*\
  !*** ./src/profile/components/forums/topics.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _topic_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./topic.js */ \"./src/profile/components/forums/topic.js\");\n/* harmony import */ var _newtopic__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newtopic */ \"./src/profile/components/forums/newtopic.js\");\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Topics = function Topics(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    type: props.type,\n    sorter: '',\n    page: 1,\n    s: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      topics = _useState6[0],\n      setTopics = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isPagination = _useState8[0],\n      setIsPagination = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      more = _useState10[0],\n      setMore = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      editTopic = _useState12[0],\n      setEditTopic = _useState12[1];\n\n  var _useState13 = useState(0),\n      _useState14 = _slicedToArray(_useState13, 2),\n      fullTopic = _useState14[0],\n      setFullTopic = _useState14[1];\n\n  var _useState15 = useState(false),\n      _useState16 = _slicedToArray(_useState15, 2),\n      isSearching = _useState16[0],\n      setIsSearching = _useState16[1];\n\n  var _useState17 = useState(false),\n      _useState18 = _slicedToArray(_useState17, 2),\n      isSubscribed = _useState18[0],\n      setIsSubscribed = _useState18[1];\n\n  var user = select('vibebp').getUser();\n  useEffect(function () {\n    if (props.hasOwnProperty('forum')) {\n      setIsSubscribed(props.forum.subscribed);\n    }\n  }, []);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_3__[\"useThrottledEffect\"])(function () {\n    setisLoading(true);\n\n    var nargs = _objectSpread({}, args, {\n      type: props.type\n    });\n\n    if (props.type === 'forum') {\n      nargs['post_parent'] = props.forum.id;\n    }\n\n    nargs['token'] = select('vibebp').getToken();\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics\"), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          var ntopics = _toConsumableArray(topics);\n\n          data.topics.map(function (topic) {\n            ntopics.push(topic);\n          });\n          setTopics(ntopics);\n          setIsPagination(false);\n\n          if (ntopics.length < data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setTopics(data.topics);\n        }\n      }\n    });\n  }, 500, [args, props.type]);\n\n  var updateTopic = function updateTopic(topic, action) {};\n\n  var setTopicFavorite = function setTopicFavorite(topic) {\n    if (topic.favorite) {\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/unfavorite\"), {\n        method: 'post',\n        body: JSON.stringify({\n          topic_id: topic.id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          var ntopics = _toConsumableArray(topics);\n\n          ntopics[ntopics.findIndex(function (t) {\n            return t.id === topic.id;\n          })].favorite = false;\n          setTopics(ntopics);\n        }\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    } else {\n      fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/favorite\"), {\n        method: 'post',\n        body: JSON.stringify({\n          topic_id: topic.id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          var ntopics = _toConsumableArray(topics);\n\n          ntopics[ntopics.findIndex(function (t) {\n            return t.id === topic.id;\n          })].favorite = true;\n          setTopics(ntopics);\n        }\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    }\n  };\n\n  var trashTopic = function trashTopic(topic) {\n    var ntopics = _toConsumableArray(topics);\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/delete\"), {\n      method: 'post',\n      body: JSON.stringify({\n        topic_id: topic.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        ntopics = ntopics.splice(ntopics.findIndex(function (t) {\n          return topic.id === t.id;\n        }), 1);\n        setTopics(ntopics);\n      } else {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  var subscribeForum = function subscribeForum() {\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/forums/subscribe\"), {\n      method: 'post',\n      body: JSON.stringify({\n        forum_id: props.forum.id,\n        subscribe: !isSubscribed,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        setIsSubscribed(!isSubscribed);\n      }\n    });\n  };\n\n  var subscribe = function subscribe(i) {\n    fetch(\"\".concat(window.vibebp.api.url, \"/bbp/topics/subscribe\"), {\n      method: 'post',\n      body: JSON.stringify({\n        topic_id: topics[i].id,\n        subscribe: !topics[i].subscribe,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        var ntopics = _toConsumableArray(topics);\n\n        ntopics[i].subscribed = !ntopics[i].subscribed;\n        setForums(ntopics);\n      } else {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_topics\"\n  }, props.hasOwnProperty('forum') ? wp.element.createElement(\"div\", {\n    className: \"vibebp_topics_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  }), wp.element.createElement(\"span\", {\n    className: isSubscribed ? 'subscribe active' : 'subscribe',\n    onClick: function onClick() {\n      subscribeForum();\n    }\n  }, isSubscribed ? window.vibebp.translations.subscribed : window.vibebp.translations.subscribe)) : '', wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"div\", {\n    className: isSearching ? 'search_me control is-loading' : 'search_me'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.s,\n    onChange: function onChange(e) {\n      setArgs({\n        page: 1,\n        s: e.target.value\n      });\n    },\n    placeholder: window.vibebp.translations.search_text\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }))), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : fullTopic ? wp.element.createElement(_topic_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    topic: fullTopic,\n    back: function back() {\n      setFullTopic(false);\n    },\n    update: updateTopic\n  }) : editTopic ? wp.element.createElement(_newtopic__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    back: function back() {\n      setEditTopic(false);\n    },\n    topic: topics[editTopic]\n  }) : topics.length ? topics.map(function (topic, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_topic_wrapper\"\n    }, wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      type: \"user\",\n      id: {\n        user_id: topic.author\n      }\n    }), wp.element.createElement(\"div\", {\n      className: \"vibebp_topic\"\n    }, wp.element.createElement(\"div\", {\n      className: \"vibebp_topic_title\"\n    }, wp.element.createElement(\"strong\", {\n      onClick: function onClick() {\n        setFullTopic(topic);\n      }\n    }, topic.post_title), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: topic.favorite ? 'vicon vicon-star active' : 'vicon vicon-star',\n      onClick: function onClick() {\n        setTopicFavorite(topic);\n      }\n    }), wp.element.createElement(\"span\", {\n      className: topic.subscribed ? 'subscribe active' : 'subscribe',\n      onClick: function onClick() {\n        subscribe(i);\n      }\n    }, topic.subscribed ? window.vibebp.translations.subscribed : window.vibebp.translations.subscribe), wp.element.createElement(\"span\", {\n      className: \"vicon vicon-comment-alt\",\n      onClick: function onClick() {\n        setFullTopic(topic);\n      }\n    }), wp.element.createElement(\"strong\", {\n      onClick: function onClick() {\n        setFullTopic(topic);\n      }\n    }, topic.reply_count))), wp.element.createElement(\"div\", {\n      className: \"vibebp_topic_actions\"\n    }, wp.element.createElement(\"a\", {\n      href: topic.permalink,\n      target: \"_blank\",\n      className: \"vicon vicon-link\"\n    }), wp.element.createElement(\"span\", null, topic.last_update), user.id === parseInt(topic.author) ? wp.element.createElement(Fragment, null, wp.element.createElement(\"span\", {\n      className: \"vicon vicon-pencil\",\n      onClick: function onClick() {\n        setEditTopic(i);\n      }\n    }), wp.element.createElement(\"span\", {\n      className: \"vicon vicon-trash\",\n      onClick: function onClick() {\n        trashTopic(i);\n      }\n    })) : '')));\n  }) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_topics_found), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Topics);\n\n//# sourceURL=webpack:///./src/profile/components/forums/topics.js?");

/***/ }),

/***/ "./src/profile/components/friends/friend_block.js":
/*!********************************************************!*\
  !*** ./src/profile/components/friends/friend_block.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _members_member__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../members/member */ \"./src/profile/components/members/member.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FriendsBlock = function FriendsBlock(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    search: '',\n    sort: 'active'\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      friends = _useState6[0],\n      setFriends = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isPagination = _useState8[0],\n      setIsPagination = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      more = _useState10[0],\n      setMore = _useState10[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.friends, \"/\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          setIsPagination(false);\n\n          var nfriends = _toConsumableArray(friends);\n\n          data.data.users.map(function (friend) {\n            nfriends.push(friend);\n          });\n          setFriends(nfriends);\n\n          if (nfriends.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setFriends(data.data.users);\n\n          if (data.data.users.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        }\n      }\n    });\n  }, [args]);\n\n  var unFriend = function unFriend(member) {\n    var nfriends = _toConsumableArray(friends);\n\n    nfriends.splice(friends.findIndex(function (f) {\n      return f.id === member.id;\n    }), 1); //API Call\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.friends, \"/removefriendship\"), {\n      method: 'post',\n      body: JSON.stringify({\n        friend_userid: member.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n    setFriends(nfriends);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"div\", {\n    className: \"header_links\"\n  }, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    placeholder: window.vibebp.translations.search_text,\n    value: args.search,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.search = e.target.value;\n      nargs.page = 1;\n      setArgs(nargs);\n    }\n  }))), wp.element.createElement(\"div\", {\n    className: \"header_extras\"\n  }, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        sort: e.target.value\n      }));\n    },\n    value: args.sort\n  }, Object.keys(window.vibebp.components.friends.sorters).map(function (key) {\n    return wp.element.createElement(\"option\", {\n      value: key\n    }, window.vibebp.components.friends.sorters[key]);\n  })))), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : friends.length ? wp.element.createElement(\"div\", {\n    className: \"friend_list member_list\"\n  }, friends.map(function (member) {\n    return wp.element.createElement(_members_member__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      member: _objectSpread({}, member, {\n        is_friend: 1\n      }),\n      unfriend: unFriend\n    });\n  }), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '') : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_friends_found)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FriendsBlock);\n\n//# sourceURL=webpack:///./src/profile/components/friends/friend_block.js?");

/***/ }),

/***/ "./src/profile/components/friends/friend_requests.js":
/*!***********************************************************!*\
  !*** ./src/profile/components/friends/friend_requests.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _members_member__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../members/member */ \"./src/profile/components/members/member.js\");\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FriendRequestsBlock = function FriendRequestsBlock(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    'requester': 0,\n    'sort': 'DESC',\n    reload: 0\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      friendRequests = _useState6[0],\n      setFriendRequests = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isPagination = _useState8[0],\n      setIsPagination = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      more = _useState10[0],\n      setMore = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      addFriend = _useState12[0],\n      setAddFriend = _useState12[1];\n\n  var _useState13 = useState(false),\n      _useState14 = _slicedToArray(_useState13, 2),\n      isSearching = _useState14[0],\n      setIsSearching = _useState14[1];\n\n  var _useState15 = useState([]),\n      _useState16 = _slicedToArray(_useState15, 2),\n      friendSelected = _useState16[0],\n      setFriendSelected = _useState16[1];\n\n  var _useState17 = useState(''),\n      _useState18 = _slicedToArray(_useState17, 2),\n      friendSearch = _useState18[0],\n      setFriendSearch = _useState18[1];\n\n  var _useState19 = useState([]),\n      _useState20 = _slicedToArray(_useState19, 2),\n      searchResults = _useState20[0],\n      setSearchResults = _useState20[1];\n\n  useEffect(function () {\n    if (friendSearch.length > 4) {\n      setIsSearching(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/search\"), {\n        method: 'post',\n        body: JSON.stringify({\n          search: friendSearch,\n          type: 'user',\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setIsSearching(false);\n\n        if (data.status) {\n          if (Array.isArray(data.results)) {\n            data.results.map(function (user) {\n              localforage.setItem('user_' + user.id, JSON.stringify(user));\n            });\n            setSearchResults(data.results);\n          }\n        }\n      });\n    }\n  }, [friendSearch]);\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.friends, \"/requests\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      setMore(false);\n\n      if (data.status) {\n        if (isPagination) {\n          setIsPagination(false);\n\n          if (data.data.length) {\n            var nfriendRequests = _toConsumableArray(friendRequests);\n\n            data.data.map(function (friendRequest) {\n              nfriendRequests.push(friendRequest);\n            });\n            setFriendRequests(nfriendRequests);\n\n            if (data.data.length === 20) {\n              setMore(true);\n            }\n          }\n        } else {\n          setFriendRequests(data.data);\n\n          if (data.data.length === 20) {\n            setMore(true);\n          }\n        }\n      }\n    });\n  }, [args]);\n\n  var sendFriendRquests = function sendFriendRquests() {\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.friends, \"/addfriendship\"), {\n      method: 'post',\n      body: JSON.stringify({\n        friends: friendSelected,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setArgs(_objectSpread({}, args, {\n        reload: 1\n      }));\n      setFriendSelected([]);\n    });\n    setAddFriend(false);\n  };\n\n  var Action = function Action(friendship_id, action) {\n    var f = friendRequests.findIndex(function (item) {\n      return item.friendship_id === friendship_id;\n    });\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.friends, \"/action\"), {\n      method: 'post',\n      body: JSON.stringify({\n        friendship_id: friendship_id,\n        action: action,\n        friend_id: friendRequests[f].user.ID,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n\n    var nfriendRequests = _toConsumableArray(friendRequests);\n\n    nfriendRequests.splice(f, 1);\n    setFriendRequests(nfriendRequests);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"div\", {\n    className: \"header_links\"\n  }, wp.element.createElement(\"a\", {\n    onClick: function onClick() {\n      setArgs(_objectSpread({}, args, {\n        requester: 0\n      }));\n    },\n    className: args.requester ? '' : 'active'\n  }, window.vibebp.translations.requestee), wp.element.createElement(\"a\", {\n    onClick: function onClick() {\n      setArgs(_objectSpread({}, args, {\n        requester: 1\n      }));\n    },\n    className: args.requester ? 'active' : ''\n  }, window.vibebp.translations.requester), wp.element.createElement(\"a\", {\n    onClick: function onClick() {\n      setAddFriend(true);\n    },\n    className: \"button is-primary\"\n  }, window.vibebp.translations.add_friend)), wp.element.createElement(\"div\", {\n    className: \"header_extras\"\n  }, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        sort: e.target.value\n      }));\n    },\n    value: args.sort\n  }, Object.keys(window.vibebp.components.friends.requests_sorter).map(function (key) {\n    return wp.element.createElement(\"option\", {\n      value: key\n    }, window.vibebp.components.friends.requests_sorter[key]);\n  })))), addFriend ? wp.element.createElement(\"div\", {\n    className: \"recipients\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipients_list\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipient_items\"\n  }, friendSelected.map(function (friend) {\n    return wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      type: \"user\",\n      click: function click() {\n        var nfriendSelected = _toConsumableArray(friendSelected);\n\n        nfriendSelected.splice(nfriendSelected.indexOf(friend), 1);\n        setFriendSelected(nfriendSelected);\n      },\n      id: {\n        user_id: friend\n      }\n    });\n  }), friendSelected.length ? wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: sendFriendRquests\n  }, window.vibebp.translations.send_friend_request) : ''), wp.element.createElement(\"div\", {\n    className: isSearching ? 'control is-loading' : 'control'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: friendSearch,\n    placeholder: window.vibebp.translations.search_member,\n    onChange: function onChange(e) {\n      setFriendSearch(e.target.value);\n    }\n  }))), searchResults.length ? wp.element.createElement(\"div\", {\n    className: \"search_results\"\n  }, searchResults.map(function (user, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"search_result user\",\n      onClick: function onClick() {\n        setFriendSearch('');\n\n        var nsearchResults = _toConsumableArray(searchResults);\n\n        var nfriendSelected = _toConsumableArray(friendSelected);\n\n        if (nfriendSelected.indexOf(user.id) === -1) {\n          nfriendSelected.push(user.id);\n          setFriendSelected(nfriendSelected);\n          nsearchResults.splice(i, 1);\n          setSearchResults(nsearchResults);\n        }\n      }\n    }, wp.element.createElement(\"img\", {\n      src: user.avatar\n    }), wp.element.createElement(\"span\", null, user.name));\n  })) : '') : '', wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    className: \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : friendRequests.length ? wp.element.createElement(\"div\", {\n    className: \"friend_list member_list\"\n  }, friendRequests.map(function (request) {\n    if (args.requester) {\n      return wp.element.createElement(_members_member__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n        member: _objectSpread({}, request.user, {\n          is_my_friend_request: 1\n        }),\n        action: function action(a) {\n          return Action(request.friendship_id, a);\n        }\n      });\n    } else {\n      return wp.element.createElement(_members_member__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n        member: _objectSpread({}, request.user, {\n          is_friend_request: 1\n        }),\n        action: function action(a) {\n          return Action(request.friendship_id, a);\n        }\n      });\n    }\n  }), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '') : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_requests_found)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FriendRequestsBlock);\n\n//# sourceURL=webpack:///./src/profile/components/friends/friend_requests.js?");

/***/ }),

/***/ "./src/profile/components/friends/friends.js":
/*!***************************************************!*\
  !*** ./src/profile/components/friends/friends.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _friend_block__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./friend_block */ \"./src/profile/components/friends/friend_block.js\");\n/* harmony import */ var _friend_requests__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./friend_requests */ \"./src/profile/components/friends/friend_requests.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Friends = function Friends(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      friendFilters = _useState4[0],\n      setFriendFilters = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      activeTab = _useState6[0],\n      setActiveTab = _useState6[1];\n\n  useEffect(function () {\n    var friend_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'friends';\n    });\n    friend_filters.map(function (filter, index) {\n      if (friend_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        friend_filters[index][\"class\"].push('current-menu-item'); // setActiveTab(group_filters[index].css_id);\n      }\n    });\n    setFriendFilters(friend_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.friends.label), friendFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n\n    if (filter.css_id !== 'compose') {\n      return wp.element.createElement(\"a\", {\n        className: classs,\n        onClick: function onClick(e) {\n          var nargs = _objectSpread({}, args);\n\n          nargs.filter = filter.css_id;\n          nargs.page = 1;\n\n          if (args.css_id !== nargs.filter) {\n            setArgs(nargs);\n          }\n\n          setActiveTab(filter.css_id);\n\n          var ffilters = _toConsumableArray(friendFilters);\n\n          var index = ffilters.findIndex(function (item) {\n            return item[\"class\"].indexOf('current-menu-item') > -1;\n          });\n          ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n          ffilters[i][\"class\"].push('current-menu-item');\n          setFriendFilters(ffilters);\n        }\n      }, filter.name);\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, activeTab === 'requests' ? wp.element.createElement(_friend_requests__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null) : wp.element.createElement(_friend_block__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Friends);\n\n//# sourceURL=webpack:///./src/profile/components/friends/friends.js?");

/***/ }),

/***/ "./src/profile/components/functions.js":
/*!*********************************************!*\
  !*** ./src/profile/components/functions.js ***!
  \*********************************************/
/*! exports provided: useThrottledEffect, validateUrl, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"useThrottledEffect\", function() { return useThrottledEffect; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"validateUrl\", function() { return validateUrl; });\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useRef = _wp$element.useRef,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar useThrottledEffect = function useThrottledEffect(callback, delay) {\n  var deps = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];\n  var lastRan = useRef(Date.now());\n  useEffect(function () {\n    var handler = setTimeout(function () {\n      if (Date.now() - lastRan.current >= delay) {\n        callback();\n        lastRan.current = Date.now();\n      }\n    }, delay - (Date.now() - lastRan.current));\n    return function () {\n      clearTimeout(handler);\n    };\n  }, [delay].concat(_toConsumableArray(deps)));\n};\nvar validateUrl = function validateUrl(value) {\n  return /^(?:(?:(?:https?|ftp):)?\\/\\/)(?:\\S+(?::\\S*)?@)?(?:(?!(?:10|127)(?:\\.\\d{1,3}){3})(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))|(?:(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*(?:\\.(?:[a-z\\u00a1-\\uffff]{2,})))(?::\\d{2,5})?(?:[/?#]\\S*)?$/i.test(value);\n};\n\nvar IsJsonString = function IsJsonString(str) {\n  try {\n    JSON.parse(str);\n  } catch (e) {\n    return false;\n  }\n\n  return true;\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (IsJsonString);\n\n//# sourceURL=webpack:///./src/profile/components/functions.js?");

/***/ }),

/***/ "./src/profile/components/generateblocks.js":
/*!**************************************************!*\
  !*** ./src/profile/components/generateblocks.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar GenerateBlocks = function GenerateBlocks(props) {\n  var _useState = useState(JSON.parse(props.object)),\n      _useState2 = _slicedToArray(_useState, 2),\n      object = _useState2[0],\n      setObject = _useState2[1];\n\n  return wp.element.createElement(Fragment, null, object.blocks[0].type === 'unstyled' ? wp.element.createElement(\"div\", {\n    className: \"blocktext\"\n  }, object.blocks[0].text) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (GenerateBlocks);\n\n//# sourceURL=webpack:///./src/profile/components/generateblocks.js?");

/***/ }),

/***/ "./src/profile/components/grid.js":
/*!****************************************!*\
  !*** ./src/profile/components/grid.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _dashboard_dashboard_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./dashboard/dashboard.js */ \"./src/profile/components/dashboard/dashboard.js\");\n/* harmony import */ var _activity_activities_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./activity/activities.js */ \"./src/profile/components/activity/activities.js\");\n/* harmony import */ var _profile_profile_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./profile/profile.js */ \"./src/profile/components/profile/profile.js\");\n/* harmony import */ var _notifications_notifications_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./notifications/notifications.js */ \"./src/profile/components/notifications/notifications.js\");\n/* harmony import */ var _messages_messages_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./messages/messages.js */ \"./src/profile/components/messages/messages.js\");\n/* harmony import */ var _friends_friends_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./friends/friends.js */ \"./src/profile/components/friends/friends.js\");\n/* harmony import */ var _followers_followers_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./followers/followers.js */ \"./src/profile/components/followers/followers.js\");\n/* harmony import */ var _groups_groups_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./groups/groups.js */ \"./src/profile/components/groups/groups.js\");\n/* harmony import */ var _settings_settings_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./settings/settings.js */ \"./src/profile/components/settings/settings.js\");\n/* harmony import */ var _forums_forums_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./forums/forums.js */ \"./src/profile/components/forums/forums.js\");\n/* harmony import */ var _shop_shop_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./shop/shop.js */ \"./src/profile/components/shop/shop.js\");\n/* harmony import */ var _kb_kb_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./kb/kb.js */ \"./src/profile/components/kb/kb.js\");\n/* harmony import */ var _page_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./page.js */ \"./src/profile/components/page.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ProfileGrid = function ProfileGrid(props) {\n  var _useState = useState('dashboard'),\n      _useState2 = _slicedToArray(_useState, 2),\n      component = _useState2[0],\n      setComponent = _useState2[1];\n\n  useEffect(function () {\n    document.addEventListener('component_loaded', function (e) {\n      console.log(e.detail.component);\n      setComponent(e.detail.component);\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"profile_grid\"\n  }, component === 'dashboard' ? wp.element.createElement(_dashboard_dashboard_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null) : component === 'activity' ? wp.element.createElement(_activity_activities_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"personal\"\n  }) : component === 'profile' ? wp.element.createElement(_profile_profile_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], null) : component === 'notifications' ? wp.element.createElement(_notifications_notifications_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], null) : component === 'messages' ? wp.element.createElement(_messages_messages_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"], null) : component === 'friends' ? wp.element.createElement(_friends_friends_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"], null) : component === 'groups' ? wp.element.createElement(_groups_groups_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"], null) : component === 'settings' ? wp.element.createElement(_settings_settings_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"], null) : component === 'followers' ? wp.element.createElement(_followers_followers_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"], null) : component === 'forums' ? wp.element.createElement(_forums_forums_js__WEBPACK_IMPORTED_MODULE_9__[\"default\"], null) : component === 'shop' ? wp.element.createElement(_shop_shop_js__WEBPACK_IMPORTED_MODULE_10__[\"default\"], null) : component === 'kb' ? wp.element.createElement(_kb_kb_js__WEBPACK_IMPORTED_MODULE_11__[\"default\"], null) : component.indexOf('post_type') !== -1 ? wp.element.createElement(_page_js__WEBPACK_IMPORTED_MODULE_12__[\"default\"], {\n    page: component\n  }) : wp.element.createElement(\"div\", {\n    id: component + '_component'\n  }, component));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ProfileGrid);\n\n//# sourceURL=webpack:///./src/profile/components/grid.js?");

/***/ }),

/***/ "./src/profile/components/groups/fullgroup.js":
/*!****************************************************!*\
  !*** ./src/profile/components/groups/fullgroup.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _activity_activities__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../activity/activities */ \"./src/profile/components/activity/activities.js\");\n/* harmony import */ var _members_members__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../members/members */ \"./src/profile/components/members/members.js\");\n/* harmony import */ var _newgroup_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./newgroup.js */ \"./src/profile/components/groups/newgroup.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FullGroup = function FullGroup(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState(''),\n      _useState4 = _slicedToArray(_useState3, 2),\n      style = _useState4[0],\n      setStyle = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      activities = _useState6[0],\n      setActivities = _useState6[1];\n\n  var _useState7 = useState(_objectSpread({}, props.group)),\n      _useState8 = _slicedToArray(_useState7, 2),\n      group = _useState8[0],\n      setGroup = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      newGroup = _useState10[0],\n      setNewGroup = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      isCoverImage = _useState12[0],\n      setCoverImage = _useState12[1];\n\n  var _useState13 = useState(0),\n      _useState14 = _slicedToArray(_useState13, 2),\n      meta = _useState14[0],\n      setMeta = _useState14[1];\n\n  var _useState15 = useState(false),\n      _useState16 = _slicedToArray(_useState15, 2),\n      fullDescription = _useState16[0],\n      showFullDescription = _useState16[1];\n\n  useEffect(function () {\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups, \"/\").concat(group.id), {\n      method: 'post',\n      body: JSON.stringify({\n        context: 'meta',\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        setMeta(data.data);\n      }\n    });\n  }, []);\n  return wp.element.createElement(Fragment, null, newGroup ? wp.element.createElement(_newgroup_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    group: group,\n    newgroup: function newgroup(rgroup) {\n      if (rgroup) {\n        setGroup(rgroup);\n        setNewGroup(false);\n      } else {\n        setNewGroup(false);\n      }\n    }\n  }) : wp.element.createElement(\"div\", {\n    className: \"vibebp_full_group\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_head\"\n  }, wp.element.createElement(\"div\", {\n    className: \"leftright_wrapper group_top\"\n  }, wp.element.createElement(\"div\", {\n    className: \"left_side\"\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: function onClick() {\n      props.show();\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"right_side\"\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-image\",\n    onClick: function onClick() {\n      setCoverImage(true);\n    }\n  }), wp.element.createElement(\"i\", {\n    className: \"vicon vicon-settings\",\n    onClick: function onClick() {\n      setNewGroup(true);\n    }\n  }))), wp.element.createElement(\"div\", {\n    className: \"group_bottom\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_avatar\"\n  }, wp.element.createElement(\"img\", {\n    src: group.avatar\n  })), wp.element.createElement(\"div\", {\n    className: \"group_title\"\n  }, wp.element.createElement(\"h1\", null, group.name), wp.element.createElement(\"div\", {\n    className: fullDescription ? 'group_description active' : 'group_description',\n    onClick: function onClick() {\n      if (fullDescription) {\n        showFullDescription(false);\n      }\n    }\n  }, group.description, !fullDescription && group.description.length > 180 ? wp.element.createElement(\"span\", {\n    className: \"more\",\n    onClick: function onClick() {\n      showFullDescription(true);\n    }\n  }, window.vibebp.translations.more) : '')))), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : wp.element.createElement(\"div\", {\n    className: \"leftright_wrapper\"\n  }, wp.element.createElement(\"div\", {\n    className: \"left_side\"\n  }, wp.element.createElement(_activity_activities__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"group\",\n    id: props.group.id\n  })), wp.element.createElement(\"div\", {\n    className: \"right_side\"\n  }, _typeof(meta) === 'object' ? wp.element.createElement(\"span\", {\n    className: \"vicon vicon-user\"\n  }, meta.total_member_count[0]) : '', wp.element.createElement(_members_members__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    type: \"groups\",\n    id: props.group.id\n  }), _typeof(meta) === 'object' ? Object.keys(meta).map(function (meta_key) {\n    if (meta_key !== 'invite_status' && meta_key !== 'last_activity' && meta_key !== 'total_member_count') {\n      var event = new CustomEvent(\"meta_key\", {\n        detail: meta[meta_key]\n      });\n      document.dispatchEvent(event);\n      return wp.element.createElement(\"div\", {\n        id: meta_key\n      });\n    }\n  }) : ''))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FullGroup);\n\n//# sourceURL=webpack:///./src/profile/components/groups/fullgroup.js?");

/***/ }),

/***/ "./src/profile/components/groups/group.js":
/*!************************************************!*\
  !*** ./src/profile/components/groups/group.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Group = function Group(props) {\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_group\",\n    onClick: function onClick() {\n      props.show();\n    }\n  }, wp.element.createElement(\"div\", {\n    className: \"group_avatar\"\n  }, wp.element.createElement(\"img\", {\n    src: props.group.avatar\n  })), wp.element.createElement(\"div\", {\n    className: \"group_name\"\n  }, wp.element.createElement(\"strong\", null, props.group.name)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Group);\n\n//# sourceURL=webpack:///./src/profile/components/groups/group.js?");

/***/ }),

/***/ "./src/profile/components/groups/groupinvite.js":
/*!******************************************************!*\
  !*** ./src/profile/components/groups/groupinvite.js ***!
  \******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _timer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../timer */ \"./src/profile/components/timer.js\");\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar GroupInvite = function GroupInvite(props) {\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_group_invite\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_avatar\"\n  }, wp.element.createElement(\"img\", {\n    src: props.invite.item.avatar\n  })), wp.element.createElement(\"div\", {\n    className: \"group_name\"\n  }, wp.element.createElement(\"strong\", null, props.invite.item.name), wp.element.createElement(\"span\", null, window.vibebp.components.groups[props.invite.item.status])), wp.element.createElement(\"div\", {\n    className: \"inviter\"\n  }, wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"user\",\n    id: {\n      user_id: props.invite.inviter_id\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"group_invite_time\"\n  }, wp.element.createElement(_timer__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    time: props.invite.item.date_modified\n  })), wp.element.createElement(\"div\", {\n    className: \"group_actions\"\n  }, wp.element.createElement(\"a\", {\n    className: \"vicon vicon-check\",\n    onClick: function onClick() {\n      props.action(props.invite.item.id, 'accept', props.invite.id);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-close\",\n    onClick: function onClick() {\n      props.action(props.invite.item.id, 'reject', props.invite.id);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-trash\",\n    onClick: function onClick() {\n      props.action(props.invite.item.id, 'delete', props.invite.id);\n    }\n  })));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (GroupInvite);\n\n//# sourceURL=webpack:///./src/profile/components/groups/groupinvite.js?");

/***/ }),

/***/ "./src/profile/components/groups/groups.js":
/*!*************************************************!*\
  !*** ./src/profile/components/groups/groups.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _timer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../timer.js */ \"./src/profile/components/timer.js\");\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _fullgroup_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fullgroup.js */ \"./src/profile/components/groups/fullgroup.js\");\n/* harmony import */ var _group_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./group.js */ \"./src/profile/components/groups/group.js\");\n/* harmony import */ var _groupinvite_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./groupinvite.js */ \"./src/profile/components/groups/groupinvite.js\");\n/* harmony import */ var _newgroup_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./newgroup.js */ \"./src/profile/components/groups/newgroup.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Groups = function Groups(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      groupInvites = _useState2[0],\n      setGroupInvites = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    orderby: '',\n    accepted: 'pending'\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      inviteArgs = _useState4[0],\n      setInviteArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      groups = _useState6[0],\n      setGroups = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isLoading = _useState8[0],\n      setisLoading = _useState8[1];\n\n  var _useState9 = useState(window.vibebp.components.groups.actions),\n      _useState10 = _slicedToArray(_useState9, 2),\n      actions = _useState10[0],\n      setActions = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      groupFilters = _useState12[0],\n      setGroupFilters = _useState12[1];\n\n  var _useState13 = useState(false),\n      _useState14 = _slicedToArray(_useState13, 2),\n      showMenu = _useState14[0],\n      setShowMenu = _useState14[1];\n\n  var _useState15 = useState({\n    mine: 'unread',\n    type: '',\n    page: 1,\n    search_terms: '',\n    label: ''\n  }),\n      _useState16 = _slicedToArray(_useState15, 2),\n      args = _useState16[0],\n      setArgs = _useState16[1];\n\n  var _useState17 = useState(false),\n      _useState18 = _slicedToArray(_useState17, 2),\n      more = _useState18[0],\n      setMore = _useState18[1];\n\n  var _useState19 = useState(false),\n      _useState20 = _slicedToArray(_useState19, 2),\n      isPagination = _useState20[0],\n      setIsPagination = _useState20[1];\n\n  var _useState21 = useState(false),\n      _useState22 = _slicedToArray(_useState21, 2),\n      newGroup = _useState22[0],\n      setnewGroup = _useState22[1];\n\n  var _useState23 = useState(false),\n      _useState24 = _slicedToArray(_useState23, 2),\n      showGroup = _useState24[0],\n      setshowGroup = _useState24[1];\n\n  var _useState25 = useState(false),\n      _useState26 = _slicedToArray(_useState25, 2),\n      newLabel = _useState26[0],\n      setNewLabel = _useState26[1];\n\n  var _useState27 = useState({\n    text: '',\n    color: '#000'\n  }),\n      _useState28 = _slicedToArray(_useState27, 2),\n      labelargs = _useState28[0],\n      setlabelArgs = _useState28[1];\n\n  var _useState29 = useState([]),\n      _useState30 = _slicedToArray(_useState29, 2),\n      labels = _useState30[0],\n      setLabels = _useState30[1];\n\n  var _useState31 = useState(''),\n      _useState32 = _slicedToArray(_useState31, 2),\n      activeTab = _useState32[0],\n      setActiveTab = _useState32[1];\n\n  useEffect(function () {\n    var group_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'groups';\n    });\n    group_filters.map(function (filter, index) {\n      if (group_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        group_filters[index][\"class\"].push('current-menu-item'); // setActiveTab(group_filters[index].css_id);\n      }\n    });\n    setGroupFilters(group_filters);\n  }, []);\n  useEffect(function () {\n    if (activeTab === 'invites') {\n      setisLoading(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups, \"/\").concat(activeTab), {\n        method: 'post',\n        body: JSON.stringify(_objectSpread({}, inviteArgs, {\n          token: select('vibebp').getToken()\n        }))\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setisLoading(false);\n\n        if (data.status) {\n          if (isPagination) {\n            var ngroupInvites = _toConsumableArray(groupInvites);\n\n            data.data.invites.map(function (invite) {\n              ngroupInvites.push(invite);\n            });\n            setGroupInvites(ngroups);\n            setIsPagination(false);\n\n            if (ngroupInvites.length < data.data.total) {\n              setMore(true);\n            } else {\n              setMore(false);\n            }\n          } else {\n            setGroupInvites(data.data.invites);\n\n            if (data.data.invites.length < data.data.total) {\n              setMore(true);\n            } else {\n              setMore(false);\n            }\n          }\n        } else {\n          setGroupInvites([]);\n        }\n      });\n    } else {\n      var nargs = _objectSpread({}, args);\n\n      nargs['token'] = select('vibebp').getToken();\n      var user = select('vibebp').getUser();\n      nargs['user_id'] = user.id;\n      setisLoading(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups), {\n        method: 'post',\n        body: JSON.stringify(nargs)\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setisLoading(false);\n\n        if (data.status) {\n          if (isPagination) {\n            var _ngroups = _toConsumableArray(groups);\n\n            data.data.groups.map(function (groups) {\n              _ngroups.push(groups);\n            });\n            setGroups(_ngroups);\n            setIsPagination(false);\n\n            if (_ngroups.length < data.data.total) {\n              setMore(true);\n            } else {\n              setMore(false);\n            }\n          } else {\n            setGroups(data.data.groups);\n\n            if (data.data.groups.length < data.data.total) {\n              setMore(true);\n            } else {\n              setMore(false);\n            }\n          }\n        } else {\n          setGroups([]);\n        }\n      });\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups, \"/labels\"), {\n        method: 'post',\n        body: JSON.stringify({\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          if (Array.isArray(data.labels) && data.labels.length) {\n            setLabels(data.labels);\n          }\n        }\n      });\n    }\n  }, [args, inviteArgs, activeTab]);\n\n  var GroupInviteAction = function GroupInviteAction(group_id, action, invite_id) {\n    var ngroupInvites = _toConsumableArray(groupInvites);\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups, \"/invite/\").concat(group_id), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken(),\n        action: action\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {}\n    });\n    ngroupInvites.splice(groupInvites.findIndex(function (g) {\n      return g.id === invite_id;\n    }), 1);\n    setGroups(ngroupInvites);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.groups.label), groupFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n\n    if (filter.css_id !== 'compose') {\n      return wp.element.createElement(\"a\", {\n        className: classs,\n        onClick: function onClick(e) {\n          var nargs = _objectSpread({}, args);\n\n          nargs.filter = filter.css_id;\n          nargs.page = 1;\n          setshowGroup(false);\n          setnewGroup(false);\n\n          if (args.css_id !== nargs.filter) {\n            setArgs(nargs);\n          }\n\n          setActiveTab(filter.css_id);\n\n          var ffilters = _toConsumableArray(groupFilters);\n\n          var index = ffilters.findIndex(function (item) {\n            return item[\"class\"].indexOf('current-menu-item') > -1;\n          });\n          ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n          ffilters[i][\"class\"].push('current-menu-item');\n          setGroupFilters(ffilters);\n        }\n      }, filter.name);\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"labels\"\n  }, wp.element.createElement(\"div\", {\n    \"class\": \"labels_title\"\n  }, wp.element.createElement(\"span\", null, window.vibebp.translations.labels), wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      if (!newLabel) {\n        setNewLabel(true);\n      } else {\n        setNewLabel(false);\n      }\n    }\n  }, window.vibebp.translations.add_new)), newLabel ? wp.element.createElement(\"div\", {\n    className: \"newlabel_form\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: labelargs.text,\n    onChange: function onChange(e) {\n      var nlabelargs = _objectSpread({}, labelargs);\n\n      nlabelargs.text = e.target.value;\n      setlabelArgs(nlabelargs);\n    }\n  }), wp.element.createElement(\"label\", {\n    style: {\n      background: labelargs.color\n    }\n  }, wp.element.createElement(\"input\", {\n    type: \"color\",\n    onChange: function onChange(e) {\n      var nlabelargs = _objectSpread({}, labelargs);\n\n      nlabelargs.color = e.target.value;\n      setlabelArgs(nlabelargs);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary vicon vicon-plus\",\n    onClick: addNewLabel\n  })) : '', labels.length ? wp.element.createElement(\"ul\", {\n    className: \"message_labels\"\n  }, labels.map(function (label, i) {\n    var classs = '';\n\n    if (args.label == label.slug) {\n      classs = 'active';\n    }\n\n    return wp.element.createElement(\"li\", {\n      className: classs\n    }, wp.element.createElement(\"label\", null, wp.element.createElement(\"strong\", {\n      onClick: function onClick() {\n        return setActiveLabel(label);\n      }\n    }, wp.element.createElement(\"span\", {\n      style: {\n        borderColor: label.color\n      }\n    }), label.name), wp.element.createElement(\"span\", {\n      className: \"vicon vicon-trash\",\n      onClick: function onClick() {\n        return removeLabel(i);\n      }\n    })), wp.element.createElement(\"span\", {\n      onClick: function onClick() {\n        return setActiveLabel(label);\n      }\n    }, label.count));\n  })) : '')), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, newGroup ? wp.element.createElement(_newgroup_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"], {\n    newgroup: function newgroup(group) {\n      if (group) {\n        var _ngroups2 = _toConsumableArray(groups);\n\n        _ngroups2.unshift(group);\n\n        setGroups(_ngroups2);\n        setnewGroup(false);\n        setshowGroup(0);\n      } else {\n        setnewGroup(false);\n      }\n    }\n  }) : showGroup !== false ? wp.element.createElement(_fullgroup_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    group: groups[showGroup],\n    show: function show() {\n      setshowGroup(false);\n    }\n  }) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_main_head\"\n  }, activeTab === 'invites' ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: inviteArgs.search_terms,\n    onChange: function onChange(e) {\n      var ninviteArgs = _objectSpread({}, inviteArgs);\n\n      ninviteArgs.search_terms = e.target.value;\n      setInviteArgs(ninviteArgs);\n    }\n  })), wp.element.createElement(\"div\", null, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      var ninviteArgs = _objectSpread({}, inviteArgs);\n\n      ninviteArgs.accepted = e.target.value;\n      setInviteArgs(ninviteArgs);\n    }\n  }, Object.keys(window.vibebp.components.groups.invite_type).map(function (invite_type) {\n    return wp.element.createElement(\"option\", {\n      value: invite_type\n    }, window.vibebp.components.groups.invite_type[invite_type]);\n  })), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      var ninviteArgs = _objectSpread({}, inviteArgs);\n\n      ninviteArgs.orderby = e.target.value;\n      setInviteArgs(ninviteArgs);\n    }\n  }, Object.keys(window.vibebp.components.groups.invite_sort).map(function (invite_sort) {\n    return wp.element.createElement(\"option\", {\n      value: invite_sort\n    }, window.vibebp.components.groups.invite_sort[invite_sort]);\n  })))) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.search_terms,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.search_terms = e.target.value;\n      setArgs(nargs);\n    }\n  })), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.type = e.target.value;\n      setArgs(nargs);\n    }\n  }, Object.keys(window.vibebp.components.groups.sorters).map(function (sorter) {\n    return wp.element.createElement(\"option\", {\n      value: sorter\n    }, window.vibebp.components.groups.sorters[sorter]);\n  })))), activeTab === 'invites' ? wp.element.createElement(\"div\", {\n    className: \"group_invites\"\n  }, !groupInvites.length && !isLoading ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_groups_found)) : wp.element.createElement(Fragment, null, groupInvites.length ? groupInvites.map(function (invite, index) {\n    return wp.element.createElement(_groupinvite_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n      invite: invite,\n      action: GroupInviteAction\n    });\n  }) : '')) : wp.element.createElement(\"div\", {\n    className: \"grouplist\"\n  }, !groups.length && !isLoading ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_groups_found), wp.element.createElement(\"div\", {\n    className: \"vibebp_groups\"\n  }, wp.element.createElement(\"div\", {\n    className: \"new_group\",\n    onClick: function onClick() {\n      setnewGroup(true);\n    }\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-plus\"\n  })))) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_groups\"\n  }, wp.element.createElement(\"div\", {\n    className: \"new_group\",\n    onClick: function onClick() {\n      setnewGroup(true);\n    }\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-plus\"\n  })), groups.length ? groups.map(function (group, index) {\n    return wp.element.createElement(_group_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      group: group,\n      show: function show() {\n        setshowGroup(index);\n      }\n    });\n  }) : ''), more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page = args.page + 1;\n      setIsPagination(true);\n      setArgs(nargs);\n    }\n  }, window.vibebp.translations.more) : '')))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Groups);\n\n//# sourceURL=webpack:///./src/profile/components/groups/groups.js?");

/***/ }),

/***/ "./src/profile/components/groups/newgroup.js":
/*!***************************************************!*\
  !*** ./src/profile/components/groups/newgroup.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _uploader_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../uploader.js */ \"./src/profile/components/uploader.js\");\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar NewGroup = function NewGroup(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    avatar: {\n      url: '',\n      cropdata: ''\n    },\n    name: '',\n    description: '',\n    status: 'public',\n    invite_status: 'members',\n    invitees: []\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      form = _useState4[0],\n      setForm = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      files = _useState6[0],\n      setFiles = _useState6[1];\n\n  var _useState7 = useState(''),\n      _useState8 = _slicedToArray(_useState7, 2),\n      memberSearch = _useState8[0],\n      setMemberSearch = _useState8[1];\n\n  var _useState9 = useState([]),\n      _useState10 = _slicedToArray(_useState9, 2),\n      searchResults = _useState10[0],\n      setSearchResults = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      memberSearching = _useState12[0],\n      setMemberSearhcing = _useState12[1];\n\n  var _useState13 = useState(true),\n      _useState14 = _slicedToArray(_useState13, 2),\n      showUploader = _useState14[0],\n      setShowUploader = _useState14[1];\n\n  useEffect(function () {\n    if (props.hasOwnProperty('group')) {\n      console.log(props.group);\n      var avatar = {\n        url: props.group.avatar,\n        cropdata: ''\n      };\n\n      if (props.group.avatar.length) {\n        setShowUploader(false);\n      }\n\n      setForm(_objectSpread({}, form, {\n        id: props.group.id,\n        name: props.group.name,\n        description: props.group.description,\n        status: props.group.status,\n        avatar: avatar\n      }));\n    }\n  }, []);\n  useEffect(function () {\n    if (memberSearch.length > 3) {\n      setMemberSearhcing(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/search\"), {\n        method: 'post',\n        body: JSON.stringify({\n          search: memberSearch,\n          type: 'user',\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          setMemberSearhcing(false);\n\n          if (Array.isArray(data.results)) {\n            data.results.map(function (user) {\n              localforage.setItem('user_' + user.id, JSON.stringify(user));\n            });\n            setSearchResults(data.results);\n          }\n        }\n      });\n    }\n  }, [memberSearch]);\n\n  var createGroup = function createGroup() {\n    setisLoading(true);\n\n    var nform = _objectSpread({}, form, {\n      token: select('vibebp').getToken()\n    });\n\n    var formData = new FormData();\n    formData.append(\"body\", JSON.stringify(nform));\n    formData.append(\"file\", files[0]);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.groups, \"/create_update_group\"), {\n      method: 'post',\n      body: formData\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        props.newgroup(data.data);\n      }\n    });\n  };\n\n  var buttonClass = 'button is-fullwidth is-primary is-rounded';\n\n  if (isLoading) {\n    buttonClass += ' is-loading';\n  }\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_create_group create_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"create_form_head\"\n  }, wp.element.createElement(\"div\", {\n    className: \"left_side\"\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: function onClick() {\n      props.newgroup(false);\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"right_side\"\n  })), wp.element.createElement(\"div\", {\n    className: \"group_creation_steps\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_step\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_avatar\"\n  }, form.avatar.url.length && !showUploader ? wp.element.createElement(Fragment, null, wp.element.createElement(\"img\", {\n    src: form.avatar.url\n  }), wp.element.createElement(\"div\", {\n    onClick: function onClick() {\n      setShowUploader(true);\n    },\n    className: \"vicon vicon-image\"\n  })) : wp.element.createElement(Fragment, null, wp.element.createElement(_uploader_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"image\",\n    crop: \"1\",\n    show: function show() {\n      return setShowUploader(false);\n    },\n    update: function update(mfiles, cropdata) {\n      setFiles(mfiles);\n\n      var nform = _objectSpread({}, form);\n\n      nform.avatar.cropdata = cropdata;\n      setForm(nform);\n    }\n  }), wp.element.createElement(\"div\", {\n    onClick: function onClick() {\n      setShowUploader(false);\n    },\n    className: \"vicon vicon-image\"\n  }))), wp.element.createElement(\"div\", {\n    className: \"group_creation_step vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_name vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.group_name), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: form.name,\n    onChange: function onChange(e) {\n      setForm(_objectSpread({}, form, {\n        name: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"group_description vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.group_description), wp.element.createElement(\"textarea\", {\n    onChange: function onChange(e) {\n      setForm(_objectSpread({}, form, {\n        description: e.target.value\n      }));\n    },\n    value: form.description\n  })))), wp.element.createElement(\"div\", {\n    className: \"group_step vibebp_form\"\n  }, window.vibebp.components.groups.hasOwnProperty('type') ? wp.element.createElement(\"div\", {\n    className: \"group_name vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.group_type), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setForm(_objectSpread({}, form, {\n        status: e.target.value\n      }));\n    },\n    value: form.status\n  }, Object.keys(window.vibebp.components.groups.type).map(function (i) {\n    return wp.element.createElement(\"option\", {\n      value: i\n    }, window.vibebp.components.groups.type[i]);\n  }))) : '', wp.element.createElement(\"div\", {\n    className: \"group_name vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.group_invitations), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setForm(_objectSpread({}, form, {\n        invite_status: e.target.value\n      }));\n    },\n    value: form.status\n  }, Object.keys(window.vibebp.components.groups.invite_status).map(function (i) {\n    return wp.element.createElement(\"option\", {\n      value: i\n    }, window.vibebp.components.groups.invite_status[i]);\n  })))), wp.element.createElement(\"div\", {\n    className: \"vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"group_name vibebp_form_field\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipients\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.invite_members), wp.element.createElement(\"div\", {\n    className: \"recipients_list\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipient_items\"\n  }, form.invitees.map(function (member) {\n    return wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      type: \"user\",\n      click: function click() {\n        var nform = _objectSpread({}, form);\n\n        nform.invitees.splice(nform.invitees.indexOf(member), 1);\n        setForm(nform);\n      },\n      id: {\n        user_id: member\n      }\n    });\n  })), wp.element.createElement(\"div\", {\n    className: memberSearching ? 'control is-loading' : 'control'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: memberSearch,\n    placeholder: window.vibebp.translations.search_member,\n    onChange: function onChange(e) {\n      setMemberSearch(e.target.value);\n    }\n  }))), searchResults.length ? wp.element.createElement(\"div\", {\n    className: \"search_results\"\n  }, searchResults.map(function (user, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"search_result user\",\n      onClick: function onClick() {\n        setMemberSearch('');\n\n        var nsearchResults = _toConsumableArray(searchResults);\n\n        var nform = _objectSpread({}, form);\n\n        if (nform.invitees.indexOf(user.id) === -1) {\n          nform.invitees.push(user.id);\n          setForm(nform);\n          nsearchResults.splice(i, 1);\n          setSearchResults(nsearchResults);\n        }\n      }\n    }, wp.element.createElement(\"img\", {\n      src: user.avatar\n    }), wp.element.createElement(\"span\", null, user.name));\n  })) : ''))), wp.element.createElement(\"br\", null), wp.element.createElement(\"a\", {\n    onClick: createGroup,\n    className: buttonClass\n  }, window.vibebp.translations.create_group)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (NewGroup);\n\n//# sourceURL=webpack:///./src/profile/components/groups/newgroup.js?");

/***/ }),

/***/ "./src/profile/components/kb/articles.js":
/*!***********************************************!*\
  !*** ./src/profile/components/kb/articles.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _fullarticle__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./fullarticle */ \"./src/profile/components/kb/fullarticle.js\");\n/* harmony import */ var _context_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./context.js */ \"./src/profile/components/kb/context.js\");\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render,\n    useContext = _wp$element.useContext;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\n\n\n\nvar Articles = function Articles(props) {\n  var kbContext = useContext(_context_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n\n  var _useState = useState({\n    type: props.type,\n    article_type: '',\n    page: 1,\n    s: '',\n    order: 'recent'\n  }),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isLoading = _useState4[0],\n      setisLoading = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      more = _useState6[0],\n      setMore = _useState6[1];\n\n  var _useState7 = useState([]),\n      _useState8 = _slicedToArray(_useState7, 2),\n      articles = _useState8[0],\n      setArticles = _useState8[1];\n\n  var _useState9 = useState([]),\n      _useState10 = _slicedToArray(_useState9, 2),\n      types = _useState10[0],\n      setTypes = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      fullArticle = _useState12[0],\n      setFullArticle = _useState12[1];\n\n  var user = select('vibebp').getUser();\n  useEffect(function () {\n    console.log('chaned');\n    setArgs(_objectSpread({}, args, {\n      type: props.type\n    }));\n  }, [props.type]);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_2__[\"useThrottledEffect\"])(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setArticles(data.articles);\n      }\n    });\n  }, 500, [args]);\n  useEffect(function () {\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles/type\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        setTypes(data.types);\n        kbContext.update('types', data.types);\n      }\n    });\n  }, []);\n\n  var updateArticle = function updateArticle(type, data) {\n    var narticles = _toConsumableArray(articles);\n\n    switch (type) {\n      case 'remove':\n        narticles.splice(articles.findIndex(function (a) {\n          return a.id === data;\n        }), 1);\n        break;\n\n      case 'addshared':\n        var ashared = _toConsumableArray(narticles[articles.findIndex(function (a) {\n          return a.id === data;\n        })].shared);\n\n        ashared.push(data);\n        narticles[articles.findIndex(function (a) {\n          return a.id === data;\n        })].shared = ashared;\n        break;\n\n      case 'removeshared':\n        var rshared = _toConsumableArray(narticles[articles.findIndex(function (a) {\n          return a.id === data;\n        })].shared);\n\n        if (rshared.length) {\n          rshared.splice(shared.indexOf(data), 1);\n        }\n\n        narticles[articles.findIndex(function (a) {\n          return a.id === data;\n        })].shared = rshared;\n        break;\n\n      case 'update':\n        narticles[articles.findIndex(function (a) {\n          return a.id === data;\n        })] = data;\n        break;\n    }\n\n    setArticles(narticles);\n    setFullArticle(false);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_articles_wrapper\"\n  }, fullArticle ? wp.element.createElement(_fullarticle__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    article: fullArticle,\n    back: function back() {\n      setFullArticle(false);\n    },\n    update: updateArticle\n  }) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_articles_header vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.s,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        s: e.target.value\n      }));\n    },\n    placeholder: window.vibebp.translations.search_text\n  }), types.length ? wp.element.createElement(\"select\", {\n    value: args.article_type,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        article_type: e.target.value\n      }));\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.article_category), types.length ? types.map(function (type) {\n    return wp.element.createElement(\"option\", {\n      value: type.term_id\n    }, type.name);\n  }) : '') : ''), wp.element.createElement(\"select\", {\n    value: args.order,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        order: e.target.value\n      }));\n    }\n  }, Object.keys(window.vibebp.components.kb.sorters).map(function (key) {\n    return wp.element.createElement(\"option\", {\n      value: key\n    }, window.vibebp.components.kb.sorters[key]);\n  }))), isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : articles.length ? wp.element.createElement(\"div\", {\n    className: \"vibebp_articles\"\n  }, articles.map(function (article) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_article\",\n      onClick: function onClick() {\n        setFullArticle(article);\n      }\n    }, wp.element.createElement(\"div\", null, wp.element.createElement(\"h3\", null, article.post_title), wp.element.createElement(\"span\", {\n      className: \"article_meta\"\n    }, wp.element.createElement(\"span\", {\n      className: \"article_date\"\n    }, article.post_date), article.type.length && types.length ? article.type.map(function (type) {\n      return wp.element.createElement(\"span\", {\n        className: \"article_type\"\n      }, types[types.findIndex(function (t) {\n        return type == t.term_id;\n      })].name);\n    }) : '')), wp.element.createElement(\"div\", {\n      className: \"vibebp_article_members\"\n    }, wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      type: \"user\",\n      id: {\n        'user_id': article.post_author\n      }\n    }), article.shared && article.shared.length ? wp.element.createElement(Fragment, null, article.shared.map(function (u, i) {\n      if (i < 5) {\n        return wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n          type: \"user\",\n          id: {\n            'user_id': u.user_id\n          }\n        });\n      }\n    }), article.shared.length > 5 ? wp.element.createElement(\"span\", null, \"+\", article.shared.length - 5) : '') : ''));\n  })) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_articles)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Articles);\n\n//# sourceURL=webpack:///./src/profile/components/kb/articles.js?");

/***/ }),

/***/ "./src/profile/components/kb/context.js":
/*!**********************************************!*\
  !*** ./src/profile/components/kb/context.js ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar createContext = wp.element.createContext;\nvar KbContext = createContext({});\n/* harmony default export */ __webpack_exports__[\"default\"] = (KbContext);\n\n//# sourceURL=webpack:///./src/profile/components/kb/context.js?");

/***/ }),

/***/ "./src/profile/components/kb/fullarticle.js":
/*!**************************************************!*\
  !*** ./src/profile/components/kb/fullarticle.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./context */ \"./src/profile/components/kb/context.js\");\n/* harmony import */ var _newarticle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./newarticle */ \"./src/profile/components/kb/newarticle.js\");\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render,\n    useContext = _wp$element.useContext;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\n\n\n\nvar FullArticle = function FullArticle(props) {\n  var kbContext = useContext(_context__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n  var user = select('vibebp').getUser();\n\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      editArticle = _useState2[0],\n      setEditArticle = _useState2[1];\n\n  var _useState3 = useState(props.article),\n      _useState4 = _slicedToArray(_useState3, 2),\n      fullArticle = _useState4[0],\n      setFullArticle = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      addParticipants = _useState6[0],\n      setAddParticipants = _useState6[1];\n\n  var _useState7 = useState(''),\n      _useState8 = _slicedToArray(_useState7, 2),\n      participantSearch = _useState8[0],\n      setParticipantSearch = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      isSearching = _useState10[0],\n      setIsSearching = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      searchResults = _useState12[0],\n      setSearchResults = _useState12[1];\n\n  var deletePost = function deletePost() {\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles/trash\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken(),\n        article_id: fullArticle.id\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.hasOwnProperty('message')) {\n        dispatch('vibebp').addNotification({\n          text: data.message\n        });\n      }\n\n      if (data.status) {\n        props.update('remove', fullArticle.id);\n      }\n    });\n  };\n\n  Object(_functions__WEBPACK_IMPORTED_MODULE_2__[\"useThrottledEffect\"])(function () {\n    if (participantSearch.length > 4) {\n      setIsSearching(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/search\"), {\n        method: 'post',\n        body: JSON.stringify({\n          search: participantSearch,\n          type: 'user',\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setIsSearching(false);\n\n        if (data.status) {\n          if (Array.isArray(data.results)) {\n            setSearchResults(data.results);\n          }\n        }\n      });\n    }\n  }, 500, [participantSearch]);\n\n  var addShared = function addShared(usr) {\n    setParticipantSearch('');\n\n    var nsearchResults = _toConsumableArray(searchResults);\n\n    var nfullArticle = _objectSpread({}, fullArticle);\n\n    if (!nfullArticle.shared) {\n      nfullArticle.shared = [];\n    }\n\n    if (nfullArticle.shared.indexOf(usr.id) === -1) {\n      nfullArticle.shared.push(usr.id);\n      setFullArticle(nfullArticle);\n      nsearchResults.splice(i, 1);\n      setSearchResults(nsearchResults);\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles/addShared\"), {\n      method: 'post',\n      body: JSON.stringify({\n        article_id: fullArticle.id,\n        user_id: usr.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n\n          if (select('vibebp').getOnlineMembers().indexOf(usr.id) !== -1) {\n            dispatch('vibebp').sendRealTimeNotification(usr.id, data.recievingmessage);\n          }\n        }\n\n        props.update('addshared', usr.id);\n      }\n    });\n  };\n\n  var removeShared = function removeShared(usr, i) {\n    var nfullArticle = _objectSpread({}, fullArticle);\n\n    nfullArticle.shared.splice(nfullArticle.shared.indexOf(usr), 1);\n    setFullArticle(nfullArticle);\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles/removeShared\"), {\n      method: 'post',\n      body: JSON.stringify({\n        article_id: fullArticle.id,\n        user_id: usr.id,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n\n        props.update('removeshared', usr.id);\n      }\n    });\n  };\n\n  return wp.element.createElement(Fragment, null, editArticle ? wp.element.createElement(_newarticle__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    article: fullArticle,\n    created: function created(article) {\n      setFullArticle(article);\n      props.update('update', article);\n    },\n    back: function back() {\n      setEditArticle(false);\n    }\n  }) : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_articles_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  }), wp.element.createElement(\"span\", null, fullArticle.post_author === user.id ? wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-pencil\",\n    onClick: function onClick() {\n      setEditArticle(true);\n    }\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-trash\",\n    onClick: deletePost\n  })) : wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    type: \"user\",\n    id: {\n      user_id: parseInt(fullArticle.post_author)\n    }\n  }))), wp.element.createElement(\"h1\", null, fullArticle.post_title), wp.element.createElement(\"span\", {\n    className: \"article_meta\"\n  }, wp.element.createElement(\"span\", {\n    className: \"article_date\"\n  }, fullArticle.post_date), fullArticle.type && fullArticle.type.length ? wp.element.createElement(\"span\", {\n    className: \"article_type\"\n  }, fullArticle.type.map(function (type) {\n    return wp.element.createElement(\"span\", null, kbContext.types[kbContext.types.findIndex(function (t) {\n      return type == t.term_id;\n    })].name);\n  })) : ''), wp.element.createElement(\"div\", {\n    className: \"vibebp_article_content\",\n    dangerouslySetInnerHTML: {\n      __html: fullArticle.post_content\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"article_participants\"\n  }, wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    type: \"user\",\n    id: {\n      user_id: fullArticle.post_author\n    }\n  }), fullArticle.shared && fullArticle.shared.length ? wp.element.createElement(Fragment, null, fullArticle.shared.map(function (share) {\n    return wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      type: \"user\",\n      id: {\n        user_id: share\n      },\n      click: function click() {\n        removeShared(share);\n      }\n    });\n  })) : '', fullArticle.post_author === user.id ? wp.element.createElement(\"span\", {\n    onClick: function onClick() {\n      setAddParticipants(!addParticipants);\n    }\n  }, wp.element.createElement(\"span\", {\n    className: addParticipants ? 'vicon vicon-close' : 'vicon vicon-plus'\n  })) : ''), addParticipants ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: isSearching ? 'vibebp_form control is-loading' : 'vibebp_form control'\n  }, wp.element.createElement(\"input\", {\n    className: \"vibebp_form_field\",\n    type: \"text\",\n    value: participantSearch,\n    placeholder: window.vibebp.translations.search_member,\n    onChange: function onChange(e) {\n      setParticipantSearch(e.target.value);\n    }\n  })), searchResults.length ? wp.element.createElement(\"div\", {\n    className: \"search_results\"\n  }, searchResults.map(function (usr, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"search_result user\",\n      onClick: function onClick() {\n        addShared(usr, i);\n      }\n    }, wp.element.createElement(\"img\", {\n      src: usr.avatar\n    }), wp.element.createElement(\"span\", null, usr.name));\n  })) : '') : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FullArticle);\n\n//# sourceURL=webpack:///./src/profile/components/kb/fullarticle.js?");

/***/ }),

/***/ "./src/profile/components/kb/kb.js":
/*!*****************************************!*\
  !*** ./src/profile/components/kb/kb.js ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _context__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./context */ \"./src/profile/components/kb/context.js\");\n/* harmony import */ var _newarticle__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./newarticle */ \"./src/profile/components/kb/newarticle.js\");\n/* harmony import */ var _fullarticle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fullarticle */ \"./src/profile/components/kb/fullarticle.js\");\n/* harmony import */ var _articles__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./articles */ \"./src/profile/components/kb/articles.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render,\n    useContext = _wp$element.useContext;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\n\n\n\nvar Kb = function Kb(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      kbContext = _useState2[0],\n      setKbContext = _useState2[1];\n\n  var updateContext = function updateContext(type, value) {\n    var nkbContext = _objectSpread({}, kbContext);\n\n    if (type === 'remove') {\n      delete nkbContext[value];\n    } else {\n      nkbContext[type] = value;\n    }\n\n    setKbContext(nkbContext);\n  };\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      kbFilters = _useState4[0],\n      setKbFilters = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      args = _useState6[0],\n      setArgs = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      activeTab = _useState8[0],\n      setActiveTab = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      newArticle = _useState10[0],\n      setNewArticle = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      fullArticle = _useState12[0],\n      setFullArticle = _useState12[1];\n\n  useEffect(function () {\n    var kb_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'kb';\n    });\n    kb_filters.map(function (filter, index) {\n      if (kb_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        kb_filters[index][\"class\"].push('current-menu-item');\n      }\n    });\n    setKbFilters(kb_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.kb.label), wp.element.createElement(\"a\", {\n    className: \"button is-primary new_mail\",\n    onClick: function onClick() {\n      setNewArticle(true);\n    }\n  }, window.vibebp.translations.create_article), kbFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n    return wp.element.createElement(\"a\", {\n      className: classs,\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n        nargs.page = 1;\n\n        if (args.css_id !== nargs.filter) {\n          setArgs(nargs);\n        }\n\n        setActiveTab(filter.css_id);\n\n        var ffilters = _toConsumableArray(kbFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setKbFilters(ffilters);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, wp.element.createElement(_context__WEBPACK_IMPORTED_MODULE_0__[\"default\"].Provider, {\n    value: _objectSpread({}, kbContext, {\n      update: updateContext\n    })\n  }, fullArticle ? wp.element.createElement(_fullarticle__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n    article: fullArticle,\n    back: function back() {\n      setNewArticle(false);\n      setFullArticle(false);\n    }\n  }) : newArticle ? wp.element.createElement(_newarticle__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    back: function back() {\n      setNewArticle(false);\n    },\n    created: function created(article) {\n      setFullArticle(article);\n    }\n  }) : activeTab === 'shared_articles' ? wp.element.createElement(_articles__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    type: \"shared\"\n  }) : activeTab === 'my_articles' ? wp.element.createElement(_articles__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    type: \"mine\"\n  }) : wp.element.createElement(_articles__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    type: \"all\"\n  }))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Kb);\n\n//# sourceURL=webpack:///./src/profile/components/kb/kb.js?");

/***/ }),

/***/ "./src/profile/components/kb/newarticle.js":
/*!*************************************************!*\
  !*** ./src/profile/components/kb/newarticle.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _context_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./context.js */ \"./src/profile/components/kb/context.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render,\n    useContext = _wp$element.useContext;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\nvar NewArticle = function NewArticle(props) {\n  var kbContext = useContext(_context_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]);\n\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    post_title: '',\n    post_content: '',\n    'raw': '',\n    type: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState({}),\n      _useState6 = _slicedToArray(_useState5, 2),\n      postContent = _useState6[0],\n      setPostContent = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      showPreview = _useState8[0],\n      setShowPreview = _useState8[1];\n\n  useEffect(function () {\n    if (props.hasOwnProperty('article')) {\n      setArgs(_objectSpread({}, args, {\n        id: props.article.id,\n        post_title: props.article.post_title,\n        post_cotent: props.article.post_content,\n        raw: props.article.raw,\n        type: props.article.type\n      }));\n    }\n  }, []);\n  useEffect(function () {\n    var event = new CustomEvent('load_vibe_editor', {\n      detail: {\n        'selector': '.vibe_article_editor',\n        'content': props.hasOwnProperty('article') ? props.article.post_content : '',\n        'raw': props.hasOwnProperty('article') ? props.article.raw : '',\n        'components': 'editor',\n        'updater': 'vibe_article'\n      }\n    });\n    document.dispatchEvent(event);\n  }, []);\n  useEffect(function () {\n    document.addEventListener('vibe_editor_content_update_vibe_article', function (e) {\n      setPostContent({\n        post_content: e.detail.raw_html,\n        raw: e.detail.editor_content\n      });\n    });\n  }, []);\n\n  var postArticle = function postArticle() {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/user/articles/new\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        post_content: postContent.post_content,\n        'raw': postContent.raw,\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        props.created(data.article);\n        var followers = select('vibebp').getData('followers');\n        var onlineMembers = select('vibebp').getOnlineMembers();\n        followers.map(function (follower) {\n          if (onlineMembers.indexOf(follower) !== -1) {\n            dispatch('vibebp').sendRealTimeNotification(follower, data.followermessage);\n          }\n        });\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"new_article\"\n  }, showPreview ? wp.element.createElement(\"div\", {\n    className: \"vibebp_content_preview_wrapper\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_content_preview\"\n  }, wp.element.createElement(\"div\", {\n    className: \"new_article_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: function onClick() {\n      setShowPreview(false);\n    }\n  })), wp.element.createElement(\"h1\", {\n    className: \"title\"\n  }, args.post_title), wp.element.createElement(\"div\", {\n    className: \"post_content\",\n    dangerouslySetInnerHTML: {\n      __html: args.post_content\n    }\n  }))) : '', wp.element.createElement(\"div\", {\n    className: \"new_article_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  })), wp.element.createElement(\"div\", {\n    className: \"new_article_content vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.article_title), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.post_title,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        post_title: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"select\", {\n    value: args.type,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        type: e.target.value\n      }));\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.article_category), kbContext.hasOwnProperty('types') && kbContext.types.length ? kbContext.types.map(function (type) {\n    return wp.element.createElement(\"option\", {\n      value: type.term_id\n    }, type.name);\n  }) : '')), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.article_content), wp.element.createElement(\"div\", {\n    className: \"vibe_article_editor\"\n  }, wp.element.createElement(\"textarea\", {\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        post_content: e.target.value\n      }));\n      setPostContent(_objectSpread({}, postContent, {\n        'post_content': e.target.value\n      }));\n    },\n    value: args.post_content\n  }))), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"a\", {\n    className: \"button is-info\",\n    onClick: function onClick() {\n      setShowPreview(!showPreview);\n    }\n  }, window.vibebp.translations.preview), wp.element.createElement(\"a\", {\n    className: isLoading ? 'button is-primary is-loading' : 'button is-primary',\n    onClick: postArticle\n  }, window.vibebp.translations.submit))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (NewArticle);\n\n//# sourceURL=webpack:///./src/profile/components/kb/newarticle.js?");

/***/ }),

/***/ "./src/profile/components/members/member.js":
/*!**************************************************!*\
  !*** ./src/profile/components/members/member.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Member = function Member(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      showCard = _useState4[0],\n      setShowCard = _useState4[1];\n\n  var _useState5 = useState(props.member),\n      _useState6 = _slicedToArray(_useState5, 2),\n      member = _useState6[0],\n      setMember = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      cardDetails = _useState8[0],\n      setCardDetails = _useState8[1];\n\n  useEffect(function () {\n    console.log(member);\n\n    if (showCard && !cardDetails) {}\n  }, [showCard]);\n\n  var doAction = function doAction(action) {\n    props.action(action);\n\n    if (action === 'follow') {\n      setMember(_objectSpread({}, member, {\n        is_following: true\n      }));\n    }\n\n    if (action === 'unfollow') {\n      setMember(_objectSpread({}, member, {\n        is_following: false\n      }));\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/followers/action\"), {\n      method: 'post',\n      body: JSON.stringify({\n        action: action,\n        user: member,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"membercard\",\n    onClick: function onClick() {\n      setShowCard(true);\n    }\n  }, wp.element.createElement(\"img\", {\n    src: member.avatar\n  }), wp.element.createElement(\"div\", {\n    className: \"member_details\"\n  }, wp.element.createElement(\"strong\", null, member.display_name), wp.element.createElement(Fragment, null, member.hasOwnProperty('is_admin') ? member.is_admin ? wp.element.createElement(\"span\", {\n    className: \"is-highlight is-admin\"\n  }, window.vibebp.translations.admin) : member.is_mod ? wp.element.createElement(\"span\", {\n    className: \"is-highlight is-mod\"\n  }, window.vibebp.translations.mod) : '' : ''), wp.element.createElement(Fragment, null, member.hasOwnProperty('latest_update') && member.latest_update ? wp.element.createElement(\"span\", null, member.latest_update.content) : ''), wp.element.createElement(\"div\", {\n    className: \"request_actions\"\n  }, member.hasOwnProperty('is_friend') ? wp.element.createElement(\"a\", {\n    className: \"button is-warning is-small vicon vicon-na\",\n    onClick: props.unfriend\n  }) : member.hasOwnProperty('is_friend_request') ? wp.element.createElement(Fragment, null, wp.element.createElement(\"a\", {\n    className: \"button is-success is-small vicon vicon-thumb-up\",\n    onClick: function onClick() {\n      return props.action('accept');\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"button is-warning is-small vicon vicon-thumb-down\",\n    onClick: function onClick() {\n      return props.action('reject');\n    }\n  })) : member.hasOwnProperty('is_my_friend_request') ? wp.element.createElement(Fragment, null, wp.element.createElement(\"a\", {\n    className: \"button is-warning is-small vicon vicon-na\",\n    onClick: function onClick() {\n      return props.action('cancel');\n    }\n  })) : '', window.vibebp.settings.followers ? member.hasOwnProperty('is_following') ? wp.element.createElement(\"a\", {\n    className: \"button is-warning is-small vicon vicon-thumb-down\",\n    onClick: function onClick() {\n      return doAction('unfollow');\n    }\n  }) : wp.element.createElement(\"a\", {\n    className: \"button is-warning is-small vicon vicon-thumb-up\",\n    onClick: function onClick() {\n      return doAction('follow');\n    }\n  }) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Member);\n\n//# sourceURL=webpack:///./src/profile/components/members/member.js?");

/***/ }),

/***/ "./src/profile/components/members/members.js":
/*!***************************************************!*\
  !*** ./src/profile/components/members/members.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _member_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./member.js */ \"./src/profile/components/members/member.js\");\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Members = function Members(props) {\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    component: '',\n    id: '',\n    search_terms: '',\n    type: '',\n    role: '',\n    page: 1\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      members = _useState6[0],\n      setMembers = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isInvite = _useState8[0],\n      setInvite = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      isAddMember = _useState10[0],\n      setAddMember = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      invitees = _useState12[0],\n      setInvitees = _useState12[1];\n\n  var _useState13 = useState(''),\n      _useState14 = _slicedToArray(_useState13, 2),\n      recipientSearch = _useState14[0],\n      setRecipientSearch = _useState14[1];\n\n  var _useState15 = useState([]),\n      _useState16 = _slicedToArray(_useState15, 2),\n      searchResults = _useState16[0],\n      setSearchResults = _useState16[1];\n\n  useEffect(function () {\n    if (props.hasOwnProperty('type')) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.component = props.type;\n      nargs.id = props.id;\n      setArgs(nargs);\n    }\n  }, []);\n  useEffect(function () {\n    if (recipientSearch.length > 4) {\n      fetch(\"\".concat(window.vibebp.api.url, \"/search\"), {\n        method: 'post',\n        body: JSON.stringify({\n          search: recipientSearch,\n          type: 'user',\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          if (Array.isArray(data.results)) {\n            data.results.map(function (user) {\n              localforage.setItem('user_' + user.id, JSON.stringify(user));\n            });\n            setSearchResults(data.results);\n          }\n        }\n      });\n    }\n  }, [recipientSearch]);\n  useEffect(function () {\n    console.log(props);\n\n    var nargs = _objectSpread({}, args);\n\n    nargs['token'] = select('vibebp').getToken();\n    var user = select('vibebp').getUser();\n    nargs['user_id'] = user.id;\n    setisLoading(true);\n    var endpoint = window.vibebp.api.endpoints.members;\n\n    if (args.component !== window.vibebp.api.endpoints.members) {\n      endpoint = props.type + '/members/' + props.id;\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(endpoint), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setMembers(data.data.members);\n      }\n    });\n  }, [args]);\n\n  var sendInvites = function sendInvites() {\n    var url = \"\".concat(window.vibebp.api.url, \"/groups/invite_member/\").concat(props.id, \"/\");\n\n    if (isAddMember) {\n      url = \"\".concat(window.vibebp.api.url, \"/groups/join_group/\").concat(props.id, \"/\");\n    }\n\n    fetch(url, {\n      method: 'post',\n      body: JSON.stringify({\n        invitees: invitees,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      console.log(data);\n      console.log(isAddMember + '#');\n\n      if (data.status) {\n        if (isAddMember) {\n          var nmembers = _toConsumableArray(members);\n\n          invitees.map(function (id) {\n            var member = JSON.parse(localforage.getItem('user_' + parseInt(id)));\n            member['ID'] = id;\n            member['display_name'] = member.name;\n            console.log(member);\n            nmembers.push(member);\n          });\n          console.log('setting');\n          console.log(nmembers);\n          setMembers(nmembers);\n        }\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"div\", {\n    className: \"headerlinks\"\n  }, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.search_terms,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.search_terms = e.target.value;\n      setArgs(nargs);\n    }\n  }))), wp.element.createElement(\"div\", {\n    className: \"header_extras\"\n  }, wp.element.createElement(\"select\", {\n    value: args.role,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        role: e.target.value\n      }));\n    }\n  }, Object.keys(window.vibebp.components[props.type].membertypes).map(function (type) {\n    return wp.element.createElement(\"option\", {\n      value: type\n    }, window.vibebp.components[props.type].membertypes[type]);\n  })))), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, wp.element.createElement(\"div\", {\n    className: \"members\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : members.length ? members.map(function (member) {\n    if (props.hasOwnProperty('type')) {\n      return wp.element.createElement(_member_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n        member: member,\n        type: props.type,\n        id: props.id\n      });\n    } else {\n      return wp.element.createElement(_member_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n        member: member\n      });\n    }\n  }) : '')), wp.element.createElement(\"div\", {\n    className: \"portal_footer\"\n  }, args.component === 'groups' ? isInvite || isAddMember ? wp.element.createElement(\"div\", {\n    className: \"recipients\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipients_list\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipient_items\"\n  }, invitees.length ? wp.element.createElement(Fragment, null, invitees.map(function (recipient) {\n    return wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      type: \"user\",\n      click: function click() {\n        var ninvitees = _toConsumableArray(invitees);\n\n        ninvitees.splice(ninvitees.indexOf(recipient), 1);\n        setInvitees(ninvitees);\n      },\n      id: {\n        user_id: recipient\n      }\n    });\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-control-forward\",\n    onClick: sendInvites\n  })) : ''), wp.element.createElement(\"div\", {\n    className: \"vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: recipientSearch,\n    placeholder: window.vibebp.translations.search_member,\n    onChange: function onChange(e) {\n      setRecipientSearch(e.target.value);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-close\",\n    onClick: function onClick() {\n      setInvite(false);\n      setAddMember(false);\n    }\n  }))), searchResults.length ? wp.element.createElement(\"div\", {\n    className: \"search_results\"\n  }, searchResults.map(function (user, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"search_result user\",\n      onClick: function onClick() {\n        setRecipientSearch('');\n\n        var nsearchResults = _toConsumableArray(searchResults);\n\n        var ninvitees = _toConsumableArray(invitees);\n\n        if (ninvitees.indexOf(user.id) === -1) {\n          ninvitees.push(user.id);\n          setInvitees(ninvitees);\n          nsearchResults.splice(i, 1);\n          setSearchResults(nsearchResults);\n        }\n      }\n    }, wp.element.createElement(\"img\", {\n      src: user.avatar\n    }), wp.element.createElement(\"span\", null, user.name));\n  })) : '') : wp.element.createElement(\"div\", {\n    className: \"actions\"\n  }, wp.element.createElement(\"a\", {\n    onClick: function onClick() {\n      setInvite(true);\n      setAddMember(false);\n    },\n    className: \"button is-primary\"\n  }, window.vibebp.translations.invite_members), wp.element.createElement(\"a\", {\n    onClick: function onClick() {\n      setAddMember(true);\n      setInvite(false);\n    },\n    className: \"button is-info\"\n  }, window.vibebp.translations.add_members)) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Members);\n\n//# sourceURL=webpack:///./src/profile/components/members/members.js?");

/***/ }),

/***/ "./src/profile/components/menu.js":
/*!****************************************!*\
  !*** ./src/profile/components/menu.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _store_actions_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../store/actions.js */ \"./src/store/actions.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar UserMenu = function UserMenu(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      menu = _useState2[0],\n      setMenu = _useState2[1];\n\n  var _useState3 = useState(''),\n      _useState4 = _slicedToArray(_useState3, 2),\n      component = _useState4[0],\n      setComponent = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      action = _useState6[0],\n      setAction = _useState6[1];\n\n  useEffect(function () {\n    fetch(\"\".concat(window.vibebp.api.url, \"/profilemenu\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (response) {\n      if (response.status) {\n        setMenu(response.menu);\n        dispatch('vibebp').setMenu(response.bpmenu);\n      }\n    });\n    document.addEventListener('component_loaded', function (e) {\n      setComponent(e.detail.component);\n    });\n  }, []);\n  useEffect(function () {\n    if (menu.length) {\n      var ccomponent = menu[0].css_id;\n\n      if (ccomponent === 'xprofile') {\n        ccomponent = 'profile';\n      }\n\n      setComponent(ccomponent);\n\n      if (window.location.href.indexOf('#') !== -1) {\n        var URLFragments = window.location.href.split('#');\n\n        if (URLFragments.length > 1) {\n          var fragments = URLFragments[1].split('&');\n          var path = {};\n          var fragment_values = [];\n          fragments.map(function (fragment, i) {\n            fragment_values = fragment.split('=');\n\n            if (fragment_values[0] === 'component') {\n              if (!select('vibebp').getComponent()) {\n                dispatch('vibebp').setComponent(fragment_values[1]);\n              }\n            }\n          });\n        }\n      }\n    }\n  }, [menu]);\n\n  var setActiveComponent = function setActiveComponent(ccomponent) {\n    if (ccomponent.hasOwnProperty('css_id')) {\n      dispatch('vibebp').setComponent(ccomponent.css_id);\n    } else {\n      dispatch('vibebp').setComponent(ccomponent.type + '__' + ccomponent.object + '__' + ccomponent.object_id);\n    }\n  };\n\n  var setActive = function setActive(key) {\n    var mmenu = _toConsumableArray(menu);\n\n    mmenu[key].classes.push('active');\n    setMenu(mmenu);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"profile_menu\"\n  }, wp.element.createElement(\"div\", {\n    className: \"menu_items\"\n  }, Array.isArray(menu) && menu.length ? menu.map(function (item, key) {\n    item.menu_item_parent = parseInt(item.menu_item_parent);\n\n    if (!item.menu_item_parent) {\n      if (item.css_id === 'xprofile') {\n        item.css_id = 'profile';\n      }\n\n      var subitems = menu.filter(function (it) {\n        return it.menu_item_parent === item.ID;\n      });\n\n      if (subitems.length && item.classes.indexOf('hasChildren') === -1) {\n        item.classes.push('hasChildren');\n      }\n\n      return wp.element.createElement(\"div\", {\n        id: item.css_id,\n        className: item.classes.join(' ')\n      }, wp.element.createElement(\"span\", {\n        onClick: function onClick() {\n          return setActiveComponent(item);\n        },\n        className: 'menu_item_' + item.css_id\n      }, wp.element.createElement(\"span\", {\n        className: item.icon\n      }), wp.element.createElement(\"span\", null, item.title)), subitems.length ? wp.element.createElement(\"div\", {\n        className: \"sub_nav_items\"\n      }, subitems.map(function (sub) {\n        return wp.element.createElement(\"div\", {\n          onClick: function onClick() {\n            return setActiveComponent(sub);\n          },\n          className: sub.classes.join(' ')\n        }, wp.element.createElement(\"span\", {\n          className: sub.icon\n        }), wp.element.createElement(\"span\", null, sub.title));\n      })) : '');\n    }\n  }) : ''), wp.element.createElement(\"div\", {\n    className: \"menu_bottom\"\n  }, wp.element.createElement(\"div\", {\n    className: \"menu_item\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-power-off\"\n  }), wp.element.createElement(\"span\", null, window.vibebp.translations.logout))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (UserMenu);\n\n//# sourceURL=webpack:///./src/profile/components/menu.js?");

/***/ }),

/***/ "./src/profile/components/messages/fullmessage.js":
/*!********************************************************!*\
  !*** ./src/profile/components/messages/fullmessage.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _generateblocks_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../generateblocks.js */ \"./src/profile/components/generateblocks.js\");\n/* harmony import */ var _functions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functions.js */ \"./src/profile/components/functions.js\");\n/* harmony import */ var _timer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../timer.js */ \"./src/profile/components/timer.js\");\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _newmessage_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./newmessage.js */ \"./src/profile/components/messages/newmessage.js\");\nfunction _typeof(obj) { if (typeof Symbol === \"function\" && typeof Symbol.iterator === \"symbol\") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === \"function\" && obj.constructor === Symbol && obj !== Symbol.prototype ? \"symbol\" : typeof obj; }; } return _typeof(obj); }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar FullMessage = function FullMessage(props) {\n  var _useState = useState(props.message),\n      _useState2 = _slicedToArray(_useState, 2),\n      messageObj = _useState2[0],\n      setMessageObj = _useState2[1];\n\n  var _useState3 = useState(0),\n      _useState4 = _slicedToArray(_useState3, 2),\n      unread = _useState4[0],\n      setunRead = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      messageRecipients = _useState6[0],\n      setMessageRecipients = _useState6[1];\n\n  useEffect(function () {\n    var recipients = [];\n    var user = select('vibebp').getUser();\n    Object.keys(props.message.recipients).map(function (i) {\n      if (props.message.recipients[i].user_id === user.id) {\n        if (props.message.recipients[i].unread_count) {\n          setunRead(1);\n        }\n      } else {\n        recipients.push(props.message.recipients[i].user_id);\n      }\n    });\n    setMessageRecipients(recipients);\n    setMessageObj(props.message);\n  }, [props.message]);\n\n  var updateMessages = function updateMessages(data, attributes) {\n    if (data.status) {\n      var nmessageObj = _objectSpread({}, messageObj);\n\n      nmessageObj.messages = data.data;\n      setMessageObj(nmessageObj);\n    }\n  };\n\n  var user = select('vibebp').getUser();\n  return wp.element.createElement(\"div\", {\n    className: \"fullmessage\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"div\", {\n    className: \"header_left\"\n  }, messageRecipients.length ? messageRecipients.map(function (user_id) {\n    return wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      type: \"user\",\n      id: {\n        user_id: user_id\n      }\n    });\n  }) : ''), wp.element.createElement(\"div\", {\n    className: \"header_right\"\n  }, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: function onClick() {\n      props.show();\n    }\n  }), wp.element.createElement(\"a\", {\n    href: \"#message_body\",\n    className: \"vicon vicon-back-left\"\n  }), wp.element.createElement(\"i\", {\n    className: \"vicon vicon-star\",\n    onClick: function onClick() {}\n  }), wp.element.createElement(\"i\", {\n    className: \"vicon vicon-trash\"\n  }))), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, messageObj.messages.map(function (message, i) {\n    return wp.element.createElement(\"div\", {\n      className: message.sender_id != user.id ? 'notmine' : 'mine'\n    }, wp.element.createElement(\"div\", {\n      className: \"portal_message_wrapper\"\n    }, wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n      type: \"user\",\n      id: {\n        user_id: message.sender_id\n      }\n    }), wp.element.createElement(\"div\", {\n      className: \"portal_message\"\n    }, wp.element.createElement(\"div\", {\n      className: \"portal_title\"\n    }, i == 0 ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n      className: \"message_subject\"\n    }, unread ? wp.element.createElement(\"strong\", null, message.subject) : wp.element.createElement(\"span\", null, message.subject)), wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      time: message.date_sent\n    })) : wp.element.createElement(\"div\", {\n      className: \"message_subject\"\n    }, unread ? wp.element.createElement(\"strong\", null, wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      time: message.date_sent\n    })) : wp.element.createElement(\"span\", null, wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      time: message.date_sent\n    })))), wp.element.createElement(\"div\", {\n      className: \"portal_content\"\n    }, Object(_functions_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(message.message) ? wp.element.createElement(_generateblocks_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      object: message.message\n    }) : wp.element.createElement(\"div\", {\n      className: \"portal_content\",\n      dangerouslySetInnerHTML: {\n        __html: message.message\n      }\n    })), wp.element.createElement(\"div\", {\n      className: \"message_attachments\"\n    }, _typeof(message.meta) === 'object' && message.meta !== null ? Object.keys(message.meta).map(function (meta_key) {\n      return wp.element.createElement(Fragment, null, message.meta[meta_key].map(function (value) {\n        if (value.length > 3) {\n          if (meta_key == 'image') {\n            return wp.element.createElement(\"img\", {\n              src: value,\n              className: \"activity_meta image\"\n            });\n          }\n\n          if (meta_key == 'video') {\n            return wp.element.createElement(\"video\", {\n              src: value,\n              className: \"activity_meta video\"\n            });\n          }\n\n          if (meta_key == 'attachment') {\n            return wp.element.createElement(\"a\", {\n              href: value,\n              target: \"_blank\",\n              className: \"vicon vicon-clip activity_meta\"\n            });\n          }\n        }\n      }));\n    }) : ''))), wp.element.createElement(\"div\", null));\n  }))), messageRecipients.length ? wp.element.createElement(_newmessage_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n    thread_id: messageObj.thread_id,\n    update: updateMessages,\n    recipients: messageRecipients\n  }) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (FullMessage);\n\n//# sourceURL=webpack:///./src/profile/components/messages/fullmessage.js?");

/***/ }),

/***/ "./src/profile/components/messages/message.js":
/*!****************************************************!*\
  !*** ./src/profile/components/messages/message.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _generateblocks_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../generateblocks.js */ \"./src/profile/components/generateblocks.js\");\n/* harmony import */ var _functions_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functions.js */ \"./src/profile/components/functions.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Message = function Message(props) {\n  var _useState = useState(0),\n      _useState2 = _slicedToArray(_useState, 2),\n      unread = _useState2[0],\n      setunRead = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      addLabel = _useState4[0],\n      setaddLabel = _useState4[1];\n\n  var _useState5 = useState(props.message.labels),\n      _useState6 = _slicedToArray(_useState5, 2),\n      labels = _useState6[0],\n      setLabels = _useState6[1];\n\n  useEffect(function () {\n    Object.keys(props.message.recipients).map(function (i) {\n      if (props.message.recipients[i].user_id === select('vibebp').getUser()) {\n        if (props.message.recipients[i].unread_count) {\n          setunRead(1);\n        }\n      }\n    });\n  }, []);\n\n  var selectedLabel = function selectedLabel(label) {\n    setaddLabel(false);\n\n    var nlabels = _toConsumableArray(labels);\n\n    nlabels.push(label.slug);\n    setLabels(nlabels);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/actions\"), {\n      method: 'post',\n      body: JSON.stringify({\n        id: props.message.thread_id,\n        action: 'add_label',\n        'label': label.slug,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      props.updateLabels(label.slug, 1);\n    });\n  };\n\n  var removeLabel = function removeLabel(label_slug) {\n    var nlabels = _toConsumableArray(labels);\n\n    nlabels.splice(nlabels.indexOf(label_slug), 1);\n    setLabels(nlabels);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/actions\"), {\n      method: 'post',\n      body: JSON.stringify({\n        id: props.message.thread_id,\n        action: 'remove_label',\n        'label': label_slug,\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      props.updateLabels(label.slug, 0);\n    });\n  };\n\n  var classs = 'message_add_label vicon vicon-plus';\n\n  if (addLabel) {\n    classs = 'message_add_label vicon vicon-close';\n  }\n\n  return wp.element.createElement(Fragment, null, props.labels.length ? wp.element.createElement(\"div\", {\n    className: \"message_labels\"\n  }, labels.length ? labels.map(function (label_slug) {\n    var label = props.labels[props.labels.findIndex(function (item) {\n      return item.slug === label_slug;\n    })];\n    return wp.element.createElement(\"span\", {\n      style: {\n        background: label.color\n      },\n      onClick: function onClick() {\n        return removeLabel(label_slug);\n      }\n    }, label.name);\n  }) : '', wp.element.createElement(\"a\", {\n    className: classs,\n    onClick: function onClick() {\n      if (!addLabel) {\n        setaddLabel(true);\n      } else {\n        setaddLabel(false);\n      }\n    }\n  }), addLabel ? wp.element.createElement(\"ul\", {\n    className: \"allmessage_labels\"\n  }, props.labels.map(function (label) {\n    if (labels.indexOf(label.slug) === -1) {\n      return wp.element.createElement(\"li\", {\n        onClick: function onClick() {\n          return selectedLabel(label);\n        },\n        style: {\n          background: label.color\n        }\n      }, label.name);\n    }\n  })) : '') : '', wp.element.createElement(\"div\", {\n    className: \"message\",\n    onClick: function onClick() {\n      props.show();\n    }\n  }, unread ? wp.element.createElement(\"strong\", {\n    dangerouslySetInnerHTML: {\n      __html: props.message.last_message_subject\n    }\n  }) : wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: props.message.last_message_subject\n    }\n  }), Object(_functions_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(props.message.last_message_content) ? wp.element.createElement(_generateblocks_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    object: props.message.last_message_content,\n    type: \"text\"\n  }) : wp.element.createElement(\"div\", {\n    className: \"message_content\",\n    dangerouslySetInnerHTML: {\n      __html: props.message.last_message_content\n    }\n  })));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Message);\n\n//# sourceURL=webpack:///./src/profile/components/messages/message.js?");

/***/ }),

/***/ "./src/profile/components/messages/messages.js":
/*!*****************************************************!*\
  !*** ./src/profile/components/messages/messages.js ***!
  \*****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _timer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../timer.js */ \"./src/profile/components/timer.js\");\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _message_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./message.js */ \"./src/profile/components/messages/message.js\");\n/* harmony import */ var _newmessage_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./newmessage.js */ \"./src/profile/components/messages/newmessage.js\");\n/* harmony import */ var _fullmessage_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./fullmessage.js */ \"./src/profile/components/messages/fullmessage.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Messages = function Messages(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      messages = _useState2[0],\n      setMessages = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      messageFilters = _useState4[0],\n      setMessageFilters = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      showMenu = _useState6[0],\n      setShowMenu = _useState6[1];\n\n  var _useState7 = useState({\n    filter: 'unread',\n    sorter: '',\n    page: 1,\n    search: '',\n    label: ''\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      args = _useState8[0],\n      setArgs = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      checkAll = _useState10[0],\n      setcheckAll = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      checked = _useState12[0],\n      setChecked = _useState12[1];\n\n  var _useState13 = useState(true),\n      _useState14 = _slicedToArray(_useState13, 2),\n      isLoading = _useState14[0],\n      setisLoading = _useState14[1];\n\n  var _useState15 = useState(''),\n      _useState16 = _slicedToArray(_useState15, 2),\n      bulkAction = _useState16[0],\n      setBulkAction = _useState16[1];\n\n  var _useState17 = useState(false),\n      _useState18 = _slicedToArray(_useState17, 2),\n      more = _useState18[0],\n      setMore = _useState18[1];\n\n  var _useState19 = useState(false),\n      _useState20 = _slicedToArray(_useState19, 2),\n      isPagination = _useState20[0],\n      setIsPagination = _useState20[1];\n\n  var _useState21 = useState(false),\n      _useState22 = _slicedToArray(_useState21, 2),\n      newMessage = _useState22[0],\n      setnewMessage = _useState22[1];\n\n  var _useState23 = useState(0),\n      _useState24 = _slicedToArray(_useState23, 2),\n      showMessage = _useState24[0],\n      setshowMessage = _useState24[1];\n\n  var _useState25 = useState(false),\n      _useState26 = _slicedToArray(_useState25, 2),\n      newLabel = _useState26[0],\n      setNewLabel = _useState26[1];\n\n  var _useState27 = useState({\n    text: '',\n    color: '#000'\n  }),\n      _useState28 = _slicedToArray(_useState27, 2),\n      labelargs = _useState28[0],\n      setlabelArgs = _useState28[1];\n\n  var _useState29 = useState([]),\n      _useState30 = _slicedToArray(_useState29, 2),\n      labels = _useState30[0],\n      setLabels = _useState30[1];\n\n  var _useState31 = useState(window.vibebp.components.messages.actions),\n      _useState32 = _slicedToArray(_useState31, 2),\n      actions = _useState32[0],\n      setActions = _useState32[1];\n\n  useEffect(function () {\n    var message_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'messages';\n    });\n    message_filters.map(function (filter, index) {\n      if (message_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        message_filters[index][\"class\"].push('current-menu-item');\n      }\n    });\n    setMessageFilters(message_filters);\n  }, []);\n  useEffect(function () {\n    var nargs = _objectSpread({}, args);\n\n    nargs['token'] = select('vibebp').getToken();\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          var nmessages = _toConsumableArray(messages);\n\n          data.data.threads.map(function (messages) {\n            nmessages.push(messages);\n          });\n          setMessages(nmessages);\n          setIsPagination(false);\n\n          if (nmessages.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setMessages(data.data.threads);\n\n          if (data.data.threads.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        }\n      } else {\n        setMessages([]);\n      }\n    });\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/labels\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        if (Array.isArray(data.labels) && data.labels.length) {\n          setLabels(data.labels);\n        }\n      }\n    });\n  }, [args]);\n\n  var updateMessage = function updateMessage(message_id, action) {\n    setShowMenu(false);\n\n    var nmessages = _toConsumableArray(messages);\n\n    if (action === 'star') {\n      nmessages[nmessages.findIndex(function (item) {\n        return item.thread_id === message_id;\n      })].star = 1;\n    }\n\n    if (action === 'unstar') {\n      nmessages[nmessages.findIndex(function (item) {\n        return item.thread_id === message_id;\n      })].star = 0;\n    }\n\n    if (action === 'read') {\n      nmessages[nmessages.findIndex(function (item) {\n        return item.thread_id === message_id;\n      })].unread_count = 0;\n    }\n\n    if (action === 'unread') {\n      nmessages[nmessages.findIndex(function (item) {\n        return item.thread_id === message_id;\n      })].unread_count++;\n    }\n\n    if (action === 'delete') {\n      nmessages.splice(nmessages.findIndex(function (item) {\n        return item.thread_id === message_id;\n      }), 1);\n    }\n\n    setMessages(nmessages);\n  };\n\n  var applybulkAction = function applybulkAction() {\n    var nmessages = _toConsumableArray(messages);\n\n    if (!bulkAction) {\n      return;\n    }\n\n    if (checkAll) {\n      setMessages([]);\n    } else {\n      if (checked.length) {}\n    }\n  };\n\n  var updateMessages = function updateMessages(data, attributes) {\n    var nmessages = _toConsumableArray(messages);\n\n    if (data.status) {\n      var recipients = {};\n      attributes['recipients'].map(function (id) {\n        recipients[1] = {\n          user_id: id,\n          unread_count: 1\n        };\n        recipients[2] = {\n          user_id: data.data[0].sender_id,\n          unread_count: 0\n        };\n      });\n      var thread = {\n        thread_id: data.data[0].thread_id,\n        last_message_date: data.data[0].date_sent,\n        last_message_subject: data.data[0].subject,\n        last_message_content: data.data[0].message,\n        star: 0,\n        recipients: recipients,\n        sender_ids: {\n          0: data.data[0].sender_id\n        },\n        messages: data.data,\n        unread_count: 0\n      };\n      nmessages.unshift(thread);\n      setMessages(nmessages);\n      setshowMessage(0);\n      setnewMessage(false);\n    }\n  };\n\n  var addNewLabel = function addNewLabel() {\n    setNewLabel(false);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/label/add\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, labelargs, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      if (data.status) {\n        setLabels(data.labels);\n      }\n    });\n  };\n\n  var removeLabel = function removeLabel(i) {\n    var nlabels = _toConsumableArray(labels);\n\n    nlabels.splice(i, 1);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/label/remove\"), {\n      method: 'post',\n      body: JSON.stringify({\n        slug: labels[i]['slug'],\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n    setLabels(nlabels);\n  };\n\n  var setActiveLabel = function setActiveLabel(label) {\n    var nargs = _objectSpread({}, args);\n\n    if (nargs.label === label.slug) {\n      nargs.label = '';\n    } else {\n      nargs.label = label.slug;\n    }\n\n    setArgs(nargs);\n  };\n\n  var updateLabelCount = function updateLabelCount(slug, add) {\n    var nlabels = _toConsumableArray(labels);\n\n    if (add) {\n      nlabels[nlabels.findIndex(function (item) {\n        return item.slug === slug;\n      })].count++;\n    } else {\n      nlabels[nlabels.findIndex(function (item) {\n        return item.slug === slug;\n      })].count--;\n    }\n\n    setLabels(nlabels);\n  };\n\n  var isActiveClass = function isActiveClass(i) {\n    if (showMessage !== false) {\n      if (showMessage === i) {\n        return 'message_block active';\n      }\n    }\n\n    return 'message_block';\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.messages.label), wp.element.createElement(\"a\", {\n    className: \"button is-primary new_mail\",\n    onClick: function onClick() {\n      setnewMessage(true);\n    }\n  }, window.vibebp.translations.new_message), wp.element.createElement(\"a\", {\n    className: \"button is-link new_mail\",\n    onClick: function onClick() {\n      setnewMessage(true);\n    }\n  }, window.vibebp.translations.send_notice), messageFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n\n    if (filter.css_id !== 'compose') {\n      return wp.element.createElement(\"a\", {\n        className: classs,\n        onClick: function onClick(e) {\n          var nargs = _objectSpread({}, args);\n\n          nargs.filter = filter.css_id;\n          nargs.page = 1;\n          setshowMessage(false);\n          setnewMessage(false);\n\n          if (args.css_id !== nargs.filter) {\n            setArgs(nargs);\n          }\n\n          var ffilters = _toConsumableArray(messageFilters);\n\n          var index = ffilters.findIndex(function (item) {\n            return item[\"class\"].indexOf('current-menu-item') > -1;\n          });\n          ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n          ffilters[i][\"class\"].push('current-menu-item');\n          setcheckAll(false);\n          setChecked([]);\n          setBulkAction('');\n          setMessageFilters(ffilters);\n        }\n      }, filter.name);\n    }\n  }), wp.element.createElement(\"div\", {\n    className: \"labels\"\n  }, wp.element.createElement(\"div\", {\n    \"class\": \"labels_title\"\n  }, wp.element.createElement(\"span\", null, window.vibebp.translations.labels), wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      if (!newLabel) {\n        setNewLabel(true);\n      } else {\n        setNewLabel(false);\n      }\n    }\n  }, window.vibebp.translations.add_new)), newLabel ? wp.element.createElement(\"div\", {\n    className: \"newlabel_form\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: labelargs.text,\n    onChange: function onChange(e) {\n      var nlabelargs = _objectSpread({}, labelargs);\n\n      nlabelargs.text = e.target.value;\n      setlabelArgs(nlabelargs);\n    }\n  }), wp.element.createElement(\"label\", {\n    style: {\n      background: labelargs.color\n    }\n  }, wp.element.createElement(\"input\", {\n    type: \"color\",\n    onChange: function onChange(e) {\n      var nlabelargs = _objectSpread({}, labelargs);\n\n      nlabelargs.color = e.target.value;\n      setlabelArgs(nlabelargs);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary vicon vicon-plus\",\n    onClick: addNewLabel\n  })) : '', labels.length ? wp.element.createElement(\"ul\", {\n    className: \"message_labels\"\n  }, labels.map(function (label, i) {\n    var classs = '';\n\n    if (args.label == label.slug) {\n      classs = 'active';\n    }\n\n    return wp.element.createElement(\"li\", {\n      className: classs\n    }, wp.element.createElement(\"label\", null, wp.element.createElement(\"strong\", {\n      onClick: function onClick() {\n        return setActiveLabel(label);\n      }\n    }, wp.element.createElement(\"span\", {\n      style: {\n        borderColor: label.color\n      }\n    }), label.name), wp.element.createElement(\"span\", {\n      className: \"vicon vicon-trash\",\n      onClick: function onClick() {\n        return removeLabel(i);\n      }\n    })), wp.element.createElement(\"span\", {\n      onClick: function onClick() {\n        return setActiveLabel(label);\n      }\n    }, label.count));\n  })) : '')), wp.element.createElement(\"div\", {\n    className: \"vibebp_main message_left_right\"\n  }, wp.element.createElement(\"div\", {\n    className: \"message_list_left\"\n  }, wp.element.createElement(\"div\", {\n    className: \"message_list_head\"\n  }, checkAll || checked.length ? '' : wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.search,\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.search = e.target.value;\n      setArgs(nargs);\n    }\n  })), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.sorter = e.target.value;\n      setArgs(nargs);\n    }\n  }, Object.keys(window.vibebp.components.messages.sorters).map(function (sorter) {\n    return wp.element.createElement(\"option\", {\n      value: sorter\n    }, window.vibebp.components.messages.sorters[sorter]);\n  }))), wp.element.createElement(\"div\", {\n    className: \"checkbox\"\n  }, wp.element.createElement(\"input\", {\n    id: \"selectall\",\n    type: \"checkbox\",\n    checked: checkAll ? 'checked' : '',\n    onClick: function onClick() {\n      if (checkAll) {\n        setcheckAll(false);\n      } else {\n        setcheckAll(true);\n        setChecked([]);\n      }\n    }\n  }), wp.element.createElement(\"label\", {\n    \"for\": \"selectall\"\n  })), checkAll || checked.length ? wp.element.createElement(\"div\", {\n    className: \"bulk_actions\"\n  }, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setBulkAction(e.target.value);\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.selectaction), Object.keys(actions).map(function (key) {\n    if (key !== args.filter) {\n      return wp.element.createElement(\"option\", {\n        value: key\n      }, actions[key]);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: applybulkAction\n  }, window.vibebp.translations.apply)) : ''), wp.element.createElement(\"div\", {\n    className: \"messages\"\n  }, !messages.length && !isLoading ? wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_messages_found) : wp.element.createElement(Fragment, null, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : messages.length ? messages.map(function (message, i) {\n    var starred = 'vicon vicon-star';\n\n    if (message.star) {\n      starred += ' filled';\n    }\n\n    return wp.element.createElement(\"div\", {\n      className: isActiveClass(i)\n    }, wp.element.createElement(\"div\", {\n      className: \"message_avatars\"\n    }, Object.keys(message.sender_ids).length ? Object.keys(message.sender_ids).map(function (user_id, key) {\n      if (Object.keys(message.sender_ids) > 3) {\n        if (key < 3) {\n          return wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n            type: \"user\",\n            id: {\n              user_id: user_id\n            }\n          });\n        }\n      } else {\n        return wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n          type: \"user\",\n          id: {\n            user_id: user_id\n          }\n        });\n      }\n    }) : '', Object.keys(message.sender_ids).length > 3 ? wp.element.createElement(\"span\", null, '+' + (Object.keys(message.sender_ids).length - 3) + ' ' + window.vibebp.translations.more) : ''), wp.element.createElement(\"div\", {\n      className: \"message_block_main\"\n    }, wp.element.createElement(\"div\", {\n      className: \"message_block_head\"\n    }, wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      time: message.date_sent\n    }), wp.element.createElement(\"div\", null, wp.element.createElement(\"div\", {\n      className: \"checkbox\"\n    }, wp.element.createElement(\"input\", {\n      type: \"checkbox\",\n      onClick: function onClick() {\n        var nchecked = _toConsumableArray(checked);\n\n        if (checkAll) {\n          setcheckAll(false);\n          messages.map(function (message) {\n            nchecked.push(message.thread_id);\n          });\n        }\n\n        if (checked.indexOf(message.thread_id) === -1) {\n          nchecked.push(message.thread_id);\n          setChecked(nchecked);\n        } else {\n          nchecked.splice(checked.indexOf(message.thread_id), 1);\n          setChecked(nchecked);\n        }\n      },\n      checked: checkAll || checked.indexOf(message.thread_id) !== -1 ? 'checked' : '',\n      id: message.thread_id\n    }), wp.element.createElement(\"label\", {\n      \"for\": message.thread_id\n    })), wp.element.createElement(\"a\", {\n      onClick: function onClick() {\n        if (message.star) {\n          updateMessage(message.thread_id, 'unstar');\n        } else {\n          updateMessage(message.thread_id, 'star');\n        }\n      },\n      className: starred\n    }), wp.element.createElement(\"a\", {\n      className: \"vicon vicon-more rotate90\",\n      onClick: function onClick() {\n        if (showMenu) {\n          setShowMenu(false);\n        } else {\n          setShowMenu(message.thread_id);\n        }\n      }\n    }), wp.element.createElement(Fragment, null, showMenu === message.thread_id ? wp.element.createElement(\"ul\", {\n      className: \"target_menu\"\n    }, Object.keys(actions).map(function (key) {\n      if (key !== 'unread' && key !== 'read' && key !== 'star' && key !== 'unstar' && key !== 'remove_label' || key === 'unread' && !message.unread_count || key === 'read' && message.unread_count || key === 'unstar' && message.star || key === 'star' && !message.star) {\n        return wp.element.createElement(\"li\", {\n          value: key,\n          onClick: function onClick() {\n            updateMessage(message.thread_id, key);\n          }\n        }, actions[key]);\n      }\n    })) : ''))), wp.element.createElement(_message_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      message: message,\n      labels: labels,\n      updateLabels: function updateLabels(slug, count) {\n        updateLabelCount(slug, count);\n      },\n      show: function show() {\n        setshowMessage(i);\n      }\n    })));\n  }) : '', more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page += 1;\n      setArgs(nargs);\n      setIsPagination(true);\n    }\n  }, window.vibebp.translations.more) : ''))), wp.element.createElement(\"div\", {\n    className: \"message_main\"\n  }, newMessage ? wp.element.createElement(_newmessage_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    cancel: function cancel() {\n      setnewMessage(false);\n    },\n    update: updateMessages\n  }) : !isLoading && messages.length && showMessage !== false ? wp.element.createElement(_fullmessage_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n    message: messages[showMessage],\n    show: function show() {\n      setshowMessage(false);\n    }\n  }) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Messages);\n\n//# sourceURL=webpack:///./src/profile/components/messages/messages.js?");

/***/ }),

/***/ "./src/profile/components/messages/newmessage.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/messages/newmessage.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../avatar */ \"./src/profile/components/avatar.js\");\n/* harmony import */ var _uploader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../uploader */ \"./src/profile/components/uploader.js\");\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar NewMessage = function NewMessage(props) {\n  var _useState = useState(''),\n      _useState2 = _slicedToArray(_useState, 2),\n      recipientSearch = _useState2[0],\n      setRecipientSearch = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isSearching = _useState4[0],\n      setIsSearching = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      searchResults = _useState6[0],\n      setSearchResults = _useState6[1];\n\n  var _useState7 = useState({\n    content: '',\n    recipients: [],\n    subject: '',\n    thread_id: 0,\n    meta: []\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      attributes = _useState8[0],\n      setAttributes = _useState8[1];\n\n  var _useState9 = useState([]),\n      _useState10 = _slicedToArray(_useState9, 2),\n      enableAttachment = _useState10[0],\n      setEnableAttachment = _useState10[1];\n\n  var _useState11 = useState(''),\n      _useState12 = _slicedToArray(_useState11, 2),\n      attachments = _useState12[0],\n      setAttachments = _useState12[1]; //const [editorState,seteditorState] = useState(EditorState.createEmpty());\n\n\n  useEffect(function () {\n    if (props.hasOwnProperty('thread_id')) {\n      var nattributes = _objectSpread({}, attributes);\n\n      nattributes.thread_id = props.thread_id;\n      nattributes.recipients = props.recipients;\n      setAttributes(nattributes);\n    }\n  }, []);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_2__[\"useThrottledEffect\"])(function () {\n    if (recipientSearch.length > 4) {\n      setIsSearching(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/search\"), {\n        method: 'post',\n        body: JSON.stringify({\n          search: recipientSearch,\n          type: 'user',\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setIsSearching(false);\n\n        if (data.status) {\n          if (Array.isArray(data.results)) {\n            data.results.map(function (user) {\n              localforage.setItem('user_' + user.id, JSON.stringify(user));\n            });\n            setSearchResults(data.results);\n          }\n        }\n      });\n    }\n  }, 500, [recipientSearch]);\n\n  var postMessage = function postMessage() {\n    var flag = 1;\n    console.log(attributes);\n\n    if (!attributes.content.length) {\n      flag = 0;\n    }\n\n    if (!attributes.recipients.length) {\n      flag = 0;\n    }\n\n    if (!attributes.subject.length && !attributes.thread_id) {\n      flag = 0;\n    } //\n\n\n    if (flag) {\n      var args = _objectSpread({}, attributes);\n\n      if (props.hasOwnProperty('notice')) {\n        args.notice = props.notice;\n      }\n\n      var formData = new FormData();\n      formData.append(\"body\", JSON.stringify({\n        args: args,\n        token: select('vibebp').getToken()\n      }));\n\n      if (attachments.length) {\n        attachments.map(function (attachment, i) {\n          formData.append(\"files_\" + i, attachment);\n        });\n      }\n\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.messages, \"/send\"), {\n        method: 'post',\n        body: formData\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        props.update(data, attributes);\n        setEnableAttachment([]);\n        setAttachments('');\n        setAttributes(_objectSpread({}, attributes, {\n          content: '',\n          subject: ''\n        }));\n      });\n    }\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"newmessage_form\"\n  }, props.recipients || props.notice ? '' : wp.element.createElement(\"div\", {\n    className: \"recipients\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.recipients), wp.element.createElement(\"div\", {\n    className: \"recipients_list\"\n  }, wp.element.createElement(\"div\", {\n    className: \"recipient_items\"\n  }, attributes.recipients.map(function (recipient) {\n    return wp.element.createElement(_avatar__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      type: \"user\",\n      click: function click() {\n        var nattributes = _objectSpread({}, attributes);\n\n        nattributes.recipients.splice(nattributes.recipients.indexOf(recipient), 1);\n        setAttributes(nattributes);\n      },\n      id: {\n        user_id: recipient\n      }\n    });\n  })), wp.element.createElement(\"div\", {\n    className: isSearching ? 'control is-loading' : 'control'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: recipientSearch,\n    placeholder: window.vibebp.translations.search_member,\n    onChange: function onChange(e) {\n      setRecipientSearch(e.target.value);\n    }\n  }))), searchResults.length ? wp.element.createElement(\"div\", {\n    className: \"search_results\"\n  }, searchResults.map(function (user, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"search_result user\",\n      onClick: function onClick() {\n        setRecipientSearch('');\n\n        var nsearchResults = _toConsumableArray(searchResults);\n\n        var nattributes = _objectSpread({}, attributes);\n\n        if (nattributes.recipients.indexOf(user.id) === -1) {\n          nattributes.recipients.push(user.id);\n          setAttributes(nattributes);\n          nsearchResults.splice(i, 1);\n          setSearchResults(nsearchResults);\n        }\n      }\n    }, wp.element.createElement(\"img\", {\n      src: user.avatar\n    }), wp.element.createElement(\"span\", null, user.name));\n  })) : ''), props.hasOwnProperty('thread_id') ? '' : wp.element.createElement(\"div\", {\n    className: \"subject\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.subject), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: attributes.subject,\n    onChange: function onChange(e) {\n      var nattributes = _objectSpread({}, attributes);\n\n      nattributes.subject = e.target.value;\n      setAttributes(nattributes);\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"message_body\",\n    id: \"message_body\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.message), wp.element.createElement(\"div\", {\n    className: \"message_editor\"\n  }, wp.element.createElement(\"textarea\", {\n    onChange: function onChange(e) {\n      var nattributes = _objectSpread({}, attributes);\n\n      nattributes.content = e.target.value;\n      setAttributes(nattributes);\n    }\n  }, attributes.content))), wp.element.createElement(\"div\", {\n    className: \"message_actions\"\n  }, wp.element.createElement(\"div\", {\n    className: \"message_Attachments\"\n  }, wp.element.createElement(Fragment, null, wp.element.createElement(\"a\", {\n    className: \"vicon vicon-clip\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('attachment');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-video-camera\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('video');\n      setEnableAttachment(nenableAttachment);\n    }\n  }), wp.element.createElement(\"a\", {\n    className: \"vicon vicon-image\",\n    onClick: function onClick() {\n      var nenableAttachment = _toConsumableArray(enableAttachment);\n\n      nenableAttachment.push('image');\n      setEnableAttachment(nenableAttachment);\n    }\n  })), enableAttachment.length ? enableAttachment.map(function (item, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"message_attachment\"\n    }, item == 'image' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-image upload_type\"\n    }) : item == 'video' ? wp.element.createElement(\"a\", {\n      className: \"vicon vicon-video-camera upload_type\"\n    }) : wp.element.createElement(\"a\", {\n      className: \"vicon vicon-clip upload_type\"\n    }), wp.element.createElement(_uploader__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      type: item,\n      update: function update(files, data) {\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments[i] = new File([files[0]], files[0].name);\n        setAttachments(nattachments);\n        setAttributes(_objectSpread({}, attributes, {\n          meta: [].concat(_toConsumableArray(attributes.meta), [{\n            key: item,\n            value: i\n          }])\n        }));\n      }\n    }), wp.element.createElement(\"a\", {\n      className: \"vicon vicon-close\",\n      onClick: function onClick() {\n        var nenableAttachment = _toConsumableArray(enableAttachment);\n\n        nenableAttachment.splice(i, 1);\n\n        var nattachments = _toConsumableArray(attachments);\n\n        nattachments.splice(i, 1);\n        setAttachments(nattachments);\n        setEnableAttachment(nenableAttachment);\n      }\n    }));\n  }) : ''), wp.element.createElement(\"div\", {\n    className: \"message_buttons\"\n  }, attributes.thread_id ? '' : wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: props.cancel\n  }, window.vibebp.translations.cancel), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: postMessage\n  }, window.vibebp.translations.send_message))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (NewMessage);\n\n//# sourceURL=webpack:///./src/profile/components/messages/newmessage.js?");

/***/ }),

/***/ "./src/profile/components/notifications/notification.js":
/*!**************************************************************!*\
  !*** ./src/profile/components/notifications/notification.js ***!
  \**************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\n\nvar Notification = function Notification(props) {\n  return wp.element.createElement(\"div\", {\n    className: \"notification\",\n    dangerouslySetInnerHTML: {\n      __html: props.notification.content.text\n    }\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Notification);\n\n//# sourceURL=webpack:///./src/profile/components/notifications/notification.js?");

/***/ }),

/***/ "./src/profile/components/notifications/notifications.js":
/*!***************************************************************!*\
  !*** ./src/profile/components/notifications/notifications.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _notification_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./notification.js */ \"./src/profile/components/notifications/notification.js\");\n/* harmony import */ var _timer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../timer.js */ \"./src/profile/components/timer.js\");\n/* harmony import */ var _avatar_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../avatar.js */ \"./src/profile/components/avatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Notifications = function Notifications(props) {\n  var _useState = useState([]),\n      _useState2 = _slicedToArray(_useState, 2),\n      notifications = _useState2[0],\n      setNotifications = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      notificationFilters = _useState4[0],\n      setNotificationFilters = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      showMenu = _useState6[0],\n      setShowMenu = _useState6[1];\n\n  var _useState7 = useState({\n    filter: 'unread',\n    sorter: '',\n    page: 1,\n    search: ''\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      args = _useState8[0],\n      setArgs = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      checkAll = _useState10[0],\n      setcheckAll = _useState10[1];\n\n  var _useState11 = useState([]),\n      _useState12 = _slicedToArray(_useState11, 2),\n      checked = _useState12[0],\n      setChecked = _useState12[1];\n\n  var _useState13 = useState(true),\n      _useState14 = _slicedToArray(_useState13, 2),\n      isLoading = _useState14[0],\n      setisLoading = _useState14[1];\n\n  var _useState15 = useState(''),\n      _useState16 = _slicedToArray(_useState15, 2),\n      bulkAction = _useState16[0],\n      setBulkAction = _useState16[1];\n\n  var _useState17 = useState(false),\n      _useState18 = _slicedToArray(_useState17, 2),\n      more = _useState18[0],\n      setMore = _useState18[1];\n\n  var _useState19 = useState(false),\n      _useState20 = _slicedToArray(_useState19, 2),\n      isPagination = _useState20[0],\n      setIsPagination = _useState20[1];\n\n  useEffect(function () {\n    console.log(select('vibebp').getMenu());\n    var notification_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'notifications';\n    });\n    notification_filters.map(function (filter, index) {\n      if (notification_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        notification_filters[index][\"class\"].push('current-menu-item');\n      }\n    });\n    setNotificationFilters(notification_filters);\n  }, []);\n  useEffect(function () {\n    var nargs = _objectSpread({}, args);\n\n    nargs['token'] = select('vibebp').getToken();\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        if (isPagination) {\n          var nnotifications = _toConsumableArray(notifications);\n\n          data.data.notifications.map(function (notification) {\n            nnotifications.push(notification);\n          });\n          setNotifications(nnotifications);\n          setIsPagination(false);\n\n          if (nnotifications.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        } else {\n          setNotifications(data.data.notifications);\n\n          if (data.data.notifications.length < data.data.total) {\n            setMore(true);\n          } else {\n            setMore(false);\n          }\n        }\n      } else {\n        setNotifications([]);\n      }\n    });\n  }, [args]);\n\n  var updateNotification = function updateNotification(notification_id, action) {\n    setShowMenu(false);\n\n    var nnotifications = _toConsumableArray(notifications);\n\n    if (action === 'read') {\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/mark-read-unread\"), {\n        method: 'post',\n        body: JSON.stringify({\n          is_new: 0,\n          id: notification_id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {});\n    }\n\n    if (action === 'unread') {\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/mark-read-unread\"), {\n        method: 'post',\n        body: JSON.stringify({\n          is_new: 1,\n          id: notification_id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {});\n    }\n\n    if (action === 'delete') {\n      fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/delete-notification\"), {\n        method: 'post',\n        body: JSON.stringify({\n          id: notification_id,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {});\n    }\n\n    nnotifications.splice(nnotifications.findIndex(function (item) {\n      return item.id === notification_id;\n    }), 1);\n    setNotifications(nnotifications);\n  };\n\n  var applybulkAction = function applybulkAction() {\n    var nnotifications = _toConsumableArray(notifications);\n\n    console.log(bulkAction);\n\n    if (!bulkAction) {\n      return;\n    }\n\n    if (checkAll) {\n      setNotifications([]);\n\n      if (bulkAction === 'read') {\n        fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/markall-read-unread\"), {\n          method: 'post',\n          body: JSON.stringify({\n            is_new: 0,\n            token: select('vibebp').getToken()\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {});\n      }\n\n      if (bulkAction === 'unread') {\n        fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/markall-read-unread\"), {\n          method: 'post',\n          body: JSON.stringify({\n            is_new: 1,\n            token: select('vibebp').getToken()\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {});\n      }\n\n      if (bulkAction === 'delete') {\n        var notification_ids = [];\n        notifications.map(function (n) {\n          notification_ids.push(n.id);\n        });\n        fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/deleteall\"), {\n          method: 'post',\n          body: JSON.stringify({\n            ids: notification_ids,\n            token: select('vibebp').getToken()\n          })\n        }).then(function (res) {\n          return res.json();\n        }).then(function (data) {});\n      }\n    } else {\n      if (checked.length) {\n        checked.map(function (nid) {\n          nnotifications.splice(nnotifications.findIndex(function (n) {\n            return nid === n.id;\n          }), 1);\n        });\n        setNotifications(nnotifications);\n\n        if (bulkAction === 'read') {\n          fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/mark-read-unread\"), {\n            method: 'post',\n            body: JSON.stringify({\n              is_new: 0,\n              id: checked,\n              token: select('vibebp').getToken()\n            })\n          }).then(function (res) {\n            return res.json();\n          }).then(function (data) {});\n        }\n\n        if (bulkAction === 'unread') {\n          fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/mark-read-unread\"), {\n            method: 'post',\n            body: JSON.stringify({\n              is_new: 1,\n              id: checked,\n              token: select('vibebp').getToken()\n            })\n          }).then(function (res) {\n            return res.json();\n          }).then(function (data) {});\n        }\n\n        if (action === 'delete') {\n          fetch(\"\".concat(window.vibebp.api.url, \"/\").concat(window.vibebp.api.endpoints.notifications, \"/delete-notification\"), {\n            method: 'post',\n            body: JSON.stringify({\n              id: checked,\n              token: select('vibebp').getToken()\n            })\n          }).then(function (res) {\n            return res.json();\n          }).then(function (data) {});\n        }\n      }\n    }\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.notifications.label), notificationFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n    return wp.element.createElement(\"a\", {\n      className: classs,\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n\n        if (filter.css_id === 'notifications-my-notifications') {\n          nargs.filter = 'unread';\n        }\n\n        nargs.page = 1;\n        setArgs(nargs);\n\n        var ffilters = _toConsumableArray(notificationFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setcheckAll(false);\n        setChecked([]);\n        setBulkAction('');\n        setNotificationFilters(ffilters);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_main_head\"\n  }, wp.element.createElement(\"div\", {\n    className: \"searchbox active\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-search\"\n  }), wp.element.createElement(\"input\", {\n    type: \"text\"\n  })), wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      var nargs = _objectSpread({}, args);\n\n      nargs.sorter = e.target.value;\n      setArgs(nargs);\n    }\n  }, Object.keys(window.vibebp.components.notifications.sorters).map(function (sorter) {\n    return wp.element.createElement(\"option\", {\n      value: sorter\n    }, window.vibebp.components.notifications.sorters[sorter]);\n  }))), !notifications.length && !isLoading ? wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_notifications_found) : wp.element.createElement(\"div\", {\n    className: \"table_block\"\n  }, wp.element.createElement(\"table\", {\n    className: \"table\"\n  }, wp.element.createElement(\"thead\", null, wp.element.createElement(\"th\", null, wp.element.createElement(\"div\", {\n    className: \"checkbox\"\n  }, wp.element.createElement(\"input\", {\n    id: \"selectall\",\n    type: \"checkbox\",\n    checked: checkAll ? 'checked' : '',\n    onClick: function onClick() {\n      if (checkAll) {\n        setcheckAll(false);\n      } else {\n        setcheckAll(true);\n        setChecked([]);\n      }\n    }\n  }), wp.element.createElement(\"label\", {\n    \"for\": \"selectall\"\n  }))), wp.element.createElement(\"th\", null, window.vibebp.translations.owner), wp.element.createElement(\"th\", null, window.vibebp.components.notifications.label), wp.element.createElement(\"th\", null, window.vibebp.translations.date), wp.element.createElement(\"th\", null, wp.element.createElement(\"a\", {\n    className: \"vicon vicon-more rotate90\"\n  }))), wp.element.createElement(\"tbody\", null, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : notifications.length ? notifications.map(function (notification) {\n    return wp.element.createElement(\"tr\", null, wp.element.createElement(\"td\", {\n      valign: \"center\"\n    }, wp.element.createElement(\"div\", {\n      className: \"checkbox\"\n    }, wp.element.createElement(\"input\", {\n      type: \"checkbox\",\n      onClick: function onClick() {\n        var nchecked = _toConsumableArray(checked);\n\n        if (checkAll) {\n          setcheckAll(false);\n          notifications.map(function (notification) {\n            nchecked.push(notification.id);\n          });\n        }\n\n        if (checked.indexOf(notification.id) === -1) {\n          nchecked.push(notification.id);\n          setChecked(nchecked);\n        } else {\n          nchecked.splice(checked.indexOf(notification.id), 1);\n          setChecked(nchecked);\n        }\n      },\n      checked: checkAll || checked.indexOf(notification.id) !== -1 ? 'checked' : '',\n      id: notification.id\n    }), wp.element.createElement(\"label\", {\n      \"for\": notification.id\n    }))), wp.element.createElement(\"td\", {\n      valign: \"center\"\n    }, wp.element.createElement(_avatar_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], {\n      type: notification.component_name,\n      id: {\n        item_id: notification.item_id,\n        secondary_item_id: notification.secondary_item_id,\n        user_id: notification.user_id\n      }\n    })), wp.element.createElement(\"td\", {\n      valign: \"center\"\n    }, wp.element.createElement(_notification_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      notification: notification,\n      update: updateNotification\n    })), wp.element.createElement(\"td\", {\n      valign: \"center\"\n    }, wp.element.createElement(_timer_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n      time: notification.date_notified\n    })), wp.element.createElement(\"td\", {\n      valign: \"center\"\n    }, wp.element.createElement(\"a\", {\n      className: \"vicon vicon-more rotate90\",\n      onClick: function onClick() {\n        if (showMenu) {\n          setShowMenu(false);\n        } else {\n          setShowMenu(notification.id);\n        }\n      }\n    }), showMenu === notification.id ? wp.element.createElement(\"ul\", {\n      className: \"target_menu\"\n    }, Object.keys(window.vibebp.components.notifications.actions).map(function (key) {\n      if (key !== args.filter) {\n        return wp.element.createElement(\"li\", {\n          value: key,\n          onClick: function onClick() {\n            updateNotification(notification.id, key);\n          }\n        }, window.vibebp.components.notifications.actions[key]);\n      }\n    })) : ''));\n  }) : '')), checkAll || checked.length ? wp.element.createElement(\"div\", {\n    className: \"bulk_actions\"\n  }, wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setBulkAction(e.target.value);\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.selectaction), Object.keys(window.vibebp.components.notifications.actions).map(function (key) {\n    if (key !== args.filter) {\n      return wp.element.createElement(\"option\", {\n        value: key\n      }, window.vibebp.components.notifications.actions[key]);\n    }\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: applybulkAction\n  }, window.vibebp.translations.apply)) : '', more ? wp.element.createElement(\"a\", {\n    className: \"link\",\n    onClick: function onClick() {\n      var nargs = _objectSpread({}, args);\n\n      nargs.page += 1;\n      setArgs(nargs);\n      setIsPagination(true);\n    }\n  }, window.vibebp.translations.more) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Notifications);\n\n//# sourceURL=webpack:///./src/profile/components/notifications/notifications.js?");

/***/ }),

/***/ "./src/profile/components/page.js":
/*!****************************************!*\
  !*** ./src/profile/components/page.js ***!
  \****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar LoadPage = function LoadPage(props) {\n  var _useState = useState(),\n      _useState2 = _slicedToArray(_useState, 2),\n      content = _useState2[0],\n      setContent = _useState2[1];\n\n  useEffect(function () {\n    if (props.page) {\n      console.log(props.page);\n      var grabPage = props.page.split('__');\n      fetch(\"\".concat(window.vibebp.api.url, \"/getPost/\"), {\n        method: 'post',\n        body: JSON.stringify({\n          post_type: grabPage[1],\n          id: grabPage[2],\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setContent(data.content);\n      });\n    }\n  }, [props.page]);\n  return wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: content\n    }\n  });\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (LoadPage);\n\n//# sourceURL=webpack:///./src/profile/components/page.js?");

/***/ }),

/***/ "./src/profile/components/profile/changeavatar.js":
/*!********************************************************!*\
  !*** ./src/profile/components/profile/changeavatar.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _uploader__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../uploader */ \"./src/profile/components/uploader.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ChangeAvatar = function ChangeAvatar(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      editMode = _useState2[0],\n      setEditImage = _useState2[1];\n\n  var _useState3 = useState(''),\n      _useState4 = _slicedToArray(_useState3, 2),\n      avatar = _useState4[0],\n      setAvatar = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      file = _useState6[0],\n      setFile = _useState6[1];\n\n  var _useState7 = useState({}),\n      _useState8 = _slicedToArray(_useState7, 2),\n      data = _useState8[0],\n      setData = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      isLoading = _useState10[0],\n      setIsLoading = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      isUpdated = _useState12[0],\n      setisUpdated = _useState12[1];\n\n  useEffect(function () {\n    setAvatar(select('vibebp').getUser().avatar);\n  }, []);\n\n  var updateImage = function updateImage() {\n    setIsLoading(true);\n    var form = {\n      cropdata: data,\n      token: select('vibebp').getToken()\n    };\n    var formData = new FormData();\n    formData.append(\"body\", JSON.stringify(form));\n    formData.append(\"file\", file);\n    fetch(\"\".concat(window.vibebp.api.url, \"/profile/avatar\"), {\n      method: 'post',\n      body: formData\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setIsLoading(false);\n\n      if (data.status) {\n        setisUpdated(false);\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      }\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"profile_avatar_wrapper\"\n  }, wp.element.createElement(\"div\", {\n    className: \"profile_avatar\"\n  }, editMode ? wp.element.createElement(_uploader__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n    type: \"image\",\n    crop: \"1\",\n    update: function update(files, data) {\n      setisUpdated(true);\n      setFile(files[0]);\n      setData(data);\n    }\n  }) : wp.element.createElement(\"img\", {\n    src: avatar\n  })), wp.element.createElement(\"div\", {\n    className: \"profile_avatar_actions buttons\"\n  }, wp.element.createElement(\"a\", {\n    className: editMode ? 'button is-danger' : 'button is-info',\n    onClick: function onClick() {\n      setEditImage(!editMode);\n    }\n  }, editMode ? window.vibebp.translations.cancel : window.vibebp.translations.change_image), isUpdated ? wp.element.createElement(\"a\", {\n    className: isLoading ? 'button is-loading is-primary' : 'button is-primary',\n    onClick: updateImage\n  }, window.vibebp.translations.update_image) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ChangeAvatar);\n\n//# sourceURL=webpack:///./src/profile/components/profile/changeavatar.js?");

/***/ }),

/***/ "./src/profile/components/profile/edit.js":
/*!************************************************!*\
  !*** ./src/profile/components/profile/edit.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _field__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./field */ \"./src/profile/components/profile/field.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar EditProfile = function EditProfile(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    avatar: {},\n    groups: [],\n    fields: [],\n    cover: {}\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      profileDetails = _useState4[0],\n      setProfileDetails = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/allfields\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        var nprofileDetails = _objectSpread({}, profileDetails);\n\n        nprofileDetails.groups = data.groups;\n        nprofileDetails.fields = data.fields;\n        setProfileDetails(nprofileDetails);\n      }\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"edit_profile\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    className: \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : wp.element.createElement(Fragment, null, profileDetails.groups.length ? profileDetails.groups.map(function (group) {\n    return wp.element.createElement(\"div\", {\n      className: \"portal\"\n    }, wp.element.createElement(\"div\", {\n      className: \"portal_header\"\n    }, wp.element.createElement(\"strong\", null, group.name)), wp.element.createElement(\"div\", {\n      className: \"portal_body\"\n    }, profileDetails.fields.filter(function (item) {\n      return item.group_id == group.id;\n    }).length ? wp.element.createElement(\"ul\", {\n      className: \"vibebp_form\"\n    }, profileDetails.fields.filter(function (item) {\n      return item.group_id == group.id;\n    }).map(function (field) {\n      return wp.element.createElement(_field__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n        field: field\n      });\n    })) : ''));\n  }) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (EditProfile);\n\n//# sourceURL=webpack:///./src/profile/components/profile/edit.js?");

/***/ }),

/***/ "./src/profile/components/profile/field.js":
/*!*************************************************!*\
  !*** ./src/profile/components/profile/field.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var vanilla_picker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vanilla-picker */ \"./node_modules/vanilla-picker/dist/vanilla-picker.mjs\");\n/* harmony import */ var react_flatpickr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-flatpickr */ \"./node_modules/react-flatpickr/build/index.js\");\n/* harmony import */ var react_flatpickr__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_flatpickr__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\n/* harmony import */ var _social__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./social */ \"./src/profile/components/profile/social.js\");\n/* harmony import */ var _location__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./location */ \"./src/profile/components/profile/location.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ProfileField = function ProfileField(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isChange = _useState2[0],\n      setIsChange = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isLoading = _useState4[0],\n      setIsLoading = _useState4[1];\n\n  var _useState5 = useState(props.field),\n      _useState6 = _slicedToArray(_useState5, 2),\n      field = _useState6[0],\n      setField = _useState6[1];\n\n  useEffect(function () {\n    if (field.type == 'checkbox' || field.type == 'selectbox' || field.type == 'radio' || field.type == 'multiselect' || field.type == 'location') {\n      fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/field/options\"), {\n        method: 'post',\n        body: JSON.stringify({\n          field_id: field.id,\n          type: field.type,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.status) {\n          setField(_objectSpread({}, field, {\n            options: data.values\n          }));\n        }\n      });\n    }\n\n    var event = new CustomEvent(\"field_loaded\", {\n      detail: {\n        field: field\n      }\n    });\n    document.dispatchEvent(event);\n  }, []);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_2__[\"useThrottledEffect\"])(function () {\n    if (isChange) {\n      setIsLoading(true);\n      fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/field/save\"), {\n        method: 'post',\n        body: JSON.stringify({\n          field_id: field.id,\n          type: field.type,\n          value: field.value,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setIsLoading(false);\n\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    }\n  }, 500, [field.value]);\n  return wp.element.createElement(\"div\", {\n    className: isLoading ? 'vibebp_form_field control is-loading' : 'vibebp_form_field control'\n  }, wp.element.createElement(\"label\", null, field.name, \" \", wp.element.createElement(\"span\", null, window.vibebp.components.xprofile.visibility[field.visibility])), field.type === 'textbox' ? wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: field.value,\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    }\n  }) : field.type === 'number' ? wp.element.createElement(\"input\", {\n    type: \"number\",\n    value: field.value,\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    }\n  }) : field.type === 'telephone' ? wp.element.createElement(\"input\", {\n    type: \"number\",\n    value: field.value,\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    }\n  }) : field.type === 'url' ? wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: field.value,\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    }\n  }) : field.type === 'textarea' ? wp.element.createElement(\"textarea\", {\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    }\n  }, field.value) : field.type === 'selectbox' ? wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    },\n    value: field.value\n  }, field.hasOwnProperty('options') ? field.options.map(function (option, i) {\n    return wp.element.createElement(\"option\", {\n      value: option.name\n    }, option.name);\n  }) : '') : field.type === 'radio' ? wp.element.createElement(\"div\", {\n    className: \"vibebp_field_group\"\n  }, field.hasOwnProperty('options') ? field.options.map(function (option, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"radio\"\n    }, wp.element.createElement(\"input\", {\n      id: option.id,\n      type: \"radio\",\n      value: option.name,\n      checked: field.value === option.name ? true : false,\n      onChange: function onChange(e) {\n        setField(_objectSpread({}, field, {\n          value: e.target.value\n        }));\n        setIsChange(true);\n      }\n    }), wp.element.createElement(\"label\", {\n      \"for\": option.id\n    }, option.name));\n  }) : '') : field.type === 'checkbox' ? wp.element.createElement(\"div\", {\n    className: \"vibebp_field_group\"\n  }, field.hasOwnProperty('options') ? field.options.map(function (option, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"checkbox\"\n    }, wp.element.createElement(\"input\", {\n      type: \"checkbox\",\n      id: option.id,\n      value: option.name,\n      checked: field.value.indexOf(option.name) === -1 ? false : true,\n      onChange: function onChange(e) {\n        if (field.value.indexOf(option.name) === -1) {\n          var arr = _toConsumableArray(field.value);\n\n          arr.push(option.name);\n          setField(_objectSpread({}, field, {\n            value: arr\n          }));\n        } else {\n          var _arr2 = _toConsumableArray(field.value);\n\n          _arr2.splice(field.value.indexOf(option.name), 1);\n\n          setField(_objectSpread({}, field, {\n            value: _arr2\n          }));\n        }\n\n        setIsChange(true);\n      }\n    }), wp.element.createElement(\"label\", {\n      \"for\": option.id\n    }, option.name));\n  }) : '') : field.type === 'multiselectbox' ? wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    },\n    value: field.value,\n    multiple: true\n  }, field.hasOwnProperty('options') ? field.options.map(function (option, i) {\n    return wp.element.createElement(\"option\", {\n      value: option.name\n    }, option.name);\n  }) : '') : field.type === 'datebox' ? wp.element.createElement(react_flatpickr__WEBPACK_IMPORTED_MODULE_1___default.a, {\n    options: {\n      dateFormat: field.date_format,\n      value: new Date(field.value),\n      defaultDate: new Date(field.value)\n    },\n    onChange: function onChange(date) {\n      setField(_objectSpread({}, field, {\n        value: flatpickr.formatDate(date[0], field.date_format)\n      }));\n      setIsChange(true);\n    }\n  }) : field.type === 'country' ? wp.element.createElement(\"select\", {\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: e.target.value\n      }));\n      setIsChange(true);\n    },\n    value: field.value\n  }, Object.keys(window.vibebp.components.xprofile.countries).length ? Object.keys(window.vibebp.components.xprofile.countries).map(function (option, i) {\n    return wp.element.createElement(\"option\", {\n      value: option\n    }, window.vibebp.components.xprofile.countries[option]);\n  }) : '') : field.type === 'color' ? wp.element.createElement(\"span\", {\n    className: \"vibebp_color_field\",\n    style: {\n      background: field.value\n    },\n    ref: function ref(_ref) {\n      var picker = new vanilla_picker__WEBPACK_IMPORTED_MODULE_0__[\"default\"](_ref);\n\n      picker.onChange = function (color) {\n        _ref.style.background = color.rgbaString;\n        setField(_objectSpread({}, field, {\n          value: color.rgbaString\n        }));\n        setIsChange(true);\n      };\n    }\n  }) : field.type === 'location' ? wp.element.createElement(_location__WEBPACK_IMPORTED_MODULE_4__[\"default\"], {\n    field: field\n  }) : field.type === 'social' ? wp.element.createElement(_social__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {\n    field: field\n  }) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ProfileField);\n\n//# sourceURL=webpack:///./src/profile/components/profile/field.js?");

/***/ }),

/***/ "./src/profile/components/profile/location.js":
/*!****************************************************!*\
  !*** ./src/profile/components/profile/location.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar LocationField = function LocationField(props) {\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState(props.field),\n      _useState4 = _slicedToArray(_useState3, 2),\n      field = _useState4[0],\n      setField = _useState4[1];\n\n  var _useState5 = useState(),\n      _useState6 = _slicedToArray(_useState5, 2),\n      currentRef = _useState6[0],\n      setCurrentRef = _useState6[1];\n\n  var _useState7 = useState(),\n      _useState8 = _slicedToArray(_useState7, 2),\n      googleMap = _useState8[0],\n      setGoogleMap = _useState8[1];\n\n  var _useState9 = useState(),\n      _useState10 = _slicedToArray(_useState9, 2),\n      marker = _useState10[0],\n      setMarker = _useState10[1];\n\n  var _useState11 = useState(),\n      _useState12 = _slicedToArray(_useState11, 2),\n      geocoder = _useState12[0],\n      setGeoCoder = _useState12[1];\n\n  var _useState13 = useState(''),\n      _useState14 = _slicedToArray(_useState13, 2),\n      search = _useState14[0],\n      setSearchText = _useState14[1];\n\n  var _useState15 = useState([]),\n      _useState16 = _slicedToArray(_useState15, 2),\n      results = _useState16[0],\n      setResults = _useState16[1];\n\n  Object(_functions__WEBPACK_IMPORTED_MODULE_0__[\"useThrottledEffect\"])(function () {\n    if (!isLoading && props.field.value !== field.value) {\n      fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/field/save\"), {\n        method: 'post',\n        body: JSON.stringify({\n          field_id: field.id,\n          type: 'location',\n          value: field.value,\n          token: select('vibebp').getToken()\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        if (data.hasOwnProperty('message')) {\n          dispatch('vibebp').addNotification({\n            text: data.message\n          });\n        }\n      });\n    }\n  }, 500, [field.value]);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_0__[\"useThrottledEffect\"])(function () {\n    if (!isLoading) {\n      var ac = new google.maps.places.AutocompleteService();\n\n      if (search.length) {\n        ac.getQueryPredictions({\n          input: search\n        }, function (predictions, status) {\n          if (status != google.maps.places.PlacesServiceStatus.OK) return;\n\n          var nresults = _toConsumableArray(results);\n\n          predictions.forEach(function (prediction) {\n            nresults.push(prediction.description);\n          });\n          setResults(nresults);\n        });\n      }\n    }\n  }, 500, [search]); //\n\n  useEffect(function () {\n    if (currentRef) {\n      if (window.hasOwnProperty('google') && window.google.hasOwnProperty('maps')) {\n        var latlng = {\n          lat: -34.397,\n          lng: 150.644\n        }; //new google.maps.LatLng(-34.397, 150.644);\n\n        var mapOptions = {\n          zoom: 16,\n          center: latlng,\n          mapTypeId: google.maps.MapTypeId.ROADMAP,\n          imageDefaultUI: true\n        };\n        var gmap = new google.maps.Map(currentRef, mapOptions);\n        setGoogleMap(gmap);\n        var nmarker = new google.maps.Marker({\n          map: gmap,\n          position: latlng,\n          animation: google.maps.Animation.DROP\n        });\n        setMarker(nmarker);\n        setIsLoading(false);\n        setGeoCoder(new google.maps.Geocoder());\n      } else {\n        var googleScript = window.document.createElement(\"script\");\n        googleScript.src = \"https://maps.googleapis.com/maps/api/js?key=\".concat(window.vibebp.settings.google_maps_api_key, \"&libraries=places\");\n        googleScript.async = true;\n        window.document.body.appendChild(googleScript);\n        googleScript.addEventListener('load', function () {\n          var latlng = {\n            lat: -34.397,\n            lng: 150.644\n          }; //new google.maps.LatLng(-34.397, 150.644);\n\n          var mapOptions = {\n            zoom: 16,\n            center: latlng,\n            mapTypeId: google.maps.MapTypeId.ROADMAP,\n            imageDefaultUI: true\n          };\n          var gmap = new google.maps.Map(currentRef, mapOptions);\n          setGoogleMap(gmap);\n          var image = {\n            url: window.vibebp.settings.map_marker,\n            size: new google.maps.Size(51, 32),\n            origin: new google.maps.Point(0, 0),\n            anchor: new google.maps.Point(21, 30)\n          };\n          var nmarker = new google.maps.Marker({\n            map: gmap,\n            position: latlng,\n            animation: google.maps.Animation.DROP,\n            draggable: true,\n            icon: image\n          });\n          setMarker(nmarker);\n          setIsLoading(false);\n          setGeoCoder(new google.maps.Geocoder());\n        });\n      }\n    }\n  }, [currentRef]);\n  useEffect(function () {\n    if (!isLoading) {\n      if (!field.value) {\n        locateMe();\n      } else {\n        var x = field.value;\n\n        if (!Array.isArray(x)) {\n          x.split(',');\n        }\n\n        if (x.length) {\n          var nfield = _objectSpread({}, field);\n\n          if (x.length === 6) {\n            nfield.value = {\n              lat: x[0],\n              lng: x[1],\n              address: x[2],\n              zipcode: x[3],\n              city: x[4],\n              country: x[5]\n            };\n          }\n\n          var center = new google.maps.LatLng(x[0], x[1]);\n          setField(nfield);\n          googleMap.setCenter(center);\n          marker.setPosition(center);\n        }\n      }\n\n      window.google.maps.event.addListener(marker, 'dragend', function (evt) {\n        new google.maps.Geocoder().geocode({\n          location: evt.latLng\n        }, function (results, status) {\n          if (status == 'OK') {\n            console.log(results);\n            googleMap.setCenter(results[0].geometry.location);\n            setField(_objectSpread({}, field, {\n              value: {\n                lat: results[0].geometry.location.lat(),\n                lng: results[0].geometry.location.lng(),\n                address: results[0].formatted_address,\n                zipcode: results[0].address_components[results[0].address_components.findIndex(function (ac) {\n                  return ac.types.indexOf('postal_code') !== -1;\n                })].long_name,\n                city: results[0].address_components[results[0].address_components.findIndex(function (ac) {\n                  return ac.types.indexOf('locality') !== -1;\n                })].long_name,\n                country: results[0].address_components[results[0].address_components.findIndex(function (ac) {\n                  return ac.types.indexOf('country') !== -1;\n                })].long_name\n              }\n            }));\n          }\n        });\n      });\n    }\n  }, [isLoading]);\n\n  var locateSearch = function locateSearch() {\n    if (geocoder) {\n      new google.maps.Geocoder().geocode({\n        address: search\n      }, function (results, status) {\n        if (status == 'OK') {\n          googleMap.setCenter(results[0].geometry.location);\n          marker.setPosition(results[0].geometry.location);\n        }\n\n        setResults([]);\n      });\n    }\n  };\n\n  var locateMe = function locateMe() {\n    console.log('...locating');\n\n    if (\"geolocation\" in navigator) {\n      navigator.geolocation.getCurrentPosition(function (position) {\n        var nfield = _objectSpread({}, field);\n\n        console.log(position);\n        nfield.value = [position.coords.latitude, position.coords.longitude];\n        setField(nfield);\n        var center = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);\n        console.log(center);\n        googleMap.setCenter(center);\n        marker.setPosition(center); // if(geocoder){\n        // \tgeocoder.geocode({location:{lat:position.coords.latitude,lng:position.coords.longitude}}).then(\n        // \t  \tresponse => {\n        // \t    \tconsole.log(response);\n        // \t  \t},\n        // \t  \terror => {\n        // \t    \tconsole.error(error);\n        // \t  \t}\n        // \t);\n        // }\n      });\n    } else {\n      fetch(\"http://ip-api.com/json\", {\n        method: 'get'\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        console.log(data);\n\n        var nfield = _objectSpread({}, field);\n\n        nfield.value = {\n          lat: data.lat,\n          lng: data.lng\n        };\n        setField(nfield);\n        var center = new google.maps.LatLng(data.lat, data.lng);\n\n        if (geocoder) {\n          geocoder.geocode({\n            location: {\n              lat: data.lat,\n              lng: data.lng\n            }\n          }).then(function (response) {\n            console.log(response);\n          }, function (error) {\n            console.error(error);\n          });\n        }\n      });\n    }\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_profile_field location\"\n  }, wp.element.createElement(\"div\", {\n    className: \"search_me\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-target\",\n    onClick: locateMe\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: search,\n    onChange: function onChange(e) {\n      setSearchText(e.target.value);\n    }\n  }), search.length ? wp.element.createElement(\"span\", {\n    className: \"vicon vicon-close\",\n    onClick: function onClick() {\n      setSearchText('');\n      setResults([]);\n    }\n  }) : '', wp.element.createElement(\"span\", {\n    className: search.length ? 'vicon vicon-search is_active' : 'vicon vicon-search',\n    onClick: locateSearch\n  })), results.length ? wp.element.createElement(\"div\", {\n    className: \"vibebp_autocomplete_results\"\n  }, results.map(function (result) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_autocomplete_result\",\n      onClick: function onClick() {\n        setSearchText(result);\n        setResults([]);\n        locateSearch();\n      }\n    }, result);\n  })) : '', wp.element.createElement(\"div\", {\n    className: \"google_map_locator\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    className: \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : '', wp.element.createElement(\"div\", {\n    ref: function ref(_ref) {\n      if (_ref && !currentRef) {\n        setCurrentRef(_ref);\n      }\n    },\n    style: {\n      height: '400px',\n      width: '100%'\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"google_map_details\"\n  }, wp.element.createElement(\"textarea\", {\n    placeholder: window.vibebp.translations.address,\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: _objectSpread({}, field.value, {\n          address: e.target.value\n        })\n      }));\n    },\n    value: field.value.hasOwnProperty('address') ? field.value.address : ''\n  }), wp.element.createElement(\"div\", {\n    className: \"gmap_fields\"\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: _objectSpread({}, field.value, {\n          zipcode: e.target.value\n        })\n      }));\n    },\n    placeholder: window.vibebp.translations.zipcode,\n    value: field.value.hasOwnProperty('zipcode') ? field.value.zipcode : ''\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    onChange: function onChange(e) {\n      setField(_objectSpread({}, field, {\n        value: _objectSpread({}, field.value, {\n          city: e.target.value\n        })\n      }));\n    },\n    placeholder: window.vibebp.translations.city,\n    value: field.value.hasOwnProperty('city') ? field.value.city : ''\n  }), wp.element.createElement(\"input\", {\n    type: \"text\",\n    placeholder: window.vibebp.translations.country,\n    value: field.value.hasOwnProperty('country') ? field.value.country : ''\n  }))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (LocationField);\n\n//# sourceURL=webpack:///./src/profile/components/profile/location.js?");

/***/ }),

/***/ "./src/profile/components/profile/profile.js":
/*!***************************************************!*\
  !*** ./src/profile/components/profile/profile.js ***!
  \***************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _userprofile_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./userprofile.js */ \"./src/profile/components/profile/userprofile.js\");\n/* harmony import */ var _edit_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./edit.js */ \"./src/profile/components/profile/edit.js\");\n/* harmony import */ var _changeavatar_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./changeavatar.js */ \"./src/profile/components/profile/changeavatar.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Profile = function Profile(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState('public'),\n      _useState4 = _slicedToArray(_useState3, 2),\n      activeTab = _useState4[0],\n      setActiveTab = _useState4[1];\n\n  var _useState5 = useState([]),\n      _useState6 = _slicedToArray(_useState5, 2),\n      profileFilters = _useState6[0],\n      setProfileFilters = _useState6[1];\n\n  useEffect(function () {\n    var profile_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'profile';\n    });\n    profile_filters.map(function (filter, index) {\n      if (profile_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        profile_filters[index][\"class\"].push('current-menu-item');\n      }\n    });\n    setProfileFilters(profile_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.profile.label), profileFilters.map(function (filter, i) {\n    return wp.element.createElement(\"a\", {\n      className: filter[\"class\"].join(' '),\n      onClick: function onClick(e) {\n        var ffilters = _toConsumableArray(profileFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setProfileFilters(ffilters);\n        setActiveTab(ffilters[i].css_id);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    className: \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : activeTab === 'edit' ? wp.element.createElement(_edit_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null) : activeTab === 'change-avatar' ? wp.element.createElement(_changeavatar_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], null) : wp.element.createElement(_userprofile_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Profile);\n\n//# sourceURL=webpack:///./src/profile/components/profile/profile.js?");

/***/ }),

/***/ "./src/profile/components/profile/social.js":
/*!**************************************************!*\
  !*** ./src/profile/components/profile/social.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar SocialField = function SocialField(props) {\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState(props.field),\n      _useState4 = _slicedToArray(_useState3, 2),\n      field = _useState4[0],\n      setField = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      addIcon = _useState6[0],\n      setAddIcon = _useState6[1];\n\n  var _useState7 = useState({\n    icon: '',\n    url: ''\n  }),\n      _useState8 = _slicedToArray(_useState7, 2),\n      icon = _useState8[0],\n      setIcon = _useState8[1];\n\n  var _useState9 = useState([]),\n      _useState10 = _slicedToArray(_useState9, 2),\n      icons = _useState10[0],\n      setIcons = _useState10[1];\n\n  useEffect(function () {\n    if (typeof props.field.value === 'string' && props.field.value.length) {\n      setIcons(JSON.parse(props.field.value));\n    }\n  }, []);\n\n  var saveIcons = function saveIcons() {\n    if (icon.url.length) {\n      var ics = _toConsumableArray(icons);\n\n      ics.push(icon);\n      setIcons(ics);\n      setAddIcon(false);\n      setIcon({\n        icon: '',\n        url: ''\n      });\n      saveIconAPI(ics);\n    }\n  };\n\n  var saveIconAPI = function saveIconAPI(ics) {\n    console.log(icons);\n    fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/field/save\"), {\n      method: 'post',\n      body: JSON.stringify({\n        field_id: field.id,\n        value: JSON.stringify(ics),\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      dispatch('vibebp').addNotification({\n        text: data.message\n      });\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_profile_field social\"\n  }, icons.length ? wp.element.createElement(\"div\", {\n    className: \"social_icons_list\"\n  }, icons.map(function (ic, i) {\n    return wp.element.createElement(\"div\", {\n      className: \"social_icon_wrapper\"\n    }, wp.element.createElement(\"div\", {\n      className: \"social_icon\"\n    }, wp.element.createElement(\"span\", {\n      className: ic.icon\n    }), wp.element.createElement(\"span\", null, ic.url)), wp.element.createElement(\"span\", {\n      className: \"vicon vicon-close\",\n      onClick: function onClick() {\n        var nic = _toConsumableArray(icons);\n\n        nic.splice(i, 1);\n        setIcons(nic);\n        saveIconAPI(nic);\n      }\n    }));\n  })) : '', wp.element.createElement(\"a\", {\n    className: addIcon ? 'vicon vicon-close' : 'vicon vicon-plus',\n    onClick: function onClick() {\n      setAddIcon(!addIcon);\n    }\n  }), addIcon ? wp.element.createElement(\"div\", {\n    className: \"add_social_icon\"\n  }, wp.element.createElement(\"div\", {\n    className: \"social_icons\"\n  }, window.vibebp.social_icons.map(function (i) {\n    return wp.element.createElement(\"div\", {\n      className: icon.icon === i.icon ? 'social_icon selected' : 'social_icon',\n      onClick: function onClick() {\n        setIcon(_objectSpread({}, icon, {\n          icon: i.icon\n        }));\n      }\n    }, wp.element.createElement(\"span\", {\n      className: i.icon\n    }), wp.element.createElement(\"span\", null, i.label));\n  })), wp.element.createElement(\"div\", {\n    className: !icon.url.length || Object(_functions__WEBPACK_IMPORTED_MODULE_0__[\"validateUrl\"])(icon.url) ? 'social_icon_url' : 'social_icon_url error'\n  }, wp.element.createElement(\"input\", {\n    type: \"text\",\n    onChange: function onChange(e) {\n      setIcon(_objectSpread({}, icon, {\n        url: e.target.value\n      }));\n    },\n    value: icon.url\n  })), wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: saveIcons\n  }, window.vibebp.translations.set_icon)) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (SocialField);\n\n//# sourceURL=webpack:///./src/profile/components/profile/social.js?");

/***/ }),

/***/ "./src/profile/components/profile/userprofile.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/profile/userprofile.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar UserProfile = function UserProfile(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState(''),\n      _useState4 = _slicedToArray(_useState3, 2),\n      profileHtml = _useState4[0],\n      setProfileHtml = _useState4[1];\n\n  useEffect(function () {\n    setIsLoading(true);\n    var obj = {\n      token: select('vibebp').getToken()\n    };\n\n    if (props.hasOwnProperty('id')) {\n      obj.id = props.id;\n    }\n\n    fetch(\"\".concat(window.vibebp.api.url, \"/profile/\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setIsLoading(false);\n      setProfileHtml(data);\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"user_profile\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    className: \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : wp.element.createElement(\"div\", {\n    dangerouslySetInnerHTML: {\n      __html: profileHtml\n    }\n  }));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (UserProfile);\n\n//# sourceURL=webpack:///./src/profile/components/profile/userprofile.js?");

/***/ }),

/***/ "./src/profile/components/settings/email.js":
/*!**************************************************!*\
  !*** ./src/profile/components/settings/email.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar EmailSettings = function EmailSettings(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({}),\n      _useState4 = _slicedToArray(_useState3, 2),\n      settings = _useState4[0],\n      setSettings = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/settings/email\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      setSettings(data);\n    });\n  }, []);\n\n  var changeEmailSetting = function changeEmailSetting(key, set) {\n    var nsettings = _objectSpread({}, settings);\n\n    nsettings[key].value = set;\n    setSettings(nsettings);\n    fetch(\"\".concat(window.vibebp.api.url, \"/settings/email/set\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken(),\n        setting: key,\n        value: set\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n  };\n\n  return wp.element.createElement(\"div\", {\n    \"class\": \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.send_email_notice)), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : Object.keys(settings).length ? wp.element.createElement(Fragment, null, Object.keys(settings).map(function (key) {\n    return wp.element.createElement(\"div\", {\n      className: \"setting\"\n    }, wp.element.createElement(\"label\", null, settings[key].label), wp.element.createElement(\"div\", {\n      className: \"switch\"\n    }, settings[key].value == 'yes' ? wp.element.createElement(\"input\", {\n      type: \"checkbox\",\n      id: key,\n      checked: true,\n      onClick: function onClick() {\n        return changeEmailSetting(key, 'no');\n      }\n    }) : wp.element.createElement(\"input\", {\n      type: \"checkbox\",\n      id: key,\n      onClick: function onClick() {\n        return changeEmailSetting(key, 'yes');\n      }\n    }), wp.element.createElement(\"label\", {\n      \"for\": key,\n      className: \"slider\"\n    })));\n  })) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (EmailSettings);\n\n//# sourceURL=webpack:///./src/profile/components/settings/email.js?");

/***/ }),

/***/ "./src/profile/components/settings/export_data.js":
/*!********************************************************!*\
  !*** ./src/profile/components/settings/export_data.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ExportDataSettings = function ExportDataSettings(props) {\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    status: '',\n    label: '',\n    exports: '',\n    message: '',\n    submessage: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      data = _useState4[0],\n      setData = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/settings/export_data\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      setData(data);\n    });\n  }, []);\n\n  var requestReport = function requestReport() {\n    fetch(\"\".concat(window.vibebp.api.url, \"/settings/email/set\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n  };\n\n  return wp.element.createElement(\"div\", {\n    \"class\": \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.export_data_settings)), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : data.exports.length ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"export_data_items\",\n    dangerouslySetInnerHTML: {\n      __html: data.exports\n    }\n  }), data.label ? data.hasOwnProperty('report_link') && data.report_link ? wp.element.createElement(\"a\", {\n    href: data.report_link,\n    className: \"button is-primary\"\n  }, data.status) : wp.element.createElement(\"a\", {\n    className: \"button is-primary\",\n    onClick: requestReport\n  }, data.label) : '') : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ExportDataSettings);\n\n//# sourceURL=webpack:///./src/profile/components/settings/export_data.js?");

/***/ }),

/***/ "./src/profile/components/settings/general.js":
/*!****************************************************!*\
  !*** ./src/profile/components/settings/general.js ***!
  \****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar GeneralSettings = function GeneralSettings(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setIsLoading = _useState2[1];\n\n  var _useState3 = useState(window.vibebp.translations.save_changes),\n      _useState4 = _slicedToArray(_useState3, 2),\n      message = _useState4[0],\n      setMessage = _useState4[1];\n\n  var _useState5 = useState({\n    email: '',\n    pwd: '',\n    'pass1': '',\n    pass2: ''\n  }),\n      _useState6 = _slicedToArray(_useState5, 2),\n      args = _useState6[0],\n      setArgs = _useState6[1];\n\n  var saveChanges = function saveChanges() {\n    setIsLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/settings/save\"), {\n      method: 'post',\n      body: JSON.stringify(_objectSpread({}, args, {\n        token: select('vibebp').getToken()\n      }))\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setIsLoading(false);\n      setMessage(data.message);\n      setTimeout(function () {\n        setMessage(window.vibebp.translations.save_changes);\n      }, 3000);\n    });\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.account_email)), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.account_email), wp.element.createElement(\"input\", {\n    type: \"text\",\n    value: args.email,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        email: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.change_password), wp.element.createElement(\"input\", {\n    type: \"password\",\n    value: args.pwd,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        pwd: e.target.value\n      }));\n    }\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(\"label\", null, window.vibebp.translations.repeat_new_password), wp.element.createElement(\"input\", {\n    type: \"password\",\n    value: args.pass1,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        pass1: e.target.value,\n        pass2: args.pwd\n      }));\n    }\n  })), wp.element.createElement(\"a\", {\n    className: isLoading ? 'button is-primary is-loading' : 'button is-primary',\n    onClick: saveChanges\n  }, message))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (GeneralSettings);\n\n//# sourceURL=webpack:///./src/profile/components/settings/general.js?");

/***/ }),

/***/ "./src/profile/components/settings/settings.js":
/*!*****************************************************!*\
  !*** ./src/profile/components/settings/settings.js ***!
  \*****************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _general__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./general */ \"./src/profile/components/settings/general.js\");\n/* harmony import */ var _export_data__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./export_data */ \"./src/profile/components/settings/export_data.js\");\n/* harmony import */ var _email__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./email */ \"./src/profile/components/settings/email.js\");\n/* harmony import */ var _visibility__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./visibility */ \"./src/profile/components/settings/visibility.js\");\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Settings = function Settings(props) {\n  return wp.element.createElement(\"div\", {\n    \"class\": \"profile_settings\"\n  }, wp.element.createElement(_general__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null), wp.element.createElement(_visibility__WEBPACK_IMPORTED_MODULE_3__[\"default\"], null), wp.element.createElement(_email__WEBPACK_IMPORTED_MODULE_2__[\"default\"], null), wp.element.createElement(_export_data__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Settings);\n\n//# sourceURL=webpack:///./src/profile/components/settings/settings.js?");

/***/ }),

/***/ "./src/profile/components/settings/visibility.js":
/*!*******************************************************!*\
  !*** ./src/profile/components/settings/visibility.js ***!
  \*******************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar VisbilitySettings = function VisbilitySettings(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({}),\n      _useState4 = _slicedToArray(_useState3, 2),\n      settings = _useState4[0],\n      setSettings = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/fields\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n      setSettings(data);\n    });\n  }, []);\n\n  var changeFieldVisibility = function changeFieldVisibility(field, visbility) {\n    var nsettings = _objectSpread({}, settings);\n\n    nsettings.fields[nsettings.fields.findIndex(function (f) {\n      return f.id === field.id;\n    })].visibility = visibility;\n    setSettings(nsettings);\n    fetch(\"\".concat(window.vibebp.api.url, \"/xprofile/fields/setvisibility\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken(),\n        field_id: field.id,\n        visibility: visibility\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {});\n  };\n\n  return wp.element.createElement(\"div\", {\n    \"class\": \"portal\"\n  }, wp.element.createElement(\"div\", {\n    className: \"portal_header\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.visibility_settings)), wp.element.createElement(\"div\", {\n    className: \"portal_body\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : Object.keys(settings).length ? wp.element.createElement(Fragment, null, settings.groups.map(function (group) {\n    return wp.element.createElement(\"div\", {\n      className: \"setting_group\"\n    }, wp.element.createElement(\"label\", null, group.name), settings.fields.filter(function (item) {\n      return item.group_id === group.id;\n    }).map(function (field) {\n      return wp.element.createElement(\"div\", {\n        className: \"setting_field\"\n      }, wp.element.createElement(\"strong\", null, field.name), wp.element.createElement(\"select\", {\n        value: field.visbility,\n        onChange: function onChange(e) {\n          return changeFieldVisibility(field, e.target.value);\n        }\n      }, Object.keys(window.vibebp.components.xprofile.visibility).map(function (key) {\n        return wp.element.createElement(\"option\", {\n          value: key\n        }, window.vibebp.components.xprofile.visibility[key]);\n      })));\n    }));\n  })) : ''));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (VisbilitySettings);\n\n//# sourceURL=webpack:///./src/profile/components/settings/visibility.js?");

/***/ }),

/***/ "./src/profile/components/shop/addresses.js":
/*!**************************************************!*\
  !*** ./src/profile/components/shop/addresses.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _functions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../functions */ \"./src/profile/components/functions.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ShopAddresses = function ShopAddresses(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({}),\n      _useState4 = _slicedToArray(_useState3, 2),\n      addresses = _useState4[0],\n      setAddresses = _useState4[1];\n\n  var _useState5 = useState(),\n      _useState6 = _slicedToArray(_useState5, 2),\n      editField = _useState6[0],\n      setEditField = _useState6[1];\n\n  var _useState7 = useState(false),\n      _useState8 = _slicedToArray(_useState7, 2),\n      isUpdatingField = _useState8[0],\n      setisUpdatingField = _useState8[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/wc/addresses\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setAddresses(data.addresses);\n      }\n    });\n  }, []);\n  Object(_functions__WEBPACK_IMPORTED_MODULE_0__[\"useThrottledEffect\"])(function () {\n    if (isUpdatingField) {\n      var key_val = editField.split('-');\n      fetch(\"\".concat(window.vibebp.api.url, \"/wc/addresses/update\"), {\n        method: 'post',\n        body: JSON.stringify({\n          token: select('vibebp').getToken(),\n          'address_type': key_val[0],\n          'field': key_val[1],\n          value: addresses[key_val[0]][key_val[1]].value\n        })\n      }).then(function (res) {\n        return res.json();\n      }).then(function (data) {\n        setisUpdatingField(false);\n\n        if (!data.status) {\n          if (data.hasOwnProperty('message')) {\n            dispatch('vibebp').addNotification({\n              text: data.message\n            });\n          }\n        }\n      });\n    }\n  }, 500, [addresses]);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_wc_addresses\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : Object.keys(addresses).length ? Object.keys(addresses).map(function (key) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_wc_address\"\n    }, wp.element.createElement(\"strong\", null, window.vibebp.translations[key]), Object.keys(addresses[key]).map(function (k) {\n      return wp.element.createElement(\"div\", {\n        className: \"vibebp_wc_address_field\"\n      }, wp.element.createElement(\"span\", {\n        onClick: function onClick() {\n          editField !== key + '-' + k ? setEditField(key + '-' + k) : setEditField(false);\n        }\n      }, addresses[key][k].label, editField === key + '-' + k ? wp.element.createElement(\"i\", null, window.vibebp.translations.cancel) : wp.element.createElement(\"span\", {\n        className: \"vicon vicon-pencil\"\n      })), editField === key + '-' + k ? wp.element.createElement(\"div\", {\n        className: isUpdatingField ? 'control is-loading' : 'control'\n      }, wp.element.createElement(\"input\", {\n        type: \"text\",\n        value: addresses[key][k].value,\n        onChange: function onChange(e) {\n          var nadd = _objectSpread({}, addresses);\n\n          nadd[key][k].value = e.target.value;\n          setAddresses(nadd);\n          setisUpdatingField(true);\n        }\n      })) : wp.element.createElement(\"span\", null, addresses[key][k].value));\n    }));\n  }) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ShopAddresses);\n\n//# sourceURL=webpack:///./src/profile/components/shop/addresses.js?");

/***/ }),

/***/ "./src/profile/components/shop/downloads.js":
/*!**************************************************!*\
  !*** ./src/profile/components/shop/downloads.js ***!
  \**************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar ShopDownloads = function ShopDownloads(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      downloads = _useState4[0],\n      setDownloads = _useState4[1];\n\n  useEffect(function () {\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/wc/downloads\"), {\n      method: 'post',\n      body: JSON.stringify({\n        token: select('vibebp').getToken()\n      })\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      setisLoading(false);\n\n      if (data.status) {\n        setDownloads(data.downloads);\n      }\n    });\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_wc_downloads\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : downloads.length ? downloads.map(function (download) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_wc_download\"\n    }, wp.element.createElement(\"strong\", null, download.download_name), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", null, window.vibebp.translations.product_name), download.product_name), download.downloads_remaining ? wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", null, window.vibebp.translations.remaining_downloads), download.downloads_remaining) : '', download.access_expires ? wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", null, window.vibebp.translations.access_expires), download.access_expires) : '', wp.element.createElement(\"a\", {\n      href: download.file.file,\n      target: \"_blank\",\n      className: \"button is-primary\"\n    }, wp.element.createElement(\"span\", {\n      className: \"vicon vicon-download\"\n    }), \" \", window.vibebp.translations.download));\n  }) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_downloads));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ShopDownloads);\n\n//# sourceURL=webpack:///./src/profile/components/shop/downloads.js?");

/***/ }),

/***/ "./src/profile/components/shop/order.js":
/*!**********************************************!*\
  !*** ./src/profile/components/shop/order.js ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Order = function Order(props) {\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_wc_full_order\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_wc_order_header\"\n  }, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-arrow-left\",\n    onClick: props.back\n  }), wp.element.createElement(\"span\", {\n    className: 'order_status ' + props.order.status\n  }, window.vibebp.components.shop.order_statuses['wc-' + props.order.status])), wp.element.createElement(\"div\", {\n    className: \"vibebp_order_details\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_order_main\"\n  }, wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vibebp_wc_order_label\"\n  }, window.vibebp.translations.order_number), \"#\", props.order.order_number), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vibebp_wc_order_label\"\n  }, window.vibebp.translations.order_date), props.order.created_at), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vibebp_wc_order_label\"\n  }, window.vibebp.translations.order_status), wp.element.createElement(\"span\", {\n    className: 'order_status ' + props.order.status\n  }, window.vibebp.components.shop.order_statuses['wc-' + props.order.status])), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vibebp_wc_order_label\"\n  }, window.vibebp.translations.order_amount), props.order.currency, \" \", props.order.total), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vibebp_wc_order_label\"\n  }, window.vibebp.translations.order_payment_method), props.order.payment_details.method_title)), wp.element.createElement(\"div\", {\n    className: \"vibebp_order_line_items\"\n  }, props.order.line_items.length ? props.order.line_items.map(function (item) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_order_line_item\"\n    }, wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.item_name), item.name, \" x \", item.quantity), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.item_total), item.subtotal, \" \", item.subtotal_tax !== \"0.00\" ? wp.element.createElement(\"span\", {\n      className: \"subtotal_tax\"\n    }, \"[\", item.subtotal_tax, \"]\") : ''));\n  }) : ''), props.order.fee_lines.length || props.order.shipping_lines.length || props.order.coupon_lines.length ? wp.element.createElement(\"div\", {\n    className: \"vibebp_order_extra_items\"\n  }, props.order.coupon_lines.length ? wp.element.createElement(Fragment, null, wp.element.createElement(\"strong\", null, window.vibebp.translations.coupons_applied), props.order.coupon_lines.map(function (coupon) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_order_coupon_item\"\n    }, wp.element.createElement(\"span\", null, coupon.code), wp.element.createElement(\"span\", null, coupon.amount));\n  })) : '', props.order.shipping_lines.length ? wp.element.createElement(Fragment, null, wp.element.createElement(\"strong\", null, window.vibebp.translations.shipping_rates), props.order.shipping_lines.map(function (shipping_line) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_order_coupon_item\"\n    }, wp.element.createElement(\"span\", null, shipping_line.method_title), wp.element.createElement(\"span\", null, shipping_line.total));\n  })) : '', props.order.fee_lines.length ? wp.element.createElement(Fragment, null, wp.element.createElement(\"strong\", null, window.vibebp.translations.fees), props.order.fee_lines.map(function (fee) {\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_order_coupon_item\"\n    }, wp.element.createElement(\"span\", null, fee.method_title), wp.element.createElement(\"span\", null, fee.total));\n  })) : '') : '', wp.element.createElement(\"div\", {\n    className: \"vibebp_addresses\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_billing_address\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.billing_address), wp.element.createElement(\"span\", null, props.order.billing_address.first_name, \" \", props.order.billing_address.last_name), wp.element.createElement(\"span\", null, props.order.billing_address.email, \" \", props.order.billing_address.phone), props.order.billing_address.company.length ? wp.element.createElement(\"span\", null, props.order.billing_address.company) : '', wp.element.createElement(\"span\", null, props.order.billing_address.address_1), props.order.billing_address.address_2.length ? wp.element.createElement(\"span\", null, props.order.billing_address.address_2) : '', wp.element.createElement(\"span\", null, props.order.billing_address.city, \" \", props.order.billing_address.state, \" \", props.order.billing_address.country, \" \", props.order.billing_address.pincode)), props.order.shipping_address.first_name.length ? wp.element.createElement(\"div\", {\n    className: \"vibebp_shipping_address\"\n  }, wp.element.createElement(\"strong\", null, window.vibebp.translations.shipping_address), wp.element.createElement(\"span\", null, props.order.shipping_address.first_name, \" \", props.order.shipping_address.last_name), wp.element.createElement(\"span\", null, props.order.shipping_address.email, \" \", props.order.shipping_address.phone), props.order.shipping_address.company.length ? wp.element.createElement(\"span\", null, props.order.shipping_address.company) : '', wp.element.createElement(\"span\", null, props.order.shipping_address.address_1), props.order.shipping_address.address_2.length ? wp.element.createElement(\"span\", null, props.order.shipping_address.address_2) : '', wp.element.createElement(\"span\", null, props.order.shipping_address.city, \" \", props.order.shipping_address.state, \" \", props.order.shipping_address.country, \" \", props.order.shipping_address.pincode)) : '')));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Order);\n\n//# sourceURL=webpack:///./src/profile/components/shop/order.js?");

/***/ }),

/***/ "./src/profile/components/shop/orders.js":
/*!***********************************************!*\
  !*** ./src/profile/components/shop/orders.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var react_flatpickr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react-flatpickr */ \"./node_modules/react-flatpickr/build/index.js\");\n/* harmony import */ var react_flatpickr__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_flatpickr__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _order__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./order */ \"./src/profile/components/shop/order.js\");\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\nvar ShopOrders = function ShopOrders(props) {\n  var _useState = useState(false),\n      _useState2 = _slicedToArray(_useState, 2),\n      isLoading = _useState2[0],\n      setisLoading = _useState2[1];\n\n  var _useState3 = useState({\n    page: 1,\n    order_date: '',\n    status: ''\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      args = _useState4[0],\n      setArgs = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      more = _useState6[0],\n      setMore = _useState6[1];\n\n  var _useState7 = useState([]),\n      _useState8 = _slicedToArray(_useState7, 2),\n      orders = _useState8[0],\n      setOrders = _useState8[1];\n\n  var _useState9 = useState(false),\n      _useState10 = _slicedToArray(_useState9, 2),\n      order = _useState10[0],\n      setOrder = _useState10[1];\n\n  var _useState11 = useState(false),\n      _useState12 = _slicedToArray(_useState11, 2),\n      isPagination = _useState12[0],\n      setIsPagination = _useState12[1];\n\n  useEffect(function () {\n    var nargs = _objectSpread({}, args);\n\n    nargs['token'] = select('vibebp').getToken();\n    setisLoading(true);\n    fetch(\"\".concat(window.vibebp.api.url, \"/wc/orders\"), {\n      method: 'post',\n      body: JSON.stringify(nargs)\n    }).then(function (res) {\n      return res.json();\n    }).then(function (data) {\n      console.log(data);\n      setisLoading(false);\n\n      if (data.status) {\n        setOrders(data.orders);\n      }\n    });\n  }, [args]);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_shop_orders\"\n  }, isLoading ? wp.element.createElement(\"div\", {\n    \"class\": \"loading-roller\"\n  }, wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null), wp.element.createElement(\"div\", null)) : order ? wp.element.createElement(_order__WEBPACK_IMPORTED_MODULE_1__[\"default\"], {\n    order: order,\n    back: function back() {\n      setOrder(false);\n    }\n  }) : orders.length ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"vibebp_shop_orders_header vibebp_form\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_form_field\"\n  }, wp.element.createElement(react_flatpickr__WEBPACK_IMPORTED_MODULE_0___default.a, {\n    options: {\n      value: args.order_date,\n      defaultDate: args.order_date\n    },\n    onChange: function onChange(date) {\n      setArgs(_objectSpread({}, args, {\n        order_date: date[0].getTime()\n      }));\n    }\n  })), wp.element.createElement(\"select\", {\n    value: args.status,\n    onChange: function onChange(e) {\n      setArgs(_objectSpread({}, args, {\n        status: e.target.value\n      }));\n    }\n  }, wp.element.createElement(\"option\", null, window.vibebp.translations.select_order_status), Object.keys(window.vibebp.components.shop.order_statuses).map(function (key) {\n    return wp.element.createElement(\"option\", {\n      value: key\n    }, window.vibebp.components.shop.order_statuses[key]);\n  }))), orders.map(function (o) {\n    var order = o[0];\n    return wp.element.createElement(\"div\", {\n      className: \"vibebp_wc_order\",\n      onClick: function onClick() {\n        setOrder(order);\n      }\n    }, wp.element.createElement(\"div\", {\n      className: \"vibebp_order_details\"\n    }, wp.element.createElement(\"a\", {\n      className: \"vibebp_order_number link\",\n      href: order.view_order_url,\n      target: \"_blank\"\n    }, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.order_number), \"#\", order.order_number), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.order_date), order.created_at), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.order_status), wp.element.createElement(\"span\", {\n      className: 'order_status ' + order.status\n    }, window.vibebp.components.shop.order_statuses['wc-' + order.status])), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.order_quantity), order.total_line_items_quantity), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n      className: \"vibebp_wc_order_label\"\n    }, window.vibebp.translations.order_amount), order.currency, \" \", order.total)));\n  })) : wp.element.createElement(\"div\", {\n    className: \"vbp_message\"\n  }, window.vibebp.translations.no_orders));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (ShopOrders);\n\n//# sourceURL=webpack:///./src/profile/components/shop/orders.js?");

/***/ }),

/***/ "./src/profile/components/shop/shop.js":
/*!*********************************************!*\
  !*** ./src/profile/components/shop/shop.js ***!
  \*********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _orders__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./orders */ \"./src/profile/components/shop/orders.js\");\n/* harmony import */ var _downloads__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./downloads */ \"./src/profile/components/shop/downloads.js\");\n/* harmony import */ var _addresses__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./addresses */ \"./src/profile/components/shop/addresses.js\");\nfunction _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }\n\nfunction _nonIterableSpread() { throw new TypeError(\"Invalid attempt to spread non-iterable instance\"); }\n\nfunction _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === \"[object Arguments]\") return Array.from(iter); }\n\nfunction _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }\n\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\nvar Shop = function Shop(props) {\n  var _useState = useState({}),\n      _useState2 = _slicedToArray(_useState, 2),\n      args = _useState2[0],\n      setArgs = _useState2[1];\n\n  var _useState3 = useState([]),\n      _useState4 = _slicedToArray(_useState3, 2),\n      shopFilters = _useState4[0],\n      setshopFilters = _useState4[1];\n\n  var _useState5 = useState(''),\n      _useState6 = _slicedToArray(_useState5, 2),\n      activeTab = _useState6[0],\n      setActiveTab = _useState6[1];\n\n  useEffect(function () {\n    var shop_filters = select('vibebp').getMenu().filter(function (item) {\n      return item.parent === 'shop';\n    });\n    shop_filters.map(function (filter, index) {\n      if (shop_filters.findIndex(function (item) {\n        return item[\"class\"].indexOf('current-menu-item') > -1;\n      }) === -1) {\n        shop_filters[index][\"class\"].push('current-menu-item'); // setActiveTab(group_filters[index].css_id);\n      }\n    });\n    setshopFilters(shop_filters);\n  }, []);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_sidebars\"\n  }, wp.element.createElement(\"div\", {\n    className: \"vibebp_left_sidebar\"\n  }, wp.element.createElement(\"h3\", null, window.vibebp.components.shop.label), shopFilters.map(function (filter, i) {\n    var classs = filter[\"class\"].join(' ') + ' ' + filter.css_id;\n    return wp.element.createElement(\"a\", {\n      className: classs,\n      onClick: function onClick(e) {\n        var nargs = _objectSpread({}, args);\n\n        nargs.filter = filter.css_id;\n        nargs.page = 1;\n\n        if (args.css_id !== nargs.filter) {\n          setArgs(nargs);\n        }\n\n        setActiveTab(filter.css_id);\n\n        var ffilters = _toConsumableArray(shopFilters);\n\n        var index = ffilters.findIndex(function (item) {\n          return item[\"class\"].indexOf('current-menu-item') > -1;\n        });\n        ffilters[index][\"class\"].splice(ffilters[index][\"class\"].indexOf('current-menu-item'), 1);\n        ffilters[i][\"class\"].push('current-menu-item');\n        setshopFilters(ffilters);\n      }\n    }, filter.name);\n  })), wp.element.createElement(\"div\", {\n    className: \"vibebp_main\"\n  }, activeTab == \"downloads\" ? wp.element.createElement(_downloads__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null) : activeTab == \"edit-address\" ? wp.element.createElement(_addresses__WEBPACK_IMPORTED_MODULE_2__[\"default\"], null) : wp.element.createElement(_orders__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null)));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Shop);\n\n//# sourceURL=webpack:///./src/profile/components/shop/shop.js?");

/***/ }),

/***/ "./src/profile/components/timer.js":
/*!*****************************************!*\
  !*** ./src/profile/components/timer.js ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\n\nvar DateTime = function DateTime(props) {\n  var _useState = useState(''),\n      _useState2 = _slicedToArray(_useState, 2),\n      timeout = _useState2[0],\n      settimout = _useState2[1];\n\n  var _useState3 = useState({\n    s: 0,\n    m: 0,\n    h: 0,\n    d: 0,\n    w: 0,\n    mn: 0,\n    y: 0\n  }),\n      _useState4 = _slicedToArray(_useState3, 2),\n      time = _useState4[0],\n      setTime = _useState4[1];\n\n  useEffect(function () {\n    setTimer();\n  }, [props.time]);\n  useEffect(function () {\n    var mytimeout = setInterval(function () {\n      setTimer();\n      settimout(timeout + 60);\n    }, 60000);\n    return function () {\n      return clearInterval(mytimeout);\n    };\n  }, []);\n\n  var setTimer = function setTimer() {\n    var ntime = {\n      s: 0,\n      m: 0,\n      h: 0,\n      d: 0,\n      mn: 0,\n      y: 0\n    };\n    var timer = Math.floor((new Date().getTime() - Date.parse(props.time) + new Date().getTimezoneOffset() * 60000) / 1000);\n\n    if (timer > 86400 * 365) {\n      ntime.y = Math.floor(timer / (86400 * 365));\n      timer = timer - ntime.y * 86400 * 365;\n    }\n\n    if (timer > 86400 * 30) {\n      ntime.mn = Math.floor(timer / (86400 * 30));\n      timer = timer - ntime.mn * 86400 * 30;\n    }\n\n    if (timer > 86400 * 7) {\n      ntime.w = Math.floor(timer / (86400 * 7));\n      timer = timer - ntime.w * 86400 * 7;\n    }\n\n    if (timer > 86400) {\n      ntime.d = Math.floor(timer / 86400);\n      timer = timer - ntime.d * 86400;\n    }\n\n    if (timer > 3600) {\n      ntime.h = Math.floor(timer / 3600);\n      timer = timer - ntime.h * 3600;\n    }\n\n    if (timer > 60) {\n      ntime.m = Math.floor(timer / 60);\n      timer = timer - ntime.m * 60;\n    }\n\n    ntime.s = timer;\n    setTime(ntime);\n  };\n\n  return wp.element.createElement(\"div\", {\n    className: \"datetime\"\n  }, !time.y && !time.mn && !time.w && !time.d && !time.h && !time.m ? window.vibebp.translations.justnow : '', time.y ? wp.element.createElement(\"span\", {\n    className: \"years\"\n  }, time.y, \" \", time.y > 1 ? window.vibebp.translations.years : window.vibebp.translations.year) : '', time.mn ? wp.element.createElement(\"span\", {\n    className: \"months\"\n  }, time.mn, \" \", time.mn > 1 ? window.vibebp.translations.months : window.vibebp.translations.month) : '', time.w ? wp.element.createElement(\"span\", {\n    className: \"weeks\"\n  }, time.w, \" \", time.w > 1 ? window.vibebp.translations.weeks : window.vibebp.translations.week) : '', time.d ? wp.element.createElement(\"span\", {\n    className: \"days\"\n  }, time.d, \" \", time.d > 1 ? window.vibebp.translations.days : window.vibebp.translations.day) : '', time.h ? wp.element.createElement(\"span\", {\n    className: \"hours\"\n  }, time.h, \" \", time.h > 1 ? window.vibebp.translations.hours : window.vibebp.translations.hour) : '', time.m ? wp.element.createElement(\"span\", {\n    className: \"minutes\"\n  }, time.m, \" \", time.m > 1 ? window.vibebp.translations.minutes : window.vibebp.translations.minute) : '');\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (DateTime);\n\n//# sourceURL=webpack:///./src/profile/components/timer.js?");

/***/ }),

/***/ "./src/profile/components/uploader.js":
/*!********************************************!*\
  !*** ./src/profile/components/uploader.js ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var croppr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! croppr */ \"./node_modules/croppr/dist/croppr.js\");\n/* harmony import */ var croppr__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(croppr__WEBPACK_IMPORTED_MODULE_0__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    useRef = _wp$element.useRef,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\nvar rand = Math.round(Math.random() * 100);\n\nvar Uploader = function Uploader(props) {\n  var inputEl = useRef(null);\n\n  var _useState = useState(true),\n      _useState2 = _slicedToArray(_useState, 2),\n      isUpload = _useState2[0],\n      setisUpload = _useState2[1];\n\n  var _useState3 = useState(false),\n      _useState4 = _slicedToArray(_useState3, 2),\n      isCrop = _useState4[0],\n      setisCrop = _useState4[1];\n\n  var _useState5 = useState(false),\n      _useState6 = _slicedToArray(_useState5, 2),\n      showCropper = _useState6[0],\n      setshowCropper = _useState6[1];\n\n  var _useState7 = useState(''),\n      _useState8 = _slicedToArray(_useState7, 2),\n      src = _useState8[0],\n      setSrc = _useState8[1];\n\n  var _useState9 = useState(''),\n      _useState10 = _slicedToArray(_useState9, 2),\n      videoUrl = _useState10[0],\n      setVideoUrl = _useState10[1];\n\n  var _useState11 = useState(''),\n      _useState12 = _slicedToArray(_useState11, 2),\n      attachmentUrl = _useState12[0],\n      setAttachemntUrl = _useState12[1];\n\n  var _useState13 = useState(''),\n      _useState14 = _slicedToArray(_useState13, 2),\n      files = _useState14[0],\n      setFiles = _useState14[1];\n\n  var _useState15 = useState({\n    x: 0,\n    y: 0,\n    width: 0,\n    height: 0,\n    type: 'image'\n  }),\n      _useState16 = _slicedToArray(_useState15, 2),\n      cropValues = _useState16[0],\n      setCropValues = _useState16[1];\n\n  var _useState17 = useState(''),\n      _useState18 = _slicedToArray(_useState17, 2),\n      imgRef = _useState18[0],\n      setImgRef = _useState18[1];\n\n  var _useState19 = useState(window.vibebp.translations.select_image),\n      _useState20 = _slicedToArray(_useState19, 2),\n      select_image = _useState20[0],\n      setSelectImage = _useState20[1];\n\n  useEffect(function () {\n    if (props.hasOwnProperty('crop')) {\n      if (props.crop) {\n        setisCrop(true);\n      }\n    }\n  }, []);\n  useEffect(function () {\n    if (showCropper && imgRef && isCrop) {\n      var croppr = new croppr__WEBPACK_IMPORTED_MODULE_0___default.a(imgRef, {\n        returnMode: 'ratio',\n        onCropEnd: function onCropEnd(value) {\n          var ncropValues = _objectSpread({}, cropValues);\n\n          ncropValues.x = value.x * 100;\n          ncropValues.y = value.y * 100;\n          ncropValues.height = value.height * 100;\n          ncropValues.width = value.width * 100;\n          setCropValues(ncropValues);\n          var truecropvalues = {\n            x: imgRef.naturalWidth * value.x,\n            y: imgRef.naturalHeight * value.y,\n            width: imgRef.naturalWidth * value.width,\n            height: imgRef.naturalHeight * value.height\n          };\n          props.update(files, truecropvalues);\n        }\n      });\n    }\n  }, [showCropper, imgRef]);\n\n  var setImage = function setImage(e) {\n    if (inputEl.current.files[0].size < window.vibebp.settings.upload_limit) {\n      setSrc(window.URL.createObjectURL(inputEl.current.files[0]));\n      setisUpload(false);\n      setFiles(inputEl.current.files);\n      props.update(inputEl.current.files, _objectSpread({}, cropValues, {\n        key: 'image'\n      }));\n    } else {\n      setSelectImage(window.vibebp.translations.image_size_error);\n      setTimeout(function () {\n        setSelectImage(window.vibebp.translations.select_image);\n      }, 3500);\n    }\n  };\n\n  var setVideo = function setVideo(e) {\n    if (inputEl.current.files[0].size < window.vibebp.settings.upload_limit) {\n      setVideoUrl(window.URL.createObjectURL(inputEl.current.files[0]));\n      setisUpload(false);\n      setFiles(inputEl.current.files);\n      props.update(inputEl.current.files, _objectSpread({}, cropValues, {\n        key: 'video'\n      }));\n    } else {\n      setSelectImage(window.vibebp.translations.image_size_error);\n      setTimeout(function () {\n        setSelectImage(window.vibebp.translations.select_image);\n      }, 3500);\n    }\n  };\n\n  var setAttachment = function setAttachment(e) {\n    if (inputEl.current.files[0].size < window.vibebp.settings.upload_limit) {\n      setAttachemntUrl(window.URL.createObjectURL(inputEl.current.files[0]));\n      setisUpload(false);\n      setFiles(inputEl.current.files);\n      props.update(inputEl.current.files, _objectSpread({}, cropValues, {\n        key: 'attachment'\n      }));\n    } else {\n      setSelectImage(window.vibebp.translations.image_size_error);\n      setTimeout(function () {\n        setSelectImage(window.vibebp.translations.select_image);\n      }, 3500);\n    }\n  };\n\n  var style = {\n    backgroundPosition: cropValues.x + '% ' + cropValues.y + '%',\n    backgroundSize: 100 * 100 / cropValues.width + '% ' + 100 * 100 / cropValues.height + '% ',\n    backgroundImage: 'url(' + src + ')'\n  };\n  return wp.element.createElement(\"div\", {\n    className: \"uploader\"\n  }, isUpload ? wp.element.createElement(\"label\", {\n    \"for\": 'fileupload_' + rand,\n    className: \"upload_file\"\n  }, select_image, props.type == 'image' ? wp.element.createElement(\"input\", {\n    id: 'fileupload_' + rand,\n    \"data-type\": props.type,\n    ref: inputEl,\n    type: \"file\",\n    accept: \"image/*\",\n    onChange: setImage\n  }) : props.type == 'video' ? wp.element.createElement(\"input\", {\n    id: 'fileupload_' + rand,\n    \"data-type\": props.type,\n    ref: inputEl,\n    type: \"file\",\n    accept: \"video/*\",\n    onChange: setVideo\n  }) : wp.element.createElement(\"input\", {\n    id: 'fileupload_' + rand,\n    \"data-type\": props.type,\n    ref: inputEl,\n    type: \"file\",\n    onChange: setAttachment\n  })) : wp.element.createElement(\"div\", {\n    className: \"uploaded_src\"\n  }, props.type == 'image' ? wp.element.createElement(Fragment, null, isCrop ? wp.element.createElement(Fragment, null, wp.element.createElement(\"div\", {\n    className: \"uploaded_image\",\n    style: style\n  }), wp.element.createElement(\"span\", null, wp.element.createElement(\"span\", {\n    className: \"vicon vicon-pencil\",\n    onClick: function onClick() {\n      if (!showCropper) {\n        setshowCropper(true);\n      } else {\n        setshowCropper(false);\n      }\n    }\n  }), wp.element.createElement(\"span\", {\n    className: \"vicon vicon-close\",\n    onClick: function onClick() {\n      setisCrop(false);\n      setisUpload(true);\n      setImgRef('');\n      setSrc('');\n      setCropValues({\n        x: 0,\n        y: 0,\n        width: 0,\n        height: 0\n      });\n    }\n  })), showCropper ? wp.element.createElement(\"div\", {\n    className: \"cropimage\",\n    id: \"cropper\"\n  }, wp.element.createElement(\"img\", {\n    src: src,\n    ref: function ref(input) {\n      setImgRef(input);\n    }\n  })) : '') : wp.element.createElement(\"img\", {\n    src: src\n  })) : props.type == 'video' ? wp.element.createElement(Fragment, null, wp.element.createElement(\"video\", {\n    src: videoUrl\n  })) : wp.element.createElement(Fragment, null, wp.element.createElement(\"i\", {\n    className: \"vicon vicon-clip\"\n  }))));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (Uploader);\n\n//# sourceURL=webpack:///./src/profile/components/uploader.js?");

/***/ }),

/***/ "./src/profile/index.js":
/*!******************************!*\
  !*** ./src/profile/index.js ***!
  \******************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _user_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./user.js */ \"./src/profile/user.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\n\ndocument.addEventListener('DOMContentLoaded', function () {\n  var _wp$element = wp.element,\n      createElement = _wp$element.createElement,\n      useState = _wp$element.useState,\n      useEffect = _wp$element.useEffect,\n      Fragment = _wp$element.Fragment,\n      render = _wp$element.render;\n  var _wp$data = wp.data,\n      dispatch = _wp$data.dispatch,\n      select = _wp$data.select;\n  var def = document.getElementById(\"vibebp_member\").innerHTML;\n\n  var Profile = function Profile(props) {\n    var _useState = useState({}),\n        _useState2 = _slicedToArray(_useState, 2),\n        user = _useState2[0],\n        setUser = _useState2[1];\n\n    useEffect(function () {\n      document.addEventListener('userLoaded', function () {\n        var guser = select('vibebp').getUser();\n\n        if (parseInt(guser.id) === parseInt(window.vibebp.user_id)) {\n          setUser(guser);\n        } else {\n          setUser({});\n        }\n      });\n    }, []);\n    return wp.element.createElement(Fragment, null, Object.keys(user).length ? wp.element.createElement(_user_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], {\n      user: user\n    }) : wp.element.createElement(\"div\", {\n      dangerouslySetInnerHTML: {\n        __html: def\n      }\n    }));\n  };\n\n  render(wp.element.createElement(Profile, null), document.getElementById(\"vibebp_member\"));\n});\n\n//# sourceURL=webpack:///./src/profile/index.js?");

/***/ }),

/***/ "./src/profile/user.js":
/*!*****************************!*\
  !*** ./src/profile/user.js ***!
  \*****************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _components_menu_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./components/menu.js */ \"./src/profile/components/menu.js\");\n/* harmony import */ var _components_grid_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./components/grid.js */ \"./src/profile/components/grid.js\");\nfunction _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }\n\nfunction _nonIterableRest() { throw new TypeError(\"Invalid attempt to destructure non-iterable instance\"); }\n\nfunction _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i[\"return\"] != null) _i[\"return\"](); } finally { if (_d) throw _e; } } return _arr; }\n\nfunction _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }\n\nvar _wp$element = wp.element,\n    createElement = _wp$element.createElement,\n    useState = _wp$element.useState,\n    useEffect = _wp$element.useEffect,\n    Fragment = _wp$element.Fragment,\n    render = _wp$element.render;\nvar _wp$data = wp.data,\n    dispatch = _wp$data.dispatch,\n    select = _wp$data.select;\n\n\n\nvar UserProfile = function UserProfile(props) {\n  var _useState = useState(),\n      _useState2 = _slicedToArray(_useState, 2),\n      _ref = _useState2[0],\n      setRef = _useState2[1];\n\n  var _useState3 = useState({}),\n      _useState4 = _slicedToArray(_useState3, 2),\n      style = _useState4[0],\n      setStyle = _useState4[1];\n\n  useEffect(function () {\n    if (_ref) {\n      var dimension = _ref.getBoundingClientRect();\n\n      setStyle({\n        height: 'calc(100vh - ' + dimension.y + 'px'\n      });\n    }\n  }, [_ref]);\n  return wp.element.createElement(\"div\", {\n    className: \"vibebp_myprofile\",\n    ref: function ref(r) {\n      if (r && !_ref) {\n        setRef(r);\n      }\n    },\n    style: style\n  }, wp.element.createElement(_components_menu_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], null), wp.element.createElement(_components_grid_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"], null));\n};\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (UserProfile);\n\n//# sourceURL=webpack:///./src/profile/user.js?");

/***/ }),

/***/ "./src/store/actions.js":
/*!******************************!*\
  !*** ./src/store/actions.js ***!
  \******************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\nfunction ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }\n\nfunction _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(source, true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(source).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }\n\nfunction _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }\n\nvar actions = {\n  setUser: function setUser(user) {\n    return {\n      type: 'SET_USER',\n      user: user\n    };\n  },\n  addNotification: function addNotification(newnotification) {\n    var notification = _objectSpread({}, newnotification, {\n      id: new Date().getTime()\n    });\n\n    return {\n      type: 'ADD_NOTIFICATION',\n      notification: notification\n    };\n  },\n  removeNotification: function removeNotification(notification) {\n    return {\n      type: 'REMOVE_NOTIFICATION',\n      notification: notification\n    };\n  },\n  getUser: function getUser() {\n    return {\n      type: 'GET_USER'\n    };\n  },\n  verifyUser: function verifyUser(path, token) {\n    return {\n      type: 'VERIFY_USER_API',\n      path: path,\n      token: token\n    };\n  },\n  setToken: function setToken(token) {\n    return {\n      type: 'SET_TOKEN',\n      token: token\n    };\n  },\n  logout: function logout() {\n    return {\n      type: 'LOGOUT'\n    };\n  },\n  setMenu: function setMenu(menu) {\n    return {\n      type: 'SET_MENU',\n      menu: menu\n    };\n  },\n  setOnlineMembers: function setOnlineMembers(onlineMembers) {\n    return {\n      type: 'SET_ONLINE_MEMBERS',\n      onlineMembers: onlineMembers\n    };\n  },\n  setComponent: function setComponent(component) {\n    var fragments = window.location.href.split('#');\n    var rebuildUrl = fragments[0] + '#';\n    var vars = [];\n    var parts = window.location.href.replace(/[#&]+([^=&]+)=([^&]*)/gi, function (m, key, value) {\n      vars[key] = value;\n    });\n    var extras = '';\n    vars.map(function (value, key) {\n      if (key !== 'component' && key !== 'action') {\n        extras += key + '=' + value;\n      }\n    });\n\n    if (extras.length) {\n      rebuildUrl += '&';\n    }\n\n    rebuildUrl += 'component=' + component;\n    window.location.href = rebuildUrl;\n    return {\n      type: 'SET_COMPONENT',\n      component: component\n    };\n  },\n  setData: function setData(type, data) {\n    return {\n      type: 'SET_DATA',\n      data_type: type,\n      data: data\n    };\n  },\n  setAction: function setAction(action) {\n    return {\n      type: 'SET_ACTION',\n      action: action\n    };\n  },\n  sendRealTimeNotification: function sendRealTimeNotification(user_id, message) {\n    console.log('action called');\n    return {\n      type: 'SEND_REALTIME_NOTIFICATION',\n      user_id: user_id,\n      message: message\n    };\n  },\n  removeRealTimeNotification: function removeRealTimeNotification(user_id, message) {\n    return {\n      type: 'REMOVE_REALTIME_NOTIFICATION',\n      user_id: user_id,\n      message: message\n    };\n  }\n};\n/* harmony default export */ __webpack_exports__[\"default\"] = (actions);\n\n//# sourceURL=webpack:///./src/store/actions.js?");

/***/ })

/******/ });