<?php

function wplms_get_random_color($i=NULL){
$color_array = array(
		'#7266ba',
 		'#23b7e5',
 		'#f05050',
 		'#fad733',
 		'#27c24c',
 		'#fa7252'
	);
if(isset($i)){
	if(isset($color_array[$i]))
	return $color_array[$i];
}
$k = array_rand($color_array);
return $color_array[$k];
}

function wplms_dashboard_template() {

	if(!is_user_logged_in())
		wp_redirect(site_url());

	$template ='templates/dashboard';

	
	wplms_dashboard_widget_scripts();
	$located_template = apply_filters( 'bp_located_template', locate_template( $template , false ), $template );	
	if ( $located_template && $located_template !='' )	{
		bp_get_template_part( apply_filters( 'bp_load_template', $located_template ) );
	}else{
	    bp_core_load_template( apply_filters( 'bp_core_template_plugin', 'members/single/dashboard' ) );
	}
}

function wplms_dashboard_widget_scripts(){
	global $bp;

	$components = apply_filters('wplms_dashboard_widget_scripts',array('dashboard'));
    if(in_array($bp->current_component,$components)){ 

		wp_enqueue_style( 'wplms-dashboard-css',  WPLMS_DASHBOARD_URL.'/css/wplms-dashboard.css',array(),array(1,999));
		wp_enqueue_script( 'wplms-dashboard-js', WPLMS_DASHBOARD_URL.'/js/wplms-dashboard.js',array('jquery','jquery-ui-sortable'),WPLMS_PLUGIN_VERSION);
		if ( is_active_widget( false, false, 'wplms_instructor_dash_stats', true ) || is_active_widget( false, false, 'wplms_dash_stats', true )) {
			wp_enqueue_script( 'wplms-sparkline', WPLMS_DASHBOARD_URL.'/js/jquery.sparkline.min.js',array('jquery'),true);
		}
		if ( is_active_widget( false, false, 'wplms_instructor_stats', true ) || is_active_widget( false, false, 'wplms_instructor_commission_stats', true )
			|| is_active_widget( false, false, 'wplms_student_stats', true )) {
			wp_enqueue_script( 'wplms-raphael',WPLMS_DASHBOARD_URL.'/js/raphael-min.js',array('jquery'),true);
      		wp_enqueue_script( 'wplms-morris',WPLMS_DASHBOARD_URL.'/js/morris.min.js',array('jquery'),true);
		}
		$currencies = array();
		if(apply_filters('wplms_commissions_migrate_to_activity',1)){
			$currencies = get_currencies();
		}
		$translation_array = array(
			'earnings' => __('Earnings','wplms'),
			'payout'=>__('Payout','wplms'),
			'students'=>__('# Students','wplms'),
			'saved'=>__('SAVED','wplms'),
			'saving'=>__('SAVING ...','wplms'),
			'select_recipients' => __('Select recipients...','wplms'),
			'no_data' => __('No data found','wplms'),
			'stats_calculated'=>__('Stats Calculated, reloading page ...','wplms'),
			'multicurrency'=>apply_filters('wplms_commissions_migrate_to_activity',1),
			'currencies'=>$currencies
			);
		wp_localize_script( 'wplms-dashboard-js', 'wplms_dashboard_strings', $translation_array );

	}
}

add_action('widgets_init','wplms_dashboard_setup_sidebars');
function wplms_dashboard_setup_sidebars(){
if(function_exists('register_sidebar')){
	register_sidebar( array(
		'name' => __('Student Sidebar','wplms'),
		'id' => 'student_sidebar',
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="dash_widget_title">',
		'after_title' => '</h4>',
        'description'   => __('This is the dashboard sidebar for Students','wplms')
	) );
	register_sidebar( array(
		'name' => __('Instructor Sidebar','wplms'),
		'id' => 'instructor_sidebar',
		'before_widget' => '<div id="%1$s" class="%2$s">',
		'after_widget' => '</div>',
		'before_title' => '<h4 class="dash_widget_title">',
		'after_title' => '</h4>',
        'description'   => __('This is the dashboard sidebar for Instructors','wplms')
	) );
    }
}



function get_currencies(){
      
        global $wpdb,$bp;
        $commissions = array();
        $results = $wpdb->get_results( "
                                      SELECT meta2.meta_value as currency
                                      FROM  {$bp->activity->table_name_meta} as meta2 
                                      WHERE  meta2.meta_key LIKE '_currency%'
                                      AND meta2.meta_value IS NOT NULL
                                      GROUP BY meta2.meta_value
                                      
                                      ",ARRAY_A);
        $currencies = array();
      if(!empty($results)){
      	foreach ($results as $key => $result) {
      		$currencies[]=$result['currency'];
      	}
      }
      return $currencies;
    }


